/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.instream;

import android.content.Context;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.MediaAspectRatio;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.doubleclick.PublisherAdRequest;
import com.google.android.gms.ads.instream.InstreamAdView;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzahl;
import com.google.android.gms.internal.ads.zzahq;

public abstract class InstreamAd {
    public static void load(Context context, String string, AdRequest adRequest, @MediaAspectRatio int n, InstreamAdLoadCallback instreamAdLoadCallback) {
        Preconditions.checkArgument((n == 2 || n == 3 ? 1 : 0) != 0, (Object)"Instream ads only support Landscape and Portrait media aspect ratios");
        new zzahq(context, string).zza(instreamAdLoadCallback).zza(new zzahl(n)).zzry().loadAd(adRequest);
    }

    public static void load(Context context, String string, InstreamAdLoadCallback instreamAdLoadCallback) {
        new zzahq(context, "").zza(instreamAdLoadCallback).zza(new zzahl(string)).zzry().loadAd(new PublisherAdRequest.Builder().build());
    }

    public abstract VideoController getVideoController();

    public abstract float getVideoDuration();

    public abstract float getVideoCurrentTime();

    public abstract float getAspectRatio();

    public abstract void destroy();

    protected abstract void zza(InstreamAdView var1);

    public static abstract class InstreamAdLoadCallback {
        public void onInstreamAdLoaded(InstreamAd instreamAd) {
        }

        public void onInstreamAdFailedToLoad(int n) {
        }
    }
}

