/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.search;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.search.DynamicHeightSearchAdRequest;
import com.google.android.gms.ads.search.SearchAdRequest;
import com.google.android.gms.internal.ads.zzayu;
import com.google.android.gms.internal.ads.zzxl;

public final class SearchAdView
extends ViewGroup {
    private final zzxl zzaca;

    public SearchAdView(Context context) {
        super(context);
        this.zzaca = new zzxl(this);
    }

    public SearchAdView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zzaca = new zzxl(this, attributeSet, false);
    }

    public SearchAdView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zzaca = new zzxl(this, attributeSet, false);
    }

    public final void destroy() {
        this.zzaca.destroy();
    }

    public final AdListener getAdListener() {
        return this.zzaca.getAdListener();
    }

    public final AdSize getAdSize() {
        return this.zzaca.getAdSize();
    }

    public final String getAdUnitId() {
        return this.zzaca.getAdUnitId();
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public final void loadAd(SearchAdRequest searchAdRequest) {
        this.zzaca.zza(searchAdRequest.zzdg());
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public final void loadAd(DynamicHeightSearchAdRequest dynamicHeightSearchAdRequest) {
        if (!AdSize.SEARCH.equals(this.getAdSize())) {
            throw new IllegalStateException("You must use AdSize.SEARCH for a DynamicHeightSearchAdRequest");
        }
        this.zzaca.zza(dynamicHeightSearchAdRequest.zzdg());
    }

    public final void pause() {
        this.zzaca.pause();
    }

    public final void resume() {
        this.zzaca.resume();
    }

    public final void setAdListener(AdListener adListener) {
        this.zzaca.setAdListener(adListener);
    }

    public final void setAdSize(AdSize adSize) {
        this.zzaca.setAdSizes(adSize);
    }

    public final void setAdUnitId(String string) {
        this.zzaca.setAdUnitId(string);
    }

    protected final void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            int n5 = view.getMeasuredWidth();
            int n6 = view.getMeasuredHeight();
            int n7 = (n3 - n - n5) / 2;
            int n8 = (n4 - n2 - n6) / 2;
            view.layout(n7, n8, n7 + n5, n8 + n6);
        }
    }

    protected final void onMeasure(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        View view = this.getChildAt(0);
        if (view != null && view.getVisibility() != 8) {
            this.measureChild(view, n, n2);
            n3 = view.getMeasuredWidth();
            n4 = view.getMeasuredHeight();
        } else {
            AdSize adSize = null;
            try {
                adSize = this.getAdSize();
            }
            catch (NullPointerException nullPointerException) {
                zzayu.zzc("Unable to retrieve ad size.", nullPointerException);
            }
            if (adSize != null) {
                Context context = this.getContext();
                n3 = adSize.getWidthInPixels(context);
                n4 = adSize.getHeightInPixels(context);
            }
        }
        n3 = Math.max(n3, this.getSuggestedMinimumWidth());
        n4 = Math.max(n4, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(View.resolveSize((int)n3, (int)n), View.resolveSize((int)n4, (int)n2));
    }
}

