/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.formats.MediaView;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzace;
import com.google.android.gms.internal.ads.zzaci;
import com.google.android.gms.internal.ads.zzacj;
import com.google.android.gms.internal.ads.zzade;
import com.google.android.gms.internal.ads.zzayu;
import com.google.android.gms.internal.ads.zzxb;
import java.util.List;
import java.util.WeakHashMap;

public final class zzadf
implements NativeCustomTemplateAd {
    private static WeakHashMap<IBinder, zzadf> zzcwa = new WeakHashMap();
    private final zzade zzcwb;
    private final MediaView zzcwc;
    private final VideoController zzcel = new VideoController();
    private NativeCustomTemplateAd.DisplayOpenMeasurement zzcwd;

    @VisibleForTesting
    private zzadf(zzade zzade2) {
        this.zzcwb = zzade2;
        Context context = null;
        try {
            context = (Context)ObjectWrapper.unwrap((IObjectWrapper)zzade2.zzrk());
        }
        catch (RemoteException | NullPointerException throwable) {
            zzayu.zzc("", throwable);
        }
        MediaView mediaView = null;
        if (context != null) {
            Object object = context;
            mediaView = new MediaView((Context)object);
            try {
                if (!this.zzcwb.zzp(ObjectWrapper.wrap((Object)((Object)mediaView)))) {
                    mediaView = null;
                }
            }
            catch (RemoteException remoteException) {
                mediaView = null;
                object = remoteException;
                zzayu.zzc("", (Throwable)object);
            }
        }
        this.zzcwc = mediaView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzadf zza(zzade zzade2) {
        WeakHashMap<IBinder, zzadf> weakHashMap = zzcwa;
        synchronized (weakHashMap) {
            zzadf zzadf2 = zzcwa.get(zzade2.asBinder());
            if (zzadf2 != null) {
                return zzadf2;
            }
            zzadf2 = new zzadf(zzade2);
            zzcwa.put(zzade2.asBinder(), zzadf2);
            return zzadf2;
        }
    }

    public final zzade zzro() {
        return this.zzcwb;
    }

    @Override
    public final CharSequence getText(String string) {
        try {
            return this.zzcwb.zzct(string);
        }
        catch (RemoteException remoteException) {
            zzayu.zzc("", remoteException);
            return null;
        }
    }

    @Override
    public final NativeAd.Image getImage(String string) {
        try {
            zzaci zzaci2 = this.zzcwb.zzcu(string);
            if (zzaci2 != null) {
                return new zzacj(zzaci2);
            }
        }
        catch (RemoteException remoteException) {
            zzayu.zzc("", remoteException);
        }
        return null;
    }

    @Override
    public final VideoController getVideoController() {
        try {
            zzxb zzxb2 = this.zzcwb.getVideoController();
            if (zzxb2 != null) {
                this.zzcel.zza(zzxb2);
            }
        }
        catch (RemoteException remoteException) {
            zzayu.zzc("Exception occurred while getting video controller", remoteException);
        }
        return this.zzcel;
    }

    @Override
    public final MediaView getVideoMediaView() {
        return this.zzcwc;
    }

    @Override
    public final List<String> getAvailableAssetNames() {
        try {
            return this.zzcwb.getAvailableAssetNames();
        }
        catch (RemoteException remoteException) {
            zzayu.zzc("", remoteException);
            return null;
        }
    }

    @Override
    public final String getCustomTemplateId() {
        try {
            return this.zzcwb.getCustomTemplateId();
        }
        catch (RemoteException remoteException) {
            zzayu.zzc("", remoteException);
            return null;
        }
    }

    @Override
    public final void performClick(String string) {
        try {
            this.zzcwb.performClick(string);
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zzc("", remoteException);
            return;
        }
    }

    @Override
    public final void recordImpression() {
        try {
            this.zzcwb.recordImpression();
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zzc("", remoteException);
            return;
        }
    }

    @Override
    public final NativeCustomTemplateAd.DisplayOpenMeasurement getDisplayOpenMeasurement() {
        try {
            if (this.zzcwd == null && this.zzcwb.zzrl()) {
                this.zzcwd = new zzace(this.zzcwb);
            }
        }
        catch (RemoteException remoteException) {
            zzayu.zzc("", remoteException);
        }
        return this.zzcwd;
    }

    @Override
    public final void destroy() {
        try {
            this.zzcwb.destroy();
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zzc("", remoteException);
            return;
        }
    }
}

