/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.RemoteException;
import androidx.annotation.Nullable;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialAdapter;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeAdMapper;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzadf;
import com.google.android.gms.internal.ads.zzali;
import com.google.android.gms.internal.ads.zzalw;
import com.google.android.gms.internal.ads.zzayu;

public final class zzalz
implements MediationBannerListener,
MediationInterstitialListener,
MediationNativeListener {
    private final zzali zzdds;
    private NativeAdMapper zzddt;
    private UnifiedNativeAdMapper zzddu;
    private NativeCustomTemplateAd zzddv;

    public zzalz(zzali zzali2) {
        this.zzdds = zzali2;
    }

    @Override
    public final void zza(MediationBannerAdapter mediationBannerAdapter, String string, String string2) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzayu.zzea("Adapter called onAppEvent.");
        try {
            this.zzdds.onAppEvent(string, string2);
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClicked(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzayu.zzea("Adapter called onAdClicked.");
        try {
            this.zzdds.onAdClicked();
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClosed(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzayu.zzea("Adapter called onAdClosed.");
        try {
            this.zzdds.onAdClosed();
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdFailedToLoad(MediationBannerAdapter mediationBannerAdapter, int n) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzayu.zzea(new StringBuilder(55).append("Adapter called onAdFailedToLoad with error. ").append(n).toString());
        try {
            this.zzdds.onAdFailedToLoad(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLeftApplication(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzayu.zzea("Adapter called onAdLeftApplication.");
        try {
            this.zzdds.onAdLeftApplication();
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdOpened(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzayu.zzea("Adapter called onAdOpened.");
        try {
            this.zzdds.onAdOpened();
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzayu.zzea("Adapter called onAdLoaded.");
        try {
            this.zzdds.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClicked(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzayu.zzea("Adapter called onAdClicked.");
        try {
            this.zzdds.onAdClicked();
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClosed(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzayu.zzea("Adapter called onAdClosed.");
        try {
            this.zzdds.onAdClosed();
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdFailedToLoad(MediationInterstitialAdapter mediationInterstitialAdapter, int n) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzayu.zzea(new StringBuilder(55).append("Adapter called onAdFailedToLoad with error ").append(n).append(".").toString());
        try {
            this.zzdds.onAdFailedToLoad(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLeftApplication(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzayu.zzea("Adapter called onAdLeftApplication.");
        try {
            this.zzdds.onAdLeftApplication();
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdOpened(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzayu.zzea("Adapter called onAdOpened.");
        try {
            this.zzdds.onAdOpened();
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzayu.zzea("Adapter called onAdLoaded.");
        try {
            this.zzdds.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationNativeAdapter mediationNativeAdapter, NativeAdMapper nativeAdMapper) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzayu.zzea("Adapter called onAdLoaded.");
        this.zzddt = nativeAdMapper;
        this.zzddu = null;
        zzalz.zza(mediationNativeAdapter, this.zzddu, this.zzddt);
        try {
            this.zzdds.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationNativeAdapter mediationNativeAdapter, UnifiedNativeAdMapper unifiedNativeAdMapper) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzayu.zzea("Adapter called onAdLoaded.");
        this.zzddu = unifiedNativeAdMapper;
        this.zzddt = null;
        zzalz.zza(mediationNativeAdapter, this.zzddu, this.zzddt);
        try {
            this.zzdds.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    private static void zza(MediationNativeAdapter mediationNativeAdapter, @Nullable UnifiedNativeAdMapper unifiedNativeAdMapper, @Nullable NativeAdMapper nativeAdMapper) {
        if (mediationNativeAdapter instanceof AdMobAdapter) {
            return;
        }
        VideoController videoController = new VideoController();
        videoController.zza(new zzalw());
        if (unifiedNativeAdMapper != null && unifiedNativeAdMapper.hasVideoContent()) {
            unifiedNativeAdMapper.zza(videoController);
        }
        if (nativeAdMapper != null && nativeAdMapper.hasVideoContent()) {
            nativeAdMapper.zza(videoController);
        }
    }

    @Override
    public final void zza(MediationNativeAdapter mediationNativeAdapter, NativeCustomTemplateAd nativeCustomTemplateAd) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        String string = String.valueOf(nativeCustomTemplateAd.getCustomTemplateId());
        zzayu.zzea(string.length() != 0 ? "Adapter called onAdLoaded with template id ".concat(string) : new String("Adapter called onAdLoaded with template id "));
        this.zzddv = nativeCustomTemplateAd;
        try {
            this.zzdds.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void zza(MediationNativeAdapter mediationNativeAdapter, NativeCustomTemplateAd nativeCustomTemplateAd, String string) {
        if (nativeCustomTemplateAd instanceof zzadf) {
            try {
                this.zzdds.zza(((zzadf)nativeCustomTemplateAd).zzro(), string);
                return;
            }
            catch (RemoteException remoteException) {
                zzayu.zze("#007 Could not call remote method.", remoteException);
                return;
            }
        }
        zzayu.zzez("Unexpected native custom template ad type.");
    }

    @Override
    public final void onAdFailedToLoad(MediationNativeAdapter mediationNativeAdapter, int n) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzayu.zzea(new StringBuilder(55).append("Adapter called onAdFailedToLoad with error ").append(n).append(".").toString());
        try {
            this.zzdds.onAdFailedToLoad(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdOpened(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzayu.zzea("Adapter called onAdOpened.");
        try {
            this.zzdds.onAdOpened();
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClosed(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzayu.zzea("Adapter called onAdClosed.");
        try {
            this.zzdds.onAdClosed();
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLeftApplication(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzayu.zzea("Adapter called onAdLeftApplication.");
        try {
            this.zzdds.onAdLeftApplication();
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClicked(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        NativeAdMapper nativeAdMapper = this.zzddt;
        UnifiedNativeAdMapper unifiedNativeAdMapper = this.zzddu;
        if (this.zzddv == null) {
            if (nativeAdMapper == null && unifiedNativeAdMapper == null) {
                zzayu.zze("#007 Could not call remote method.", null);
                return;
            }
            if (unifiedNativeAdMapper != null && !unifiedNativeAdMapper.getOverrideClickHandling()) {
                zzayu.zzea("Could not call onAdClicked since setOverrideClickHandling is not set to true");
                return;
            }
            if (nativeAdMapper != null && !nativeAdMapper.getOverrideClickHandling()) {
                zzayu.zzea("Could not call onAdClicked since setOverrideClickHandling is not set to true");
                return;
            }
        }
        zzayu.zzea("Adapter called onAdClicked.");
        try {
            this.zzdds.onAdClicked();
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdImpression(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        NativeAdMapper nativeAdMapper = this.zzddt;
        UnifiedNativeAdMapper unifiedNativeAdMapper = this.zzddu;
        if (this.zzddv == null) {
            if (nativeAdMapper == null && unifiedNativeAdMapper == null) {
                zzayu.zze("#007 Could not call remote method.", null);
                return;
            }
            if (unifiedNativeAdMapper != null && !unifiedNativeAdMapper.getOverrideImpressionRecording()) {
                zzayu.zzea("Could not call onAdImpression since setOverrideImpressionRecording is not set to true");
                return;
            }
            if (nativeAdMapper != null && !nativeAdMapper.getOverrideImpressionRecording()) {
                zzayu.zzea("Could not call onAdImpression since setOverrideImpressionRecording is not set to true");
                return;
            }
        }
        zzayu.zzea("Adapter called onAdImpression.");
        try {
            this.zzdds.onAdImpression();
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onVideoEnd(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzayu.zzea("Adapter called onVideoEnd.");
        try {
            this.zzdds.onVideoEnd();
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final NativeAdMapper zzsw() {
        return this.zzddt;
    }

    public final UnifiedNativeAdMapper zzsx() {
        return this.zzddu;
    }

    public final NativeCustomTemplateAd zzsy() {
        return this.zzddv;
    }
}

