/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.text.TextUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzabi;
import com.google.android.gms.internal.ads.zzapm;
import com.google.android.gms.internal.ads.zzapo;
import com.google.android.gms.internal.ads.zzapp;
import com.google.android.gms.internal.ads.zzapq;
import com.google.android.gms.internal.ads.zzapr;
import com.google.android.gms.internal.ads.zzayk;
import com.google.android.gms.internal.ads.zzayu;
import com.google.android.gms.internal.ads.zzayy;
import com.google.android.gms.internal.ads.zzazb;
import com.google.android.gms.internal.ads.zzddq;
import com.google.android.gms.internal.ads.zzddv;
import com.google.android.gms.internal.ads.zzdpt;
import com.google.android.gms.internal.ads.zzve;
import com.google.android.gms.internal.ads.zzzn;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class zzapn
implements zzapr {
    private static final Object lock = new Object();
    @VisibleForTesting
    private static zzapr zzdif = null;
    @VisibleForTesting
    private static zzapr zzdig = null;
    private final Object zzdih = new Object();
    private final Context zzcgd;
    private final WeakHashMap<Thread, Boolean> zzdii = new WeakHashMap();
    private final ExecutorService zzxk = zzddq.zzaqs().zzdt(zzddv.zzgtv);
    private final zzazb zzdij;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzapr zzs(Context context) {
        Object object = lock;
        synchronized (object) {
            if (zzdif == null) {
                zzdif = zzabi.zzcun.get() != false ? new zzapn(context) : new zzapq();
            }
        }
        return zzdif;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzapr zzc(Context context, zzazb zzazb2) {
        Object object = lock;
        synchronized (object) {
            if (zzdig == null) {
                if (zzabi.zzcun.get().booleanValue()) {
                    zzapn zzapn2 = new zzapn(context, zzazb2);
                    Thread thread = Looper.getMainLooper().getThread();
                    zzapn zzapn3 = zzapn2;
                    if (thread != null) {
                        Object object2 = zzapn3.zzdih;
                        synchronized (object2) {
                            zzapn3.zzdii.put(thread, true);
                        }
                        object2 = thread.getUncaughtExceptionHandler();
                        thread.setUncaughtExceptionHandler(new zzapo(zzapn3, (Thread.UncaughtExceptionHandler)object2));
                    }
                    zzapn zzapn4 = zzapn2;
                    Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
                    Thread.setDefaultUncaughtExceptionHandler(new zzapp(zzapn4, uncaughtExceptionHandler));
                    zzdig = zzapn2;
                } else {
                    zzdig = new zzapq();
                }
            }
        }
        return zzdig;
    }

    private zzapn(Context context) {
        this(context, zzazb.zzxm());
    }

    private zzapn(Context context, zzazb zzazb2) {
        this.zzcgd = context.getApplicationContext() != null ? context.getApplicationContext() : context;
        this.zzdij = zzazb2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void zza(Thread thread, Throwable throwable) {
        Throwable throwable2;
        zzapn zzapn2 = this;
        if (throwable2 == null) return;
        boolean bl = false;
        boolean bl2 = false;
        for (throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            for (StackTraceElement stackTraceElement : throwable2.getStackTrace()) {
                if (zzayk.zzet(stackTraceElement.getClassName())) {
                    bl = true;
                }
                if (!zzapn2.getClass().getName().equals(stackTraceElement.getClassName())) continue;
                bl2 = true;
            }
        }
        if (!bl) return;
        if (bl2) return;
        boolean bl3 = true;
        if (!bl3) return;
        throwable2 = throwable;
        String string = "";
        Throwable throwable3 = throwable2;
        this.zza(throwable2, string, 1.0f);
    }

    @Override
    public final void zza(Throwable throwable, String string) {
        this.zza(throwable, string, 1.0f);
    }

    @Override
    public final void zza(Throwable throwable, String string, float f) {
        if (zzayk.zzc(throwable) == null) {
            return;
        }
        String string2 = throwable.getClass().getName();
        StringWriter stringWriter = new StringWriter();
        zzdpt.zza((Throwable)throwable, (PrintWriter)new PrintWriter(stringWriter));
        String string3 = stringWriter.toString();
        boolean bl = Math.random() < (double)f;
        int n = f > 0.0f ? (int)(1.0f / f) : 1;
        if (bl) {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = n;
            String string4 = string;
            String string5 = string3;
            Object object = string2;
            arrayList.add(this.zza((String)object, string5, string4, n2).toString());
            object = arrayList;
            zzapn zzapn2 = this;
            ArrayList arrayList2 = (ArrayList)object;
            int n3 = arrayList2.size();
            string5 = null;
            for (int i = 0; i < n3; ++i) {
                Object e = arrayList2.get(i);
                string4 = (String)e;
                zzayy zzayy2 = new zzayy();
                zzapn2.zzxk.execute(new zzapm(zzayy2, string4));
            }
        }
    }

    @VisibleForTesting
    private final Uri.Builder zza(String string, String string2, String string3, int n) {
        boolean bl = false;
        try {
            bl = Wrappers.packageManager((Context)this.zzcgd).isCallerInstantApp();
        }
        catch (Throwable throwable) {
            zzayu.zzc("Error fetching instant app info", throwable);
        }
        String string4 = "unknown";
        try {
            string4 = this.zzcgd.getPackageName();
        }
        catch (Throwable throwable) {
            zzayu.zzez("Cannot obtain package name, proceeding.");
        }
        String string5 = Build.MANUFACTURER;
        String string6 = Build.MODEL;
        return new Uri.Builder().scheme("https").path("//pagead2.googlesyndication.com/pagead/gen_204").appendQueryParameter("is_aia", Boolean.toString(bl)).appendQueryParameter("id", "gmob-apps-report-exception").appendQueryParameter("os", Build.VERSION.RELEASE).appendQueryParameter("api", String.valueOf(Build.VERSION.SDK_INT)).appendQueryParameter("device", string6.startsWith(string5) ? string6 : new StringBuilder(1 + String.valueOf(string5).length() + String.valueOf(string6).length()).append(string5).append(" ").append(string6).toString()).appendQueryParameter("js", this.zzdij.zzbma).appendQueryParameter("appid", string4).appendQueryParameter("exceptiontype", string).appendQueryParameter("stacktrace", string2).appendQueryParameter("eids", TextUtils.join((CharSequence)",", zzzn.zzqg())).appendQueryParameter("exceptionkey", string3).appendQueryParameter("cl", "278033407").appendQueryParameter("rc", "dev").appendQueryParameter("session_id", zzve.zzoz()).appendQueryParameter("sampling_rate", Integer.toString(n)).appendQueryParameter("pb_tm", String.valueOf(zzabi.zzcul.get()));
    }

    static final /* synthetic */ void zza(zzayy zzayy2, String string) {
        zzayy2.zzen(string);
    }
}

