/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.util.JsonWriter;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.internal.ads.zzaax;
import com.google.android.gms.internal.ads.zzayk;
import com.google.android.gms.internal.ads.zzayq;
import com.google.android.gms.internal.ads.zzayr;
import com.google.android.gms.internal.ads.zzays;
import com.google.android.gms.internal.ads.zzayt;
import com.google.android.gms.internal.ads.zzayu;
import com.google.android.gms.internal.ads.zzayv;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public final class zzayo {
    private static Object lock = new Object();
    @GuardedBy(value="lock")
    private static boolean zzdvs = false;
    @GuardedBy(value="lock")
    private static boolean enabled = false;
    private static Clock zzbmq = DefaultClock.getInstance();
    private static final Set<String> zzdvt = new HashSet<String>(Arrays.asList(new String[0]));
    private final List<String> zzdvu;

    public zzayo() {
        this(null);
    }

    public zzayo(@Nullable String string) {
        List<String> list;
        if (!zzayo.isEnabled()) {
            list = new ArrayList<String>();
        } else {
            String string2 = UUID.randomUUID().toString();
            String[] stringArray = new String[1];
            String string3 = String.valueOf(string2);
            stringArray[0] = string3.length() != 0 ? "network_request_".concat(string3) : new String("network_request_");
            list = Arrays.asList(stringArray);
        }
        this.zzdvu = list;
    }

    public final void zza(HttpURLConnection httpURLConnection, @Nullable byte[] byArray) {
        if (!zzayo.isEnabled()) {
            return;
        }
        HashMap<String, List<String>> hashMap = httpURLConnection.getRequestProperties() == null ? null : new HashMap<String, List<String>>(httpURLConnection.getRequestProperties());
        String string = new String(httpURLConnection.getURL().toString());
        String string2 = new String(httpURLConnection.getRequestMethod());
        this.zzb(string, string2, hashMap, byArray);
    }

    public final void zza(String string, String string2, @Nullable Map<String, ?> map, @Nullable byte[] byArray) {
        if (!zzayo.isEnabled()) {
            return;
        }
        this.zzb(string, string2, map, byArray);
    }

    private final void zzb(String string, String string2, @Nullable Map<String, ?> map, @Nullable byte[] byArray) {
        this.zza("onNetworkRequest", new zzayr(string, string2, map, byArray));
    }

    public final void zza(HttpURLConnection httpURLConnection, int n) {
        if (!zzayo.isEnabled()) {
            return;
        }
        HashMap<String, List<String>> hashMap = httpURLConnection.getHeaderFields() == null ? null : new HashMap<String, List<String>>(httpURLConnection.getHeaderFields());
        this.zzb(hashMap, n);
        if (n < 200 || n >= 300) {
            String string = null;
            try {
                string = httpURLConnection.getResponseMessage();
            }
            catch (IOException iOException) {
                String string2 = String.valueOf(iOException.getMessage());
                zzayu.zzez(string2.length() != 0 ? "Can not get error message from error HttpURLConnection\n".concat(string2) : new String("Can not get error message from error HttpURLConnection\n"));
            }
            this.zzev(string);
        }
    }

    public final void zza(@Nullable Map<String, ?> map, int n) {
        if (!zzayo.isEnabled()) {
            return;
        }
        this.zzb(map, n);
        if (n < 200 || n >= 300) {
            this.zzev(null);
        }
    }

    private final void zzb(@Nullable Map<String, ?> map, int n) {
        this.zza("onNetworkResponse", new zzayq(n, map));
    }

    public final void zzeu(@Nullable String string) {
        if (!zzayo.isEnabled()) {
            return;
        }
        if (string == null) {
            return;
        }
        byte[] byArray = string.getBytes();
        this.zzi(byArray);
    }

    public final void zzi(byte[] byArray) {
        this.zza("onNetworkResponseBody", new zzayt(byArray));
    }

    private final void zzev(@Nullable String string) {
        this.zza("onNetworkRequestError", new zzays(string));
    }

    private static void zza(JsonWriter jsonWriter, @Nullable Map<String, ?> map) throws IOException {
        if (map == null) {
            return;
        }
        jsonWriter.name("headers").beginArray();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String string = entry.getKey();
            if (zzdvt.contains(string)) continue;
            if (entry.getValue() instanceof List) {
                for (String string2 : (List)entry.getValue()) {
                    jsonWriter.beginObject();
                    jsonWriter.name("name").value(string);
                    jsonWriter.name("value").value(string2);
                    jsonWriter.endObject();
                }
                continue;
            }
            if (entry.getValue() instanceof String) {
                jsonWriter.beginObject();
                jsonWriter.name("name").value(string);
                jsonWriter.name("value").value((String)entry.getValue());
                jsonWriter.endObject();
                continue;
            }
            zzayu.zzex("Connection headers should be either Map<String, String> or Map<String, List<String>>");
            break;
        }
        jsonWriter.endArray();
    }

    private final void zza(String string, zzayv zzayv2) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
        try {
            jsonWriter.beginObject();
            jsonWriter.name("timestamp").value(zzbmq.currentTimeMillis());
            jsonWriter.name("event").value(string);
            jsonWriter.name("components").beginArray();
            for (String string2 : this.zzdvu) {
                jsonWriter.value(string2);
            }
            jsonWriter.endArray();
            zzayv2.zzb(jsonWriter);
            jsonWriter.endObject();
            jsonWriter.flush();
            jsonWriter.close();
        }
        catch (IOException iOException) {
            zzayu.zzc("unable to log", iOException);
        }
        zzayo.zzew(stringWriter.toString());
    }

    private static synchronized void zzew(String string) {
        zzayu.zzey("GMA Debug BEGIN");
        for (int i = 0; i < string.length(); i += 4000) {
            int n = Math.min(i + 4000, string.length());
            String string2 = String.valueOf(string.substring(i, n));
            zzayu.zzey(string2.length() != 0 ? "GMA Debug CONTENT ".concat(string2) : new String("GMA Debug CONTENT "));
        }
        zzayu.zzey("GMA Debug FINISH");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzxk() {
        Object object = lock;
        synchronized (object) {
            zzdvs = false;
            enabled = false;
            zzayu.zzez("Ad debug logging enablement is out of date.");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzar(boolean bl) {
        Object object = lock;
        synchronized (object) {
            zzdvs = true;
            enabled = bl;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean zzxl() {
        Object object = lock;
        synchronized (object) {
            return zzdvs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEnabled() {
        Object object = lock;
        synchronized (object) {
            return zzdvs && enabled;
        }
    }

    public static boolean zzbo(Context context) {
        if (Build.VERSION.SDK_INT < 17) {
            return false;
        }
        if (!zzaax.zzctd.get().booleanValue()) {
            return false;
        }
        try {
            return Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"development_settings_enabled", (int)0) != 0;
        }
        catch (Exception exception) {
            zzayu.zzd("Fail to determine debug setting.", exception);
            return false;
        }
    }

    static final /* synthetic */ void zza(String string, JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("params").beginObject();
        if (string != null) {
            jsonWriter.name("error_description").value(string);
        }
        jsonWriter.endObject();
    }

    static final /* synthetic */ void zza(byte[] byArray, JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("params").beginObject();
        int n = byArray.length;
        String string = Base64Utils.encode((byte[])byArray);
        if (n < 10000) {
            jsonWriter.name("body").value(string);
        } else {
            String string2 = zzayk.zzes(string);
            if (string2 != null) {
                jsonWriter.name("bodydigest").value(string2);
            }
        }
        jsonWriter.name("bodylength").value((long)n);
        jsonWriter.endObject();
    }

    static final /* synthetic */ void zza(int n, Map map, JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("params").beginObject();
        jsonWriter.name("firstline").beginObject();
        jsonWriter.name("code").value((long)n);
        jsonWriter.endObject();
        zzayo.zza(jsonWriter, map);
        jsonWriter.endObject();
    }

    static final /* synthetic */ void zza(String string, String string2, Map map, byte[] byArray, JsonWriter jsonWriter) throws IOException {
        jsonWriter.name("params").beginObject();
        jsonWriter.name("firstline").beginObject();
        jsonWriter.name("uri").value(string);
        jsonWriter.name("verb").value(string2);
        jsonWriter.endObject();
        zzayo.zza(jsonWriter, map);
        if (byArray != null) {
            jsonWriter.name("body").value(Base64Utils.encode((byte[])byArray));
        }
        jsonWriter.endObject();
    }
}

