/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaal;
import com.google.android.gms.internal.ads.zzakz;
import com.google.android.gms.internal.ads.zzayk;
import com.google.android.gms.internal.ads.zzayu;
import com.google.android.gms.internal.ads.zztx;
import com.google.android.gms.internal.ads.zzty;
import com.google.android.gms.internal.ads.zzuc;
import com.google.android.gms.internal.ads.zzuh;
import com.google.android.gms.internal.ads.zzuj;
import com.google.android.gms.internal.ads.zzul;
import com.google.android.gms.internal.ads.zzup;
import com.google.android.gms.internal.ads.zzuq;
import com.google.android.gms.internal.ads.zzus;
import com.google.android.gms.internal.ads.zzuw;
import com.google.android.gms.internal.ads.zzvd;
import com.google.android.gms.internal.ads.zzve;
import com.google.android.gms.internal.ads.zzvu;
import com.google.android.gms.internal.ads.zzxb;
import com.google.android.gms.internal.ads.zzxj;
import com.google.android.gms.internal.ads.zzxo;
import com.google.android.gms.internal.ads.zzyw;
import java.util.concurrent.atomic.AtomicBoolean;

public final class zzxl {
    private final zzakz zzbrb = new zzakz();
    private final zzuh zzaba;
    private final AtomicBoolean zzcek;
    private final VideoController zzcel = new VideoController();
    @VisibleForTesting
    private final zzvd zzcem = new zzxo(this);
    private zzty zzcbt;
    private AdListener zzcbw;
    private AdSize[] zzcdf;
    private AppEventListener zzbkj;
    private zzvu zzbqy;
    private OnCustomRenderedAdLoadedListener zzcen;
    private VideoOptions zzbka;
    private String zzbqz;
    private ViewGroup zzceo;
    private int zzcep;
    private boolean zzbkh;

    public zzxl(ViewGroup viewGroup) {
        this(viewGroup, null, false, zzuh.zzccn, 0);
    }

    public zzxl(ViewGroup viewGroup, int n) {
        this(viewGroup, null, false, zzuh.zzccn, n);
    }

    public zzxl(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl) {
        this(viewGroup, attributeSet, bl, zzuh.zzccn, 0);
    }

    public zzxl(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, int n) {
        this(viewGroup, attributeSet, false, zzuh.zzccn, n);
    }

    @VisibleForTesting
    private zzxl(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzuh zzuh2, zzvu zzvu2, int n) {
        this.zzceo = viewGroup;
        this.zzaba = zzuh2;
        this.zzbqy = null;
        this.zzcek = new AtomicBoolean(false);
        this.zzcep = n;
        if (attributeSet != null) {
            Context context = viewGroup.getContext();
            try {
                zzuq zzuq2 = new zzuq(context, attributeSet);
                this.zzcdf = zzuq2.zzy(bl);
                this.zzbqz = zzuq2.getAdUnitId();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzve.zzou().zza(viewGroup, new zzuj(context, AdSize.BANNER), illegalArgumentException.getMessage(), illegalArgumentException.getMessage());
                return;
            }
            if (viewGroup.isInEditMode()) {
                zzuj zzuj2;
                zzayk zzayk2 = zzve.zzou();
                int n2 = this.zzcep;
                AdSize adSize = this.zzcdf[0];
                Context context2 = context;
                if (adSize.equals(AdSize.INVALID)) {
                    zzuj2 = zzuj.zzon();
                } else {
                    boolean bl2;
                    zzuj zzuj3 = new zzuj(context2, adSize);
                    new zzuj(context2, adSize).zzccr = bl2 = zzxl.zzck(n2);
                    zzuj2 = zzuj3;
                }
                zzayk2.zza(viewGroup, zzuj2, "Ads by Google");
            }
        }
    }

    @VisibleForTesting
    private zzxl(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzuh zzuh2, int n) {
        this(viewGroup, attributeSet, bl, zzuh2, null, n);
    }

    public final void destroy() {
        try {
            if (this.zzbqy != null) {
                this.zzbqy.destroy();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final AdListener getAdListener() {
        return this.zzcbw;
    }

    public final AdSize getAdSize() {
        try {
            zzuj zzuj2;
            if (this.zzbqy != null && (zzuj2 = this.zzbqy.zzjz()) != null) {
                return zzuj2.zzoo();
            }
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
        }
        if (this.zzcdf != null) {
            return this.zzcdf[0];
        }
        return null;
    }

    public final AdSize[] getAdSizes() {
        return this.zzcdf;
    }

    public final String getAdUnitId() {
        if (this.zzbqz == null && this.zzbqy != null) {
            try {
                this.zzbqz = this.zzbqy.getAdUnitId();
            }
            catch (RemoteException remoteException) {
                zzayu.zze("#007 Could not call remote method.", remoteException);
            }
        }
        return this.zzbqz;
    }

    public final AppEventListener getAppEventListener() {
        return this.zzbkj;
    }

    public final OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzcen;
    }

    public final void zza(zzxj zzxj2) {
        try {
            if (this.zzbqy == null) {
                zzvu zzvu2;
                zzuj zzuj2;
                zzxl zzxl2 = this;
                if ((zzxl2.zzcdf == null || zzxl2.zzbqz == null) && zzxl2.zzbqy == null) {
                    throw new IllegalStateException("The ad size and ad unit ID must be set before loadAd is called.");
                }
                zzxl zzxl3 = zzxl2;
                Context context = zzxl3.zzceo.getContext();
                Object object = zzuj2 = zzxl.zza(context, zzxl3.zzcdf, zzxl3.zzcep);
                if ("search_v2".equals(object.zzabg)) {
                    String string = zzxl3.zzbqz;
                    zzuj zzuj3 = zzuj2;
                    Context context2 = context;
                    object = zzve.zzov();
                    Context context3 = context2;
                    zzvu2 = (zzvu)new zzuw((zzup)object, context2, zzuj3, string).zzd(context3, false);
                } else {
                    zzakz zzakz2 = zzxl3.zzbrb;
                    String string = zzxl3.zzbqz;
                    zzuj zzuj4 = zzuj2;
                    Context context4 = context;
                    object = zzve.zzov();
                    Context context5 = context4;
                    zzvu2 = (zzvu)new zzus((zzup)object, context4, zzuj4, string, zzakz2).zzd(context5, false);
                }
                zzxl2.zzbqy = zzvu2;
                zzxl2.zzbqy.zza(new zzuc(zzxl2.zzcem));
                if (zzxl2.zzcbt != null) {
                    zzxl2.zzbqy.zza(new zztx(zzxl2.zzcbt));
                }
                if (zzxl2.zzbkj != null) {
                    zzxl2.zzbqy.zza(new zzul(zzxl2.zzbkj));
                }
                if (zzxl2.zzcen != null) {
                    zzxl2.zzbqy.zza(new zzaal(zzxl2.zzcen));
                }
                if (zzxl2.zzbka != null) {
                    zzxl2.zzbqy.zza(new zzyw(zzxl2.zzbka));
                }
                zzxl2.zzbqy.setManualImpressionsEnabled(zzxl2.zzbkh);
                zzxl zzxl4 = zzxl2;
                try {
                    IObjectWrapper iObjectWrapper = zzxl4.zzbqy.zzjx();
                    if (iObjectWrapper != null) {
                        zzxl4.zzceo.addView((View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
                    }
                }
                catch (RemoteException remoteException) {
                    zzayu.zze("#007 Could not call remote method.", remoteException);
                }
            }
            if (this.zzbqy.zza(zzuh.zza(this.zzceo.getContext(), zzxj2))) {
                this.zzbrb.zzf(zzxj2.zzpq());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void pause() {
        try {
            if (this.zzbqy != null) {
                this.zzbqy.pause();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void recordManualImpression() {
        if (this.zzcek.getAndSet(true)) {
            return;
        }
        try {
            if (this.zzbqy != null) {
                this.zzbqy.zzjy();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void resume() {
        try {
            if (this.zzbqy != null) {
                this.zzbqy.resume();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setAdListener(AdListener adListener) {
        this.zzcbw = adListener;
        this.zzcem.zza(adListener);
    }

    public final void zza(zzty zzty2) {
        try {
            this.zzcbt = zzty2;
            if (this.zzbqy != null) {
                this.zzbqy.zza(zzty2 != null ? new zztx(zzty2) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setAdSizes(AdSize ... adSizeArray) {
        if (this.zzcdf != null) {
            throw new IllegalStateException("The ad size can only be set once on AdView.");
        }
        this.zza(adSizeArray);
    }

    public final void zza(AdSize ... adSizeArray) {
        this.zzcdf = adSizeArray;
        try {
            if (this.zzbqy != null) {
                this.zzbqy.zza(zzxl.zza(this.zzceo.getContext(), this.zzcdf, this.zzcep));
            }
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
        }
        this.zzceo.requestLayout();
    }

    public final void setAdUnitId(String string) {
        if (this.zzbqz != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on AdView.");
        }
        this.zzbqz = string;
    }

    public final void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzbkj = appEventListener;
            if (this.zzbqy != null) {
                this.zzbqy.zza(appEventListener != null ? new zzul(appEventListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        this.zzcen = onCustomRenderedAdLoadedListener;
        try {
            if (this.zzbqy != null) {
                this.zzbqy.zza(onCustomRenderedAdLoadedListener != null ? new zzaal(onCustomRenderedAdLoadedListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setManualImpressionsEnabled(boolean bl) {
        this.zzbkh = bl;
        try {
            if (this.zzbqy != null) {
                this.zzbqy.setManualImpressionsEnabled(this.zzbkh);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final String getMediationAdapterClassName() {
        try {
            if (this.zzbqy != null) {
                return this.zzbqy.zzka();
            }
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
        }
        return null;
    }

    public final boolean isLoading() {
        try {
            if (this.zzbqy != null) {
                return this.zzbqy.isLoading();
            }
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
        }
        return false;
    }

    public final VideoController getVideoController() {
        return this.zzcel;
    }

    public final zzxb zzdl() {
        if (this.zzbqy == null) {
            return null;
        }
        try {
            return this.zzbqy.getVideoController();
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return null;
        }
    }

    public final void setVideoOptions(VideoOptions videoOptions) {
        this.zzbka = videoOptions;
        try {
            if (this.zzbqy != null) {
                this.zzbqy.zza(videoOptions == null ? null : new zzyw(videoOptions));
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final VideoOptions getVideoOptions() {
        return this.zzbka;
    }

    public final boolean zza(zzvu zzvu2) {
        IObjectWrapper iObjectWrapper;
        if (zzvu2 == null) {
            return false;
        }
        try {
            iObjectWrapper = zzvu2.zzjx();
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#007 Could not call remote method.", remoteException);
            return false;
        }
        if (iObjectWrapper == null) {
            return false;
        }
        if (((View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)).getParent() != null) {
            return false;
        }
        this.zzceo.addView((View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        this.zzbqy = zzvu2;
        return true;
    }

    private static zzuj zza(Context context, AdSize[] adSizeArray, int n) {
        boolean bl;
        Object object = adSizeArray;
        int n2 = adSizeArray.length;
        for (int i = 0; i < n2; ++i) {
            if (!object[i].equals(AdSize.INVALID)) continue;
            return zzuj.zzon();
        }
        object = new zzuj(context, adSizeArray);
        new zzuj(context, adSizeArray).zzccr = bl = zzxl.zzck(n);
        return object;
    }

    private static boolean zzck(int n) {
        return n == 1;
    }

    static /* synthetic */ VideoController zza(zzxl zzxl2) {
        return zzxl2.zzcel;
    }
}

