/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.doubleclick.PublisherInterstitialAd;
import com.google.android.gms.ads.reward.AdMetadataListener;
import com.google.android.gms.ads.reward.RewardedVideoAdListener;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaal;
import com.google.android.gms.internal.ads.zzakz;
import com.google.android.gms.internal.ads.zzarv;
import com.google.android.gms.internal.ads.zzayu;
import com.google.android.gms.internal.ads.zztx;
import com.google.android.gms.internal.ads.zzty;
import com.google.android.gms.internal.ads.zzuc;
import com.google.android.gms.internal.ads.zzud;
import com.google.android.gms.internal.ads.zzuh;
import com.google.android.gms.internal.ads.zzuj;
import com.google.android.gms.internal.ads.zzul;
import com.google.android.gms.internal.ads.zzup;
import com.google.android.gms.internal.ads.zzuv;
import com.google.android.gms.internal.ads.zzve;
import com.google.android.gms.internal.ads.zzvu;
import com.google.android.gms.internal.ads.zzxj;

public final class zzxn {
    private final zzakz zzbrb = new zzakz();
    private final Context zzup;
    private final zzuh zzaba;
    private AdListener zzcbw;
    private zzty zzcbt;
    private zzvu zzbqy;
    private String zzbqz;
    private AdMetadataListener zzcbx;
    private AppEventListener zzbkj;
    private OnCustomRenderedAdLoadedListener zzcen;
    private RewardedVideoAdListener zzceu;
    private boolean zzcev;
    private boolean zzbld;

    public zzxn(Context context) {
        this(context, zzuh.zzccn, null);
    }

    public zzxn(Context context, PublisherInterstitialAd publisherInterstitialAd) {
        this(context, zzuh.zzccn, publisherInterstitialAd);
    }

    @VisibleForTesting
    private zzxn(Context context, zzuh zzuh2, PublisherInterstitialAd publisherInterstitialAd) {
        this.zzup = context;
        this.zzaba = zzuh2;
    }

    public final AdListener getAdListener() {
        return this.zzcbw;
    }

    public final String getAdUnitId() {
        return this.zzbqz;
    }

    public final AppEventListener getAppEventListener() {
        return this.zzbkj;
    }

    public final OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzcen;
    }

    public final boolean isLoaded() {
        try {
            if (this.zzbqy == null) {
                return false;
            }
            return this.zzbqy.isReady();
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#008 Must be called on the main UI thread.", remoteException);
            return false;
        }
    }

    public final boolean isLoading() {
        try {
            if (this.zzbqy == null) {
                return false;
            }
            return this.zzbqy.isLoading();
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#008 Must be called on the main UI thread.", remoteException);
            return false;
        }
    }

    public final void zza(zzxj zzxj2) {
        try {
            if (this.zzbqy == null) {
                String string = "loadAd";
                zzxn zzxn2 = this;
                if (zzxn2.zzbqz == null) {
                    zzxn2.zzcn(string);
                }
                zzuj zzuj2 = zzxn2.zzcev ? zzuj.zzol() : new zzuj();
                zzakz zzakz2 = zzxn2.zzbrb;
                String string2 = zzxn2.zzbqz;
                zzuj zzuj3 = zzuj2;
                Context context = zzxn2.zzup;
                zzup zzup2 = zzve.zzov();
                Context context2 = context;
                zzxn2.zzbqy = (zzvu)new zzuv(zzup2, context, zzuj3, string2, zzakz2).zzd(context2, false);
                if (zzxn2.zzcbw != null) {
                    zzxn2.zzbqy.zza(new zzuc(zzxn2.zzcbw));
                }
                if (zzxn2.zzcbt != null) {
                    zzxn2.zzbqy.zza(new zztx(zzxn2.zzcbt));
                }
                if (zzxn2.zzcbx != null) {
                    zzxn2.zzbqy.zza(new zzud(zzxn2.zzcbx));
                }
                if (zzxn2.zzbkj != null) {
                    zzxn2.zzbqy.zza(new zzul(zzxn2.zzbkj));
                }
                if (zzxn2.zzcen != null) {
                    zzxn2.zzbqy.zza(new zzaal(zzxn2.zzcen));
                }
                if (zzxn2.zzceu != null) {
                    zzxn2.zzbqy.zza(new zzarv(zzxn2.zzceu));
                }
                zzxn2.zzbqy.setImmersiveMode(zzxn2.zzbld);
            }
            if (this.zzbqy.zza(zzuh.zza(this.zzup, zzxj2))) {
                this.zzbrb.zzf(zzxj2.zzpq());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#008 Must be called on the main UI thread.", remoteException);
            return;
        }
    }

    public final void setAdListener(AdListener adListener) {
        try {
            this.zzcbw = adListener;
            if (this.zzbqy != null) {
                this.zzbqy.zza(adListener != null ? new zzuc(adListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#008 Must be called on the main UI thread.", remoteException);
            return;
        }
    }

    public final void zza(zzty zzty2) {
        try {
            this.zzcbt = zzty2;
            if (this.zzbqy != null) {
                this.zzbqy.zza(zzty2 != null ? new zztx(zzty2) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#008 Must be called on the main UI thread.", remoteException);
            return;
        }
    }

    public final void setAdUnitId(String string) {
        if (this.zzbqz != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on InterstitialAd.");
        }
        this.zzbqz = string;
    }

    public final void setAdMetadataListener(AdMetadataListener adMetadataListener) {
        try {
            this.zzcbx = adMetadataListener;
            if (this.zzbqy != null) {
                this.zzbqy.zza(adMetadataListener != null ? new zzud(adMetadataListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#008 Must be called on the main UI thread.", remoteException);
            return;
        }
    }

    public final Bundle getAdMetadata() {
        try {
            if (this.zzbqy != null) {
                return this.zzbqy.getAdMetadata();
            }
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#008 Must be called on the main UI thread.", remoteException);
        }
        return new Bundle();
    }

    public final void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzbkj = appEventListener;
            if (this.zzbqy != null) {
                this.zzbqy.zza(appEventListener != null ? new zzul(appEventListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#008 Must be called on the main UI thread.", remoteException);
            return;
        }
    }

    public final void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        try {
            this.zzcen = onCustomRenderedAdLoadedListener;
            if (this.zzbqy != null) {
                this.zzbqy.zza(onCustomRenderedAdLoadedListener != null ? new zzaal(onCustomRenderedAdLoadedListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#008 Must be called on the main UI thread.", remoteException);
            return;
        }
    }

    public final void setRewardedVideoAdListener(RewardedVideoAdListener rewardedVideoAdListener) {
        try {
            this.zzceu = rewardedVideoAdListener;
            if (this.zzbqy != null) {
                this.zzbqy.zza(rewardedVideoAdListener != null ? new zzarv(rewardedVideoAdListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#008 Must be called on the main UI thread.", remoteException);
            return;
        }
    }

    public final void zzd(boolean bl) {
        this.zzcev = true;
    }

    public final String getMediationAdapterClassName() {
        try {
            if (this.zzbqy != null) {
                return this.zzbqy.zzka();
            }
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#008 Must be called on the main UI thread.", remoteException);
        }
        return null;
    }

    public final void show() {
        try {
            this.zzcn("show");
            this.zzbqy.showInterstitial();
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#008 Must be called on the main UI thread.", remoteException);
            return;
        }
    }

    public final void setImmersiveMode(boolean bl) {
        try {
            this.zzbld = bl;
            if (this.zzbqy != null) {
                this.zzbqy.setImmersiveMode(bl);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zze("#008 Must be called on the main UI thread.", remoteException);
            return;
        }
    }

    private final void zzcn(String string) {
        if (this.zzbqy == null) {
            throw new IllegalStateException(new StringBuilder(63 + String.valueOf(string).length()).append("The ad unit ID must be set on InterstitialAd before ").append(string).append(" is called.").toString());
        }
    }
}

