/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.RequestConfiguration;
import com.google.android.gms.ads.initialization.AdapterStatus;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.google.android.gms.ads.mediation.rtb.RtbAdapter;
import com.google.android.gms.ads.reward.RewardedVideoAd;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzagn;
import com.google.android.gms.internal.ads.zzagv;
import com.google.android.gms.internal.ads.zzagy;
import com.google.android.gms.internal.ads.zzaku;
import com.google.android.gms.internal.ads.zzakz;
import com.google.android.gms.internal.ads.zzarl;
import com.google.android.gms.internal.ads.zzarw;
import com.google.android.gms.internal.ads.zzayk;
import com.google.android.gms.internal.ads.zzayu;
import com.google.android.gms.internal.ads.zzup;
import com.google.android.gms.internal.ads.zzux;
import com.google.android.gms.internal.ads.zzvc;
import com.google.android.gms.internal.ads.zzve;
import com.google.android.gms.internal.ads.zzwk;
import com.google.android.gms.internal.ads.zzxp;
import com.google.android.gms.internal.ads.zzxr;
import com.google.android.gms.internal.ads.zzxs;
import com.google.android.gms.internal.ads.zzxt;
import com.google.android.gms.internal.ads.zzxv;
import com.google.android.gms.internal.ads.zzyq;
import com.google.android.gms.internal.ads.zzzn;
import java.util.HashMap;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

public final class zzxq {
    @GuardedBy(value="lock")
    private static zzxq zzcez;
    private static final Object lock;
    private zzwk zzcfa;
    private RewardedVideoAd zzcfb;
    @NonNull
    private RequestConfiguration zzcfc = new RequestConfiguration.Builder().build();
    private InitializationStatus zzcfd;

    private zzxq() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzxq zzpw() {
        Object object = lock;
        synchronized (object) {
            if (zzcez == null) {
                zzcez = new zzxq();
            }
            return zzcez;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(Context context, String string, zzxv zzxv2, OnInitializationCompleteListener onInitializationCompleteListener) {
        Object object = lock;
        synchronized (object) {
            if (this.zzcfa != null) {
                return;
            }
            if (context == null) {
                throw new IllegalArgumentException("Context cannot be null.");
            }
            try {
                zzaku.zzsj().zzc(context, string);
                Context context2 = context;
                Object object2 = zzve.zzov();
                Context context3 = context2;
                this.zzcfa = (zzwk)new zzux((zzup)object2, context2).zzd(context3, false);
                if (onInitializationCompleteListener != null) {
                    this.zzcfa.zza(new zzxt(this, onInitializationCompleteListener, null));
                }
                this.zzcfa.zza(new zzakz());
                this.zzcfa.initialize();
                this.zzcfa.zza(string, ObjectWrapper.wrap((Object)new zzxp(this, context)));
                if (this.zzcfc.getTagForChildDirectedTreatment() != -1 || this.zzcfc.getTagForUnderAgeOfConsent() != -1) {
                    this.zza(this.zzcfc);
                }
                zzzn.initialize(context);
                object2 = zzzn.zzcom;
                if (!((Boolean)zzve.zzoy().zzd(object2)).booleanValue() && !this.zzpx()) {
                    zzayu.zzex("Google Mobile Ads SDK initialization functionality unavailable for this session. Ad requests can be made at any time.");
                    object2 = this;
                    this.zzcfd = new zzxr((zzxq)object2);
                    if (onInitializationCompleteListener != null) {
                        zzayk.zzyu.post((Runnable)new zzxs(this, onInitializationCompleteListener));
                    }
                }
            }
            catch (RemoteException remoteException) {
                zzayu.zzd("MobileAdsSettingManager initialization failed", remoteException);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RewardedVideoAd getRewardedVideoAdInstance(Context context) {
        Object object = lock;
        synchronized (object) {
            zzakz zzakz2;
            if (this.zzcfb != null) {
                return this.zzcfb;
            }
            zzakz zzakz3 = zzakz2 = new zzakz();
            Context context2 = context;
            zzup zzup2 = zzve.zzov();
            Context context3 = context2;
            zzarl zzarl2 = (zzarl)new zzvc(zzup2, context2, zzakz3).zzd(context3, false);
            this.zzcfb = new zzarw(context, zzarl2);
            return this.zzcfb;
        }
    }

    public final void setAppVolume(float f) {
        Preconditions.checkArgument((0.0f <= f && f <= 1.0f ? 1 : 0) != 0, (Object)"The app volume must be a value between 0 and 1 inclusive.");
        Preconditions.checkState((this.zzcfa != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to setting the app volume.");
        try {
            this.zzcfa.setAppVolume(f);
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zzc("Unable to set app volume.", remoteException);
            return;
        }
    }

    public final float zzpe() {
        float f = 1.0f;
        if (this.zzcfa == null) {
            return 1.0f;
        }
        try {
            f = this.zzcfa.zzpe();
        }
        catch (RemoteException remoteException) {
            zzayu.zzc("Unable to get app volume.", remoteException);
        }
        return f;
    }

    public final void setAppMuted(boolean bl) {
        Preconditions.checkState((this.zzcfa != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to setting app muted state.");
        try {
            this.zzcfa.setAppMuted(bl);
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zzc("Unable to set app mute state.", remoteException);
            return;
        }
    }

    public final boolean zzpf() {
        boolean bl = false;
        if (this.zzcfa == null) {
            return false;
        }
        try {
            bl = this.zzcfa.zzpf();
        }
        catch (RemoteException remoteException) {
            zzayu.zzc("Unable to get app mute state.", remoteException);
        }
        return bl;
    }

    public final void openDebugMenu(Context context, String string) {
        Preconditions.checkState((this.zzcfa != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to opening debug menu.");
        try {
            this.zzcfa.zzb(ObjectWrapper.wrap((Object)context), string);
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zzc("Unable to open debug menu.", remoteException);
            return;
        }
    }

    public final String getVersionString() {
        Preconditions.checkState((this.zzcfa != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to getting version string.");
        try {
            return this.zzcfa.getVersionString();
        }
        catch (RemoteException remoteException) {
            zzayu.zzc("Unable to get version string.", remoteException);
            return "";
        }
    }

    public final void registerRtbAdapter(Class<? extends RtbAdapter> clazz) {
        try {
            this.zzcfa.zzce(clazz.getCanonicalName());
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zzc("Unable to register RtbAdapter", remoteException);
            return;
        }
    }

    public final InitializationStatus getInitializationStatus() {
        Preconditions.checkState((this.zzcfa != null ? 1 : 0) != 0, (Object)"MobileAds.initialize() must be called prior to getting initialization status.");
        try {
            if (this.zzcfd != null) {
                return this.zzcfd;
            }
            return zzxq.zzb(this.zzcfa.zzpg());
        }
        catch (RemoteException remoteException) {
            zzayu.zzex("Unable to get Initialization status.");
            return null;
        }
    }

    private static InitializationStatus zzb(List<zzagn> list) {
        HashMap<String, AdapterStatus> hashMap = new HashMap<String, AdapterStatus>();
        for (zzagn zzagn2 : list) {
            hashMap.put(zzagn2.zzcyc, new zzagv(zzagn2.zzcyd ? AdapterStatus.State.READY : AdapterStatus.State.NOT_READY, zzagn2.description, zzagn2.zzcye));
        }
        return new zzagy(hashMap);
    }

    @NonNull
    public final RequestConfiguration getRequestConfiguration() {
        return this.zzcfc;
    }

    public final void setRequestConfiguration(@NonNull RequestConfiguration requestConfiguration) {
        Preconditions.checkArgument((requestConfiguration != null ? 1 : 0) != 0, (Object)"Null passed to setRequestConfiguration.");
        RequestConfiguration requestConfiguration2 = this.zzcfc;
        this.zzcfc = requestConfiguration;
        if (this.zzcfa == null) {
            return;
        }
        if (requestConfiguration2.getTagForChildDirectedTreatment() != requestConfiguration.getTagForChildDirectedTreatment() || requestConfiguration2.getTagForUnderAgeOfConsent() != requestConfiguration.getTagForUnderAgeOfConsent()) {
            this.zza(requestConfiguration);
        }
    }

    private final void zza(@NonNull RequestConfiguration requestConfiguration) {
        try {
            this.zzcfa.zza(new zzyq(requestConfiguration));
            return;
        }
        catch (RemoteException remoteException) {
            zzayu.zzc("Unable to set request configuration parcel.", remoteException);
            return;
        }
    }

    private final boolean zzpx() throws RemoteException {
        try {
            return this.zzcfa.getVersionString().endsWith("0");
        }
        catch (RemoteException remoteException) {
            zzayu.zzex("Unable to get version string.");
            return true;
        }
    }

    final /* synthetic */ void zza(OnInitializationCompleteListener onInitializationCompleteListener) {
        onInitializationCompleteListener.onInitializationComplete(this.zzcfd);
    }

    static /* synthetic */ InitializationStatus zza(zzxq zzxq2, List list) {
        return zzxq.zzb(list);
    }

    static {
        lock = new Object();
    }
}

