/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzaku;
import com.google.android.gms.internal.ads.zzayu;

public final class zzxw
extends ContentProvider {
    public final void attachInfo(Context context, ProviderInfo providerInfo) {
        zzaku zzaku2 = zzaku.zzsj();
        Bundle bundle = zzxw.zzh(context);
        Context context2 = context;
        if (bundle == null) {
            zzayu.zzex("Metadata was null.");
        } else {
            Boolean bl;
            Boolean bl2;
            String string;
            try {
                string = (String)bundle.get("com.google.android.gms.ads.APPLICATION_ID");
            }
            catch (ClassCastException classCastException) {
                throw new IllegalStateException("The com.google.android.gms.ads.APPLICATION_ID metadata must have a String value.", classCastException);
            }
            try {
                bl2 = (Boolean)bundle.get("com.google.android.gms.ads.AD_MANAGER_APP");
            }
            catch (ClassCastException classCastException) {
                throw new IllegalStateException("The com.google.android.gms.ads.AD_MANAGER_APP metadata must have a boolean value.", classCastException);
            }
            try {
                bl = (Boolean)bundle.get("com.google.android.gms.ads.DELAY_APP_MEASUREMENT_INIT");
            }
            catch (ClassCastException classCastException) {
                throw new IllegalStateException("The com.google.android.gms.ads.DELAY_APP_MEASUREMENT_INIT metadata must have a boolean value.", classCastException);
            }
            if (string != null && !string.matches("^/\\d+~.+$")) {
                if (!string.matches("^ca-app-pub-[0-9]{16}~[0-9]{10}$")) {
                    throw new IllegalStateException("\n\n******************************************************************************\n* Invalid application ID. Follow instructions here:                          *\n* https://googlemobileadssdk.page.link/admob-android-update-manifest         *\n* to find your app ID.                                                       *\n******************************************************************************\n\n");
                }
                String string2 = String.valueOf(string);
                zzayu.zzea(string2.length() != 0 ? "Publisher provided Google AdMob App ID in manifest: ".concat(string2) : new String("Publisher provided Google AdMob App ID in manifest: "));
                if (bl == null || !bl.booleanValue()) {
                    zzaku2.zzc(context2, string);
                }
            } else if (bl2 != null && bl2.booleanValue()) {
                if (bl == null || !bl.booleanValue()) {
                    zzaku2.zzm(context2);
                }
            } else {
                throw new IllegalStateException("\n\n******************************************************************************\n* The Google Mobile Ads SDK was initialized incorrectly. AdMob publishers    *\n* should follow the instructions here:                                       *\n* https://googlemobileadssdk.page.link/admob-android-update-manifest         *\n* to add a valid App ID inside the AndroidManifest.                          *\n* Google Ad Manager publishers should follow instructions here:              *\n* https://googlemobileadssdk.page.link/ad-manager-android-update-manifest.   *\n******************************************************************************\n\n");
            }
        }
        super.attachInfo(context, providerInfo);
    }

    @Nullable
    private static Bundle zzh(Context context) {
        try {
            return Wrappers.packageManager((Context)context).getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
        }
        catch (NullPointerException nullPointerException) {
            zzayu.zzc("Failed to load metadata: Null pointer exception.", nullPointerException);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            zzayu.zzc("Failed to load metadata: Package name not found.", nameNotFoundException);
        }
        return null;
    }

    public final boolean onCreate() {
        return false;
    }

    @Nullable
    public final Cursor query(@NonNull Uri uri, String[] stringArray, String string, String[] stringArray2, String string2) {
        return null;
    }

    @Nullable
    public final String getType(@NonNull Uri uri) {
        return null;
    }

    @Nullable
    public final Uri insert(@NonNull Uri uri, ContentValues contentValues) {
        return null;
    }

    public final int delete(@NonNull Uri uri, String string, String[] stringArray) {
        return 0;
    }

    public final int update(@NonNull Uri uri, ContentValues contentValues, String string, String[] stringArray) {
        return 0;
    }
}

