/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.zze;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;

@SafeParcelable.Class(creator="StatusCreator")
@KeepForSdk
public final class Status
extends AbstractSafeParcelable
implements Result,
ReflectedParcelable {
    @VisibleForTesting
    @KeepForSdk
    public static final Status RESULT_SUCCESS = new Status(0);
    @KeepForSdk
    public static final Status RESULT_INTERRUPTED = new Status(14);
    @KeepForSdk
    public static final Status RESULT_INTERNAL_ERROR = new Status(8);
    @KeepForSdk
    public static final Status RESULT_TIMEOUT = new Status(15);
    @KeepForSdk
    public static final Status RESULT_CANCELED = new Status(16);
    private static final Status zzdq = new Status(17);
    @KeepForSdk
    public static final Status RESULT_DEAD_CLIENT = new Status(18);
    public static final Parcelable.Creator<Status> CREATOR = new zze();
    @SafeParcelable.VersionField(id=1000)
    private final int zzal;
    @SafeParcelable.Field(id=1, getter="getStatusCode")
    private final int zzam;
    @SafeParcelable.Field(id=2, getter="getStatusMessage")
    @Nullable
    private final String zzao;
    @SafeParcelable.Field(id=3, getter="getPendingIntent")
    @Nullable
    private final PendingIntent zzan;

    @SafeParcelable.Constructor
    @KeepForSdk
    Status(@SafeParcelable.Param(id=1000) int n, @SafeParcelable.Param(id=1) int n2, @SafeParcelable.Param(id=2) @Nullable String string2, @SafeParcelable.Param(id=3) @Nullable PendingIntent pendingIntent) {
        this.zzal = n;
        this.zzam = n2;
        this.zzao = string2;
        this.zzan = pendingIntent;
    }

    @KeepForSdk
    public Status(int n) {
        this(n, null);
    }

    @KeepForSdk
    public Status(int n, @Nullable String string2) {
        this(1, n, string2, null);
    }

    @KeepForSdk
    public Status(int n, @Nullable String string2, @Nullable PendingIntent pendingIntent) {
        this(1, n, string2, pendingIntent);
    }

    public final void startResolutionForResult(Activity activity, int n) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.zzan.getIntentSender(), n, null, 0, 0, 0);
    }

    @Nullable
    public final String getStatusMessage() {
        return this.zzao;
    }

    @VisibleForTesting
    public final boolean hasResolution() {
        return this.zzan != null;
    }

    public final boolean isSuccess() {
        return this.zzam <= 0;
    }

    public final boolean isCanceled() {
        return this.zzam == 16;
    }

    public final boolean isInterrupted() {
        return this.zzam == 14;
    }

    public final int getStatusCode() {
        return this.zzam;
    }

    public final PendingIntent getResolution() {
        return this.zzan;
    }

    public final int hashCode() {
        return Objects.hashCode(this.zzal, this.zzam, this.zzao, this.zzan);
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Status)) {
            return false;
        }
        Status status = (Status)object;
        return this.zzal == status.zzal && this.zzam == status.zzam && Objects.equal(this.zzao, status.zzao) && Objects.equal(this.zzan, status.zzan);
    }

    public final String zzp() {
        if (this.zzao != null) {
            return this.zzao;
        }
        return CommonStatusCodes.getStatusCodeString(this.zzam);
    }

    public final String toString() {
        return Objects.toStringHelper(this).add("statusCode", this.zzp()).add("resolution", this.zzan).toString();
    }

    @KeepForSdk
    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Status status = this;
        int n2 = SafeParcelWriter.beginObjectHeader(parcel2);
        SafeParcelWriter.writeInt(parcel2, 1, status.getStatusCode());
        SafeParcelWriter.writeString(parcel2, 2, status.getStatusMessage(), false);
        SafeParcelWriter.writeParcelable(parcel2, 3, (Parcelable)status.zzan, n, false);
        SafeParcelWriter.writeInt(parcel2, 1000, status.zzal);
        SafeParcelWriter.finishObjectHeader(parcel2, n2);
    }

    @Override
    @KeepForSdk
    public final Status getStatus() {
        return this;
    }
}

