/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.ComponentName;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.Message;
import com.google.android.gms.common.internal.GmsClientSupervisor;
import com.google.android.gms.common.internal.zzh;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

final class zzi
implements ServiceConnection {
    private final Set<ServiceConnection> zztv;
    private int mState;
    private boolean zztw;
    private IBinder zzry;
    private final GmsClientSupervisor.ConnectionStatusConfig zztx;
    private ComponentName mComponentName;
    private final /* synthetic */ zzh zzty;

    public zzi(zzh zzh2, GmsClientSupervisor.ConnectionStatusConfig connectionStatusConfig) {
        this.zzty = zzh2;
        this.zztx = connectionStatusConfig;
        this.zztv = new HashSet<ServiceConnection>();
        this.mState = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        HashMap hashMap = zzh.zza(this.zzty);
        synchronized (hashMap) {
            zzh.zzb(this.zzty).removeMessages(1, (Object)this.zztx);
            this.zzry = iBinder;
            this.mComponentName = componentName;
            Iterator<ServiceConnection> iterator = this.zztv.iterator();
            while (iterator.hasNext()) {
                iterator.next().onServiceConnected(componentName, iBinder);
            }
            this.mState = 1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onServiceDisconnected(ComponentName componentName) {
        HashMap hashMap = zzh.zza(this.zzty);
        synchronized (hashMap) {
            zzh.zzb(this.zzty).removeMessages(1, (Object)this.zztx);
            this.zzry = null;
            this.mComponentName = componentName;
            Iterator<ServiceConnection> iterator = this.zztv.iterator();
            while (iterator.hasNext()) {
                iterator.next().onServiceDisconnected(componentName);
            }
            this.mState = 2;
            return;
        }
    }

    public final void zzj(String string2) {
        this.mState = 3;
        this.zztw = zzh.zzd(this.zzty).bindService(zzh.zzc(this.zzty), string2, this.zztx.getStartServiceIntent(zzh.zzc(this.zzty)), this, this.zztx.getBindFlags());
        if (this.zztw) {
            Message message = zzh.zzb(this.zzty).obtainMessage(1, (Object)this.zztx);
            zzh.zzb(this.zzty).sendMessageDelayed(message, zzh.zze(this.zzty));
            return;
        }
        this.mState = 2;
        try {
            zzh.zzd(this.zzty).unbindService(zzh.zzc(this.zzty), this);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public final void zzk(String string2) {
        zzh.zzb(this.zzty).removeMessages(1, (Object)this.zztx);
        zzh.zzd(this.zzty).unbindService(zzh.zzc(this.zzty), this);
        this.zztw = false;
        this.mState = 2;
    }

    public final void zza(ServiceConnection serviceConnection, String string2) {
        zzh.zzd(this.zzty).logConnectService(zzh.zzc(this.zzty), serviceConnection, string2, this.zztx.getStartServiceIntent(zzh.zzc(this.zzty)));
        this.zztv.add(serviceConnection);
    }

    public final void zzb(ServiceConnection serviceConnection, String string2) {
        zzh.zzd(this.zzty).logDisconnectService(zzh.zzc(this.zzty), serviceConnection);
        this.zztv.remove(serviceConnection);
    }

    public final boolean isBound() {
        return this.zztw;
    }

    public final int getState() {
        return this.mState;
    }

    public final boolean zza(ServiceConnection serviceConnection) {
        return this.zztv.contains(serviceConnection);
    }

    public final boolean zzcv() {
        return this.zztv.isEmpty();
    }

    public final IBinder getBinder() {
        return this.zzry;
    }

    public final ComponentName getComponentName() {
        return this.mComponentName;
    }

    static /* synthetic */ GmsClientSupervisor.ConnectionStatusConfig zza(zzi zzi2) {
        return zzi2.zztx;
    }
}

