/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.stats;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.stats.ConnectionEventCreator;
import com.google.android.gms.common.stats.StatsEvent;
import javax.annotation.Nullable;

@SafeParcelable.Class(creator="ConnectionEventCreator")
public final class ConnectionEvent
extends StatsEvent {
    public static final Parcelable.Creator<ConnectionEvent> CREATOR = new ConnectionEventCreator();
    @SafeParcelable.VersionField(id=1)
    private final int zzal;
    @SafeParcelable.Field(id=2, getter="getTimeMillis")
    private final long zzxv;
    @SafeParcelable.Field(id=12, getter="getEventType")
    private int zzxw;
    @SafeParcelable.Field(id=4, getter="getCallingProcess")
    private final String zzxx;
    @SafeParcelable.Field(id=5, getter="getCallingService")
    private final String zzxy;
    @SafeParcelable.Field(id=6, getter="getTargetProcess")
    private final String zzxz;
    @SafeParcelable.Field(id=7, getter="getTargetService")
    private final String zzya;
    @SafeParcelable.Field(id=8, getter="getStackTrace")
    private final String zzyb;
    @SafeParcelable.Field(id=13, getter="getEventKey")
    private final String zzyc;
    @SafeParcelable.Field(id=10, getter="getElapsedRealtime")
    private final long zzyd;
    @SafeParcelable.Field(id=11, getter="getHeapAlloc")
    private final long zzye;
    private long zzyf;

    @SafeParcelable.Constructor
    ConnectionEvent(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) long l, @SafeParcelable.Param(id=12) int n2, @SafeParcelable.Param(id=4) String string2, @SafeParcelable.Param(id=5) String string3, @SafeParcelable.Param(id=6) String string4, @SafeParcelable.Param(id=7) String string5, @SafeParcelable.Param(id=8) String string6, @SafeParcelable.Param(id=13) String string7, @SafeParcelable.Param(id=10) long l2, @SafeParcelable.Param(id=11) long l3) {
        this.zzal = n;
        this.zzxv = l;
        this.zzxw = n2;
        this.zzxx = string2;
        this.zzxy = string3;
        this.zzxz = string4;
        this.zzya = string5;
        this.zzyf = -1L;
        this.zzyb = string6;
        this.zzyc = string7;
        this.zzyd = l2;
        this.zzye = l3;
    }

    public ConnectionEvent(long l, int n, String string2, String string3, String string4, String string5, String string6, String string7, long l2, long l3) {
        this(1, l, n, string2, string3, string4, string5, string6, string7, l2, l3);
    }

    public ConnectionEvent(ConnectionEvent connectionEvent) {
        this(connectionEvent.zzal, ((StatsEvent)connectionEvent).getTimeMillis(), ((StatsEvent)connectionEvent).getEventType(), connectionEvent.getCallingProcess(), connectionEvent.getCallingService(), connectionEvent.getTargetProcess(), connectionEvent.getTargetService(), connectionEvent.getStackTrace(), ((StatsEvent)connectionEvent).getEventKey(), ((StatsEvent)connectionEvent).getElapsedRealtime(), connectionEvent.getHeapAlloc());
    }

    @Override
    public final long getTimeMillis() {
        return this.zzxv;
    }

    @Override
    public final int getEventType() {
        return this.zzxw;
    }

    @Override
    public final ConnectionEvent setEventType(int n) {
        this.zzxw = n;
        return this;
    }

    public final String getCallingProcess() {
        return this.zzxx;
    }

    public final String getCallingService() {
        return this.zzxy;
    }

    public final String getTargetProcess() {
        return this.zzxz;
    }

    public final String getTargetService() {
        return this.zzya;
    }

    @Nullable
    public final String getStackTrace() {
        return this.zzyb;
    }

    @Override
    public final String getEventKey() {
        return this.zzyc;
    }

    @Override
    public final long getDurationMillis() {
        return this.zzyf;
    }

    public final long getHeapAlloc() {
        return this.zzye;
    }

    @Override
    public final ConnectionEvent setDurationMillis(long l) {
        this.zzyf = l;
        return this;
    }

    @Override
    public final long getElapsedRealtime() {
        return this.zzyd;
    }

    @Override
    public final StatsEvent ReconstructCloseEvent(StatsEvent statsEvent) {
        if (statsEvent instanceof ConnectionEvent) {
            ConnectionEvent connectionEvent = (ConnectionEvent)statsEvent;
            return (ConnectionEvent)((StatsEvent)((ConnectionEvent)((StatsEvent)new ConnectionEvent(connectionEvent)).setEventType(((StatsEvent)this).getEventType()))).setDurationMillis(((StatsEvent)this).getElapsedRealtime() - ((StatsEvent)connectionEvent).getElapsedRealtime());
        }
        return statsEvent;
    }

    @Override
    public final long getTimeout() {
        return 0L;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ConnectionEvent connectionEvent = this;
        int n2 = SafeParcelWriter.beginObjectHeader(parcel2);
        SafeParcelWriter.writeInt(parcel2, 1, connectionEvent.zzal);
        SafeParcelWriter.writeLong(parcel2, 2, ((StatsEvent)connectionEvent).getTimeMillis());
        SafeParcelWriter.writeString(parcel2, 4, connectionEvent.getCallingProcess(), false);
        SafeParcelWriter.writeString(parcel2, 5, connectionEvent.getCallingService(), false);
        SafeParcelWriter.writeString(parcel2, 6, connectionEvent.getTargetProcess(), false);
        SafeParcelWriter.writeString(parcel2, 7, connectionEvent.getTargetService(), false);
        SafeParcelWriter.writeString(parcel2, 8, connectionEvent.getStackTrace(), false);
        SafeParcelWriter.writeLong(parcel2, 10, ((StatsEvent)connectionEvent).getElapsedRealtime());
        SafeParcelWriter.writeLong(parcel2, 11, connectionEvent.getHeapAlloc());
        SafeParcelWriter.writeInt(parcel2, 12, ((StatsEvent)connectionEvent).getEventType());
        SafeParcelWriter.writeString(parcel2, 13, ((StatsEvent)connectionEvent).getEventKey(), false);
        SafeParcelWriter.finishObjectHeader(parcel2, n2);
    }

    @Override
    public final String getSpecificString() {
        String string2 = this.getCallingProcess();
        String string3 = this.getCallingService();
        String string4 = this.getTargetProcess();
        String string5 = this.getTargetService();
        String string6 = this.zzyb == null ? "" : this.zzyb;
        long l = this.getHeapAlloc();
        return new StringBuilder(26 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length() + String.valueOf(string6).length()).append("\t").append(string2).append("/").append(string3).append("\t").append(string4).append("/").append(string5).append("\t").append(string6).append("\t").append(l).toString();
    }

    @Override
    public final ConnectionEvent markTimeOut() {
        this.zzxw = 6;
        return this;
    }

    public static boolean checkEventType(StatsEvent statsEvent) {
        return 2 == statsEvent.getEventType() || 3 == statsEvent.getEventType() || 4 == statsEvent.getEventType() || 1 == statsEvent.getEventType() || 6 == statsEvent.getEventType() || 13 == statsEvent.getEventType() || 14 == statsEvent.getEventType() || 15 == statsEvent.getEventType();
    }
}

