/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.annotation.Nullable;
import com.google.android.gms.common.wrappers.Wrappers;

public class ClientLibraryUtils {
    public static final int GMS_CLIENT_VERSION_UNKNOWN = -1;

    private ClientLibraryUtils() {
    }

    public static int getClientVersion(Context context, String string2) {
        return ClientLibraryUtils.getClientVersion(ClientLibraryUtils.getPackageInfo(context, string2));
    }

    public static int getClientVersion(PackageInfo packageInfo) {
        if (packageInfo == null || packageInfo.applicationInfo == null) {
            return -1;
        }
        Bundle bundle = packageInfo.applicationInfo.metaData;
        if (bundle == null) {
            return -1;
        }
        return bundle.getInt("com.google.android.gms.version", -1);
    }

    @Nullable
    public static PackageInfo getPackageInfo(Context context, String string2) {
        PackageInfo packageInfo;
        try {
            packageInfo = Wrappers.packageManager(context).getPackageInfo(string2, 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
        return packageInfo;
    }

    public static boolean isPackageStopped(Context context, String string2) {
        "com.google.android.gms".equals(string2);
        try {
            return (Wrappers.packageManager((Context)context).getApplicationInfo((String)string2, (int)0).flags & 0x200000) != 0;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    public static boolean isPackageSide() {
        return false;
    }
}

