/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.os.ParcelFileDescriptor;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.internal.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Arrays;
import javax.annotation.Nullable;

public final class IOUtils {
    private IOUtils() {
    }

    public static void closeQuietly(@Nullable Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    public static void closeQuietly(@Nullable ParcelFileDescriptor parcelFileDescriptor) {
        if (parcelFileDescriptor != null) {
            try {
                parcelFileDescriptor.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    public static void closeQuietly(@Nullable Socket socket) {
        if (socket != null) {
            try {
                socket.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    public static void closeQuietly(@Nullable ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                serverSocket.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    public static void close(@Nullable Closeable closeable, String string2, String string3) {
        if (closeable != null) {
            try {
                closeable.close();
                return;
            }
            catch (IOException iOException) {
                Log.d((String)string2, (String)string3, (Throwable)iOException);
            }
        }
    }

    public static boolean isGzipByteBuffer(byte[] byArray) {
        return byArray.length > 1 && (byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8) == 35615;
    }

    public static long copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        return IOUtils.copyStream(inputStream, outputStream, false);
    }

    public static long copyStream(InputStream inputStream, OutputStream outputStream, boolean bl) throws IOException {
        return IOUtils.copyStream(inputStream, outputStream, bl, 1024);
    }

    public static long copyStream(InputStream inputStream, OutputStream outputStream, boolean bl, int n) throws IOException {
        byte[] byArray = new byte[n];
        long l = 0L;
        try {
            int n2;
            while ((n2 = inputStream.read(byArray, 0, n)) != -1) {
                l += (long)n2;
                outputStream.write(byArray, 0, n2);
            }
        }
        finally {
            if (bl) {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(outputStream);
            }
        }
        return l;
    }

    public static byte[] readInputStreamFully(InputStream inputStream) throws IOException {
        return IOUtils.readInputStreamFully(inputStream, true);
    }

    public static byte[] readInputStreamFully(InputStream inputStream, boolean bl) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copyStream(inputStream, byteArrayOutputStream, bl);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] toByteArray(File file) throws IOException {
        File file2 = file;
        return new zzb(file2, null).zzdd();
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.zza(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    @WorkerThread
    public static void lockAndTruncateFile(File file) throws IOException, OverlappingFileLockException {
        RandomAccessFile randomAccessFile;
        block9: {
            randomAccessFile = null;
            FileLock fileLock = null;
            if (!file.exists()) {
                throw new FileNotFoundException();
            }
            try {
                randomAccessFile = new RandomAccessFile(file, "rw");
                FileChannel fileChannel = randomAccessFile.getChannel();
                fileLock = fileChannel.lock();
                fileChannel.truncate(0L);
                if (fileLock == null || !fileLock.isValid()) break block9;
            }
            catch (Throwable throwable) {
                if (fileLock != null && fileLock.isValid()) {
                    try {
                        fileLock.release();
                    }
                    catch (IOException iOException) {}
                }
                if (randomAccessFile != null) {
                    IOUtils.closeQuietly(randomAccessFile);
                }
                throw throwable;
            }
            try {
                fileLock.release();
            }
            catch (IOException iOException) {}
        }
        IOUtils.closeQuietly(randomAccessFile);
    }

    private static byte[] zza(InputStream inputStream, long l) throws IOException {
        int n;
        int n2;
        if (l > Integer.MAX_VALUE) {
            throw new OutOfMemoryError(new StringBuilder(68).append("file is too large to fit in a byte array: ").append(l).append(" bytes").toString());
        }
        if (l == 0L) {
            return IOUtils.toByteArray(inputStream);
        }
        int n3 = (int)l;
        InputStream inputStream2 = inputStream;
        byte[] byArray = new byte[n3];
        for (int i = n3; i > 0; i -= n2) {
            n = n3 - i;
            n2 = inputStream2.read(byArray, n, i);
            if (n2 != -1) continue;
            return Arrays.copyOf(byArray, n);
        }
        n = inputStream2.read();
        if (n == -1) {
            return byArray;
        }
        zza zza2 = new zza(null);
        zza2.write(n);
        IOUtils.zza(inputStream2, zza2);
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length + zza2.size());
        zza2.zza(byArray2, byArray.length);
        return byArray2;
    }

    private static long zza(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        Preconditions.checkNotNull(inputStream);
        Preconditions.checkNotNull(outputStream);
        byte[] byArray = new byte[4096];
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    private static final class zza
    extends ByteArrayOutputStream {
        private zza() {
        }

        final void zza(byte[] byArray, int n) {
            System.arraycopy(this.buf, 0, byArray, n, this.count);
        }

        /* synthetic */ zza(com.google.android.gms.common.util.zzb zzb2) {
            this();
        }
    }

    private static final class zzb {
        private final File file;

        private zzb(File file) {
            this.file = Preconditions.checkNotNull(file);
        }

        public final byte[] zzdd() throws IOException {
            byte[] byArray;
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(this.file);
                byArray = IOUtils.zza(fileInputStream, fileInputStream.getChannel().size());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly(fileInputStream);
            return byArray;
        }

        /* synthetic */ zzb(File file, com.google.android.gms.common.util.zzb zzb2) {
            this(file);
        }
    }
}

