/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@VisibleForTesting
public class Strings {
    private static final Pattern zzaak = Pattern.compile("\\$\\{(.*?)\\}");

    private Strings() {
    }

    public static String format(@NonNull String string2, @NonNull Bundle bundle) {
        Matcher matcher = zzaak.matcher(string2);
        if (matcher.find()) {
            StringBuffer stringBuffer = new StringBuffer();
            do {
                String string3;
                Object object;
                if ((object = bundle.get(string3 = matcher.group(1))) != null) {
                    matcher.appendReplacement(stringBuffer, object.toString());
                    continue;
                }
                if (bundle.containsKey(string3)) {
                    matcher.appendReplacement(stringBuffer, "null");
                    continue;
                }
                matcher.appendReplacement(stringBuffer, "");
            } while (matcher.find());
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        return string2;
    }

    public static String nullToEmpty(@Nullable String string2) {
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    @Nullable
    public static String emptyToNull(@Nullable String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        return string2;
    }

    public static String capitalize(@NonNull String string2) {
        char c;
        if (string2.length() == 0) {
            return string2;
        }
        char c2 = string2.charAt(0);
        if (c2 == (c = Character.toUpperCase(c2))) {
            return string2;
        }
        String string3 = string2.substring(1);
        return new StringBuilder(1 + String.valueOf(string3).length()).append(c).append(string3).toString();
    }

    public static boolean isEmptyOrWhitespace(@Nullable String string2) {
        return string2 == null || string2.trim().isEmpty();
    }

    public static String padEnd(@NonNull String string2, int n, char c) {
        Preconditions.checkNotNull(string2);
        if (string2.length() >= n) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        stringBuilder.append(string2);
        for (int i = string2.length(); i < n; ++i) {
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }
}

