/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.common.zzc;
import com.google.android.gms.common.zze;
import com.google.android.gms.common.zzf;
import com.google.android.gms.common.zzh;
import com.google.android.gms.common.zzm;
import javax.annotation.CheckReturnValue;

@CheckReturnValue
@ShowFirstParty
@KeepForSdk
public class GoogleSignatureVerifier {
    private static GoogleSignatureVerifier zzam;
    private final Context mContext;
    private volatile String zzan;

    private GoogleSignatureVerifier(Context context) {
        this.mContext = context.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public static GoogleSignatureVerifier getInstance(Context context) {
        Preconditions.checkNotNull(context);
        Class<GoogleSignatureVerifier> clazz = GoogleSignatureVerifier.class;
        synchronized (GoogleSignatureVerifier.class) {
            if (zzam == null) {
                zzc.zza(context);
                zzam = new GoogleSignatureVerifier(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return zzam;
        }
    }

    @ShowFirstParty
    @KeepForSdk
    public boolean isUidGoogleSigned(int n) {
        zzm zzm2;
        GoogleSignatureVerifier googleSignatureVerifier = this;
        String[] stringArray = Wrappers.packageManager(googleSignatureVerifier.mContext).getPackagesForUid(n);
        if (stringArray == null || stringArray.length == 0) {
            zzm2 = zzm.zzb("no pkgs");
        } else {
            zzm zzm3 = null;
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                String string2 = stringArray2[i];
                zzm3 = googleSignatureVerifier.zza(string2, n);
                if (zzm3.zzad) break;
            }
            zzm2 = zzm3;
        }
        zzm zzm4 = zzm2;
        zzm2.zzf();
        return zzm4.zzad;
    }

    @ShowFirstParty
    @KeepForSdk
    public boolean isPackageGoogleSigned(String string2) {
        zzm zzm2 = this.zzc(string2);
        zzm2.zzf();
        return zzm2.zzad;
    }

    public static boolean zza(PackageInfo packageInfo, boolean bl) {
        return packageInfo != null && packageInfo.signatures != null && (bl ? GoogleSignatureVerifier.zza(packageInfo, zzh.zzx) : GoogleSignatureVerifier.zza(packageInfo, zzh.zzx[0])) != null;
    }

    @KeepForSdk
    public boolean isGooglePublicSignedPackage(PackageInfo packageInfo) {
        if (packageInfo == null) {
            return false;
        }
        if (GoogleSignatureVerifier.zza(packageInfo, false)) {
            return true;
        }
        if (GoogleSignatureVerifier.zza(packageInfo, true)) {
            if (GooglePlayServicesUtilLight.honorsDebugCertificates(this.mContext)) {
                return true;
            }
            Log.w((String)"GoogleSignatureVerifier", (String)"Test-keys aren't accepted on this build.");
        }
        return false;
    }

    private final zzm zza(String string2, int n) {
        try {
            PackageInfo packageInfo;
            PackageInfo packageInfo2 = packageInfo = Wrappers.packageManager(this.mContext).zza(string2, 64, n);
            boolean bl = GooglePlayServicesUtilLight.honorsDebugCertificates(this.mContext);
            PackageInfo packageInfo3 = packageInfo2;
            if (packageInfo3 == null) {
                return zzm.zzb("null pkg");
            }
            if (packageInfo3.signatures.length != 1) {
                return zzm.zzb("single cert required");
            }
            zzf zzf2 = new zzf(packageInfo3.signatures[0].toByteArray());
            String string3 = packageInfo3.packageName;
            zzm zzm2 = zzc.zza(string3, zzf2, bl, false);
            if (zzm2.zzad && packageInfo3.applicationInfo != null && (packageInfo3.applicationInfo.flags & 2) != 0 && (!bl || zzc.zza((String)string3, (zze)zzf2, (boolean)false, (boolean)false).zzad)) {
                return zzm.zzb("debuggable release cert app rejected");
            }
            return zzm2;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string4 = String.valueOf(string2);
            return zzm.zzb(string4.length() != 0 ? "no pkg ".concat(string4) : new String("no pkg "));
        }
    }

    private final zzm zzc(String string2) {
        zzm zzm2;
        zzm zzm3;
        PackageInfo packageInfo;
        PackageInfo packageInfo2;
        if (string2 == null) {
            return zzm.zzb("null pkg");
        }
        if (string2.equals(this.zzan)) {
            return zzm.zze();
        }
        try {
            packageInfo2 = Wrappers.packageManager(this.mContext).getPackageInfo(string2, 64);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            String string3 = String.valueOf(string2);
            return zzm.zzb(string3.length() != 0 ? "no pkg ".concat(string3) : new String("no pkg "));
        }
        PackageInfo packageInfo3 = packageInfo = packageInfo2;
        boolean bl = GooglePlayServicesUtilLight.honorsDebugCertificates(this.mContext);
        PackageInfo packageInfo4 = packageInfo3;
        if (packageInfo4 == null) {
            zzm3 = zzm.zzb("null pkg");
        } else if (packageInfo4.signatures.length != 1) {
            zzm3 = zzm.zzb("single cert required");
        } else {
            zzf zzf2 = new zzf(packageInfo4.signatures[0].toByteArray());
            String string4 = packageInfo4.packageName;
            zzm zzm4 = zzc.zza(string4, zzf2, bl, false);
            zzm3 = zzm2 = zzm4.zzad && packageInfo4.applicationInfo != null && (packageInfo4.applicationInfo.flags & 2) != 0 && (!bl || zzc.zza((String)string4, (zze)zzf2, (boolean)false, (boolean)false).zzad) ? zzm.zzb("debuggable release cert app rejected") : zzm4;
        }
        if (zzm3.zzad) {
            this.zzan = string2;
        }
        return zzm2;
    }

    private static zze zza(PackageInfo packageInfo, zze ... zzeArray) {
        if (packageInfo.signatures == null) {
            return null;
        }
        if (packageInfo.signatures.length != 1) {
            Log.w((String)"GoogleSignatureVerifier", (String)"Package has more than one signature.");
            return null;
        }
        zzf zzf2 = new zzf(packageInfo.signatures[0].toByteArray());
        for (int i = 0; i < zzeArray.length; ++i) {
            if (!zzeArray[i].equals(zzf2)) continue;
            return zzeArray[i];
        }
        return null;
    }
}

