/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.security;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CrashUtils;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.security.zza;
import java.lang.reflect.Method;

public class ProviderInstaller {
    private static final GoogleApiAvailabilityLight zziu = GoogleApiAvailabilityLight.getInstance();
    private static final Object lock = new Object();
    private static Method zziv = null;
    public static final String PROVIDER_NAME = "GmsCore_OpenSSL";

    public ProviderInstaller() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void installIfNeeded(Context context) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        Preconditions.checkNotNull(context, "Context must not be null");
        zziu.verifyGooglePlayServicesIsAvailable(context, 11925000);
        Context context2 = ProviderInstaller.zzk(context);
        if (context2 == null) {
            context2 = ProviderInstaller.zzl(context);
        }
        if (context2 == null) {
            Log.e((String)"ProviderInstaller", (String)"Failed to get remote context");
            throw new GooglePlayServicesNotAvailableException(8);
        }
        Object object = lock;
        synchronized (object) {
            try {
                if (zziv == null) {
                    Class<?> clazz = context2.getClassLoader().loadClass("com.google.android.gms.common.security.ProviderInstallerImpl");
                    Class[] classArray = new Class[]{Context.class};
                    zziv = clazz.getMethod("insertProvider", classArray);
                }
                zziv.invoke(null, context2);
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                Throwable throwable = exception.getCause();
                if (Log.isLoggable((String)"ProviderInstaller", (int)6)) {
                    String string2 = throwable == null ? exception2.getMessage() : throwable.getMessage();
                    String string3 = String.valueOf(string2);
                    Log.e((String)"ProviderInstaller", (String)(string3.length() != 0 ? "Failed to install provider: ".concat(string3) : new String("Failed to install provider: ")));
                }
                CrashUtils.addDynamiteErrorToDropBox(context, throwable == null ? exception2 : throwable);
                throw new GooglePlayServicesNotAvailableException(8);
            }
            return;
        }
    }

    public static void installIfNeededAsync(Context context, ProviderInstallListener providerInstallListener) {
        Preconditions.checkNotNull(context, "Context must not be null");
        Preconditions.checkNotNull(providerInstallListener, "Listener must not be null");
        Preconditions.checkMainThread("Must be called on the UI thread");
        new zza(context, providerInstallListener).execute(new Void[0]);
    }

    @Nullable
    private static Context zzk(Context context) {
        try {
            return DynamiteModule.load(context, DynamiteModule.PREFER_HIGHEST_OR_LOCAL_VERSION_NO_FORCE_STAGING, "providerinstaller").getModuleContext();
        }
        catch (DynamiteModule.LoadingException loadingException) {
            String string2 = String.valueOf(loadingException.getMessage());
            Log.w((String)"ProviderInstaller", (String)(string2.length() != 0 ? "Failed to load providerinstaller module: ".concat(string2) : new String("Failed to load providerinstaller module: ")));
            return null;
        }
    }

    @Nullable
    private static Context zzl(Context context) {
        try {
            return GooglePlayServicesUtilLight.getRemoteContext(context);
        }
        catch (Resources.NotFoundException notFoundException) {
            String string2 = String.valueOf(notFoundException.getMessage());
            Log.w((String)"ProviderInstaller", (String)(string2.length() != 0 ? "Failed to load GMS Core context for providerinstaller: ".concat(string2) : new String("Failed to load GMS Core context for providerinstaller: ")));
            CrashUtils.addDynamiteErrorToDropBox(context, notFoundException);
            return null;
        }
    }

    static /* synthetic */ GoogleApiAvailabilityLight zzal() {
        return zziu;
    }

    public static interface ProviderInstallListener {
        public void onProviderInstalled();

        public void onProviderInstallFailed(int var1, Intent var2);
    }
}

