/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.zzad;
import com.google.android.gms.common.zzm;
import com.google.android.gms.common.zzn;
import com.google.android.gms.common.zzp;
import com.google.android.gms.common.zzq;
import com.google.android.gms.common.zzy;
import com.google.android.gms.internal.common.zzah;
import com.google.android.gms.internal.common.zzal;
import com.google.android.gms.internal.common.zzv;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.Nullable;

@ShowFirstParty
@KeepForSdk
public class GoogleSignatureVerifier {
    @Nullable
    private static GoogleSignatureVerifier zza;
    @Nullable
    private static volatile Set zzb;
    @Nullable
    private static volatile Set zzc;
    private final Context zzd;
    private volatile String zze;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @NonNull
    public static GoogleSignatureVerifier getInstance(@NonNull Context context) {
        Preconditions.checkNotNull(context);
        Class<GoogleSignatureVerifier> clazz = GoogleSignatureVerifier.class;
        synchronized (clazz) {
            Context context2;
            GoogleSignatureVerifier googleSignatureVerifier = zza;
            if (googleSignatureVerifier != null) return zza;
            zzq.zzd(context2);
            zza = new GoogleSignatureVerifier(context2);
            return zza;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public GoogleSignatureVerifier(@NonNull Context context) {
        this.zzd = context.getApplicationContext();
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public boolean isGooglePublicSignedPackage(@NonNull PackageInfo packageInfo) {
        void var1_1;
        if (packageInfo == null) {
            return false;
        }
        if (GoogleSignatureVerifier.zza((PackageInfo)var1_1, false)) {
            return true;
        }
        if (GoogleSignatureVerifier.zza((PackageInfo)var1_1, true)) {
            if (GooglePlayServicesUtilLight.honorsDebugCertificates(this.zzd)) {
                return true;
            }
            Log.w((String)"GoogleSignatureVerifier", (String)"Test-keys aren't accepted on this build.");
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @ShowFirstParty
    @KeepForSdk
    public boolean isPackageGoogleSigned(@Nullable String callingPackage) {
        void var1_1;
        zzad zzad2 = this.zzc((String)var1_1, false, false);
        zzad2.zze();
        return zzad2.zza;
    }

    /*
     * Unable to fully structure code
     */
    @ShowFirstParty
    @KeepForSdk
    public boolean isUidGoogleSigned(int uid) {
        var3_3 = this.zzd.getPackageManager().getPackagesForUid((int)var1_1);
        if (var3_3 == null || (var4_4 = var3_3.length) == 0) {
            this = zzad.zzc("no pkgs");
lbl4:
            // 3 sources

            while (true) {
                this.zze();
                return this.zza;
            }
        }
        var1_2 = null;
        for (var2_5 = 0; var2_5 < var4_4; ++var2_5) {
            var1_2 = super.zzc(var3_3[var2_5], false, false);
            if (!var1_2.zza) continue;
            this = var1_2;
            ** GOTO lbl4
        }
        Preconditions.checkNotNull(var1_2);
        this = var1_2;
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    private static zzm zzb(PackageInfo packageInfo, zzm ... zzmArray) {
        if (packageInfo.signatures != null) {
            if (packageInfo.signatures.length != 1) {
                Log.w((String)"GoogleSignatureVerifier", (String)"Package has more than one signature.");
                return null;
            }
            zzn zzn2 = new zzn(packageInfo.signatures[0].toByteArray());
            for (int i = 0; i < zzmArray.length; ++i) {
                if (!zzmArray[i].equals(zzn2)) continue;
                return zzmArray[i];
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"PackageManagerGetSignatures"})
    private final zzad zzc(@Nullable String string2, boolean bl, boolean bl2) {
        void var2_5;
        block11: {
            zzad zzad2;
            block15: {
                block16: {
                    boolean bl3;
                    PackageInfo packageInfo;
                    block14: {
                        block13: {
                            block12: {
                                if (string2 == null) {
                                    return zzad.zzc("null pkg");
                                }
                                if (string2.equals(this.zze)) {
                                    return zzad.zzb();
                                }
                                if (!zzq.zzf()) break block12;
                                zzy zzy2 = new zzy(null);
                                zzy2.zzc(string2);
                                zzy2.zza(GooglePlayServicesUtilLight.honorsDebugCertificates(this.zzd));
                                zzy2.zzb(true);
                                zzad zzad3 = zzq.zzb(zzy2.zzd());
                                break block11;
                            }
                            if (Build.VERSION.SDK_INT >= 28) {
                                int n = 0x8000040;
                            } else {
                                int n = 64;
                            }
                            try {
                                void var2_7;
                                packageInfo = this.zzd.getPackageManager().getPackageInfo(string2, (int)var2_7);
                            }
                            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                                return zzad.zzd("no pkg ".concat(string2), nameNotFoundException);
                            }
                            bl3 = GooglePlayServicesUtilLight.honorsDebugCertificates(this.zzd);
                            if (packageInfo != null) break block13;
                            zzad zzad4 = zzad.zzc("null pkg");
                            break block11;
                        }
                        if (packageInfo.signatures != null && packageInfo.signatures.length == 1) break block14;
                        zzad zzad5 = zzad.zzc("single cert required");
                        break block11;
                    }
                    zzn zzn2 = new zzn(packageInfo.signatures[0].toByteArray());
                    String string3 = packageInfo.packageName;
                    zzad2 = zzq.zza(string3, zzn2, bl3, false);
                    if (!zzad2.zza) break block15;
                    if (packageInfo.applicationInfo == null) break block16;
                    if ((packageInfo.applicationInfo.flags & 2) != 0) {
                        if (zzq.zza((String)string3, (zzm)zzn2, (boolean)false, (boolean)true).zza) {
                            zzad zzad6 = zzad.zzc("debuggable release cert app rejected");
                            break block11;
                        } else {
                            zzad zzad7 = zzad2;
                        }
                        break block11;
                    } else {
                        zzad zzad8 = zzad2;
                    }
                    break block11;
                }
                zzad zzad9 = zzad2;
                break block11;
            }
            zzad zzad10 = zzad2;
        }
        if (var2_5.zza) {
            this.zze = string2;
        }
        return var2_5;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    static final boolean zza(PackageInfo var0, boolean var1_2) {
        block26: {
            block22: {
                block24: {
                    block25: {
                        block23: {
                            block30: {
                                block29: {
                                    block28: {
                                        if (!var1_2 || var0 /* !! */  == null || !"com.android.vending".equals(var0 /* !! */ .packageName) && !"com.google.android.gms".equals(var2_4 = var0 /* !! */ .packageName)) break block28;
                                        var1_3 = var0 /* !! */ .applicationInfo;
                                        if (var1_3 != null) break block29;
                                        var1_2 = false;
                                    }
lbl6:
                                    // 3 sources

                                    while (true) {
                                        if (var0 /* !! */  == null) {
                                            return false;
                                        }
                                        if (!var1_2) break block22;
                                        var2_4 = zzp.zzc;
lbl13:
                                        // 2 sources

                                        while (true) {
                                            var3_5 = Build.VERSION.SDK_INT;
                                            if (var3_5 < 28) {
                                                var3_6 = var0 /* !! */ .signatures;
                                                if (var3_6 != null) {
                                                    var3_7 = var0 /* !! */ .signatures.length;
                                                    var3_6 = var3_7 == 1 ? (Object)var0 /* !! */ .signatures[0].toByteArray() : null;
lbl20:
                                                    // 2 sources

                                                    while (true) {
                                                        var3_6 = var3_6 != null ? zzal.zzn(var3_6) : zzal.zzm();
                                                        break block23;
                                                        break;
                                                    }
                                                } else {
                                                    var3_6 = null;
                                                    ** continue;
                                                }
                                            }
                                            var3_5 = Build.VERSION.SDK_INT;
                                            if (var3_5 < 28) break block24;
                                            var3_5 = 1;
lbl28:
                                            // 2 sources

                                            while (true) {
                                                zzv.zzd((boolean)var3_5);
                                                var3_6 = var0 /* !! */ .signingInfo;
                                                if (var3_6 == null || (var4_12 = var3_6.hasMultipleSigners()) || (var4_13 = var3_6.getSigningCertificateHistory()) == null) {
                                                    var3_6 = zzal.zzm();
                                                    break block23;
                                                }
                                                var4_13 = new zzah();
                                                var5_14 = var3_6.getSigningCertificateHistory();
                                                var6_16 = var5_14.length;
                                                for (var3_9 = 0; var3_9 < var6_16; ++var3_9) {
                                                    var4_13.zzb(var5_14[var3_9].toByteArray());
                                                }
                                                break block25;
                                                break;
                                            }
                                            break;
                                        }
                                        break;
                                    }
                                }
                                if ((var1_3.flags & 129) == 0) break block30;
                                var1_2 = true;
                                ** GOTO lbl6
                            }
                            var1_2 = false;
                            ** while (true)
                            catch (IllegalArgumentException v0) {
                                Log.i((String)"GoogleSignatureVerifier", (String)"package info is not set correctly");
                                if (var1_2) {
                                    var0 /* !! */  = GoogleSignatureVerifier.zzb(var0 /* !! */ , zzp.zza);
lbl54:
                                    // 2 sources

                                    while (true) {
                                        if (var0 /* !! */  == null) return false;
                                        return true;
                                    }
                                }
                                break block26;
                            }
                        }
lbl59:
                        // 2 sources

                        while (!(var4_10 = var3_6.isEmpty())) {
                            var4_11 = var3_6.zzh();
                            var5_15 = var4_11.size();
                            var3_8 = 0;
                            while (true) {
                                block27: {
                                    if (var3_8 >= var5_15) {
                                        return false;
                                    }
                                    var6_17 = (byte[])var4_11.get(var3_8);
                                    var7_18 = var2_4.zzq(0);
                                    do {
                                        var8_19 = var7_18.hasNext();
                                        var9_20 = var3_8 + 1;
                                        if (!var8_19) break block27;
                                    } while (!(var8_19 = Arrays.equals(var6_17, (byte[])var7_18.next())));
                                    return true;
                                }
                                var3_8 = var9_20;
                            }
                        }
                        ** GOTO lbl-1000
                    }
                    var3_6 = var4_13.zzd();
                    ** GOTO lbl59
                }
                var3_5 = 0;
                ** while (true)
            }
            var2_4 = zzp.zzb;
            ** while (true)
lbl-1000:
            // 1 sources

            {
                var2_4 = "Unable to obtain package certificate history.";
                throw new IllegalArgumentException((String)var2_4);
            }
        }
        var0 /* !! */  = GoogleSignatureVerifier.zzb(var0 /* !! */ , new zzm[]{zzp.zza[0]});
        ** while (true)
    }
}

