/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.ActivityOptions;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.IntentSenderRequest;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.zze;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.PlatformVersion;

@SafeParcelable.Class(creator="StatusCreator")
public final class Status
extends AbstractSafeParcelable
implements Result,
ReflectedParcelable {
    @KeepForSdk
    @ShowFirstParty
    @NonNull
    public static final Status RESULT_SUCCESS_CACHE = new Status(-1);
    @KeepForSdk
    @ShowFirstParty
    @NonNull
    public static final Status RESULT_SUCCESS = new Status(0);
    @KeepForSdk
    @ShowFirstParty
    @NonNull
    public static final Status RESULT_INTERRUPTED = new Status(14);
    @KeepForSdk
    @ShowFirstParty
    @NonNull
    public static final Status RESULT_INTERNAL_ERROR = new Status(8);
    @KeepForSdk
    @ShowFirstParty
    @NonNull
    public static final Status RESULT_TIMEOUT = new Status(15);
    @KeepForSdk
    @ShowFirstParty
    @NonNull
    public static final Status RESULT_CANCELED = new Status(16);
    @KeepForSdk
    @ShowFirstParty
    @NonNull
    public static final Status RESULT_API_NOT_CONNECTED = new Status(17);
    @KeepForSdk
    @NonNull
    public static final Status RESULT_DEAD_CLIENT = new Status(18);
    @NonNull
    public static final Parcelable.Creator<Status> CREATOR = new zze();
    @SafeParcelable.Field(id=1, getter="getStatusCode")
    private final int zza;
    @SafeParcelable.Field(id=2, getter="getStatusMessage")
    @Nullable
    private final String zzb;
    @SafeParcelable.Field(id=3, getter="getPendingIntent")
    @Nullable
    private final PendingIntent zzc;
    @SafeParcelable.Field(id=4, getter="getConnectionResult")
    @Nullable
    private final ConnectionResult zzd;

    public int getStatusCode() {
        return this.zza;
    }

    public int hashCode() {
        return Objects.hashCode(this.zza, this.zzb, this.zzc, this.zzd);
    }

    @Nullable
    public PendingIntent getResolution() {
        return this.zzc;
    }

    @Nullable
    public ConnectionResult getConnectionResult() {
        return this.zzd;
    }

    @Override
    @NonNull
    public Status getStatus() {
        return this;
    }

    @Nullable
    public String getStatusMessage() {
        return this.zzb;
    }

    @NonNull
    public String toString() {
        Objects.ToStringHelper toStringHelper = Objects.toStringHelper(this);
        toStringHelper.add("statusCode", this.zza());
        toStringHelper.add("resolution", this.zzc);
        return toStringHelper.toString();
    }

    /*
     * WARNING - void declaration
     */
    public Status(int statusCode) {
        this((int)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Status(int statusCode, @Nullable String statusMessage) {
        this((int)var1_1, (String)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Status(@NonNull ConnectionResult connectionResult, @NonNull String statusMessage) {
        this((ConnectionResult)var1_1, (String)var2_2, 17);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Status(int statusCode, @Nullable String statusMessage, @Nullable PendingIntent pendingIntent) {
        this((int)var1_1, (String)var2_2, (PendingIntent)var3_3, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @KeepForSdk
    public Status(@NonNull ConnectionResult connectionResult, @NonNull String statusMessage, int statusCode) {
        this((int)var3_3, (String)var2_2, var1_1.getResolution(), (ConnectionResult)var1_1);
        void var1_1;
        void var2_2;
        void var3_3;
    }

    @SafeParcelable.Constructor
    Status(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) @Nullable String string2, @SafeParcelable.Param(id=3) @Nullable PendingIntent pendingIntent, @SafeParcelable.Param(id=4) @Nullable ConnectionResult connectionResult) {
        this.zza = n;
        this.zzb = string2;
        this.zzc = pendingIntent;
        this.zzd = connectionResult;
    }

    /*
     * WARNING - void declaration
     */
    public void startResolutionForResult(@NonNull ActivityResultLauncher<IntentSenderRequest> activityResultLauncher) {
        void var1_1;
        if (!this_.hasResolution()) {
            return;
        }
        Status this_ = this_.zzc;
        Preconditions.checkNotNull(this_);
        var1_1.launch((Object)new IntentSenderRequest.Builder(((PendingIntent)this_).getIntentSender()).build());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void startResolutionForResult(@NonNull Activity activity, int requestCode) throws IntentSender.SendIntentException {
        void var2_2;
        void var1_1;
        if (!this.hasResolution()) {
            return;
        }
        Bundle bundle = PlatformVersion.isAtLeastU() ? ActivityOptions.makeBasic().setPendingIntentBackgroundActivityStartMode(1).toBundle() : null;
        PendingIntent pendingIntent = this.zzc;
        Preconditions.checkNotNull(pendingIntent);
        var1_1.startIntentSenderForResult(pendingIntent.getIntentSender(), (int)var2_2, null, 0, 0, 0, bundle);
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel out, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader(out);
        SafeParcelWriter.writeInt((Parcel)var1_1, 1, this.getStatusCode());
        SafeParcelWriter.writeString((Parcel)var1_1, 2, this.getStatusMessage(), false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, 3, (Parcelable)this.zzc, (int)var2_2, false);
        void v1 = var1_1;
        SafeParcelWriter.writeParcelable((Parcel)v1, 4, this.getConnectionResult(), (int)var2_2, false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, n);
    }

    public boolean equals(@Nullable Object obj) {
        Status status;
        if (!(obj instanceof Status)) {
            return false;
        }
        status = status;
        return this.zza == status.zza && Objects.equal(this.zzb, status.zzb) && Objects.equal(this.zzc, status.zzc) && Objects.equal(this.zzd, status.zzd);
    }

    public boolean hasResolution() {
        return this.zzc != null;
    }

    public boolean isCanceled() {
        return this.zza == 16;
    }

    public boolean isInterrupted() {
        return this.zza == 14;
    }

    public boolean isSuccess() {
        return this.zza <= 0;
    }

    @NonNull
    public final String zza() {
        String string2 = this.zzb;
        if (string2 != null) {
            return string2;
        }
        return CommonStatusCodes.getStatusCodeString(this.zza);
    }
}

