/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Context;
import android.content.res.Resources;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.R;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.StringResourceValueReader;
import com.google.android.gms.common.internal.zzag;

@Deprecated
@KeepForSdk
public final class GoogleServices {
    private static final Object zza = new Object();
    @Nullable
    private static GoogleServices zzb;
    @Nullable
    private final String zzc;
    private final Status zzd;
    private final boolean zze;
    private final boolean zzf;

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @KeepForSdk
    Status checkGoogleAppId(String appId) {
        void var1_1;
        String string2 = ((GoogleServices)((Object)this_)).zzc;
        if (string2 != null && !string2.equals(var1_1)) {
            String this_ = ((GoogleServices)((Object)this_)).zzc;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Initialize was called with two different Google App IDs.  Only the first app ID will be used: '");
            stringBuilder.append(this_);
            stringBuilder.append("'.");
            return new Status(10, stringBuilder.toString());
        }
        return Status.RESULT_SUCCESS;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @NonNull
    public static Status initialize(@NonNull Context context) {
        Preconditions.checkNotNull(context, "Context must not be null.");
        Object object = zza;
        synchronized (object) {
            Object object2;
            GoogleServices googleServices = zzb;
            if (googleServices != null) return GoogleServices.zzb.zzd;
            zzb = new GoogleServices((Context)object2);
            return GoogleServices.zzb.zzd;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @NonNull
    public static Status initialize(@NonNull Context context, @NonNull String appId, boolean isMeasurementEnabled) {
        Status status;
        Preconditions.checkNotNull(context, "Context must not be null.");
        Preconditions.checkNotEmpty((String)((Object)status), "App ID must be nonempty.");
        Object object = zza;
        synchronized (object) {
            void var2_3;
            GoogleServices googleServices = zzb;
            if (googleServices != null) {
                return googleServices.checkGoogleAppId((String)((Object)status));
            }
            zzb = new GoogleServices((String)((Object)status), (boolean)var2_3);
            return GoogleServices.zzb.zzd;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    private static GoogleServices checkInitialized(String methodName) {
        Object object = zza;
        synchronized (object) {
            try {
                String string2;
                GoogleServices googleServices = zzb;
                if (googleServices != null) {
                    return googleServices;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Initialize must be called before ");
                stringBuilder.append(string2);
                stringBuilder.append(".");
                throw new IllegalStateException(stringBuilder.toString());
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }

    @KeepForSdk
    @Nullable
    public static String getGoogleAppId() {
        return GoogleServices.checkInitialized((String)"getGoogleAppId").zzc;
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    @KeepForSdk
    GoogleServices(Context context) {
        String string2;
        Resources resources = string2.getResources();
        String string3 = resources.getResourcePackageName(R.string.common_google_play_services_unknown_issue);
        int n = resources.getIdentifier("google_app_measurement_enable", "integer", string3);
        if (n != 0) {
            boolean bl = (n = resources.getInteger(n)) == 0;
            n = n != 0 ? 1 : 0;
            this.zzf = bl;
        } else {
            this.zzf = false;
            n = 1;
        }
        this.zze = n;
        String string4 = zzag.zzb((Context)string2);
        string2 = string4 == null ? new StringResourceValueReader((Context)string2).getString("google_app_id") : string4;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            string2 = "Missing google app id value from from string resources with name google_app_id.";
            this.zzd = new Status(10, string2);
            this.zzc = null;
            return;
        }
        this.zzc = string2;
        this.zzd = Status.RESULT_SUCCESS;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @KeepForSdk
    GoogleServices(String appId, boolean isMeasurementEnabled) {
        void var2_2;
        void var1_1;
        this.zzc = var1_1;
        this.zzd = Status.RESULT_SUCCESS;
        this.zze = var2_2;
        this.zzf = var2_2 ^ 1;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    @KeepForSdk
    static void clearInstanceForTest() {
        Object object = zza;
        synchronized (object) {
            zzb = null;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @KeepForSdk
    public static boolean isMeasurementEnabled() {
        GoogleServices googleServices = GoogleServices.checkInitialized("isMeasurementEnabled");
        return googleServices.zzd.isSuccess() && googleServices.zze;
    }

    @KeepForSdk
    public static boolean isMeasurementExplicitlyDisabled() {
        return GoogleServices.checkInitialized((String)"isMeasurementExplicitlyDisabled").zzf;
    }
}

