/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.quest;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.games.internal.GamesAbstractSafeParcelable;
import com.google.android.gms.games.quest.Milestone;
import com.google.android.gms.games.quest.MilestoneEntityCreator;

public final class MilestoneEntity
extends GamesAbstractSafeParcelable
implements Milestone {
    public static final Parcelable.Creator<MilestoneEntity> CREATOR = new MilestoneEntityCreator();
    private final String zzbaF;
    private final long zzbeS;
    private final long zzbeT;
    private final byte[] zzbeU;
    private final int mState;
    private final String zzaZp;

    public MilestoneEntity(Milestone milestone) {
        this.zzbaF = milestone.getMilestoneId();
        this.zzbeS = milestone.getCurrentProgress();
        this.zzbeT = milestone.getTargetProgress();
        this.mState = milestone.getState();
        this.zzaZp = milestone.getEventId();
        byte[] byArray = milestone.getCompletionRewardData();
        if (byArray == null) {
            this.zzbeU = null;
        } else {
            this.zzbeU = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.zzbeU, 0, byArray.length);
        }
    }

    MilestoneEntity(String string, long l, long l2, byte[] byArray, int n, String string2) {
        this.zzbaF = string;
        this.zzbeS = l;
        this.zzbeT = l2;
        this.zzbeU = byArray;
        this.mState = n;
        this.zzaZp = string2;
    }

    @Override
    public String getEventId() {
        return this.zzaZp;
    }

    @Override
    public String getMilestoneId() {
        return this.zzbaF;
    }

    @Override
    public long getCurrentProgress() {
        return this.zzbeS;
    }

    @Override
    public long getTargetProgress() {
        return this.zzbeT;
    }

    @Override
    public byte[] getCompletionRewardData() {
        return this.zzbeU;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    public Milestone freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return MilestoneEntity.zza(this);
    }

    static int zza(Milestone milestone) {
        return zzaa.hashCode((Object[])new Object[]{milestone.getMilestoneId(), milestone.getCurrentProgress(), milestone.getTargetProgress(), milestone.getState(), milestone.getEventId()});
    }

    public boolean equals(Object object) {
        return MilestoneEntity.zza(this, object);
    }

    static boolean zza(Milestone milestone, Object object) {
        if (!(object instanceof Milestone)) {
            return false;
        }
        if (milestone == object) {
            return true;
        }
        Milestone milestone2 = (Milestone)object;
        return zzaa.equal((Object)milestone2.getMilestoneId(), (Object)milestone.getMilestoneId()) && zzaa.equal((Object)milestone2.getCurrentProgress(), (Object)milestone.getCurrentProgress()) && zzaa.equal((Object)milestone2.getTargetProgress(), (Object)milestone.getTargetProgress()) && zzaa.equal((Object)milestone2.getState(), (Object)milestone.getState()) && zzaa.equal((Object)milestone2.getEventId(), (Object)milestone.getEventId());
    }

    public String toString() {
        return MilestoneEntity.zzb(this);
    }

    static String zzb(Milestone milestone) {
        return zzaa.zzv((Object)milestone).zzg("MilestoneId", (Object)milestone.getMilestoneId()).zzg("CurrentProgress", (Object)milestone.getCurrentProgress()).zzg("TargetProgress", (Object)milestone.getTargetProgress()).zzg("State", (Object)milestone.getState()).zzg("CompletionRewardData", (Object)milestone.getCompletionRewardData()).zzg("EventId", (Object)milestone.getEventId()).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        MilestoneEntityCreator.zza(this, parcel, n);
    }
}

