/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzbj;
import com.google.android.gms.internal.measurement.zzbr;
import com.google.android.gms.internal.measurement.zzfd;
import com.google.android.gms.internal.measurement.zzky;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzap;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzjv;
import com.google.android.gms.measurement.internal.zzjz;
import com.google.android.gms.measurement.internal.zzkc;
import com.google.android.gms.measurement.internal.zzkg;
import com.google.android.gms.measurement.internal.zzkj;
import com.google.android.gms.measurement.internal.zzkk;
import com.google.android.gms.measurement.internal.zzkl;
import com.google.android.gms.measurement.internal.zzv;
import com.google.android.gms.measurement.internal.zzx;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class zzac
extends zzjz {
    private static final String[] zzb = new String[]{"last_bundled_timestamp", "ALTER TABLE events ADD COLUMN last_bundled_timestamp INTEGER;", "last_bundled_day", "ALTER TABLE events ADD COLUMN last_bundled_day INTEGER;", "last_sampled_complex_event_id", "ALTER TABLE events ADD COLUMN last_sampled_complex_event_id INTEGER;", "last_sampling_rate", "ALTER TABLE events ADD COLUMN last_sampling_rate INTEGER;", "last_exempt_from_sampling", "ALTER TABLE events ADD COLUMN last_exempt_from_sampling INTEGER;", "current_session_count", "ALTER TABLE events ADD COLUMN current_session_count INTEGER;"};
    private static final String[] zzc = new String[]{"origin", "ALTER TABLE user_attributes ADD COLUMN origin TEXT;"};
    private static final String[] zzd = new String[]{"app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;", "app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;", "gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;", "dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;", "measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;", "last_bundle_start_timestamp", "ALTER TABLE apps ADD COLUMN last_bundle_start_timestamp INTEGER;", "day", "ALTER TABLE apps ADD COLUMN day INTEGER;", "daily_public_events_count", "ALTER TABLE apps ADD COLUMN daily_public_events_count INTEGER;", "daily_events_count", "ALTER TABLE apps ADD COLUMN daily_events_count INTEGER;", "daily_conversions_count", "ALTER TABLE apps ADD COLUMN daily_conversions_count INTEGER;", "remote_config", "ALTER TABLE apps ADD COLUMN remote_config BLOB;", "config_fetched_time", "ALTER TABLE apps ADD COLUMN config_fetched_time INTEGER;", "failed_config_fetch_time", "ALTER TABLE apps ADD COLUMN failed_config_fetch_time INTEGER;", "app_version_int", "ALTER TABLE apps ADD COLUMN app_version_int INTEGER;", "firebase_instance_id", "ALTER TABLE apps ADD COLUMN firebase_instance_id TEXT;", "daily_error_events_count", "ALTER TABLE apps ADD COLUMN daily_error_events_count INTEGER;", "daily_realtime_events_count", "ALTER TABLE apps ADD COLUMN daily_realtime_events_count INTEGER;", "health_monitor_sample", "ALTER TABLE apps ADD COLUMN health_monitor_sample TEXT;", "android_id", "ALTER TABLE apps ADD COLUMN android_id INTEGER;", "adid_reporting_enabled", "ALTER TABLE apps ADD COLUMN adid_reporting_enabled INTEGER;", "ssaid_reporting_enabled", "ALTER TABLE apps ADD COLUMN ssaid_reporting_enabled INTEGER;", "admob_app_id", "ALTER TABLE apps ADD COLUMN admob_app_id TEXT;", "linked_admob_app_id", "ALTER TABLE apps ADD COLUMN linked_admob_app_id TEXT;", "dynamite_version", "ALTER TABLE apps ADD COLUMN dynamite_version INTEGER;", "safelisted_events", "ALTER TABLE apps ADD COLUMN safelisted_events TEXT;", "ga_app_id", "ALTER TABLE apps ADD COLUMN ga_app_id TEXT;"};
    private static final String[] zze = new String[]{"realtime", "ALTER TABLE raw_events ADD COLUMN realtime INTEGER;"};
    private static final String[] zzf = new String[]{"has_realtime", "ALTER TABLE queue ADD COLUMN has_realtime INTEGER;", "retry_count", "ALTER TABLE queue ADD COLUMN retry_count INTEGER;"};
    private static final String[] zzg = new String[]{"session_scoped", "ALTER TABLE event_filters ADD COLUMN session_scoped BOOLEAN;"};
    private static final String[] zzh = new String[]{"session_scoped", "ALTER TABLE property_filters ADD COLUMN session_scoped BOOLEAN;"};
    private static final String[] zzi = new String[]{"previous_install_count", "ALTER TABLE app2 ADD COLUMN previous_install_count INTEGER;"};
    private final zzad zzj;
    private final zzjv zzk = new zzjv(this.zzm());

    zzac(zzkc zzkc2) {
        super(zzkc2);
        String string = "google_app_measurement.db";
        this.zzj = new zzad(this, this.zzn(), string);
    }

    @Override
    protected final boolean zze() {
        return false;
    }

    @WorkerThread
    public final void zzf() {
        this.zzak();
        this.c_().beginTransaction();
    }

    @WorkerThread
    public final void b_() {
        this.zzak();
        this.c_().setTransactionSuccessful();
    }

    @WorkerThread
    public final void zzh() {
        this.zzak();
        this.c_().endTransaction();
    }

    @WorkerThread
    private final long zzb(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.c_();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzr().zzf().zza("Database error", (Object)string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    @WorkerThread
    private final long zza(String string, String[] stringArray, long l) {
        long l2;
        block7: {
            SQLiteDatabase sQLiteDatabase = this.c_();
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.rawQuery(string, stringArray);
                if (cursor.moveToFirst()) {
                    long l3 = cursor.getLong(0);
                    return l3;
                }
                l2 = l;
                if (cursor == null) break block7;
            }
            cursor.close();
        }
        return l2;
    }

    @VisibleForTesting
    @WorkerThread
    final SQLiteDatabase c_() {
        this.zzd();
        try {
            return this.zzj.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzi().zza("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    @WorkerThread
    public final zzaj zza(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzd();
        this.zzak();
        boolean bl = this.zzt().zze(string, zzap.zzbt);
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList("lifetime_count", "current_bundle_count", "last_fire_timestamp", "last_bundled_timestamp", "last_bundled_day", "last_sampled_complex_event_id", "last_sampling_rate", "last_exempt_from_sampling"));
        if (bl) {
            arrayList.add("current_session_count");
        }
        try (Cursor cursor = null;){
            cursor = this.c_().query("events", arrayList.toArray(new String[0]), "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            long l4 = cursor.isNull(3) ? 0L : cursor.getLong(3);
            Long l5 = cursor.isNull(4) ? null : Long.valueOf(cursor.getLong(4));
            Long l6 = cursor.isNull(5) ? null : Long.valueOf(cursor.getLong(5));
            Long l7 = cursor.isNull(6) ? null : Long.valueOf(cursor.getLong(6));
            Boolean bl2 = null;
            if (!cursor.isNull(7)) {
                bl2 = cursor.getLong(7) == 1L;
            }
            long l8 = 0L;
            if (bl && !cursor.isNull(8)) {
                l8 = cursor.getLong(8);
            }
            zzaj zzaj2 = new zzaj(string, string2, l, l2, l8, l3, l4, l5, l6, l7, bl2);
            if (cursor.moveToNext()) {
                this.zzr().zzf().zza("Got multiple records for event aggregates, expected one. appId", zzet.zza((String)string));
            }
            zzaj zzaj3 = zzaj2;
            return zzaj3;
        }
    }

    @WorkerThread
    public final void zza(zzaj zzaj2) {
        Preconditions.checkNotNull((Object)zzaj2);
        this.zzd();
        this.zzak();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzaj2.zza);
        contentValues.put("name", zzaj2.zzb);
        contentValues.put("lifetime_count", Long.valueOf(zzaj2.zzc));
        contentValues.put("current_bundle_count", Long.valueOf(zzaj2.zzd));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzaj2.zzf));
        contentValues.put("last_bundled_timestamp", Long.valueOf(zzaj2.zzg));
        contentValues.put("last_bundled_day", zzaj2.zzh);
        contentValues.put("last_sampled_complex_event_id", zzaj2.zzi);
        contentValues.put("last_sampling_rate", zzaj2.zzj);
        if (this.zzt().zze(zzaj2.zza, zzap.zzbt)) {
            contentValues.put("current_session_count", Long.valueOf(zzaj2.zze));
        }
        Long l = null;
        if (zzaj2.zzk != null && zzaj2.zzk.booleanValue()) {
            l = 1L;
        }
        contentValues.put("last_exempt_from_sampling", l);
        try {
            if (this.c_().insertWithOnConflict("events", null, contentValues, 5) == -1L) {
                this.zzr().zzf().zza("Failed to insert/update event aggregates (got -1). appId", zzet.zza((String)zzaj2.zza));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Error storing event aggregates. appId", zzet.zza((String)zzaj2.zza), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final void zzb(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzd();
        this.zzak();
        try {
            int n = this.c_().delete("user_attributes", "app_id=? and name=?", new String[]{string, string2});
            this.zzr().zzx().zza("Deleted user attribute rows", (Object)n);
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Error deleting user attribute. appId", zzet.zza((String)string), (Object)this.zzo().zzc(string2), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final boolean zza(zzkl zzkl2) {
        Preconditions.checkNotNull((Object)zzkl2);
        this.zzd();
        this.zzak();
        if (this.zzc(zzkl2.zza, zzkl2.zzc) == null && (zzkk.zza((String)zzkl2.zzc) ? this.zzb("select count(1) from user_attributes where app_id=? and name not like '!_%' escape '!'", new String[]{zzkl2.zza}) >= 25L : (this.zzt().zze(zzkl2.zza, zzap.zzbg) ? !"_npa".equals(zzkl2.zzc) && this.zzb("select count(1) from user_attributes where app_id=? and origin=? AND name like '!_%' escape '!'", new String[]{zzkl2.zza, zzkl2.zzb}) >= 25L : this.zzb("select count(1) from user_attributes where app_id=? and origin=? AND name like '!_%' escape '!'", new String[]{zzkl2.zza, zzkl2.zzb}) >= 25L))) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzkl2.zza);
        contentValues.put("origin", zzkl2.zzb);
        contentValues.put("name", zzkl2.zzc);
        contentValues.put("set_timestamp", Long.valueOf(zzkl2.zzd));
        zzac.zza(contentValues, "value", zzkl2.zze);
        try {
            if (this.c_().insertWithOnConflict("user_attributes", null, contentValues, 5) == -1L) {
                this.zzr().zzf().zza("Failed to insert/update user property (got -1). appId", zzet.zza((String)zzkl2.zza));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Error storing user property. appId", zzet.zza((String)zzkl2.zza), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzkl zzc(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzd();
        this.zzak();
        try (Cursor cursor = null;){
            cursor = this.c_().query("user_attributes", new String[]{"set_timestamp", "value", "origin"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            Object object = this.zza(cursor, 1);
            String string3 = cursor.getString(2);
            zzkl zzkl2 = new zzkl(string, string3, string2, l, object);
            if (cursor.moveToNext()) {
                this.zzr().zzf().zza("Got multiple records for user property, expected one. appId", zzet.zza((String)string));
            }
            zzkl zzkl3 = zzkl2;
            return zzkl3;
        }
    }

    @WorkerThread
    public final List<zzkl> zza(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzd();
        this.zzak();
        ArrayList<zzkl> arrayList = new ArrayList<zzkl>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.c_().query("user_attributes", new String[]{"name", "origin", "set_timestamp", "value"}, "app_id=?", new String[]{string}, null, null, "rowid", "1000");
            if (!cursor.moveToFirst()) {
                ArrayList<zzkl> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                if (string2 == null) {
                    string2 = "";
                }
                long l = cursor.getLong(2);
                Object object2 = this.zza(cursor, 3);
                if (object2 == null) {
                    this.zzr().zzf().zza("Read invalid user property value, ignoring it. appId", zzet.zza((String)string));
                    continue;
                }
                zzkl zzkl2 = new zzkl(string, string2, (String)object, l, object2);
                arrayList.add(zzkl2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final List<zzkl> zza(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        this.zzd();
        this.zzak();
        ArrayList<zzkl> arrayList = new ArrayList<zzkl>();
        try (Cursor cursor = null;){
            Object object;
            ArrayList<String> arrayList2 = new ArrayList<String>(3);
            arrayList2.add(string);
            StringBuilder stringBuilder = new StringBuilder("app_id=?");
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                arrayList2.add(string2);
                stringBuilder.append(" and origin=?");
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                arrayList2.add(String.valueOf(string3).concat("*"));
                stringBuilder.append(" and name glob ?");
            }
            String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
            cursor = this.c_().query("user_attributes", new String[]{"name", "set_timestamp", "value", "origin"}, stringBuilder.toString(), stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzkl> arrayList3 = arrayList;
                return arrayList3;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzr().zzf().zza("Read more than the max allowed user properties, ignoring excess", (Object)1000);
                    break;
                }
                object = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object2 = this.zza(cursor, 2);
                string2 = cursor.getString(3);
                if (object2 == null) {
                    this.zzr().zzf().zza("(2)Read invalid user property value, ignoring it", zzet.zza((String)string), (Object)string2, (Object)string3);
                    continue;
                }
                zzkl zzkl2 = new zzkl(string, string2, (String)object, l, object2);
                arrayList.add(zzkl2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final boolean zza(zzv zzv2) {
        Preconditions.checkNotNull((Object)zzv2);
        this.zzd();
        this.zzak();
        if (this.zzc(zzv2.zza, zzv2.zzc.zza) == null && this.zzb("SELECT COUNT(1) FROM conditional_properties WHERE app_id=?", new String[]{zzv2.zza}) >= 1000L) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzv2.zza);
        contentValues.put("origin", zzv2.zzb);
        contentValues.put("name", zzv2.zzc.zza);
        zzac.zza(contentValues, "value", zzv2.zzc.zza());
        contentValues.put("active", Boolean.valueOf(zzv2.zze));
        contentValues.put("trigger_event_name", zzv2.zzf);
        contentValues.put("trigger_timeout", Long.valueOf(zzv2.zzh));
        this.zzp();
        contentValues.put("timed_out_event", zzkk.zza((Parcelable)zzv2.zzg));
        contentValues.put("creation_timestamp", Long.valueOf(zzv2.zzd));
        this.zzp();
        contentValues.put("triggered_event", zzkk.zza((Parcelable)zzv2.zzi));
        contentValues.put("triggered_timestamp", Long.valueOf(zzv2.zzc.zzb));
        contentValues.put("time_to_live", Long.valueOf(zzv2.zzj));
        this.zzp();
        contentValues.put("expired_event", zzkk.zza((Parcelable)zzv2.zzk));
        try {
            if (this.c_().insertWithOnConflict("conditional_properties", null, contentValues, 5) == -1L) {
                this.zzr().zzf().zza("Failed to insert/update conditional user property (got -1)", zzet.zza((String)zzv2.zza));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Error storing conditional user property", zzet.zza((String)zzv2.zza), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzv zzd(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzd();
        this.zzak();
        try (Cursor cursor = null;){
            cursor = this.c_().query("conditional_properties", new String[]{"origin", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            String string3 = cursor.getString(0);
            Object object = this.zza(cursor, 1);
            boolean bl = cursor.getInt(2) != 0;
            String string4 = cursor.getString(3);
            long l = cursor.getLong(4);
            zzan zzan2 = (zzan)this.zzg().zza(cursor.getBlob(5), zzan.CREATOR);
            long l2 = cursor.getLong(6);
            zzan zzan3 = (zzan)this.zzg().zza(cursor.getBlob(7), zzan.CREATOR);
            long l3 = cursor.getLong(8);
            long l4 = cursor.getLong(9);
            zzan zzan4 = (zzan)this.zzg().zza(cursor.getBlob(10), zzan.CREATOR);
            zzkj zzkj2 = new zzkj(string2, l3, object, string3);
            zzv zzv2 = new zzv(string, string3, zzkj2, l2, bl, string4, zzan2, l, zzan3, l4, zzan4);
            if (cursor.moveToNext()) {
                this.zzr().zzf().zza("Got multiple records for conditional property, expected one", zzet.zza((String)string), (Object)this.zzo().zzc(string2));
            }
            zzv zzv3 = zzv2;
            return zzv3;
        }
    }

    @WorkerThread
    public final int zze(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzd();
        this.zzak();
        try {
            return this.c_().delete("conditional_properties", "app_id=? and name=?", new String[]{string, string2});
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Error deleting conditional property", zzet.zza((String)string), (Object)this.zzo().zzc(string2), (Object)sQLiteException);
            return 0;
        }
    }

    @WorkerThread
    public final List<zzv> zzb(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        this.zzd();
        this.zzak();
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(string);
        StringBuilder stringBuilder = new StringBuilder("app_id=?");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
            stringBuilder.append(" and origin=?");
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            arrayList.add(String.valueOf(string3).concat("*"));
            stringBuilder.append(" and name glob ?");
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return this.zza(stringBuilder.toString(), stringArray);
    }

    public final List<zzv> zza(String string, String[] stringArray) {
        this.zzd();
        this.zzak();
        ArrayList<zzv> arrayList = new ArrayList<zzv>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.c_().query("conditional_properties", new String[]{"app_id", "origin", "name", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, string, stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzv> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzr().zzf().zza("Read more than the max allowed conditional properties, ignoring extra", (Object)1000);
                    break;
                }
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                String string3 = cursor.getString(2);
                Object object2 = this.zza(cursor, 3);
                boolean bl = cursor.getInt(4) != 0;
                String string4 = cursor.getString(5);
                long l = cursor.getLong(6);
                zzan zzan2 = (zzan)this.zzg().zza(cursor.getBlob(7), zzan.CREATOR);
                long l2 = cursor.getLong(8);
                zzan zzan3 = (zzan)this.zzg().zza(cursor.getBlob(9), zzan.CREATOR);
                long l3 = cursor.getLong(10);
                long l4 = cursor.getLong(11);
                zzan zzan4 = (zzan)this.zzg().zza(cursor.getBlob(12), zzan.CREATOR);
                zzkj zzkj2 = new zzkj(string3, l3, object2, string2);
                zzv zzv2 = new zzv((String)object, string2, zzkj2, l2, bl, string4, zzan2, l, zzan3, l4, zzan4);
                arrayList.add(zzv2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final zzg zzb(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzd();
        this.zzak();
        try (Cursor cursor = null;){
            cursor = this.c_().query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_start_timestamp", "last_bundle_end_timestamp", "app_version", "app_store", "gmp_version", "dev_cert_hash", "measurement_enabled", "day", "daily_public_events_count", "daily_events_count", "daily_conversions_count", "config_fetched_time", "failed_config_fetch_time", "app_version_int", "firebase_instance_id", "daily_error_events_count", "daily_realtime_events_count", "health_monitor_sample", "android_id", "adid_reporting_enabled", "ssaid_reporting_enabled", "admob_app_id", "dynamite_version", "safelisted_events", "ga_app_id"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            zzg zzg2 = new zzg(this.zza.zzs(), string);
            zzg2.zza(cursor.getString(0));
            zzg2.zzb(cursor.getString(1));
            zzg2.zze(cursor.getString(2));
            zzg2.zzg(cursor.getLong(3));
            zzg2.zza(cursor.getLong(4));
            zzg2.zzb(cursor.getLong(5));
            zzg2.zzg(cursor.getString(6));
            zzg2.zzh(cursor.getString(7));
            zzg2.zzd(cursor.getLong(8));
            zzg2.zze(cursor.getLong(9));
            zzg2.zza(cursor.isNull(10) || cursor.getInt(10) != 0);
            zzg2.zzj(cursor.getLong(11));
            zzg2.zzk(cursor.getLong(12));
            zzg2.zzl(cursor.getLong(13));
            zzg2.zzm(cursor.getLong(14));
            zzg2.zzh(cursor.getLong(15));
            zzg2.zzi(cursor.getLong(16));
            zzg2.zzc(cursor.isNull(17) ? Integer.MIN_VALUE : (long)cursor.getInt(17));
            zzg2.zzf(cursor.getString(18));
            zzg2.zzo(cursor.getLong(19));
            zzg2.zzn(cursor.getLong(20));
            zzg2.zzi(cursor.getString(21));
            zzg2.zzp(cursor.isNull(22) ? 0L : cursor.getLong(22));
            zzg2.zzb(cursor.isNull(23) || cursor.getInt(23) != 0);
            zzg2.zzc(cursor.isNull(24) || cursor.getInt(24) != 0);
            zzg2.zzc(cursor.getString(25));
            zzg2.zzf(cursor.isNull(26) ? 0L : cursor.getLong(26));
            if (!cursor.isNull(27)) {
                zzg2.zza(Arrays.asList(cursor.getString(27).split(",", -1)));
            }
            if (zzky.zzb() && this.zzt().zze(string, zzap.zzci)) {
                zzg2.zzd(cursor.getString(28));
            }
            zzg2.zzb();
            if (cursor.moveToNext()) {
                this.zzr().zzf().zza("Got multiple records for app, expected one. appId", zzet.zza((String)string));
            }
            zzg zzg3 = zzg2;
            return zzg3;
        }
    }

    @WorkerThread
    public final void zza(zzg zzg2) {
        Preconditions.checkNotNull((Object)zzg2);
        this.zzd();
        this.zzak();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzg2.zzc());
        contentValues.put("app_instance_id", zzg2.zzd());
        contentValues.put("gmp_app_id", zzg2.zze());
        contentValues.put("resettable_device_id_hash", zzg2.zzh());
        contentValues.put("last_bundle_index", Long.valueOf(zzg2.zzs()));
        contentValues.put("last_bundle_start_timestamp", Long.valueOf(zzg2.zzj()));
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(zzg2.zzk()));
        contentValues.put("app_version", zzg2.zzl());
        contentValues.put("app_store", zzg2.zzn());
        contentValues.put("gmp_version", Long.valueOf(zzg2.zzo()));
        contentValues.put("dev_cert_hash", Long.valueOf(zzg2.zzp()));
        contentValues.put("measurement_enabled", Boolean.valueOf(zzg2.zzr()));
        contentValues.put("day", Long.valueOf(zzg2.zzw()));
        contentValues.put("daily_public_events_count", Long.valueOf(zzg2.zzx()));
        contentValues.put("daily_events_count", Long.valueOf(zzg2.zzy()));
        contentValues.put("daily_conversions_count", Long.valueOf(zzg2.zzz()));
        contentValues.put("config_fetched_time", Long.valueOf(zzg2.zzt()));
        contentValues.put("failed_config_fetch_time", Long.valueOf(zzg2.zzu()));
        contentValues.put("app_version_int", Long.valueOf(zzg2.zzm()));
        contentValues.put("firebase_instance_id", zzg2.zzi());
        contentValues.put("daily_error_events_count", Long.valueOf(zzg2.zzab()));
        contentValues.put("daily_realtime_events_count", Long.valueOf(zzg2.zzaa()));
        contentValues.put("health_monitor_sample", zzg2.zzac());
        contentValues.put("android_id", Long.valueOf(zzg2.zzae()));
        contentValues.put("adid_reporting_enabled", Boolean.valueOf(zzg2.zzaf()));
        contentValues.put("ssaid_reporting_enabled", Boolean.valueOf(zzg2.zzag()));
        contentValues.put("admob_app_id", zzg2.zzf());
        contentValues.put("dynamite_version", Long.valueOf(zzg2.zzq()));
        if (zzg2.zzai() != null) {
            if (zzg2.zzai().size() == 0) {
                this.zzr().zzi().zza("Safelisted events should not be an empty list. appId", (Object)zzg2.zzc());
            } else {
                contentValues.put("safelisted_events", TextUtils.join((CharSequence)",", (Iterable)zzg2.zzai()));
            }
        }
        if (zzky.zzb() && this.zzt().zze(zzg2.zzc(), zzap.zzci)) {
            contentValues.put("ga_app_id", zzg2.zzg());
        }
        try {
            SQLiteDatabase sQLiteDatabase = this.c_();
            if ((long)sQLiteDatabase.update("apps", contentValues, "app_id = ?", new String[]{zzg2.zzc()}) == 0L && sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5) == -1L) {
                this.zzr().zzf().zza("Failed to insert/update app (got -1). appId", zzet.zza((String)zzg2.zzc()));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Error storing app. appId", zzet.zza((String)zzg2.zzc()), (Object)sQLiteException);
            return;
        }
    }

    public final long zzc(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzd();
        this.zzak();
        try {
            SQLiteDatabase sQLiteDatabase = this.c_();
            String string2 = string;
            int n = this.zzt().zzb(string2, zzap.zzs);
            n = Math.min(1000000, n);
            String string3 = String.valueOf(Math.max(0, n));
            return sQLiteDatabase.delete("raw_events", "rowid in (select rowid from raw_events where app_id=? order by rowid desc limit -1 offset ?)", new String[]{string, string3});
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Error deleting over the limit events. appId", zzet.zza((String)string), (Object)sQLiteException);
            return 0L;
        }
    }

    @WorkerThread
    public final zzab zza(long l, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        Preconditions.checkNotEmpty((String)string);
        this.zzd();
        this.zzak();
        String[] stringArray = new String[]{string};
        zzab zzab2 = new zzab();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.c_();
            cursor = sQLiteDatabase.query("apps", new String[]{"day", "daily_events_count", "daily_public_events_count", "daily_conversions_count", "daily_error_events_count", "daily_realtime_events_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                this.zzr().zzi().zza("Not updating daily counts, app is not known. appId", zzet.zza((String)string));
                zzab zzab3 = zzab2;
                return zzab3;
            }
            if (cursor.getLong(0) == l) {
                zzab2.zzb = cursor.getLong(1);
                zzab2.zza = cursor.getLong(2);
                zzab2.zzc = cursor.getLong(3);
                zzab2.zzd = cursor.getLong(4);
                zzab2.zze = cursor.getLong(5);
            }
            if (bl) {
                ++zzab2.zzb;
            }
            if (bl2) {
                ++zzab2.zza;
            }
            if (bl3) {
                ++zzab2.zzc;
            }
            if (bl4) {
                ++zzab2.zzd;
            }
            if (bl5) {
                ++zzab2.zze;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("day", Long.valueOf(l));
            contentValues.put("daily_public_events_count", Long.valueOf(zzab2.zza));
            contentValues.put("daily_events_count", Long.valueOf(zzab2.zzb));
            contentValues.put("daily_conversions_count", Long.valueOf(zzab2.zzc));
            contentValues.put("daily_error_events_count", Long.valueOf(zzab2.zzd));
            contentValues.put("daily_realtime_events_count", Long.valueOf(zzab2.zze));
            sQLiteDatabase.update("apps", contentValues, "app_id=?", stringArray);
            zzab zzab4 = zzab2;
            return zzab4;
        }
    }

    @WorkerThread
    public final byte[] zzd(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzd();
        this.zzak();
        try (Cursor cursor = null;){
            cursor = this.c_().query("apps", new String[]{"remote_config"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            if (cursor.moveToNext()) {
                this.zzr().zzf().zza("Got multiple records for app config, expected one. appId", zzet.zza((String)string));
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    @WorkerThread
    public final boolean zza(zzbr.zzg zzg2, boolean bl) {
        this.zzd();
        this.zzak();
        Preconditions.checkNotNull((Object)((Object)zzg2));
        Preconditions.checkNotEmpty((String)zzg2.zzx());
        Preconditions.checkState((boolean)zzg2.zzk());
        this.zzv();
        long l = this.zzm().currentTimeMillis();
        if (zzg2.zzl() < l - zzx.zzk() || zzg2.zzl() > l + zzx.zzk()) {
            this.zzr().zzi().zza("Storing bundle outside of the max uploading time span. appId, now, timestamp", zzet.zza((String)zzg2.zzx()), (Object)l, (Object)zzg2.zzl());
        }
        byte[] byArray = zzg2.zzbh();
        try {
            byArray = this.zzg().zzc(byArray);
        }
        catch (IOException iOException) {
            this.zzr().zzf().zza("Data loss. Failed to serialize bundle. appId", zzet.zza((String)zzg2.zzx()), (Object)iOException);
            return false;
        }
        this.zzr().zzx().zza("Saving bundle, size", (Object)byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzg2.zzx());
        contentValues.put("bundle_end_timestamp", Long.valueOf(zzg2.zzl()));
        contentValues.put("data", byArray);
        contentValues.put("has_realtime", Integer.valueOf(bl ? 1 : 0));
        if (zzg2.zzaz()) {
            contentValues.put("retry_count", Integer.valueOf(zzg2.zzba()));
        }
        try {
            if (this.c_().insert("queue", null, contentValues) == -1L) {
                this.zzr().zzf().zza("Failed to insert bundle (got -1). appId", zzet.zza((String)zzg2.zzx()));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Error storing bundle. appId", zzet.zza((String)zzg2.zzx()), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final String d_() {
        SQLiteDatabase sQLiteDatabase = this.c_();
        Cursor cursor = null;
        try {
            String string = "select app_id from queue order by has_realtime desc, rowid asc limit 1;";
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(0);
                return string2;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Database error getting next bundle app id", (Object)sQLiteException);
            return null;
        }
        if (cursor == null) return null;
        cursor.close();
        return null;
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public final boolean zzk() {
        return this.zzb("select count(1) > 0 from queue where has_realtime = 1", (String[])null) != 0L;
    }

    @WorkerThread
    public final List<Pair<zzbr.zzg, Long>> zza(String string, int n, int n2) {
        this.zzd();
        this.zzak();
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((n2 > 0 ? 1 : 0) != 0);
        Preconditions.checkNotEmpty((String)string);
        try (Cursor cursor = null;){
            cursor = this.c_().query("queue", new String[]{"rowid", "data", "retry_count"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(n));
            if (!cursor.moveToFirst()) {
                List<Pair<zzbr.zzg, Long>> list = Collections.emptyList();
                return list;
            }
            ArrayList<Pair<zzbr.zzg, Long>> arrayList = new ArrayList<Pair<zzbr.zzg, Long>>();
            int n3 = 0;
            do {
                byte[] byArray;
                Object object;
                long l = cursor.getLong(0);
                try {
                    object = cursor.getBlob(1);
                    byArray = this.zzg().zzb((byte[])object);
                }
                catch (IOException iOException) {
                    this.zzr().zzf().zza("Failed to unzip queued bundle. appId", zzet.zza((String)string), (Object)iOException);
                    continue;
                }
                if (!arrayList.isEmpty() && n3 + byArray.length > n2) break;
                try {
                    object = (Object)zzkg.zza(zzbr.zzg.zzbe(), byArray);
                }
                catch (IOException iOException) {
                    this.zzr().zzf().zza("Failed to merge queued bundle. appId", zzet.zza((String)string), (Object)iOException);
                    continue;
                }
                if (!cursor.isNull(2)) {
                    ((zzbr.zzg.zza)((Object)object)).zzi(cursor.getInt(2));
                }
                n3 += byArray.length;
                arrayList.add((Pair<zzbr.zzg, Long>)Pair.create((Object)((Object)((zzbr.zzg)((zzfd)object.zzt()))), (Object)l));
            } while (cursor.moveToNext() && n3 <= n2);
            ArrayList<Pair<zzbr.zzg, Long>> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @WorkerThread
    final void zzv() {
        this.zzd();
        this.zzak();
        if (!this.zzam()) {
            return;
        }
        long l = this.zzs().zzf.zza();
        long l2 = this.zzm().elapsedRealtime();
        if (Math.abs(l2 - l) > (Long)zzap.zzab.zza(null)) {
            this.zzs().zzf.zza(l2);
            zzac zzac2 = this;
            zzac2.zzd();
            zzac2.zzak();
            if (zzac2.zzam()) {
                SQLiteDatabase sQLiteDatabase = zzac2.c_();
                String[] stringArray = new String[]{String.valueOf(zzac2.zzm().currentTimeMillis()), String.valueOf(zzx.zzk())};
                int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
                if (n > 0) {
                    zzac2.zzr().zzx().zza("Deleted stale rows. rowsDeleted", (Object)n);
                }
            }
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zza(List<Long> list) {
        this.zzd();
        this.zzak();
        Preconditions.checkNotNull(list);
        Preconditions.checkNotZero((int)list.size());
        if (!this.zzam()) {
            return;
        }
        String string = TextUtils.join((CharSequence)",", list);
        String string2 = new StringBuilder(2 + String.valueOf(string).length()).append("(").append(string).append(")").toString();
        if (this.zzb(new StringBuilder(80 + String.valueOf(string2).length()).append("SELECT COUNT(1) FROM queue WHERE rowid IN ").append(string2).append(" AND retry_count =  2147483647 LIMIT 1").toString(), (String[])null) > 0L) {
            this.zzr().zzi().zza("The number of upload retries exceeds the limit. Will remain unchanged.");
        }
        try {
            this.c_().execSQL(new StringBuilder(127 + String.valueOf(string2).length()).append("UPDATE queue SET retry_count = IFNULL(retry_count, 0) + 1 WHERE rowid IN ").append(string2).append(" AND (retry_count IS NULL OR retry_count < 2147483647)").toString());
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Error incrementing retry count. error", (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    final void zza(String string, List<zzbj.zza> list) {
        this.zzak();
        this.zzd();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull(list);
        SQLiteDatabase sQLiteDatabase = this.c_();
        sQLiteDatabase.beginTransaction();
        try {
            String string2 = string;
            zzac zzac2 = this;
            zzac2.zzak();
            zzac2.zzd();
            Preconditions.checkNotEmpty((String)string2);
            Object object = zzac2.c_();
            object.delete("property_filters", "app_id=?", new String[]{string2});
            object.delete("event_filters", "app_id=?", new String[]{string2});
            Object object2 = list.iterator();
            block3: while (object2.hasNext()) {
                Object object3;
                object = object3 = object2.next();
                string2 = string;
                zzac2 = this;
                zzac2.zzak();
                zzac2.zzd();
                Preconditions.checkNotEmpty((String)string2);
                Preconditions.checkNotNull((Object)object);
                if (!((zzbj.zza)((Object)object)).zza()) {
                    zzac2.zzr().zzi().zza("Audience with no ID. appId", zzet.zza((String)string2));
                    continue;
                }
                int n = ((zzbj.zza)((Object)object)).zzb();
                Iterator<zzfd> iterator = ((zzbj.zza)((Object)object)).zze().iterator();
                while (iterator.hasNext()) {
                    if (iterator.next().zza()) continue;
                    zzac2.zzr().zzi().zza("Event filter with no ID. Audience definition ignored. appId, audienceId", zzet.zza((String)string2), (Object)n);
                    continue block3;
                }
                iterator = ((zzbj.zza)((Object)object)).zzc().iterator();
                while (iterator.hasNext()) {
                    if (((zzbj.zze)iterator.next()).zza()) continue;
                    zzac2.zzr().zzi().zza("Property filter with no ID. Audience definition ignored. appId, audienceId", zzet.zza((String)string2), (Object)n);
                    continue block3;
                }
                boolean bl = true;
                for (zzbj.zzb zzb2 : ((zzbj.zza)((Object)object)).zze()) {
                    if (zzac2.zza(string2, n, zzb2)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    for (zzbj.zze zze2 : ((zzbj.zza)((Object)object)).zzc()) {
                        if (zzac2.zza(string2, n, zze2)) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) continue;
                int n2 = n;
                String string3 = string2;
                zzac zzac3 = zzac2;
                zzac3.zzak();
                zzac3.zzd();
                Preconditions.checkNotEmpty((String)string3);
                SQLiteDatabase sQLiteDatabase2 = zzac3.c_();
                sQLiteDatabase2.delete("property_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n2)});
                sQLiteDatabase2.delete("event_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n2)});
            }
            object2 = new ArrayList();
            for (zzbj.zza zza2 : list) {
                object2.add(zza2.zza() ? Integer.valueOf(zza2.zzb()) : null);
            }
            this.zzc(string, (List<Integer>)object2);
            sQLiteDatabase.setTransactionSuccessful();
            return;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzbj.zzb zzb2) {
        this.zzak();
        this.zzd();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)zzb2));
        if (TextUtils.isEmpty((CharSequence)zzb2.zzc())) {
            this.zzr().zzi().zza("Event filter had no event name. Audience definition ignored. appId, audienceId, filterId", zzet.zza((String)string), (Object)n, (Object)String.valueOf(zzb2.zza() ? Integer.valueOf(zzb2.zzb()) : null));
            return false;
        }
        byte[] byArray = zzb2.zzbh();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzb2.zza() ? Integer.valueOf(zzb2.zzb()) : null);
        contentValues.put("event_name", zzb2.zzc());
        if (this.zzt().zze(string, zzap.zzbs)) {
            contentValues.put("session_scoped", zzb2.zzj() ? Boolean.valueOf(zzb2.zzk()) : null);
        }
        contentValues.put("data", byArray);
        try {
            if (this.c_().insertWithOnConflict("event_filters", null, contentValues, 5) == -1L) {
                this.zzr().zzf().zza("Failed to insert event filter (got -1). appId", zzet.zza((String)string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Error storing event filter. appId", zzet.zza((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzbj.zze zze2) {
        this.zzak();
        this.zzd();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)((Object)zze2));
        if (TextUtils.isEmpty((CharSequence)zze2.zzc())) {
            this.zzr().zzi().zza("Property filter had no property name. Audience definition ignored. appId, audienceId, filterId", zzet.zza((String)string), (Object)n, (Object)String.valueOf(zze2.zza() ? Integer.valueOf(zze2.zzb()) : null));
            return false;
        }
        byte[] byArray = zze2.zzbh();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zze2.zza() ? Integer.valueOf(zze2.zzb()) : null);
        contentValues.put("property_name", zze2.zzc());
        if (this.zzt().zze(string, zzap.zzbs)) {
            contentValues.put("session_scoped", zze2.zzg() ? Boolean.valueOf(zze2.zzh()) : null);
        }
        contentValues.put("data", byArray);
        try {
            if (this.c_().insertWithOnConflict("property_filters", null, contentValues, 5) == -1L) {
                this.zzr().zzf().zza("Failed to insert property filter (got -1). appId", zzet.zza((String)string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Error storing property filter. appId", zzet.zza((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    final Map<Integer, List<zzbj.zzb>> zzf(String string, String string2) {
        this.zzak();
        this.zzd();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.c_();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=? AND event_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzbj.zzb>> map = Collections.emptyMap();
                return map;
            }
            do {
                zzbj.zzb zzb2;
                byte[] byArray = cursor.getBlob(1);
                try {
                    zzb2 = (zzbj.zzb)((zzfd)zzkg.zza(zzbj.zzb.zzl(), byArray).zzt());
                }
                catch (IOException iOException) {
                    this.zzr().zzf().zza("Failed to merge filter. appId", zzet.zza((String)string), (Object)iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzbj.zzb> arrayList = (ArrayList<zzbj.zzb>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzbj.zzb>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzb2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<zzbj.zze>> zzg(String string, String string2) {
        this.zzak();
        this.zzd();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.c_();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("property_filters", new String[]{"audience_id", "data"}, "app_id=? AND property_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzbj.zze>> map = Collections.emptyMap();
                return map;
            }
            do {
                zzbj.zze zze2;
                byte[] byArray = cursor.getBlob(1);
                try {
                    zze2 = (zzbj.zze)((zzfd)zzkg.zza(zzbj.zze.zzi(), byArray).zzt());
                }
                catch (IOException iOException) {
                    this.zzr().zzf().zza("Failed to merge filter", zzet.zza((String)string), (Object)iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzbj.zze> arrayList = (ArrayList<zzbj.zze>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzbj.zze>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zze2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<Integer>> zzb(String string, List<String> list) {
        this.zzak();
        this.zzd();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull(list);
        ArrayMap arrayMap = new ArrayMap();
        if (list.isEmpty()) {
            return arrayMap;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("app_id=? AND property_name in (");
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("?");
        }
        stringBuilder.append(")");
        ArrayList<String> arrayList = new ArrayList<String>(list);
        arrayList.add(0, string);
        SQLiteDatabase sQLiteDatabase = this.c_();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("property_filters", new String[]{"audience_id", "filter_id"}, stringBuilder.toString(), arrayList.toArray(new String[0]), null, null, null);
            if (!cursor.moveToFirst()) {
                ArrayMap arrayMap2 = arrayMap;
                return arrayMap2;
            }
            do {
                int n;
                ArrayList<Integer> arrayList2;
                if ((arrayList2 = (ArrayList<Integer>)arrayMap.get(n = cursor.getInt(0))) == null) {
                    arrayList2 = new ArrayList<Integer>();
                    arrayMap.put(n, arrayList2);
                }
                int n2 = cursor.getInt(1);
                arrayList2.add(n2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<Integer>> zze(String string) {
        this.zzak();
        this.zzd();
        Preconditions.checkNotEmpty((String)string);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.c_();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery("select audience_id, filter_id from event_filters where app_id = ? and session_scoped = 1 UNION select audience_id, filter_id from property_filters where app_id = ? and session_scoped = 1;", new String[]{string, string});
            if (!cursor.moveToFirst()) {
                Map<Integer, List<Integer>> map = Collections.emptyMap();
                return map;
            }
            do {
                int n;
                ArrayList<Integer> arrayList;
                if ((arrayList = (ArrayList<Integer>)arrayMap.get(n = cursor.getInt(0))) == null) {
                    arrayList = new ArrayList<Integer>();
                    arrayMap.put(n, arrayList);
                }
                int n2 = cursor.getInt(1);
                arrayList.add(n2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    private final boolean zzc(String string, List<Integer> list) {
        Object object;
        long l;
        Preconditions.checkNotEmpty((String)string);
        this.zzak();
        this.zzd();
        SQLiteDatabase sQLiteDatabase = this.c_();
        try {
            l = this.zzb("select count(1) from audience_filter_values where app_id=?", new String[]{string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Database error querying filters. appId", zzet.zza((String)string), (Object)sQLiteException);
            return false;
        }
        String string2 = string;
        int n = this.zzt().zzb(string2, zzap.zzai);
        n = Math.min(2000, n);
        int n2 = Math.max(0, n);
        if (l <= (long)n2) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            if (object == null || !(object instanceof Integer)) {
                return false;
            }
            arrayList.add(Integer.toString((Integer)object));
        }
        object = TextUtils.join((CharSequence)",", arrayList);
        String string3 = new StringBuilder(2 + String.valueOf(object).length()).append("(").append((String)object).append(")").toString();
        return sQLiteDatabase.delete("audience_filter_values", new StringBuilder(140 + String.valueOf(string3).length()).append("audience_id in (select audience_id from audience_filter_values where app_id=? and audience_id not in ").append(string3).append(" order by rowid desc limit -1 offset ?)").toString(), new String[]{string, Integer.toString(n2)}) > 0;
    }

    final Map<Integer, zzbr.zzi> zzf(String string) {
        this.zzak();
        this.zzd();
        Preconditions.checkNotEmpty((String)string);
        SQLiteDatabase sQLiteDatabase = this.c_();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("audience_filter_values", new String[]{"audience_id", "current_results"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            ArrayMap arrayMap = new ArrayMap();
            do {
                zzbr.zzi zzi2;
                int n = cursor.getInt(0);
                byte[] byArray = cursor.getBlob(1);
                try {
                    zzi2 = (zzbr.zzi)((zzfd)zzkg.zza(zzbr.zzi.zzi(), byArray).zzt());
                }
                catch (IOException iOException) {
                    this.zzr().zzf().zza("Failed to merge filter results. appId, audienceId, error", zzet.zza((String)string), (Object)n, (Object)iOException);
                    continue;
                }
                arrayMap.put(n, zzi2);
            } while (cursor.moveToNext());
            ArrayMap arrayMap2 = arrayMap;
            return arrayMap2;
        }
    }

    @WorkerThread
    private static void zza(ContentValues contentValues, String string, Object object) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)object);
        if (object instanceof String) {
            contentValues.put(string, (String)object);
            return;
        }
        if (object instanceof Long) {
            contentValues.put(string, (Long)object);
            return;
        }
        if (object instanceof Double) {
            contentValues.put(string, (Double)object);
            return;
        }
        throw new IllegalArgumentException("Invalid value type");
    }

    @VisibleForTesting
    @WorkerThread
    private final Object zza(Cursor cursor, int n) {
        int n2 = n;
        Cursor cursor2 = cursor;
        int n3 = cursor2.getType(n2);
        switch (n3) {
            case 0: {
                this.zzr().zzf().zza("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return cursor.getDouble(n);
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzr().zzf().zza("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzr().zzf().zza("Loaded invalid unknown value type, ignoring it", (Object)n3);
        return null;
    }

    @WorkerThread
    public final long zzw() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    @WorkerThread
    @VisibleForTesting
    protected final long zzh(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzd();
        this.zzak();
        long l = 0L;
        SQLiteDatabase sQLiteDatabase = this.c_();
        sQLiteDatabase.beginTransaction();
        try {
            ContentValues contentValues;
            l = this.zza(new StringBuilder(32 + String.valueOf(string2).length()).append("select ").append(string2).append(" from app2 where app_id=?").toString(), new String[]{string}, -1L);
            if (l == -1L) {
                l = 0L;
                contentValues = new ContentValues();
                contentValues.put("app_id", string);
                contentValues.put("first_open_count", Integer.valueOf(0));
                contentValues.put("previous_install_count", Integer.valueOf(0));
                if (sQLiteDatabase.insertWithOnConflict("app2", null, contentValues, 5) == -1L) {
                    this.zzr().zzf().zza("Failed to insert column (got -1). appId", zzet.zza((String)string), (Object)string2);
                    return -1L;
                }
            }
            contentValues = new ContentValues();
            contentValues.put("app_id", string);
            contentValues.put(string2, Long.valueOf(l + 1L));
            if ((long)sQLiteDatabase.update("app2", contentValues, "app_id = ?", new String[]{string}) == 0L) {
                this.zzr().zzf().zza("Failed to update column (got 0). appId", zzet.zza((String)string), (Object)string2);
                return -1L;
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Error inserting column. appId", zzet.zza((String)string), (Object)string2, (Object)sQLiteException);
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        return l;
    }

    @WorkerThread
    public final long zzx() {
        return this.zza("select max(timestamp) from raw_events", null, 0L);
    }

    public final long zza(zzbr.zzg zzg2) throws IOException {
        this.zzd();
        this.zzak();
        Preconditions.checkNotNull((Object)((Object)zzg2));
        Preconditions.checkNotEmpty((String)zzg2.zzx());
        byte[] byArray = zzg2.zzbh();
        long l = this.zzg().zza(byArray);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzg2.zzx());
        contentValues.put("metadata_fingerprint", Long.valueOf(l));
        contentValues.put("metadata", byArray);
        try {
            this.c_().insertWithOnConflict("raw_events_metadata", null, contentValues, 4);
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Error storing raw event metadata. appId", zzet.zza((String)zzg2.zzx()), (Object)sQLiteException);
            throw sQLiteException;
        }
        return l;
    }

    public final boolean zzy() {
        return this.zzb("select count(1) > 0 from raw_events", (String[])null) != 0L;
    }

    public final boolean zzz() {
        return this.zzb("select count(1) > 0 from raw_events where realtime = 1", (String[])null) != 0L;
    }

    public final long zzg(String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zza("select count(1) from events where app_id=? and name not like '!_%' escape '!'", new String[]{string}, 0L);
    }

    public final String zza(long l) {
        this.zzd();
        this.zzak();
        try (Cursor cursor = null;){
            cursor = this.c_().rawQuery("select app_id from apps where app_id in (select distinct app_id from raw_events) and config_fetched_time < ? order by failed_config_fetch_time limit 1;", new String[]{String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzr().zzx().zza("No expired configs for apps with pending events");
                return null;
            }
            String string = cursor.getString(0);
            return string;
        }
        return null;
    }

    public final long zzaa() {
        try (Cursor cursor = null;){
            cursor = this.c_().rawQuery("select rowid from raw_events order by rowid desc limit 1;", null);
            if (!cursor.moveToFirst()) {
                return -1L;
            }
            long l = cursor.getLong(0);
            return l;
        }
        return -1L;
    }

    public final Pair<zzbr.zzc, Long> zza(String string, Long l) {
        this.zzd();
        this.zzak();
        try (Cursor cursor = null;){
            zzbr.zzc zzc2;
            cursor = this.c_().rawQuery("select main_event, children_to_process from main_event_params where app_id=? and event_id=?", new String[]{string, String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzr().zzx().zza("Main event not found");
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            Long l2 = cursor.getLong(1);
            try {
                zzc2 = (zzbr.zzc)((zzfd)zzkg.zza(zzbr.zzc.zzj(), byArray).zzt());
            }
            catch (IOException iOException) {
                this.zzr().zzf().zza("Failed to merge main event. appId, eventId", zzet.zza((String)string), (Object)l, (Object)iOException);
                if (cursor != null) {
                    cursor.close();
                }
                return null;
            }
            Pair pair = Pair.create((Object)((Object)zzc2), (Object)l2);
            return pair;
        }
        return null;
    }

    public final boolean zza(String string, Long l, long l2, zzbr.zzc zzc2) {
        this.zzd();
        this.zzak();
        Preconditions.checkNotNull((Object)((Object)zzc2));
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)l);
        byte[] byArray = zzc2.zzbh();
        this.zzr().zzx().zza("Saving complex main event, appId, data size", (Object)this.zzo().zza(string), (Object)byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("event_id", l);
        contentValues.put("children_to_process", Long.valueOf(l2));
        contentValues.put("main_event", byArray);
        try {
            if (this.c_().insertWithOnConflict("main_event_params", null, contentValues, 5) == -1L) {
                this.zzr().zzf().zza("Failed to insert complex main event (got -1). appId", zzet.zza((String)string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Error storing complex main event. appId", zzet.zza((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    public final boolean zza(zzak zzak2, long l, boolean bl) {
        String string2;
        this.zzd();
        this.zzak();
        Preconditions.checkNotNull((Object)zzak2);
        Preconditions.checkNotEmpty((String)zzak2.zza);
        zzbr.zzc.zza zza2 = zzbr.zzc.zzj().zzb(zzak2.zzd);
        for (String string2 : zzak2.zze) {
            zzbr.zze.zza zza3 = zzbr.zze.zzh().zza(string2);
            Object object = zzak2.zze.zza(string2);
            this.zzg().zza(zza3, object);
            zza2.zza(zza3);
        }
        Object object = ((zzbr.zzc)((zzfd)zza2.zzt())).zzbh();
        this.zzr().zzx().zza("Saving event, name, data size", (Object)this.zzo().zza(zzak2.zzb), (Object)((Object)object).length);
        string2 = new ContentValues();
        string2.put("app_id", zzak2.zza);
        string2.put("name", zzak2.zzb);
        string2.put("timestamp", Long.valueOf(zzak2.zzc));
        string2.put("metadata_fingerprint", Long.valueOf(l));
        string2.put("data", (byte[])object);
        string2.put("realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.c_().insert("raw_events", null, (ContentValues)string2) == -1L) {
                this.zzr().zzf().zza("Failed to insert raw event (got -1). appId", zzet.zza((String)zzak2.zza));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzr().zzf().zza("Error storing raw event. appId", zzet.zza((String)zzak2.zza), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    private final boolean zzam() {
        return this.zzn().getDatabasePath("google_app_measurement.db").exists();
    }

    static /* synthetic */ zzjv zza(zzac zzac2) {
        return zzac2.zzk;
    }

    static /* synthetic */ String[] zzab() {
        return zzb;
    }

    static /* synthetic */ String[] zzac() {
        return zzc;
    }

    static /* synthetic */ String[] zzad() {
        return zzd;
    }

    static /* synthetic */ String[] zzae() {
        return zzf;
    }

    static /* synthetic */ String[] zzaf() {
        return zze;
    }

    static /* synthetic */ String[] zzag() {
        return zzg;
    }

    static /* synthetic */ String[] zzah() {
        return zzh;
    }

    static /* synthetic */ String[] zzai() {
        return zzi;
    }
}

