/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.database.sqlite.SQLiteException;
import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import androidx.collection.LruCache;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzb;
import com.google.android.gms.internal.measurement.zzc;
import com.google.android.gms.internal.measurement.zzfn;
import com.google.android.gms.internal.measurement.zzfx;
import com.google.android.gms.internal.measurement.zzhg;
import com.google.android.gms.internal.measurement.zzlc;
import com.google.android.gms.internal.measurement.zzlk;
import com.google.android.gms.internal.measurement.zzv;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzao;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzhk;
import com.google.android.gms.measurement.internal.zzhl;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzjb;
import com.google.android.gms.measurement.internal.zzjc;
import com.google.android.gms.measurement.internal.zzjf;
import com.google.android.gms.measurement.internal.zzno;
import com.google.android.gms.measurement.internal.zznr;
import com.google.android.gms.measurement.internal.zznv;
import com.google.android.gms.measurement.internal.zzol;
import com.google.android.gms.measurement.internal.zzop;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzhg
extends zznr
implements zzaj {
    private final Map<String, @Nullable Map<String, String>> zzc = new ArrayMap();
    @VisibleForTesting
    private final Map<String, @Nullable Set<String>> zzd = new ArrayMap();
    @VisibleForTesting
    private final Map<String, @Nullable Map<String, Boolean>> zze = new ArrayMap();
    @VisibleForTesting
    private final Map<String, @Nullable Map<String, Boolean>> zzf = new ArrayMap();
    private final Map<String, @Nullable zzfx.zzd> zzh = new ArrayMap();
    private final Map<String, @Nullable Map<String, Integer>> zzi;
    @VisibleForTesting
    final LruCache<String, zzb> zza;
    final zzv zzb;
    private final Map<String, @Nullable String> zzj = new ArrayMap();
    private final Map<String, @Nullable String> zzk = new ArrayMap();
    private final Map<String, @Nullable String> zzl = new ArrayMap();

    @WorkerThread
    final int zzb(String string, String string2) {
        this.zzt();
        this.zzv(string);
        Map<String, Integer> map = this.zzi.get(string);
        if (map != null) {
            Integer n = map.get(string2);
            if (n == null) {
                return 1;
            }
            return n;
        }
        return 1;
    }

    @WorkerThread
    final long zza(String string) {
        String string2 = this.zza(string, "measurement.account.time_zone_offset_minutes");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.zzj().zzu().zza("Unable to parse timezone offset. appId", zzgi.zza((String)string), (Object)numberFormatException);
            }
        }
        return 0L;
    }

    static /* synthetic */ zzb zza(zzhg zzhg2, String string) {
        String string2 = string;
        zzhg zzhg3 = zzhg2;
        zzhg3.zzal();
        Preconditions.checkNotEmpty((String)string2);
        if (!zzhg3.zzl(string2)) {
            return null;
        }
        if (zzhg3.zzh.containsKey(string2) && zzhg3.zzh.get(string2) != null) {
            zzhg3.zza(string2, zzhg3.zzh.get(string2));
        } else {
            zzhg3.zzv(string2);
        }
        return (zzb)zzhg3.zza.snapshot().get(string2);
    }

    @WorkerThread
    final zzjb zza(String string, zzjc.zza zza2) {
        this.zzt();
        this.zzv(string);
        zzfx.zza zza3 = this.zzb(string);
        if (zza3 == null) {
            return zzjb.zza;
        }
        for (zzfx.zza.zzb zzb2 : zza3.zzf()) {
            if (zzhg.zza(zzb2.zzc()) != zza2) continue;
            switch (zzb2.zzb()) {
                case zzc: {
                    return zzjb.zzc;
                }
                case zzb: {
                    return zzjb.zzd;
                }
            }
            return zzjb.zza;
        }
        return zzjb.zza;
    }

    @WorkerThread
    final // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable zzjc.zza zzb(String string, zzjc.zza zza2) {
        this.zzt();
        this.zzv(string);
        zzfx.zza zza3 = this.zzb(string);
        if (zza3 == null) {
            return null;
        }
        for (zzfx.zza.zzc zzc2 : zza3.zze()) {
            zzjc.zza zza4 = zzhg.zza(zzc2.zzc());
            if (zza2 != zza4) continue;
            return zzhg.zza(zzc2.zzb());
        }
        return null;
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable zzjc.zza zza(zzfx.zza.zze zze2) {
        switch (zze2) {
            case zzb: {
                return zzjc.zza.zza;
            }
            case zzc: {
                return zzjc.zza.zzb;
            }
            case zzd: {
                return zzjc.zza.zzc;
            }
            case zze: {
                return zzjc.zza.zzd;
            }
        }
        return null;
    }

    @WorkerThread
    final @Nullable zzfx.zza zzb(String string) {
        this.zzt();
        this.zzv(string);
        zzfx.zzd zzd2 = this.zzc(string);
        if (zzd2 == null || !zzd2.zzp()) {
            return null;
        }
        return zzd2.zzd();
    }

    @WorkerThread
    protected final @Nullable zzfx.zzd zzc(String string) {
        this.zzal();
        this.zzt();
        Preconditions.checkNotEmpty((String)string);
        this.zzv(string);
        return this.zzh.get(string);
    }

    @WorkerThread
    private final zzfx.zzd zza(String string, byte @Nullable [] byArray) {
        zzfx.zzd zzd2;
        if (byArray == null) {
            return zzfx.zzd.zzg();
        }
        try {
            zzd2 = (zzfx.zzd)((zzlc)zzol.zza(zzfx.zzd.zze(), byArray).zzai());
            this.zzj().zzp().zza("Parsed config. version, gmp_app_id", (Object)(zzd2.zzs() ? Long.valueOf(zzd2.zzc()) : null), (Object)(zzd2.zzq() ? zzd2.zzi() : null));
        }
        catch (zzlk zzlk2) {
            this.zzj().zzu().zza("Unable to merge remote config. appId", zzgi.zza((String)string), (Object)zzlk2);
            return zzfx.zzd.zzg();
        }
        catch (RuntimeException runtimeException) {
            this.zzj().zzu().zza("Unable to merge remote config. appId", zzgi.zza((String)string), (Object)runtimeException);
            return zzfx.zzd.zzg();
        }
        return zzd2;
    }

    @WorkerThread
    public final @Nullable String zza(String string, String string2) {
        this.zzt();
        this.zzv(string);
        Map<String, String> map = this.zzc.get(string);
        if (map != null) {
            return map.get(string2);
        }
        return null;
    }

    @WorkerThread
    protected final @Nullable String zzd(String string) {
        this.zzt();
        return this.zzl.get(string);
    }

    @WorkerThread
    protected final @Nullable String zze(String string) {
        this.zzt();
        return this.zzk.get(string);
    }

    @WorkerThread
    final @Nullable String zzf(String string) {
        this.zzt();
        this.zzv(string);
        return this.zzj.get(string);
    }

    static /* bridge */ /* synthetic */ Map zza(zzhg zzhg2) {
        return zzhg2.zzc;
    }

    private static Map<String, String> zza(zzfx.zzd zzd2) {
        ArrayMap arrayMap = new ArrayMap();
        if (zzd2 != null) {
            for (zzfx.zzh zzh2 : zzd2.zzn()) {
                arrayMap.put(zzh2.zzb(), zzh2.zzc());
            }
        }
        return arrayMap;
    }

    @WorkerThread
    final @Nullable Set<String> zzg(String string) {
        this.zzt();
        this.zzv(string);
        return this.zzd.get(string);
    }

    @WorkerThread
    final SortedSet<String> zzh(String string) {
        this.zzt();
        this.zzv(string);
        TreeSet<String> treeSet = new TreeSet<String>();
        zzfx.zza zza2 = this.zzb(string);
        if (zza2 == null) {
            return treeSet;
        }
        for (zzfx.zza.zzf zzf2 : zza2.zzc()) {
            treeSet.add(zzf2.zzb());
        }
        return treeSet;
    }

    zzhg(zznv zznv2) {
        super(zznv2);
        this.zzi = new ArrayMap();
        this.zza = new zzhm(this, 20);
        this.zzb = new zzhl(this);
    }

    @WorkerThread
    protected final void zzi(String string) {
        this.zzt();
        this.zzk.put(string, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void zza(String string, zzfx.zzd.zza zza2) {
        HashSet<String> hashSet = new HashSet<String>();
        ArrayMap arrayMap = new ArrayMap();
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        if (zza2 != null) {
            for (zzfx.zzb zzmn2 : zza2.zze()) {
                hashSet.add(zzmn2.zzb());
            }
            for (int i = 0; i < zza2.zza(); ++i) {
                void var8_13;
                zzfx.zzc.zza zza3 = (zzfx.zzc.zza)zza2.zza(i).zzcd();
                if (zza3.zzb().isEmpty()) {
                    this.zzj().zzu().zza("EventConfig contained null event name");
                    continue;
                }
                String string2 = zza3.zzb();
                String string3 = zzjf.zzb((String)zza3.zzb());
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    zzfx.zzc.zza zza4 = zza3.zza(string3);
                    zza2.zza(i, zza4);
                }
                if (var8_13.zze() && var8_13.zzc()) {
                    arrayMap.put(string2, true);
                }
                if (var8_13.zzf() && var8_13.zzd()) {
                    arrayMap2.put(var8_13.zzb(), true);
                }
                if (!var8_13.zzg()) continue;
                if (var8_13.zza() < 2 || var8_13.zza() > 65535) {
                    this.zzj().zzu().zza("Invalid sampling rate. Event name, sample rate", (Object)var8_13.zzb(), (Object)var8_13.zza());
                    continue;
                }
                arrayMap3.put(var8_13.zzb(), var8_13.zza());
            }
        }
        this.zzd.put(string, hashSet);
        this.zze.put(string, (Map<String, Boolean>)arrayMap);
        this.zzf.put(string, (Map<String, Boolean>)arrayMap2);
        this.zzi.put(string, (Map<String, Integer>)arrayMap3);
    }

    @WorkerThread
    private final void zzv(String string) {
        this.zzal();
        this.zzt();
        Preconditions.checkNotEmpty((String)string);
        if (this.zzh.get(string) == null) {
            zzao zzao2 = ((zzno)this).zzh().zzf(string);
            if (zzao2 == null) {
                this.zzc.put(string, null);
                this.zze.put(string, null);
                this.zzd.put(string, null);
                this.zzf.put(string, null);
                this.zzh.put(string, null);
                this.zzj.put(string, null);
                this.zzk.put(string, null);
                this.zzl.put(string, null);
                this.zzi.put(string, null);
                return;
            }
            byte[] byArray = zzao2.zza;
            zzfx.zzd.zza zza2 = (zzfx.zzd.zza)this.zza(string, byArray).zzcd();
            this.zza(string, zza2);
            this.zzc.put(string, zzhg.zza((zzfx.zzd)((zzlc)zza2.zzai())));
            this.zzh.put(string, (zzfx.zzd)((zzlc)zza2.zzai()));
            this.zza(string, (zzfx.zzd)((zzlc)zza2.zzai()));
            this.zzj.put(string, zza2.zzc());
            this.zzk.put(string, zzao2.zzb);
            this.zzl.put(string, zzao2.zzc);
        }
    }

    @WorkerThread
    private final void zza(String string, zzfx.zzd zzd2) {
        if (zzd2.zza() == 0) {
            this.zza.remove((Object)string);
            return;
        }
        this.zzj().zzp().zza("EES programs found", (Object)zzd2.zza());
        zzhg.zzc zzc2 = zzd2.zzm().get(0);
        try {
            zzb zzb2 = new zzb();
            String string2 = string;
            zzhg zzhg2 = this;
            zzb2.zza("internal.remoteConfig", new zzhh(zzhg2, string2));
            string2 = string;
            zzhg2 = this;
            zzb2.zza("internal.appMetadata", new zzhk(zzhg2, string2));
            zzhg2 = this;
            zzb2.zza("internal.logger", new zzhj(zzhg2));
            zzb2.zza(zzc2);
            this.zza.put((Object)string, (Object)zzb2);
            this.zzj().zzp().zza("EES program loaded for appId, activities", (Object)string, (Object)zzc2.zza().zza());
            for (zzhg.zzb zzb3 : zzc2.zza().zzd()) {
                this.zzj().zzp().zza("EES program activity", (Object)zzb3.zzb());
            }
            return;
        }
        catch (zzc zzc3) {
            this.zzj().zzg().zza("Failed to load EES program. appId", (Object)string);
            return;
        }
    }

    @WorkerThread
    final void zzj(String string) {
        this.zzt();
        this.zzh.remove(string);
    }

    @WorkerThread
    final boolean zzk(String string) {
        this.zzt();
        zzfx.zzd zzd2 = this.zzc(string);
        if (zzd2 == null) {
            return false;
        }
        return zzd2.zzo();
    }

    public final boolean zzl(@Nullable String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        zzfx.zzd zzd2 = this.zzh.get(string);
        if (zzd2 == null) {
            return false;
        }
        return zzd2.zza() != 0;
    }

    final boolean zzm(String string) {
        return "1".equals(this.zza(string, "measurement.upload.blacklist_internal"));
    }

    @WorkerThread
    final boolean zzc(String string, zzjc.zza zza2) {
        this.zzt();
        this.zzv(string);
        zzfx.zza zza3 = this.zzb(string);
        if (zza3 == null) {
            return false;
        }
        for (zzfx.zza.zzb zzb2 : zza3.zzd()) {
            if (zza2 != zzhg.zza(zzb2.zzc())) continue;
            return zzb2.zzb() == zzfx.zza.zzd.zzb;
        }
        return false;
    }

    @WorkerThread
    final boolean zzn(String string) {
        this.zzt();
        this.zzv(string);
        zzfx.zza zza2 = this.zzb(string);
        if (zza2 == null) {
            return true;
        }
        return !zza2.zzh() || zza2.zzg();
    }

    @WorkerThread
    final boolean zzc(String string, String string2) {
        this.zzt();
        this.zzv(string);
        if ("ecommerce_purchase".equals(string2)) {
            return true;
        }
        if ("purchase".equals(string2) || "refund".equals(string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zzf.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @WorkerThread
    final boolean zzd(String string, String string2) {
        this.zzt();
        this.zzv(string);
        if (this.zzm(string) && zzop.zzg((String)string2)) {
            return true;
        }
        if (this.zzo(string) && zzop.zzh((String)string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zze.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @Override
    protected final boolean zzc() {
        return false;
    }

    final boolean zzo(String string) {
        return "1".equals(this.zza(string, "measurement.upload.blacklist_public"));
    }

    @WorkerThread
    protected final boolean zza(String string, byte @Nullable [] byArray, @Nullable String string2, @Nullable String string3) {
        this.zzal();
        this.zzt();
        Preconditions.checkNotEmpty((String)string);
        zzfx.zzd.zza zza2 = (zzfx.zzd.zza)this.zza(string, byArray).zzcd();
        if (zza2 == null) {
            return false;
        }
        this.zza(string, zza2);
        this.zza(string, (zzfx.zzd)((zzlc)zza2.zzai()));
        this.zzh.put(string, (zzfx.zzd)((zzlc)zza2.zzai()));
        this.zzj.put(string, zza2.zzc());
        this.zzk.put(string, string2);
        this.zzl.put(string, string3);
        this.zzc.put(string, zzhg.zza((zzfx.zzd)((zzlc)zza2.zzai())));
        ((zzno)this).zzh().zza(string, new ArrayList<zzfn.zza>(zza2.zzd()));
        try {
            zza2.zzb();
            byArray = ((zzfx.zzd)((zzlc)zza2.zzai())).zzca();
        }
        catch (RuntimeException runtimeException) {
            this.zzj().zzu().zza("Unable to serialize reduced-size config. Storing full config instead. appId", zzgi.zza((String)string), (Object)runtimeException);
        }
        String string4 = string3;
        String string5 = string2;
        byte[] byArray2 = byArray;
        String string6 = string;
        zzam zzam2 = ((zzno)this).zzh();
        Preconditions.checkNotEmpty((String)string6);
        zzam2.zzt();
        zzam2.zzal();
        ContentValues contentValues = new ContentValues();
        contentValues.put("remote_config", byArray2);
        contentValues.put("config_last_modified_time", string5);
        contentValues.put("e_tag", string4);
        try {
            if ((long)zzam2.e_().update("apps", contentValues, "app_id = ?", new String[]{string6}) == 0L) {
                zzam2.zzj().zzg().zza("Failed to update remote config (got 0). appId", zzgi.zza((String)string6));
            }
        }
        catch (SQLiteException sQLiteException) {
            zzam2.zzj().zzg().zza("Error storing remote config. appId", zzgi.zza((String)string6), (Object)sQLiteException);
        }
        this.zzh.put(string, (zzfx.zzd)((zzlc)zza2.zzai()));
        return true;
    }

    @WorkerThread
    final boolean zzp(String string) {
        this.zzt();
        this.zzv(string);
        return this.zzd.get(string) != null && this.zzd.get(string).contains("app_instance_id");
    }

    @WorkerThread
    final boolean zzq(String string) {
        this.zzt();
        this.zzv(string);
        return this.zzd.get(string) != null && (this.zzd.get(string).contains("device_model") || this.zzd.get(string).contains("device_info"));
    }

    @WorkerThread
    final boolean zzr(String string) {
        this.zzt();
        this.zzv(string);
        return this.zzd.get(string) != null && this.zzd.get(string).contains("enhanced_user_id");
    }

    @WorkerThread
    final boolean zzs(String string) {
        this.zzt();
        this.zzv(string);
        return this.zzd.get(string) != null && this.zzd.get(string).contains("google_signals");
    }

    @WorkerThread
    final boolean zzt(String string) {
        this.zzt();
        this.zzv(string);
        return this.zzd.get(string) != null && (this.zzd.get(string).contains("os_version") || this.zzd.get(string).contains("device_info"));
    }

    @WorkerThread
    final boolean zzu(String string) {
        this.zzt();
        this.zzv(string);
        return this.zzd.get(string) != null && this.zzd.get(string).contains("user_id");
    }
}

