/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.os.Binder;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.BinderThread;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.internal.measurement.zzad;
import com.google.android.gms.internal.measurement.zzb;
import com.google.android.gms.internal.measurement.zzc;
import com.google.android.gms.internal.measurement.zzgn;
import com.google.android.gms.internal.measurement.zzlc;
import com.google.android.gms.internal.measurement.zzpi;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzba;
import com.google.android.gms.measurement.internal.zzbh;
import com.google.android.gms.measurement.internal.zzbj;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzhg;
import com.google.android.gms.measurement.internal.zzhz;
import com.google.android.gms.measurement.internal.zzib;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzid;
import com.google.android.gms.measurement.internal.zzie;
import com.google.android.gms.measurement.internal.zzif;
import com.google.android.gms.measurement.internal.zzig;
import com.google.android.gms.measurement.internal.zzih;
import com.google.android.gms.measurement.internal.zzii;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zzik;
import com.google.android.gms.measurement.internal.zzil;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzin;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzip;
import com.google.android.gms.measurement.internal.zziq;
import com.google.android.gms.measurement.internal.zzir;
import com.google.android.gms.measurement.internal.zzis;
import com.google.android.gms.measurement.internal.zzit;
import com.google.android.gms.measurement.internal.zziu;
import com.google.android.gms.measurement.internal.zziv;
import com.google.android.gms.measurement.internal.zziw;
import com.google.android.gms.measurement.internal.zzjf;
import com.google.android.gms.measurement.internal.zznk;
import com.google.android.gms.measurement.internal.zznr;
import com.google.android.gms.measurement.internal.zznv;
import com.google.android.gms.measurement.internal.zzok;
import com.google.android.gms.measurement.internal.zzol;
import com.google.android.gms.measurement.internal.zzom;
import com.google.android.gms.measurement.internal.zzop;
import com.google.android.gms.measurement.internal.zzp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzia
extends zzga {
    private final zznv zza;
    private Boolean zzb;
    private @Nullable String zzc;

    @BinderThread
    public final zzak zza(zzp zzp2) {
        this.zzb(zzp2, false);
        Preconditions.checkNotEmpty((String)zzp2.zza);
        Future future = this.zza.zzl().zzb((Callable)new zzip(this, zzp2));
        try {
            return (zzak)future.get(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            this.zza.zzj().zzg().zza("Failed to get consent. appId", zzgi.zza((String)zzp2.zza), (Object)exception);
            return new zzak(null);
        }
    }

    @VisibleForTesting
    final zzbh zzb(zzbh zzbh2, zzp zzp2) {
        String string;
        zzbh zzbh3 = zzbh2;
        if (!"_cmp".equals(zzbh3.zza) || zzbh3.zzb == null || zzbh3.zzb.zza() == 0 ? false : "referrer broadcast".equals(string = zzbh3.zzb.zzd("_cis")) || "referrer API".equals(string)) {
            this.zza.zzj().zzn().zza("Event has been filtered ", (Object)zzbh2.toString());
            return new zzbh("_cmpx", zzbh2.zzb, zzbh2.zzc, zzbh2.zzd);
        }
        return zzbh2;
    }

    static /* bridge */ /* synthetic */ zznv zza(zzia zzia2) {
        return zzia2.zza;
    }

    @BinderThread
    public final @Nullable String zzb(zzp zzp2) {
        this.zzb(zzp2, false);
        return this.zza.zzb(zzp2);
    }

    @BinderThread
    public final List<zznk> zza(zzp zzp2, Bundle bundle) {
        this.zzb(zzp2, false);
        Preconditions.checkNotNull((Object)zzp2.zza);
        Future future = this.zza.zzl().zza((Callable)new zziw(this, zzp2, bundle));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get trigger URIs. appId", zzgi.zza((String)zzp2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final @Nullable List<zzok> zza(zzp zzp2, boolean bl) {
        this.zzb(zzp2, false);
        String string = zzp2.zza;
        Preconditions.checkNotNull((Object)string);
        Future future = this.zza.zzl().zza((Callable)new zziv(this, string));
        try {
            List list = (List)future.get();
            ArrayList<zzok> arrayList = new ArrayList<zzok>(list.size());
            for (zzom zzom2 : list) {
                if (!bl && zzop.zzg((String)zzom2.zzc)) continue;
                arrayList.add(new zzok(zzom2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get user properties. appId", zzgi.zza((String)zzp2.zza), (Object)exception);
            return null;
        }
    }

    @BinderThread
    public final List<zzaf> zza(@Nullable String string, @Nullable String string2, zzp zzp2) {
        this.zzb(zzp2, false);
        String string3 = zzp2.zza;
        Preconditions.checkNotNull((Object)string3);
        Future future = this.zza.zzl().zza((Callable)new zzil(this, string3, string, string2));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get conditional user properties", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzaf> zza(String string, @Nullable String string2, @Nullable String string3) {
        this.zza(string, true);
        Future future = this.zza.zzl().zza((Callable)new zzio(this, string, string2, string3));
        try {
            return (List)future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get conditional user properties as", (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzok> zza(@Nullable String string, @Nullable String string2, boolean bl, zzp zzp2) {
        this.zzb(zzp2, false);
        String string3 = zzp2.zza;
        Preconditions.checkNotNull((Object)string3);
        Future future = this.zza.zzl().zza((Callable)new zzij(this, string3, string, string2));
        try {
            List list = (List)future.get();
            ArrayList<zzok> arrayList = new ArrayList<zzok>(list.size());
            for (zzom zzom2 : list) {
                if (!bl && zzop.zzg((String)zzom2.zzc)) continue;
                arrayList.add(new zzok(zzom2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to query user properties. appId", zzgi.zza((String)zzp2.zza), (Object)exception);
            return Collections.emptyList();
        }
    }

    @BinderThread
    public final List<zzok> zza(String string, @Nullable String string2, @Nullable String string3, boolean bl) {
        this.zza(string, true);
        Future future = this.zza.zzl().zza((Callable)new zzim(this, string, string2, string3));
        try {
            List list = (List)future.get();
            ArrayList<zzok> arrayList = new ArrayList<zzok>(list.size());
            for (zzom zzom2 : list) {
                if (!bl && zzop.zzg((String)zzom2.zzc)) continue;
                arrayList.add(new zzok(zzom2));
            }
            return arrayList;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to get user properties as. appId", zzgi.zza((String)string), (Object)exception);
            return Collections.emptyList();
        }
    }

    public zzia(zznv zznv2) {
        this(zznv2, null);
    }

    private zzia(zznv zznv2, @Nullable String string) {
        Preconditions.checkNotNull((Object)zznv2);
        this.zza = zznv2;
        this.zzc = null;
    }

    @BinderThread
    public final void zzc(zzp zzp2) {
        this.zzb(zzp2, false);
        this.zzb(new zzif(this, zzp2));
    }

    @BinderThread
    public final void zzd(zzp zzp2) {
        this.zzb(zzp2, false);
        this.zzb(new zzig(this, zzp2));
    }

    @BinderThread
    private final void zzb(zzp zzp2, boolean bl) {
        Preconditions.checkNotNull((Object)zzp2);
        Preconditions.checkNotEmpty((String)zzp2.zza);
        this.zza(zzp2.zza, false);
        this.zza.zzq().zza(zzp2.zzb, zzp2.zzp);
    }

    @BinderThread
    private final void zza(String string, boolean bl) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.zza.zzj().zzg().zza("Measurement Service called without app package");
            throw new SecurityException("Measurement Service called without app package");
        }
        try {
            block10: {
                zzia zzia2;
                String string2;
                block9: {
                    boolean bl2 = bl;
                    string2 = string;
                    zzia2 = this;
                    if (!bl2) break block9;
                    if (zzia2.zzb == null) {
                        zzia2.zzb = "com.google.android.gms".equals(zzia2.zzc) || UidVerifier.isGooglePlayServicesUid((Context)zzia2.zza.zza(), (int)Binder.getCallingUid()) || GoogleSignatureVerifier.getInstance((Context)zzia2.zza.zza()).isUidGoogleSigned(Binder.getCallingUid());
                    }
                    if (zzia2.zzb.booleanValue()) break block10;
                }
                if (zzia2.zzc == null && GooglePlayServicesUtilLight.uidHasPackageName((Context)zzia2.zza.zza(), (int)Binder.getCallingUid(), (String)string2)) {
                    zzia2.zzc = string2;
                }
                if (!string2.equals(zzia2.zzc)) {
                    throw new SecurityException(String.format("Unknown calling package name '%s'.", string2));
                }
            }
            return;
        }
        catch (SecurityException securityException) {
            this.zza.zzj().zzg().zza("Measurement Service called with invalid calling package. appId", zzgi.zza((String)string));
            throw securityException;
        }
    }

    final void zzc(zzbh zzbh2, zzp zzp2) {
        if (!this.zza.zzi().zzl(zzp2.zza)) {
            this.zzd(zzbh2, zzp2);
            return;
        }
        this.zza.zzj().zzp().zza("EES config found for", (Object)zzp2.zza);
        String string = zzp2.zza;
        zznr zznr2 = this.zza.zzi();
        zzb zzb2 = TextUtils.isEmpty((CharSequence)string) ? null : (zzb)((zzhg)zznr2).zza.get((Object)string);
        if (zzb2 == null) {
            this.zza.zzj().zzp().zza("EES not loaded for", (Object)zzp2.zza);
            this.zzd(zzbh2, zzp2);
            return;
        }
        boolean bl = false;
        try {
            string = zzbh2;
            zznr2 = this.zza.zzp();
            Bundle bundle = ((zzbh)string).zzb.zzb();
            Map<String, Object> map = ((zzol)zznr2).zza(bundle, true);
            String string2 = zzjf.zza((String)((zzbh)string).zza);
            if (string2 == null) {
                string2 = ((zzbh)string).zza;
            }
            bl = zzb2.zza(new zzad(string2, ((zzbh)string).zzd, map));
        }
        catch (zzc zzc2) {
            this.zza.zzj().zzg().zza("EES error. appId, eventName", (Object)zzp2.zzb, (Object)zzbh2.zza);
        }
        if (!bl) {
            this.zza.zzj().zzp().zza("EES was not applied to event", (Object)zzbh2.zza);
            this.zzd(zzbh2, zzp2);
            return;
        }
        if (zzb2.zzd()) {
            this.zza.zzj().zzp().zza("EES edited event", (Object)zzbh2.zza);
            this.zzd(this.zza.zzp().zza(zzb2.zza().zzb()), zzp2);
        } else {
            this.zzd(zzbh2, zzp2);
        }
        if (zzb2.zzc()) {
            for (zzad zzad2 : zzb2.zza().zzc()) {
                this.zza.zzj().zzp().zza("EES logging created event", (Object)zzad2.zzb());
                this.zzd(this.zza.zzp().zza(zzad2), zzp2);
            }
        }
    }

    final /* synthetic */ void zza(Bundle bundle, String string) {
        boolean bl = this.zza.zze().zza(zzbj.zzdi);
        boolean bl2 = this.zza.zze().zza(zzbj.zzdk);
        if (bundle.isEmpty() && bl && bl2) {
            this.zza.zzf().zzp(string);
            return;
        }
        this.zza.zzf().zza(string, bundle);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final /* synthetic */ void zzb(Bundle bundle, String string) {
        if (bundle.isEmpty()) {
            this.zza.zzf().zzp(string);
            return;
        }
        this.zza.zzf().zza(string, bundle);
        Bundle bundle2 = bundle;
        String string2 = string;
        zzam zzam2 = this.zza.zzf();
        Preconditions.checkNotNull((Object)bundle2);
        zzam2.zzt();
        zzam2.zzal();
        long l = -1L;
        block8: while (true) {
            ArrayList<zzaq> arrayList;
            block21: {
                Cursor cursor;
                block20: {
                    arrayList = new ArrayList<zzaq>();
                    String string3 = "app_id = ? and rowid > ?";
                    String[] stringArray = new String[]{string2, String.valueOf(l)};
                    cursor = null;
                    try {
                        cursor = zzam2.e_().query("raw_events", new String[]{"rowid", "name", "timestamp", "metadata_fingerprint", "data", "realtime"}, string3, stringArray, null, null, "rowid", "1000");
                        if (!cursor.moveToFirst()) {
                            if (cursor == null) break;
                            break block20;
                        }
                        do {
                            zzgn.zzf.zza zza2;
                            long l2 = cursor.getLong(0);
                            long l3 = cursor.getLong(3);
                            boolean bl = cursor.getLong(5) == 1L;
                            byte[] byArray = cursor.getBlob(4);
                            try {
                                zza2 = zzol.zza(zzgn.zzf.zze(), byArray);
                            }
                            catch (IOException iOException) {
                                zzam2.zzj().zzg().zza("Data loss. Failed to merge raw event. appId", zzgi.zza((String)string2), (Object)iOException);
                                continue;
                            }
                            String string4 = cursor.getString(1);
                            zza2.zza(string4 != null ? string4 : "").zzb(cursor.getLong(2));
                            zzgn.zzf zzf2 = (zzgn.zzf)((zzlc)zza2.zzai());
                            zzol zzol2 = zzam2.g_();
                            Bundle bundle3 = new Bundle();
                            for (zzgn.zzh zzh2 : zzf2.zzh()) {
                                if (zzh2.zzj()) {
                                    bundle3.putDouble(zzh2.zzg(), zzh2.zza());
                                    continue;
                                }
                                if (zzh2.zzk()) {
                                    bundle3.putFloat(zzh2.zzg(), zzh2.zzb());
                                    continue;
                                }
                                if (zzh2.zzl()) {
                                    bundle3.putLong(zzh2.zzg(), zzh2.zzd());
                                    continue;
                                }
                                if (zzh2.zzn()) {
                                    bundle3.putString(zzh2.zzg(), zzh2.zzh());
                                    continue;
                                }
                                if (!zzh2.zzi().isEmpty()) {
                                    bundle3.putParcelableArray(zzh2.zzg(), (Parcelable[])zzol.zzb(zzh2.zzi()));
                                    continue;
                                }
                                zzol2.zzj().zzg().zza("Unexpected parameter type for parameter", (Object)zzh2);
                            }
                            String string5 = bundle3.getString("_o");
                            bundle3.remove("_o");
                            zzgm zzgm2 = new zzgm(zzf2.zzg(), (String)(string5 == null ? "" : string5), bundle3, zzf2.zzd());
                            zzam2.zzq().zza(zzgm2.zzd, bundle2);
                            zzam2.zzq().zza(zzgm2, zzam2.zze().zzb(string2));
                            arrayList.add(new zzaq(l2, l3, bl, zza2.zzb(), zzgm2));
                        } while (cursor.moveToNext());
                        break block21;
                    }
                    catch (SQLiteException sQLiteException) {
                        zzam2.zzj().zzg().zza("Data loss. Error querying raw events. appId", zzgi.zza((String)string2), (Object)sQLiteException);
                        break block21;
                    }
                }
                cursor.close();
                return;
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
            ArrayList<zzaq> arrayList2 = arrayList;
            int n = arrayList2.size();
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block8;
                Object e = arrayList2.get(n2);
                ++n2;
                zzaq zzaq2 = (zzaq)e;
                zzba zzba2 = new zzba(zzam2.zzu, zzaq2.zze.zzb, string2, zzaq2.zze.zza, zzaq2.zze.zzc, zzaq2.zzd, zzaq2.zze.zzd);
                zzam2.zza(zzaq2.zza, zzba2, zzaq2.zzb, zzaq2.zzc);
                if (zzaq2.zza <= l) continue;
                l = zzaq2.zza;
            }
            break;
        }
    }

    final /* synthetic */ void zzj(zzp zzp2) {
        this.zza.zzr();
        this.zza.zzf(zzp2);
    }

    final /* synthetic */ void zzk(zzp zzp2) {
        this.zza.zzr();
        this.zza.zzg(zzp2);
    }

    @BinderThread
    public final void zza(zzbh zzbh2, zzp zzp2) {
        Preconditions.checkNotNull((Object)zzbh2);
        this.zzb(zzp2, false);
        this.zzb(new zzis(this, zzbh2, zzp2));
    }

    @BinderThread
    public final void zza(zzbh zzbh2, String string, @Nullable String string2) {
        Preconditions.checkNotNull((Object)zzbh2);
        Preconditions.checkNotEmpty((String)string);
        this.zza(string, true);
        this.zzb(new zzir(this, zzbh2, string));
    }

    private final void zzd(zzbh zzbh2, zzp zzp2) {
        this.zza.zzr();
        this.zza.zza(zzbh2, zzp2);
    }

    @BinderThread
    public final void zze(zzp zzp2) {
        Preconditions.checkNotEmpty((String)zzp2.zza);
        this.zza(zzp2.zza, false);
        this.zzb(new zzin(this, zzp2));
    }

    @VisibleForTesting
    private final void zza(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzl().zzg()) {
            runnable.run();
            return;
        }
        this.zza.zzl().zzc(runnable);
    }

    @VisibleForTesting
    private final void zzb(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable);
        if (this.zza.zzl().zzg()) {
            runnable.run();
            return;
        }
        this.zza.zzl().zzb(runnable);
    }

    @BinderThread
    public final void zza(zzaf zzaf2, zzp zzp2) {
        Preconditions.checkNotNull((Object)zzaf2);
        Preconditions.checkNotNull((Object)zzaf2.zzc);
        this.zzb(zzp2, false);
        zzaf zzaf3 = new zzaf(zzaf2);
        new zzaf(zzaf2).zza = zzp2.zza;
        this.zzb(new zzih(this, zzaf3, zzp2));
    }

    @BinderThread
    public final void zza(zzaf zzaf2) {
        Preconditions.checkNotNull((Object)zzaf2);
        Preconditions.checkNotNull((Object)zzaf2.zzc);
        Preconditions.checkNotEmpty((String)zzaf2.zza);
        this.zza(zzaf2.zza, true);
        zzaf zzaf3 = new zzaf(zzaf2);
        this.zzb(new zzik(this, zzaf3));
    }

    @BinderThread
    public final void zzf(zzp zzp2) {
        Preconditions.checkNotEmpty((String)zzp2.zza);
        Preconditions.checkNotNull((Object)zzp2.zzt);
        this.zza(new zziq(this, zzp2));
    }

    @BinderThread
    public final void zza(long l, @Nullable String string, @Nullable String string2, String string3) {
        this.zzb(new zzii(this, string2, string3, string, l));
    }

    @BinderThread
    public final void zza(Bundle bundle, zzp zzp2) {
        this.zzb(zzp2, false);
        String string = zzp2.zza;
        Preconditions.checkNotNull((Object)string);
        String string2 = string;
        Bundle bundle2 = bundle;
        zzia zzia2 = this;
        this.zzb(new zzie(zzia2, bundle2, string2));
    }

    @BinderThread
    public final void zzb(Bundle bundle, zzp zzp2) {
        if (zzpi.zza() && this.zza.zze().zza(zzbj.zzdk)) {
            this.zzb(zzp2, false);
            String string = zzp2.zza;
            Preconditions.checkNotNull((Object)string);
            String string2 = string;
            Bundle bundle2 = bundle;
            zzia zzia2 = this;
            this.zzb(new zzic(zzia2, bundle2, string2));
        }
    }

    @BinderThread
    public final void zzg(zzp zzp2) {
        Preconditions.checkNotEmpty((String)zzp2.zza);
        Preconditions.checkNotNull((Object)zzp2.zzt);
        zzp zzp3 = zzp2;
        zzia zzia2 = this;
        this.zza(new zzib(zzia2, zzp3));
    }

    @BinderThread
    public final void zzh(zzp zzp2) {
        this.zzb(zzp2, false);
        this.zzb(new zzid(this, zzp2));
    }

    @BinderThread
    public final void zzi(zzp zzp2) {
        Preconditions.checkNotEmpty((String)zzp2.zza);
        Preconditions.checkNotNull((Object)zzp2.zzt);
        zzp zzp3 = zzp2;
        zzia zzia2 = this;
        this.zza(new zzhz(zzia2, zzp3));
    }

    @BinderThread
    public final void zza(zzok zzok2, zzp zzp2) {
        Preconditions.checkNotNull((Object)zzok2);
        this.zzb(zzp2, false);
        this.zzb(new zzit(this, zzok2, zzp2));
    }

    @BinderThread
    public final byte @Nullable [] zza(zzbh zzbh2, String string) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzbh2);
        this.zza(string, true);
        this.zza.zzj().zzc().zza("Log and bundle. event", (Object)this.zza.zzg().zza(zzbh2.zza));
        long l = this.zza.zzb().nanoTime() / 1000000L;
        Future future = this.zza.zzl().zzb((Callable)new zziu(this, zzbh2, string));
        try {
            byte[] byArray = (byte[])future.get();
            if (byArray == null) {
                this.zza.zzj().zzg().zza("Log and bundle returned null. appId", zzgi.zza((String)string));
                byArray = new byte[]{};
            }
            long l2 = this.zza.zzb().nanoTime() / 1000000L;
            this.zza.zzj().zzc().zza("Log and bundle processed. event, size, time_ms", (Object)this.zza.zzg().zza(zzbh2.zza), (Object)byArray.length, (Object)(l2 - l));
            return byArray;
        }
        catch (InterruptedException | ExecutionException exception) {
            this.zza.zzj().zzg().zza("Failed to log and bundle. appId, event, error", zzgi.zza((String)string), (Object)this.zza.zzg().zza(zzbh2.zza), (Object)exception);
            return null;
        }
    }
}

