/*
 * Decompiled with CFR 0.152.
 */
package com.google.mlkit.vision.barcode;

import android.graphics.Point;
import android.graphics.Rect;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.mlkit.vision.barcode.internal.zzk;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.List;

public class Barcode {
    public static final int FORMAT_UNKNOWN = -1;
    public static final int FORMAT_ALL_FORMATS = 0;
    public static final int FORMAT_CODE_128 = 1;
    public static final int FORMAT_CODE_39 = 2;
    public static final int FORMAT_CODE_93 = 4;
    public static final int FORMAT_CODABAR = 8;
    public static final int FORMAT_DATA_MATRIX = 16;
    public static final int FORMAT_EAN_13 = 32;
    public static final int FORMAT_EAN_8 = 64;
    public static final int FORMAT_ITF = 128;
    public static final int FORMAT_QR_CODE = 256;
    public static final int FORMAT_UPC_A = 512;
    public static final int FORMAT_UPC_E = 1024;
    public static final int FORMAT_PDF417 = 2048;
    public static final int FORMAT_AZTEC = 4096;
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_CONTACT_INFO = 1;
    public static final int TYPE_EMAIL = 2;
    public static final int TYPE_ISBN = 3;
    public static final int TYPE_PHONE = 4;
    public static final int TYPE_PRODUCT = 5;
    public static final int TYPE_SMS = 6;
    public static final int TYPE_TEXT = 7;
    public static final int TYPE_URL = 8;
    public static final int TYPE_WIFI = 9;
    public static final int TYPE_GEO = 10;
    public static final int TYPE_CALENDAR_EVENT = 11;
    public static final int TYPE_DRIVER_LICENSE = 12;
    private final zzk zza;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @BarcodeFormat
    public int getFormat() {
        int n = this.zza.zza();
        if (n > 4096) return -1;
        if (n != 0) return n;
        return -1;
    }

    @BarcodeValueType
    public int getValueType() {
        return this.zza.zzb();
    }

    @RecentlyNullable
    public Rect getBoundingBox() {
        return this.zza.zzc();
    }

    @RecentlyNullable
    public CalendarEvent getCalendarEvent() {
        return this.zza.zzd();
    }

    @RecentlyNullable
    public ContactInfo getContactInfo() {
        return this.zza.zze();
    }

    @RecentlyNullable
    public DriverLicense getDriverLicense() {
        return this.zza.zzf();
    }

    @RecentlyNullable
    public Email getEmail() {
        return this.zza.zzg();
    }

    @RecentlyNullable
    public GeoPoint getGeoPoint() {
        return this.zza.zzh();
    }

    @RecentlyNullable
    public Phone getPhone() {
        return this.zza.zzi();
    }

    @RecentlyNullable
    public Sms getSms() {
        return this.zza.zzj();
    }

    @RecentlyNullable
    public UrlBookmark getUrl() {
        return this.zza.zzk();
    }

    @RecentlyNullable
    public WiFi getWifi() {
        return this.zza.zzl();
    }

    @RecentlyNullable
    public String getDisplayValue() {
        return this.zza.zzm();
    }

    @RecentlyNullable
    public String getRawValue() {
        return this.zza.zzn();
    }

    @RecentlyNullable
    public byte[] getRawBytes() {
        Object this_ = ((Barcode)this_).zza.zzo();
        if (this_ != null) {
            return Arrays.copyOf((byte[])this_, ((Object)this_).length);
        }
        return null;
    }

    @RecentlyNullable
    public Point[] getCornerPoints() {
        return this.zza.zzp();
    }

    public Barcode(@NonNull zzk zzk2) {
        this.zza = (zzk)Preconditions.checkNotNull((Object)zzk2);
    }

    public static class WiFi {
        public static final int TYPE_OPEN = 1;
        public static final int TYPE_WPA = 2;
        public static final int TYPE_WEP = 3;
        @Nullable
        private final String zza;
        @Nullable
        private final String zzb;
        private final int zzc;

        @EncryptionType
        public int getEncryptionType() {
            return this.zzc;
        }

        @RecentlyNullable
        public String getPassword() {
            return this.zzb;
        }

        @RecentlyNullable
        public String getSsid() {
            return this.zza;
        }

        public WiFi(@Nullable String string, @Nullable String string2, int n) {
            this.zza = string;
            this.zzb = string2;
            this.zzc = n;
        }

        @Retention(value=RetentionPolicy.CLASS)
        public static @interface EncryptionType {
        }
    }

    public static class UrlBookmark {
        @Nullable
        private final String zza;
        @Nullable
        private final String zzb;

        @RecentlyNullable
        public String getTitle() {
            return this.zza;
        }

        @RecentlyNullable
        public String getUrl() {
            return this.zzb;
        }

        public UrlBookmark(@Nullable String string, @Nullable String string2) {
            this.zza = string;
            this.zzb = string2;
        }
    }

    public static class Sms {
        @Nullable
        private final String zza;
        @Nullable
        private final String zzb;

        @RecentlyNullable
        public String getMessage() {
            return this.zza;
        }

        @RecentlyNullable
        public String getPhoneNumber() {
            return this.zzb;
        }

        public Sms(@Nullable String string, @Nullable String string2) {
            this.zza = string;
            this.zzb = string2;
        }
    }

    public static class GeoPoint {
        private final double zza;
        private final double zzb;

        public double getLat() {
            return this.zza;
        }

        public double getLng() {
            return this.zzb;
        }

        public GeoPoint(double d, double d2) {
            this.zza = d;
            this.zzb = d2;
        }
    }

    public static class ContactInfo {
        @Nullable
        private final PersonName zza;
        @Nullable
        private final String zzb;
        @Nullable
        private final String zzc;
        private final List<Phone> zzd;
        private final List<Email> zze;
        private final List<String> zzf;
        private final List<Address> zzg;

        @RecentlyNullable
        public PersonName getName() {
            return this.zza;
        }

        @RecentlyNullable
        public String getOrganization() {
            return this.zzb;
        }

        @RecentlyNullable
        public String getTitle() {
            return this.zzc;
        }

        @NonNull
        public List<Address> getAddresses() {
            return this.zzg;
        }

        @NonNull
        public List<Email> getEmails() {
            return this.zze;
        }

        @NonNull
        public List<Phone> getPhones() {
            return this.zzd;
        }

        @NonNull
        public List<String> getUrls() {
            return this.zzf;
        }

        public ContactInfo(@Nullable PersonName personName, @Nullable String string, @Nullable String string2, @RecentlyNonNull List<Phone> list, @RecentlyNonNull List<Email> list2, @RecentlyNonNull List<String> list3, @RecentlyNonNull List<Address> list4) {
            this.zza = personName;
            this.zzb = string;
            this.zzc = string2;
            this.zzd = list;
            this.zze = list2;
            this.zzf = list3;
            this.zzg = list4;
        }
    }

    public static class Email {
        public static final int TYPE_UNKNOWN = 0;
        public static final int TYPE_WORK = 1;
        public static final int TYPE_HOME = 2;
        private final int zza;
        @Nullable
        private final String zzb;
        @Nullable
        private final String zzc;
        @Nullable
        private final String zzd;

        @FormatType
        public int getType() {
            return this.zza;
        }

        @RecentlyNullable
        public String getAddress() {
            return this.zzb;
        }

        @RecentlyNullable
        public String getBody() {
            return this.zzd;
        }

        @RecentlyNullable
        public String getSubject() {
            return this.zzc;
        }

        public Email(int n, @Nullable String string, @Nullable String string2, @Nullable String string3) {
            this.zza = n;
            this.zzb = string;
            this.zzc = string2;
            this.zzd = string3;
        }

        @Retention(value=RetentionPolicy.CLASS)
        public static @interface FormatType {
        }
    }

    public static class Phone {
        public static final int TYPE_UNKNOWN = 0;
        public static final int TYPE_WORK = 1;
        public static final int TYPE_HOME = 2;
        public static final int TYPE_FAX = 3;
        public static final int TYPE_MOBILE = 4;
        @Nullable
        private final String zza;
        private final int zzb;

        @FormatType
        public int getType() {
            return this.zzb;
        }

        @RecentlyNullable
        public String getNumber() {
            return this.zza;
        }

        public Phone(@Nullable String string, int n) {
            this.zza = string;
            this.zzb = n;
        }

        @Retention(value=RetentionPolicy.CLASS)
        public static @interface FormatType {
        }
    }

    public static class PersonName {
        @Nullable
        private final String zza;
        @Nullable
        private final String zzb;
        @Nullable
        private final String zzc;
        @Nullable
        private final String zzd;
        @Nullable
        private final String zze;
        @Nullable
        private final String zzf;
        @Nullable
        private final String zzg;

        @RecentlyNullable
        public String getFirst() {
            return this.zzd;
        }

        @RecentlyNullable
        public String getFormattedName() {
            return this.zza;
        }

        @RecentlyNullable
        public String getLast() {
            return this.zzf;
        }

        @RecentlyNullable
        public String getMiddle() {
            return this.zze;
        }

        @RecentlyNullable
        public String getPrefix() {
            return this.zzc;
        }

        @RecentlyNullable
        public String getPronunciation() {
            return this.zzb;
        }

        @RecentlyNullable
        public String getSuffix() {
            return this.zzg;
        }

        public PersonName(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable String string7) {
            this.zza = string;
            this.zzb = string2;
            this.zzc = string3;
            this.zzd = string4;
            this.zze = string5;
            this.zzf = string6;
            this.zzg = string7;
        }
    }

    public static class DriverLicense {
        @Nullable
        private final String zza;
        @Nullable
        private final String zzb;
        @Nullable
        private final String zzc;
        @Nullable
        private final String zzd;
        @Nullable
        private final String zze;
        @Nullable
        private final String zzf;
        @Nullable
        private final String zzg;
        @Nullable
        private final String zzh;
        @Nullable
        private final String zzi;
        @Nullable
        private final String zzj;
        @Nullable
        private final String zzk;
        @Nullable
        private final String zzl;
        @Nullable
        private final String zzm;
        @Nullable
        private final String zzn;

        @RecentlyNullable
        public String getAddressCity() {
            return this.zzg;
        }

        @RecentlyNullable
        public String getAddressState() {
            return this.zzh;
        }

        @RecentlyNullable
        public String getAddressStreet() {
            return this.zzf;
        }

        @RecentlyNullable
        public String getAddressZip() {
            return this.zzi;
        }

        @RecentlyNullable
        public String getBirthDate() {
            return this.zzm;
        }

        @RecentlyNullable
        public String getDocumentType() {
            return this.zza;
        }

        @RecentlyNullable
        public String getExpiryDate() {
            return this.zzl;
        }

        @RecentlyNullable
        public String getFirstName() {
            return this.zzb;
        }

        @RecentlyNullable
        public String getGender() {
            return this.zze;
        }

        @RecentlyNullable
        public String getIssueDate() {
            return this.zzk;
        }

        @RecentlyNullable
        public String getIssuingCountry() {
            return this.zzn;
        }

        @RecentlyNullable
        public String getLastName() {
            return this.zzd;
        }

        @RecentlyNullable
        public String getLicenseNumber() {
            return this.zzj;
        }

        @RecentlyNullable
        public String getMiddleName() {
            return this.zzc;
        }

        public DriverLicense(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable String string7, @Nullable String string8, @Nullable String string9, @Nullable String string10, @Nullable String string11, @Nullable String string12, @Nullable String string13, @Nullable String string14) {
            this.zza = string;
            this.zzb = string2;
            this.zzc = string3;
            this.zzd = string4;
            this.zze = string5;
            this.zzf = string6;
            this.zzg = string7;
            this.zzh = string8;
            this.zzi = string9;
            this.zzj = string10;
            this.zzk = string11;
            this.zzl = string12;
            this.zzm = string13;
            this.zzn = string14;
        }
    }

    public static class CalendarEvent {
        @Nullable
        private final String zza;
        @Nullable
        private final String zzb;
        @Nullable
        private final String zzc;
        @Nullable
        private final String zzd;
        @Nullable
        private final String zze;
        @Nullable
        private final CalendarDateTime zzf;
        @Nullable
        private final CalendarDateTime zzg;

        @RecentlyNullable
        public CalendarDateTime getEnd() {
            return this.zzg;
        }

        @RecentlyNullable
        public CalendarDateTime getStart() {
            return this.zzf;
        }

        @RecentlyNullable
        public String getDescription() {
            return this.zzb;
        }

        @RecentlyNullable
        public String getLocation() {
            return this.zzc;
        }

        @RecentlyNullable
        public String getOrganizer() {
            return this.zzd;
        }

        @RecentlyNullable
        public String getStatus() {
            return this.zze;
        }

        @RecentlyNullable
        public String getSummary() {
            return this.zza;
        }

        public CalendarEvent(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable CalendarDateTime calendarDateTime, @Nullable CalendarDateTime calendarDateTime2) {
            this.zza = string;
            this.zzb = string2;
            this.zzc = string3;
            this.zzd = string4;
            this.zze = string5;
            this.zzf = calendarDateTime;
            this.zzg = calendarDateTime2;
        }
    }

    public static class CalendarDateTime {
        private final int zza;
        private final int zzb;
        private final int zzc;
        private final int zzd;
        private final int zze;
        private final int zzf;
        private final boolean zzg;
        @Nullable
        private final String zzh;

        public int getDay() {
            return this.zzc;
        }

        public int getHours() {
            return this.zzd;
        }

        public int getMinutes() {
            return this.zze;
        }

        public int getMonth() {
            return this.zzb;
        }

        public int getSeconds() {
            return this.zzf;
        }

        public int getYear() {
            return this.zza;
        }

        @RecentlyNullable
        public String getRawValue() {
            return this.zzh;
        }

        public CalendarDateTime(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, @Nullable String string) {
            this.zza = n;
            this.zzb = n2;
            this.zzc = n3;
            this.zzd = n4;
            this.zze = n5;
            this.zzf = n6;
            this.zzg = bl;
            this.zzh = string;
        }

        public boolean isUtc() {
            return this.zzg;
        }
    }

    public static class Address {
        public static final int TYPE_UNKNOWN = 0;
        public static final int TYPE_WORK = 1;
        public static final int TYPE_HOME = 2;
        private final int zza;
        private final String[] zzb;

        @AddressType
        public int getType() {
            return this.zza;
        }

        public Address(int n, @RecentlyNonNull String[] stringArray) {
            this.zza = n;
            this.zzb = stringArray;
        }

        @NonNull
        public String[] getAddressLines() {
            return this.zzb;
        }

        @Retention(value=RetentionPolicy.CLASS)
        public static @interface AddressType {
        }
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface BarcodeValueType {
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface BarcodeFormat {
    }
}

