/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzec;
import com.google.android.gms.internal.vision.zzen;
import com.google.android.gms.internal.vision.zzeo;
import com.google.android.gms.internal.vision.zzff;
import com.google.android.gms.internal.vision.zzfg;
import com.google.android.gms.internal.vision.zzga;
import com.google.android.gms.internal.vision.zzgm;
import com.google.android.gms.internal.vision.zzhf;
import com.google.android.gms.internal.vision.zzhw;
import com.google.android.gms.internal.vision.zziu;
import com.google.android.gms.internal.vision.zziw;
import com.google.android.gms.internal.vision.zzja;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class zzfe
extends zzen {
    private static final Logger logger = Logger.getLogger(zzfe.class.getName());
    private static final boolean zzsr = zziu.zzhh();
    zzfg zzss;

    public static zzfe zzg(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        return new zza(byArray2, 0, n);
    }

    public static zzfe zza(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            return new zzb(byteBuffer);
        }
        if (byteBuffer.isDirect() && !byteBuffer.isReadOnly()) {
            if (zziu.zzhi()) {
                ByteBuffer byteBuffer2 = byteBuffer;
                return new zze(byteBuffer2);
            }
            ByteBuffer byteBuffer3 = byteBuffer;
            return new zzd(byteBuffer3);
        }
        throw new IllegalArgumentException("ByteBuffer is read-only");
    }

    private zzfe() {
    }

    public abstract void zzd(int var1, int var2) throws IOException;

    public abstract void zze(int var1, int var2) throws IOException;

    public abstract void zzf(int var1, int var2) throws IOException;

    public final void zzg(int n, int n2) throws IOException {
        this.zzf(n, zzfe.zzbc(n2));
    }

    public abstract void zzh(int var1, int var2) throws IOException;

    public abstract void zza(int var1, long var2) throws IOException;

    public final void zzb(int n, long l) throws IOException {
        this.zza(n, zzfe.zzm(l));
    }

    public abstract void zzc(int var1, long var2) throws IOException;

    public final void zza(int n, float f) throws IOException {
        this.zzh(n, Float.floatToRawIntBits(f));
    }

    public final void zza(int n, double d) throws IOException {
        this.zzc(n, Double.doubleToRawLongBits(d));
    }

    public abstract void zzb(int var1, boolean var2) throws IOException;

    public abstract void zza(int var1, String var2) throws IOException;

    public abstract void zza(int var1, zzeo var2) throws IOException;

    public abstract void zza(int var1, zzhf var2) throws IOException;

    abstract void zza(int var1, zzhf var2, zzhw var3) throws IOException;

    public abstract void zzb(int var1, zzhf var2) throws IOException;

    public abstract void zzb(int var1, zzeo var2) throws IOException;

    public abstract void zzar(int var1) throws IOException;

    public abstract void zzas(int var1) throws IOException;

    public final void zzat(int n) throws IOException {
        this.zzas(zzfe.zzbc(n));
    }

    public abstract void zzau(int var1) throws IOException;

    public abstract void zze(long var1) throws IOException;

    public final void zzf(long l) throws IOException {
        this.zze(zzfe.zzm(l));
    }

    public abstract void zzg(long var1) throws IOException;

    public final void zzf(float f) throws IOException {
        this.zzau(Float.floatToRawIntBits(f));
    }

    public final void zza(double d) throws IOException {
        this.zzg(Double.doubleToRawLongBits(d));
    }

    public final void zzh(boolean bl) throws IOException {
        this.zzc((byte)(bl ? 1 : 0));
    }

    public abstract void zzm(String var1) throws IOException;

    public abstract void zza(zzeo var1) throws IOException;

    public abstract void zzb(zzhf var1) throws IOException;

    abstract void zza(zzhf var1, zzhw var2) throws IOException;

    public abstract void zzc(byte var1) throws IOException;

    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    public static int zzi(int n, int n2) {
        return zzfe.zzav(n) + zzfe.zzaw(n2);
    }

    public static int zzj(int n, int n2) {
        return zzfe.zzav(n) + zzfe.zzax(n2);
    }

    public static int zzk(int n, int n2) {
        return zzfe.zzav(n) + zzfe.zzax(zzfe.zzbc(n2));
    }

    public static int zzl(int n, int n2) {
        return zzfe.zzav(n) + 4;
    }

    public static int zzm(int n, int n2) {
        return zzfe.zzav(n) + 4;
    }

    public static int zzd(int n, long l) {
        return zzfe.zzav(n) + zzfe.zzi(l);
    }

    public static int zze(int n, long l) {
        return zzfe.zzav(n) + zzfe.zzi(l);
    }

    public static int zzf(int n, long l) {
        return zzfe.zzav(n) + zzfe.zzi(zzfe.zzm(l));
    }

    public static int zzg(int n, long l) {
        return zzfe.zzav(n) + 8;
    }

    public static int zzh(int n, long l) {
        return zzfe.zzav(n) + 8;
    }

    public static int zzb(int n, float f) {
        return zzfe.zzav(n) + 4;
    }

    public static int zzb(int n, double d) {
        return zzfe.zzav(n) + 8;
    }

    public static int zzc(int n, boolean bl) {
        return zzfe.zzav(n) + 1;
    }

    public static int zzn(int n, int n2) {
        return zzfe.zzav(n) + zzfe.zzaw(n2);
    }

    public static int zzb(int n, String string) {
        return zzfe.zzav(n) + zzfe.zzn(string);
    }

    public static int zzc(int n, zzeo zzeo2) {
        int n2 = zzeo2.size();
        return zzfe.zzav(n) + (zzfe.zzax(n2) + n2);
    }

    public static int zza(int n, zzgm zzgm2) {
        int n2 = zzgm2.zzeq();
        return zzfe.zzav(n) + (zzfe.zzax(n2) + n2);
    }

    public static int zzc(int n, zzhf zzhf2) {
        return zzfe.zzav(n) + zzfe.zzc(zzhf2);
    }

    static int zzb(int n, zzhf zzhf2, zzhw zzhw2) {
        return zzfe.zzav(n) + zzfe.zzb(zzhf2, zzhw2);
    }

    public static int zzd(int n, zzhf zzhf2) {
        return (zzfe.zzav(1) << 1) + zzfe.zzj(2, n) + zzfe.zzc(3, zzhf2);
    }

    public static int zzd(int n, zzeo zzeo2) {
        return (zzfe.zzav(1) << 1) + zzfe.zzj(2, n) + zzfe.zzc(3, zzeo2);
    }

    public static int zzb(int n, zzgm zzgm2) {
        return (zzfe.zzav(1) << 1) + zzfe.zzj(2, n) + zzfe.zza(3, zzgm2);
    }

    public static int zzav(int n) {
        return zzfe.zzax(n << 3);
    }

    public static int zzaw(int n) {
        if (n >= 0) {
            return zzfe.zzax(n);
        }
        return 10;
    }

    public static int zzax(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int zzay(int n) {
        return zzfe.zzax(zzfe.zzbc(n));
    }

    public static int zzaz(int n) {
        return 4;
    }

    public static int zzba(int n) {
        return 4;
    }

    public static int zzh(long l) {
        return zzfe.zzi(l);
    }

    public static int zzi(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (l < 0L) {
            return 10;
        }
        int n = 2;
        if ((l & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            l >>>= 28;
        }
        if ((l & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            l >>>= 14;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return n;
    }

    public static int zzj(long l) {
        return zzfe.zzi(zzfe.zzm(l));
    }

    public static int zzk(long l) {
        return 8;
    }

    public static int zzl(long l) {
        return 8;
    }

    public static int zzg(float f) {
        return 4;
    }

    public static int zzb(double d) {
        return 8;
    }

    public static int zzi(boolean bl) {
        return 1;
    }

    public static int zzbb(int n) {
        return zzfe.zzaw(n);
    }

    public static int zzn(String string) {
        int n;
        try {
            n = zziw.zza(string);
        }
        catch (zzja zzja2) {
            n = string.getBytes(zzga.UTF_8).length;
        }
        int n2 = n;
        return zzfe.zzax(n2) + n2;
    }

    public static int zza(zzgm zzgm2) {
        int n = zzgm2.zzeq();
        return zzfe.zzax(n) + n;
    }

    public static int zzb(zzeo zzeo2) {
        int n = zzeo2.size();
        return zzfe.zzax(n) + n;
    }

    public static int zzh(byte[] byArray) {
        int n = byArray.length;
        return zzfe.zzax(n) + n;
    }

    public static int zzc(zzhf zzhf2) {
        int n = zzhf2.zzeq();
        return zzfe.zzax(n) + n;
    }

    static int zzb(zzhf zzhf2, zzhw zzhw2) {
        zzhw zzhw3 = zzhw2;
        zzec zzec2 = (zzec)zzhf2;
        int n = zzec2.zzcf();
        if (n == -1) {
            n = zzhw3.zzp(zzec2);
            zzec2.zzy(n);
        }
        int n2 = n;
        return zzfe.zzax(n2) + n2;
    }

    private static int zzbc(int n) {
        return n << 1 ^ n >> 31;
    }

    private static long zzm(long l) {
        return l << 1 ^ l >> 63;
    }

    public abstract void flush() throws IOException;

    public abstract int zzdz();

    public final void zzea() {
        if (this.zzdz() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    abstract void zzf(byte[] var1, int var2, int var3) throws IOException;

    final void zza(String string, zzja zzja2) throws IOException {
        logger.logp(Level.WARNING, "com.google.protobuf.CodedOutputStream", "inefficientWriteStringNoTag", "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", zzja2);
        byte[] byArray = string.getBytes(zzga.UTF_8);
        try {
            this.zzas(byArray.length);
            this.zza(byArray, 0, byArray.length);
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new zzc(indexOutOfBoundsException);
        }
        catch (zzc zzc2) {
            throw zzc2;
        }
    }

    @Deprecated
    static int zzc(int n, zzhf zzhf2, zzhw zzhw2) {
        zzhw zzhw3;
        int n2 = zzfe.zzav(n) << 1;
        zzhw zzhw4 = zzhw3 = zzhw2;
        zzec zzec2 = (zzec)zzhf2;
        int n3 = zzec2.zzcf();
        if (n3 == -1) {
            n3 = zzhw4.zzp(zzec2);
            zzec2.zzy(n3);
        }
        return n2 + n3;
    }

    @Deprecated
    public static int zzd(zzhf zzhf2) {
        return zzhf2.zzeq();
    }

    @Deprecated
    public static int zzbd(int n) {
        return zzfe.zzax(n);
    }

    /* synthetic */ zzfe(zzff zzff2) {
        this();
    }

    static final class zze
    extends zzfe {
        private final ByteBuffer zzsv;
        private final ByteBuffer zzsw;
        private final long zzsx;
        private final long zzsy;
        private final long zzsz;
        private final long zzta;
        private long zztb;

        zze(ByteBuffer byteBuffer) {
            super(null);
            this.zzsv = byteBuffer;
            this.zzsw = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzsx = zziu.zzb(byteBuffer);
            this.zzsy = this.zzsx + (long)byteBuffer.position();
            this.zzsz = this.zzsx + (long)byteBuffer.limit();
            this.zzta = this.zzsz - 10L;
            this.zztb = this.zzsy;
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzfe)this).zzas(n << 3 | n3);
        }

        @Override
        public final void zze(int n, int n2) throws IOException {
            ((zzfe)this).zzd(n, 0);
            ((zzfe)this).zzar(n2);
        }

        @Override
        public final void zzf(int n, int n2) throws IOException {
            ((zzfe)this).zzd(n, 0);
            ((zzfe)this).zzas(n2);
        }

        @Override
        public final void zzh(int n, int n2) throws IOException {
            ((zzfe)this).zzd(n, 5);
            ((zzfe)this).zzau(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzfe)this).zzd(n, 0);
            ((zzfe)this).zze(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzfe)this).zzd(n, 1);
            ((zzfe)this).zzg(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzfe)this).zzd(n, 0);
            ((zzfe)this).zzc((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zza(int n, String string) throws IOException {
            ((zzfe)this).zzd(n, 2);
            ((zzfe)this).zzm(string);
        }

        @Override
        public final void zza(int n, zzeo zzeo2) throws IOException {
            ((zzfe)this).zzd(n, 2);
            ((zzfe)this).zza(zzeo2);
        }

        @Override
        public final void zza(int n, zzhf zzhf2) throws IOException {
            ((zzfe)this).zzd(n, 2);
            ((zzfe)this).zzb(zzhf2);
        }

        @Override
        final void zza(int n, zzhf zzhf2, zzhw zzhw2) throws IOException {
            ((zzfe)this).zzd(n, 2);
            ((zzfe)this).zza(zzhf2, zzhw2);
        }

        @Override
        public final void zzb(int n, zzhf zzhf2) throws IOException {
            ((zzfe)this).zzd(1, 3);
            ((zzfe)this).zzf(2, n);
            ((zzfe)this).zza(3, zzhf2);
            ((zzfe)this).zzd(1, 4);
        }

        @Override
        public final void zzb(int n, zzeo zzeo2) throws IOException {
            ((zzfe)this).zzd(1, 3);
            ((zzfe)this).zzf(2, n);
            ((zzfe)this).zza(3, zzeo2);
            ((zzfe)this).zzd(1, 4);
        }

        @Override
        public final void zzb(zzhf zzhf2) throws IOException {
            ((zzfe)this).zzas(zzhf2.zzeq());
            zzhf2.zzb(this);
        }

        @Override
        final void zza(zzhf zzhf2, zzhw zzhw2) throws IOException {
            zzhw zzhw3 = zzhw2;
            zzec zzec2 = (zzec)zzhf2;
            int n = zzec2.zzcf();
            if (n == -1) {
                n = zzhw3.zzp(zzec2);
                zzec2.zzy(n);
            }
            ((zzfe)this).zzas(n);
            zzhw2.zza(zzhf2, this.zzss);
        }

        @Override
        public final void zzc(byte by) throws IOException {
            if (this.zztb >= this.zzsz) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zztb, this.zzsz, 1));
            }
            zziu.zza(this.zztb++, by);
        }

        @Override
        public final void zza(zzeo zzeo2) throws IOException {
            ((zzfe)this).zzas(zzeo2.size());
            zzeo2.zza(this);
        }

        @Override
        public final void zzf(byte[] byArray, int n, int n2) throws IOException {
            ((zzfe)this).zzas(n2);
            ((zzfe)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzar(int n) throws IOException {
            if (n >= 0) {
                ((zzfe)this).zzas(n);
                return;
            }
            ((zzfe)this).zze(n);
        }

        @Override
        public final void zzas(int n) throws IOException {
            if (this.zztb <= this.zzta) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zziu.zza(this.zztb++, (byte)n);
                        return;
                    }
                    zziu.zza(this.zztb++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            while (this.zztb < this.zzsz) {
                if ((n & 0xFFFFFF80) == 0) {
                    zziu.zza(this.zztb++, (byte)n);
                    return;
                }
                zziu.zza(this.zztb++, (byte)(n & 0x7F | 0x80));
                n >>>= 7;
            }
            throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zztb, this.zzsz, 1));
        }

        @Override
        public final void zzau(int n) throws IOException {
            long l = this.zztb;
            zze zze2 = this;
            this.zzsw.putInt((int)(l - zze2.zzsx), n);
            this.zztb += 4L;
        }

        @Override
        public final void zze(long l) throws IOException {
            if (this.zztb <= this.zzta) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zziu.zza(this.zztb++, (byte)l);
                        return;
                    }
                    zziu.zza(this.zztb++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            while (this.zztb < this.zzsz) {
                if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    zziu.zza(this.zztb++, (byte)l);
                    return;
                }
                zziu.zza(this.zztb++, (byte)((int)l & 0x7F | 0x80));
                l >>>= 7;
            }
            throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zztb, this.zzsz, 1));
        }

        @Override
        public final void zzg(long l) throws IOException {
            long l2 = this.zztb;
            zze zze2 = this;
            this.zzsw.putLong((int)(l2 - zze2.zzsx), l);
            this.zztb += 8L;
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null || n < 0 || n2 < 0 || byArray.length - n2 < n || this.zzsz - (long)n2 < this.zztb) {
                if (byArray == null) {
                    throw new NullPointerException("value");
                }
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.zztb, this.zzsz, n2));
            }
            zziu.zza(byArray, n, this.zztb, n2);
            this.zztb += (long)n2;
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzfe)this).write(byArray, n, n2);
        }

        @Override
        public final void zzm(String string) throws IOException {
            long l = this.zztb;
            try {
                int n = zze.zzax(string.length() * 3);
                int n2 = zze.zzax(string.length());
                if (n2 == n) {
                    long l2 = this.zztb;
                    zze zze2 = this;
                    int n3 = (int)(l2 - zze2.zzsx) + n2;
                    this.zzsw.position(n3);
                    zziw.zza(string, this.zzsw);
                    int n4 = this.zzsw.position() - n3;
                    ((zzfe)this).zzas(n4);
                    this.zztb += (long)n4;
                    return;
                }
                int n5 = zziw.zza(string);
                ((zzfe)this).zzas(n5);
                this.zzn(this.zztb);
                zziw.zza(string, this.zzsw);
                this.zztb += (long)n5;
                return;
            }
            catch (zzja zzja2) {
                this.zztb = l;
                this.zzn(this.zztb);
                this.zza(string, zzja2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzc(illegalArgumentException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }

        @Override
        public final void flush() {
            long l = this.zztb;
            zze zze2 = this;
            this.zzsv.position((int)(l - zze2.zzsx));
        }

        @Override
        public final int zzdz() {
            return (int)(this.zzsz - this.zztb);
        }

        private final void zzn(long l) {
            long l2 = l;
            zze zze2 = this;
            this.zzsw.position((int)(l2 - zze2.zzsx));
        }
    }

    static final class zzd
    extends zzfe {
        private final ByteBuffer zzsv;
        private final ByteBuffer zzsw;
        private final int zzsu;

        zzd(ByteBuffer byteBuffer) {
            super(null);
            this.zzsv = byteBuffer;
            this.zzsw = byteBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
            this.zzsu = byteBuffer.position();
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzfe)this).zzas(n << 3 | n3);
        }

        @Override
        public final void zze(int n, int n2) throws IOException {
            ((zzfe)this).zzd(n, 0);
            ((zzfe)this).zzar(n2);
        }

        @Override
        public final void zzf(int n, int n2) throws IOException {
            ((zzfe)this).zzd(n, 0);
            ((zzfe)this).zzas(n2);
        }

        @Override
        public final void zzh(int n, int n2) throws IOException {
            ((zzfe)this).zzd(n, 5);
            ((zzfe)this).zzau(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzfe)this).zzd(n, 0);
            ((zzfe)this).zze(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzfe)this).zzd(n, 1);
            ((zzfe)this).zzg(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzfe)this).zzd(n, 0);
            ((zzfe)this).zzc((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zza(int n, String string) throws IOException {
            ((zzfe)this).zzd(n, 2);
            ((zzfe)this).zzm(string);
        }

        @Override
        public final void zza(int n, zzeo zzeo2) throws IOException {
            ((zzfe)this).zzd(n, 2);
            ((zzfe)this).zza(zzeo2);
        }

        @Override
        public final void zza(int n, zzhf zzhf2) throws IOException {
            ((zzfe)this).zzd(n, 2);
            ((zzfe)this).zzb(zzhf2);
        }

        @Override
        final void zza(int n, zzhf zzhf2, zzhw zzhw2) throws IOException {
            ((zzfe)this).zzd(n, 2);
            ((zzfe)this).zza(zzhf2, zzhw2);
        }

        @Override
        public final void zzb(int n, zzhf zzhf2) throws IOException {
            ((zzfe)this).zzd(1, 3);
            ((zzfe)this).zzf(2, n);
            ((zzfe)this).zza(3, zzhf2);
            ((zzfe)this).zzd(1, 4);
        }

        @Override
        public final void zzb(int n, zzeo zzeo2) throws IOException {
            ((zzfe)this).zzd(1, 3);
            ((zzfe)this).zzf(2, n);
            ((zzfe)this).zza(3, zzeo2);
            ((zzfe)this).zzd(1, 4);
        }

        @Override
        public final void zzb(zzhf zzhf2) throws IOException {
            ((zzfe)this).zzas(zzhf2.zzeq());
            zzhf2.zzb(this);
        }

        @Override
        final void zza(zzhf zzhf2, zzhw zzhw2) throws IOException {
            zzhw zzhw3 = zzhw2;
            zzec zzec2 = (zzec)zzhf2;
            int n = zzec2.zzcf();
            if (n == -1) {
                n = zzhw3.zzp(zzec2);
                zzec2.zzy(n);
            }
            ((zzfe)this).zzas(n);
            zzhw2.zza(zzhf2, this.zzss);
        }

        @Override
        public final void zzc(byte by) throws IOException {
            try {
                this.zzsw.put(by);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zza(zzeo zzeo2) throws IOException {
            ((zzfe)this).zzas(zzeo2.size());
            zzeo2.zza(this);
        }

        @Override
        public final void zzf(byte[] byArray, int n, int n2) throws IOException {
            ((zzfe)this).zzas(n2);
            ((zzfe)this).write(byArray, 0, n2);
        }

        @Override
        public final void zzar(int n) throws IOException {
            if (n >= 0) {
                ((zzfe)this).zzas(n);
                return;
            }
            ((zzfe)this).zze(n);
        }

        @Override
        public final void zzas(int n) throws IOException {
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.zzsw.put((byte)n);
                        return;
                    }
                    this.zzsw.put((byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzau(int n) throws IOException {
            try {
                this.zzsw.putInt(n);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zze(long l) throws IOException {
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.zzsw.put((byte)l);
                        return;
                    }
                    this.zzsw.put((byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zzg(long l) throws IOException {
            try {
                this.zzsw.putLong(l);
                return;
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.zzsw.put(byArray, n, n2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
            catch (BufferOverflowException bufferOverflowException) {
                throw new zzc(bufferOverflowException);
            }
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzfe)this).write(byArray, n, n2);
        }

        @Override
        public final void zzm(String string) throws IOException {
            int n = this.zzsw.position();
            try {
                int n2 = zzd.zzax(string.length() * 3);
                int n3 = zzd.zzax(string.length());
                if (n3 == n2) {
                    int n4 = this.zzsw.position() + n3;
                    this.zzsw.position(n4);
                    this.zzo(string);
                    int n5 = this.zzsw.position();
                    this.zzsw.position(n);
                    ((zzfe)this).zzas(n5 - n4);
                    this.zzsw.position(n5);
                    return;
                }
                int n6 = zziw.zza(string);
                ((zzfe)this).zzas(n6);
                this.zzo(string);
                return;
            }
            catch (zzja zzja2) {
                this.zzsw.position(n);
                this.zza(string, zzja2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new zzc(illegalArgumentException);
            }
        }

        @Override
        public final void flush() {
            this.zzsv.position(this.zzsw.position());
        }

        @Override
        public final int zzdz() {
            return this.zzsw.remaining();
        }

        private final void zzo(String string) throws IOException {
            try {
                zziw.zza(string, this.zzsw);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }
    }

    static final class zzb
    extends zza {
        private final ByteBuffer zzst;
        private int zzsu;

        zzb(ByteBuffer byteBuffer) {
            super(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
            this.zzst = byteBuffer;
            this.zzsu = byteBuffer.position();
        }

        @Override
        public final void flush() {
            this.zzst.position(this.zzsu + this.zzec());
        }
    }

    static class zza
    extends zzfe {
        private final byte[] buffer;
        private final int offset;
        private final int limit;
        private int position;

        zza(byte[] byArray, int n, int n2) {
            super(null);
            if (byArray == null) {
                throw new NullPointerException("buffer");
            }
            if ((n | n2 | byArray.length - (n + n2)) < 0) {
                throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", byArray.length, n, n2));
            }
            this.buffer = byArray;
            this.offset = n;
            this.position = n;
            this.limit = n + n2;
        }

        @Override
        public final void zzd(int n, int n2) throws IOException {
            int n3 = n2;
            ((zzfe)this).zzas(n << 3 | n3);
        }

        @Override
        public final void zze(int n, int n2) throws IOException {
            ((zzfe)this).zzd(n, 0);
            ((zzfe)this).zzar(n2);
        }

        @Override
        public final void zzf(int n, int n2) throws IOException {
            ((zzfe)this).zzd(n, 0);
            ((zzfe)this).zzas(n2);
        }

        @Override
        public final void zzh(int n, int n2) throws IOException {
            ((zzfe)this).zzd(n, 5);
            ((zzfe)this).zzau(n2);
        }

        @Override
        public final void zza(int n, long l) throws IOException {
            ((zzfe)this).zzd(n, 0);
            ((zzfe)this).zze(l);
        }

        @Override
        public final void zzc(int n, long l) throws IOException {
            ((zzfe)this).zzd(n, 1);
            ((zzfe)this).zzg(l);
        }

        @Override
        public final void zzb(int n, boolean bl) throws IOException {
            ((zzfe)this).zzd(n, 0);
            ((zzfe)this).zzc((byte)(bl ? 1 : 0));
        }

        @Override
        public final void zza(int n, String string) throws IOException {
            ((zzfe)this).zzd(n, 2);
            ((zzfe)this).zzm(string);
        }

        @Override
        public final void zza(int n, zzeo zzeo2) throws IOException {
            ((zzfe)this).zzd(n, 2);
            ((zzfe)this).zza(zzeo2);
        }

        @Override
        public final void zza(zzeo zzeo2) throws IOException {
            ((zzfe)this).zzas(zzeo2.size());
            zzeo2.zza(this);
        }

        @Override
        public final void zzf(byte[] byArray, int n, int n2) throws IOException {
            ((zzfe)this).zzas(n2);
            ((zzfe)this).write(byArray, 0, n2);
        }

        @Override
        public final void zza(int n, zzhf zzhf2) throws IOException {
            ((zzfe)this).zzd(n, 2);
            ((zzfe)this).zzb(zzhf2);
        }

        @Override
        final void zza(int n, zzhf zzhf2, zzhw zzhw2) throws IOException {
            ((zzfe)this).zzd(n, 2);
            zzhw zzhw3 = zzhw2;
            zzec zzec2 = (zzec)zzhf2;
            int n2 = zzec2.zzcf();
            if (n2 == -1) {
                n2 = zzhw3.zzp(zzec2);
                zzec2.zzy(n2);
            }
            ((zzfe)this).zzas(n2);
            zzhw2.zza(zzhf2, this.zzss);
        }

        @Override
        public final void zzb(int n, zzhf zzhf2) throws IOException {
            ((zzfe)this).zzd(1, 3);
            ((zzfe)this).zzf(2, n);
            ((zzfe)this).zza(3, zzhf2);
            ((zzfe)this).zzd(1, 4);
        }

        @Override
        public final void zzb(int n, zzeo zzeo2) throws IOException {
            ((zzfe)this).zzd(1, 3);
            ((zzfe)this).zzf(2, n);
            ((zzfe)this).zza(3, zzeo2);
            ((zzfe)this).zzd(1, 4);
        }

        @Override
        public final void zzb(zzhf zzhf2) throws IOException {
            ((zzfe)this).zzas(zzhf2.zzeq());
            zzhf2.zzb(this);
        }

        @Override
        final void zza(zzhf zzhf2, zzhw zzhw2) throws IOException {
            zzhw zzhw3 = zzhw2;
            zzec zzec2 = (zzec)zzhf2;
            int n = zzec2.zzcf();
            if (n == -1) {
                n = zzhw3.zzp(zzec2);
                zzec2.zzy(n);
            }
            ((zzfe)this).zzas(n);
            zzhw2.zza(zzhf2, this.zzss);
        }

        @Override
        public final void zzc(byte by) throws IOException {
            try {
                this.buffer[this.position++] = by;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzar(int n) throws IOException {
            if (n >= 0) {
                ((zzfe)this).zzas(n);
                return;
            }
            ((zzfe)this).zze(n);
        }

        @Override
        public final void zzas(int n) throws IOException {
            if (zzsr && ((zzfe)this).zzdz() >= 10) {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        zziu.zza(this.buffer, (long)this.position++, (byte)n);
                        return;
                    }
                    zziu.zza(this.buffer, (long)this.position++, (byte)(n & 0x7F | 0x80));
                    n >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((n & 0xFFFFFF80) == 0) {
                        this.buffer[this.position++] = (byte)n;
                        return;
                    }
                    this.buffer[this.position++] = (byte)(n & 0x7F | 0x80);
                    n >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzau(int n) throws IOException {
            try {
                this.buffer[this.position++] = (byte)n;
                this.buffer[this.position++] = (byte)(n >> 8);
                this.buffer[this.position++] = (byte)(n >> 16);
                this.buffer[this.position++] = n >> 24;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zze(long l) throws IOException {
            if (zzsr && ((zzfe)this).zzdz() >= 10) {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        zziu.zza(this.buffer, (long)this.position++, (byte)l);
                        return;
                    }
                    zziu.zza(this.buffer, (long)this.position++, (byte)((int)l & 0x7F | 0x80));
                    l >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)l;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)l & 0x7F | 0x80);
                    l >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zzg(long l) throws IOException {
            try {
                this.buffer[this.position++] = (byte)l;
                this.buffer[this.position++] = (byte)(l >> 8);
                this.buffer[this.position++] = (byte)(l >> 16);
                this.buffer[this.position++] = (byte)(l >> 24);
                this.buffer[this.position++] = (byte)(l >> 32);
                this.buffer[this.position++] = (byte)(l >> 40);
                this.buffer[this.position++] = (byte)(l >> 48);
                this.buffer[this.position++] = (byte)(l >> 56);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), indexOutOfBoundsException);
            }
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                System.arraycopy(byArray, n, this.buffer, this.position, n2);
                this.position += n2;
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, n2), indexOutOfBoundsException);
            }
        }

        @Override
        public final void zza(byte[] byArray, int n, int n2) throws IOException {
            ((zzfe)this).write(byArray, n, n2);
        }

        @Override
        public final void zzm(String string) throws IOException {
            int n = this.position;
            try {
                int n2 = zza.zzax(string.length() * 3);
                int n3 = zza.zzax(string.length());
                if (n3 == n2) {
                    this.position = n + n3;
                    int n4 = zziw.zza(string, this.buffer, this.position, ((zzfe)this).zzdz());
                    this.position = n;
                    int n5 = n4 - n - n3;
                    ((zzfe)this).zzas(n5);
                    this.position = n4;
                    return;
                }
                int n6 = zziw.zza(string);
                ((zzfe)this).zzas(n6);
                this.position = zziw.zza(string, this.buffer, this.position, ((zzfe)this).zzdz());
                return;
            }
            catch (zzja zzja2) {
                this.position = n;
                this.zza(string, zzja2);
                return;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new zzc(indexOutOfBoundsException);
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public final int zzdz() {
            return this.limit - this.position;
        }

        public final int zzec() {
            return this.position - this.offset;
        }
    }

    public static final class zzc
    extends IOException {
        zzc() {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.");
        }

        zzc(String string) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        }

        zzc(Throwable throwable) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.", throwable);
        }

        zzc(String string, Throwable throwable) {
            String string2 = String.valueOf("CodedOutputStream was writing to a flat byte array and ran out of space.: ");
            String string3 = String.valueOf(string);
            super(string3.length() != 0 ? string2.concat(string3) : new String(string2), throwable);
        }
    }
}

