/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.play.core.assetpacks;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.google.android.play.core.assetpacks.AssetLocation;
import com.google.android.play.core.assetpacks.AssetPackLocation;
import com.google.android.play.core.assetpacks.bl;
import com.google.android.play.core.assetpacks.bm;
import com.google.android.play.core.assetpacks.bt;
import com.google.android.play.core.assetpacks.ck;
import com.google.android.play.core.assetpacks.ec;
import com.google.android.play.core.assetpacks.internal.o;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

final class bh {
    private static final o a = new o("AssetPackStorage");
    private static final long b = TimeUnit.DAYS.toMillis(14L);
    private static final long c = TimeUnit.DAYS.toMillis(28L);
    private final Context d;
    private final ec e;

    final int a(String string) {
        return (int)bh.H(this.I(string), true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final int b(String object, int n2, long l2) throws IOException {
        if (!((File)(this = ((bh)this).J((String)object, n2, l2))).exists()) {
            return 0;
        }
        object = new Properties();
        FileInputStream fileInputStream = new FileInputStream((File)this);
        try {
            ((Properties)object).load(fileInputStream);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
        if (((Properties)object).getProperty("numberOfMerges") == null) {
            throw new ck("Merge checkpoint file corrupt.");
        }
        try {
            return Integer.parseInt(((Properties)object).getProperty("numberOfMerges"));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ck("Merge checkpoint file corrupt.", numberFormatException);
        }
    }

    final long c(String string) {
        bh bh2 = this;
        String string2 = string;
        return bh.H(bh2.g(string2, (int)bh.H(bh2.I(string2), true)), true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long H(File file, boolean bl2) {
        ArrayList<Long> arrayList;
        block8: {
            block7: {
                if (!file.exists()) break block7;
                arrayList = new ArrayList<Long>();
                if (bl2 && file.listFiles().length > 1) {
                    Object[] objectArray = new Object[]{};
                    a.e("Multiple pack versions found, using highest version code.", objectArray);
                }
                try {
                    for (File file2 : file.listFiles()) {
                        boolean bl3 = file2.getName().equals("stale.tmp");
                        if (bl3) continue;
                        arrayList.add(Long.valueOf(file2.getName()));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    Object[] objectArray = new Object[]{};
                    a.c(numberFormatException, "Corrupt asset pack directories.", objectArray);
                }
                if (!arrayList.isEmpty()) break block8;
            }
            return -1L;
        }
        Collections.sort(arrayList);
        ArrayList<Long> arrayList2 = arrayList;
        return (Long)arrayList2.get(arrayList2.size() + -1);
    }

    /*
     * Loose catch block
     */
    @VisibleForTesting
    @Nullable
    final AssetLocation d(String objectArray, String string, List list) {
        if (list == null) {
            return null;
        }
        Object[] objectArray2 = new File("assets", string).getPath();
        for (Object object : list) {
            if ((object = bt.a((String)object, (String)objectArray2)) == null) continue;
            return object;
        }
        objectArray2 = new Object[]{string, objectArray, list};
        a.a("The asset %s is not present in Asset Pack %s. Searched in APKs: %s", objectArray2);
        return null;
        catch (IOException iOException) {
            Object object;
            objectArray = new Object[]{object, string};
            a.c(iOException, "Failed to parse APK file '%s' looking for asset '%s'.", objectArray);
            return null;
        }
    }

    @Nullable
    final AssetLocation e(String string, String string2, AssetPackLocation assetPackLocation) {
        Object[] objectArray = new File(assetPackLocation.assetsPath(), string2);
        if (objectArray.exists()) {
            string = objectArray.getPath();
            long l2 = objectArray.length();
            return new bl(string, 0L, l2);
        }
        objectArray = new Object[]{string2, string, assetPackLocation.assetsPath()};
        a.a("The asset %s is not present in Asset Pack %s. Searched in folder: %s", objectArray);
        return null;
    }

    @Nullable
    final AssetPackLocation f(String string) throws IOException {
        if ((objectArray = objectArray.r(string)) == null) {
            return null;
        }
        string = "assets";
        File file = new File((String)objectArray, string);
        if (!file.isDirectory()) {
            Object[] objectArray = new Object[]{file};
            a.b("Failed to find assets directory: %s", objectArray);
            return null;
        }
        string = file.getCanonicalPath();
        return new bm(0, (String)objectArray, string);
    }

    private final File I(String string) {
        return new File(this.L(), string);
    }

    final File g(String string, int n2) {
        return new File(this.I(string), String.valueOf(n2));
    }

    final File h(String string, int n2, long l2) {
        return new File(this.g(string, n2), String.valueOf(l2));
    }

    final File i(String string, int n2, long l2) {
        return new File(this.h(string, n2, l2), "_metadata");
    }

    private final File J(String string, int n2, long l2) {
        return new File(this.j(string, n2, l2), "merge.tmp");
    }

    final File j(String string, int n2, long l2) {
        return new File(this.K(string, n2, l2), "_packs");
    }

    final File k(String string, int n2, long l2) {
        return new File(this.i(string, n2, l2), "properties.dat");
    }

    private final File K(String string, int n2, long l2) {
        return new File(new File(new File(this.M(), string), String.valueOf(n2)), String.valueOf(l2));
    }

    final File l(String string, int n2, long l2) {
        return new File(new File(this.K(string, n2, l2), "_slices"), "_metadata");
    }

    final File m(String string, int n2, long l2, String string2) {
        return new File(this.o(string, n2, l2, string2), "checkpoint_ext.dat");
    }

    final File n(String string, int n2, long l2, String string2) {
        return new File(this.o(string, n2, l2, string2), "checkpoint.dat");
    }

    final File o(String string, int n2, long l2, String string2) {
        return new File(this.l(string, n2, l2), string2);
    }

    private final File L() {
        bh bh2 = bh2.d;
        return new File(bh2.getFilesDir(), "assetpacks");
    }

    private final File M() {
        return new File(this.L(), "_tmp");
    }

    final File p(String string, int n2, long l2, String string2) {
        return new File(new File(new File(this.K(string, n2, l2), "_slices"), "_unverified"), string2);
    }

    final File q(String string, int n2, long l2, String string2) {
        return new File(new File(new File(this.K(string, n2, l2), "_slices"), "_verified"), string2);
    }

    @Nullable
    final String r(String string) throws IOException {
        int n2;
        Object[] objectArray = new File(objectArray2.L(), string);
        if (!objectArray.exists()) {
            Object[] objectArray2 = new Object[]{string};
            a.a("Pack not found with pack name: %s", objectArray2);
            return null;
        }
        ec ec2 = objectArray2.e;
        File file = new File((File)objectArray, String.valueOf(ec2.a()));
        if (!file.exists()) {
            objectArray = new Object[]{string, objectArray2.e.a()};
            a.a("Pack not found with pack name: %s app version: %s", objectArray);
            return null;
        }
        objectArray = file.listFiles();
        if (objectArray == null || (n2 = objectArray.length) == 0) {
            objectArray = new Object[]{string, objectArray2.e.a()};
            a.a("No pack version found for pack name: %s app version: %s", objectArray);
            return null;
        }
        if (n2 > 1) {
            objectArray = new Object[]{string, objectArray2.e.a()};
            a.b("Multiple pack versions found for pack name: %s app version: %s", objectArray);
            return null;
        }
        return ((File)objectArray[0]).getCanonicalPath();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    final List s(String string) {
        PackageInfo packageInfo;
        try {
            packageInfo = packageInfo.d.getPackageManager().getPackageInfo(packageInfo.d.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            packageInfo = new PackageInfo[]{};
            a.b("Could not find PackageInfo.", (Object[])packageInfo);
            return null;
        }
        if (packageInfo == null) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (Build.VERSION.SDK_INT >= 21) {
            Object[] objectArray;
            if (packageInfo.splitNames == null || packageInfo.applicationInfo.splitSourceDirs == null) {
                objectArray = new Object[]{string};
                a.a("No splits present for package %s.", objectArray);
                objectArray = null;
            } else {
                int n2 = Arrays.binarySearch(packageInfo.splitNames, string);
                if (n2 < 0) {
                    objectArray = new Object[]{string};
                    a.a("Asset Pack '%s' is not installed.", objectArray);
                    objectArray = null;
                } else {
                    objectArray = packageInfo.applicationInfo.splitSourceDirs[n2];
                }
            }
            if (objectArray == null) {
                arrayList.add(packageInfo.applicationInfo.sourceDir);
                arrayList.addAll(bh.N(packageInfo, "config."));
                return arrayList;
            }
            arrayList.add(objectArray);
            arrayList.addAll(bh.N(packageInfo, String.valueOf(string).concat(".config.")));
            return arrayList;
        }
        arrayList.add(packageInfo.applicationInfo.sourceDir);
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    @RequiresApi(value=21)
    private static List N(PackageInfo packageInfo, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (packageInfo.splitNames != null) {
            for (int i2 = -Arrays.binarySearch(packageInfo.splitNames, string) + -1; i2 < packageInfo.splitNames.length && packageInfo.splitNames[i2].startsWith(string); ++i2) {
                arrayList.add(packageInfo.applicationInfo.splitSourceDirs[i2]);
            }
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final List O() {
        ArrayList<File> arrayList = new ArrayList<File>();
        try {
            boolean bl2 = this.L().exists();
            if (!bl2) return arrayList;
            File[] fileArray = this.L().listFiles();
            if (fileArray == null) {
                return arrayList;
            }
            File[] fileArray2 = this.L().listFiles();
            int n2 = fileArray2.length;
            int n3 = 0;
            while (n3 < n2) {
                File file = fileArray2[n3];
                boolean bl3 = file.getCanonicalPath().equals(this.M().getCanonicalPath());
                if (!bl3) {
                    arrayList.add(file);
                }
                ++n3;
            }
            return arrayList;
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{iOException};
            a.b("Could not process directory while scanning installed packs. %s", objectArray);
            return arrayList;
        }
    }

    final Map t() {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        Iterator iterator = this.O().iterator();
        while (iterator.hasNext()) {
            String string = ((File)iterator.next()).getName();
            bh bh2 = this;
            String string2 = string;
            int n2 = (int)bh.H(bh2.I(string2), true);
            long l2 = bh.H(bh2.g(string2, n2), true);
            if (!bh2.h(string2, n2, l2).exists()) continue;
            hashMap.put(string, l2);
        }
        return hashMap;
    }

    final Map u() {
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        for (String string : this.v().keySet()) {
            hashMap.put(string, this.c(string));
        }
        return hashMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Map v() {
        HashMap<String, AssetPackLocation> hashMap = new HashMap<String, AssetPackLocation>();
        try {
            boolean bl2;
            Iterator iterator = this.O().iterator();
            while (bl2 = iterator.hasNext()) {
                File file = (File)iterator.next();
                AssetPackLocation assetPackLocation = this.f(file.getName());
                if (assetPackLocation == null) continue;
                hashMap.put(file.getName(), assetPackLocation);
            }
            return hashMap;
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{iOException};
            a.b("Could not process directory while scanning installed packs: %s", objectArray);
            return hashMap;
        }
    }

    bh(Context context, ec ec2) {
        this.d = context;
        this.e = ec2;
    }

    /*
     * Unable to fully structure code
     */
    final void w() {
        block2: for (File var1_2 : this.O()) {
            if (var1_2.listFiles() == null) continue;
            bh.P(var1_2);
            var3_4 = bh.H(var1_2, false);
            if ((long)this.e.a() != var3_4) {
                var5_5 = new File(new File(var1_2, String.valueOf(var3_4)), "stale.tmp");
                var5_5.createNewFile();
            }
lbl10:
            // 4 sources

            while (true) {
                var5_5 = var1_2.listFiles();
                var6_6 = var5_5.length;
                for (var1_3 = 0; var1_3 < var6_6; ++var1_3) {
                    bh.P(var5_5[var1_3]);
                }
                continue block2;
                break;
            }
        }
        return;
        catch (IOException v0) {
            var5_5 = new Object[]{};
            bh.a.b("Could not write staleness marker.", var5_5);
            ** continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void P(File file) {
        if (file.listFiles() != null && file.listFiles().length > 1) {
            long l2 = bh.H(file, false);
            for (File file2 : file.listFiles()) {
                if (file2.getName().equals(String.valueOf(l2)) || file2.getName().equals("stale.tmp")) continue;
                bh.Q(file2);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    final void x() {
        if (this.M().exists()) {
            for (File file : this.M().listFiles()) {
                if (System.currentTimeMillis() - file.lastModified() > b) {
                    bh.Q(file);
                    continue;
                }
                bh.P(file);
            }
        }
    }

    final void y() {
        for (Object object : ((bh)object).O()) {
            if (((File)object).listFiles() == null) continue;
            for (File file : ((File)object).listFiles()) {
                String string = "stale.tmp";
                File file2 = new File(file, string);
                if (!file2.exists() || System.currentTimeMillis() - file2.lastModified() <= c) continue;
                bh.Q(file);
            }
        }
    }

    final void z() {
        bh.Q(this.L());
    }

    final void A(String string, int n2, long l2, int n3) throws IOException {
        File file = ((bh)((Object)file)).J(string, n2, l2);
        Properties properties = new Properties();
        properties.put("numberOfMerges", String.valueOf(n3));
        file.getParentFile().mkdirs();
        file.createNewFile();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        properties.store(fileOutputStream, null);
        ((OutputStream)fileOutputStream).close();
    }

    /*
     * Enabled aggressive block sorting
     */
    final void B(String object2, int n2, long l2) {
        if (((File)(this = ((bh)this).I((String)object2))).exists()) {
            for (Object object2 : ((File)this).listFiles()) {
                if (!((File)object2).getName().equals(String.valueOf(n2)) && !((File)object2).getName().equals("stale.tmp")) {
                    bh.Q((File)object2);
                    continue;
                }
                if (!((File)object2).getName().equals(String.valueOf(n2))) continue;
                for (File file : ((File)object2).listFiles()) {
                    if (file.getName().equals(String.valueOf(l2))) continue;
                    bh.Q(file);
                }
            }
        }
    }

    final void C(List list) {
        int n2 = ((bh)this).e.a();
        for (File file : ((bh)this).O()) {
            if (list.contains(file.getName()) || bh.H(file, true) == (long)n2) continue;
            bh.Q(file);
        }
    }

    final boolean D(String string) {
        if (!this.I(string).exists()) {
            return true;
        }
        return bh.Q(this.I(string));
    }

    final boolean E(String string, int n2, long l2) {
        if (!this.K(string, n2, l2).exists()) {
            return true;
        }
        return bh.Q(this.K(string, n2, l2));
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean Q(File file) {
        boolean bl2;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            bl2 = true;
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                bl2 = bh.Q(fileArray[i2]) & bl2;
            }
        } else {
            bl2 = true;
        }
        if (!file.delete()) {
            return false;
        }
        return bl2;
    }

    final boolean F(String string, int n2, long l2) {
        if (!this.h(string, n2, l2).exists()) {
            return true;
        }
        return bh.Q(this.h(string, n2, l2));
    }

    final boolean G(String string) {
        try {
            String string2 = ((bh)((Object)string2)).r(string);
            return string2 != null;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

