/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.play.core.splitinstall;

import android.app.PendingIntent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.play.core.splitinstall.model.SplitInstallErrorCode;
import com.google.android.play.core.splitinstall.model.SplitInstallSessionStatus;
import com.google.android.play.core.splitinstall.zza;
import java.util.ArrayList;
import java.util.List;

public abstract class SplitInstallSessionState {
    @SplitInstallErrorCode
    public abstract int errorCode();

    public abstract int sessionId();

    @SplitInstallSessionStatus
    public abstract int status();

    public abstract long bytesDownloaded();

    public abstract long totalBytesToDownload();

    @Deprecated
    @Nullable
    public abstract PendingIntent resolutionIntent();

    /*
     * WARNING - void declaration
     */
    public static SplitInstallSessionState create(int sessionId, @SplitInstallSessionStatus int status, @SplitInstallErrorCode int errorCode, long bytesDownloaded, long totalBytesToDownload, List<String> moduleNames, List<String> languages) {
        void var8_6;
        void var7_5;
        void var5_4;
        void var3_3;
        void var2_2;
        void var1_1;
        int n;
        if (status == 8) {
            throw new IllegalArgumentException("REQUIRES_USER_CONFIRMATION state not supported.");
        }
        return new zza(n, (int)var1_1, (int)var2_2, (long)var3_3, (long)var5_4, (List)var7_5, (List)var8_6, null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public List<String> languages() {
        if (((SplitInstallSessionState)((Object)this)).zza() == null) return new ArrayList();
        return new ArrayList<String>(((SplitInstallSessionState)((Object)this)).zza());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public List<String> moduleNames() {
        if (((SplitInstallSessionState)((Object)this)).zzb() == null) return new ArrayList();
        return new ArrayList<String>(((SplitInstallSessionState)((Object)this)).zzb());
    }

    public boolean hasTerminalStatus() {
        int n = this.status();
        return n == 0 || n == 5 || n == 6 || n == 7;
    }

    public static SplitInstallSessionState zzd(Bundle bundle) {
        String string = "user_confirmation_intent";
        String string2 = "languages";
        String string3 = "module_names";
        String string4 = "total_bytes_to_download";
        String string5 = "bytes_downloaded";
        String string6 = "error_code";
        String string7 = "status";
        String string8 = "session_id";
        return new zza(bundle.getInt(string8), bundle.getInt(string7), bundle.getInt(string6), bundle.getLong(string5), bundle.getLong(string4), bundle.getStringArrayList(string3), bundle.getStringArrayList(string2), (PendingIntent)bundle.getParcelable(string), bundle.getParcelableArrayList("split_file_intents"));
    }

    @Nullable
    abstract List zza();

    @Nullable
    abstract List zzb();

    @Nullable
    abstract List zzc();
}

