/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.play.core.splitinstall;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.Nullable;
import com.google.android.play.core.splitinstall.internal.zzu;
import com.google.android.play.core.splitinstall.zzbg;
import com.google.android.play.core.splitinstall.zzi;
import com.google.android.play.core.splitinstall.zzk;
import com.google.android.play.core.splitinstall.zzr;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;

public final class zzs {
    private static final zzu zzb = new zzu("SplitInstallInfoProvider");
    private final Context zzc;
    private final String zzd;
    public static final /* synthetic */ int zza;

    @Nullable
    private final PackageInfo zzg() {
        try {
            zzs zzs2 = zzs2.zzc.getPackageManager().getPackageInfo(zzs2.zzd, 128);
            return zzs2;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            zzb.zzb("App is not found in PackageManager", new Object[0]);
            return null;
        }
    }

    @Nullable
    public final zzk zza(@Nullable Bundle bundle) {
        Object object;
        if (bundle == null) {
            object = new Object[]{};
            zzb.zze("No metadata found in Context.", object);
            return null;
        }
        int n = bundle.getInt("com.android.vending.splits");
        if (n == 0) {
            object = new Object[]{};
            zzb.zze("No metadata found in AndroidManifest.", object);
            return null;
        }
        try {
            object = object.zzc.getResources().getXml(n);
        }
        catch (Resources.NotFoundException notFoundException) {
            object = new Object[]{};
            zzb.zze("Resource with languages metadata doesn't exist.", object);
            return null;
        }
        object = zzbg.zza((XmlPullParser)object, new zzi());
        if (object == null) {
            Object[] objectArray = new Object[]{};
            zzb.zze("Can't parse languages metadata.", objectArray);
        }
        return object;
    }

    public static String zzb(String string) {
        if (string.startsWith("config.")) {
            return "";
        }
        return string.split("\\.config\\.", 2)[0];
    }

    public final Set zzc() {
        if ((this = this.zzg()) == null || ((PackageInfo)this).applicationInfo == null) {
            return new HashSet();
        }
        return zzs.zzf((PackageInfo)this);
    }

    @Nullable
    public final Set zzd() {
        PackageInfo object2 = ((zzs)((Object)this)).zzg();
        if (object2 == null || object2.applicationInfo == null) {
            return null;
        }
        if ((this = ((zzs)((Object)this)).zza(object2.applicationInfo.metaData)) == null) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Set set = zzs.zzh(object2);
        set.add("");
        Set set2 = zzs.zzf(object2);
        set2.add("");
        for (Map.Entry entry : ((zzk)((Object)this)).zza(set2).entrySet()) {
            if (!set.containsAll((Collection)entry.getValue())) continue;
            hashSet.add((String)entry.getKey());
        }
        return hashSet;
    }

    zzs(Context context) {
        this.zzc = context;
        this.zzd = context.getPackageName();
    }

    public zzs(Context context, String string) {
        this.zzc = context;
        this.zzd = string;
    }

    public static boolean zze(String string) {
        return string.startsWith("config.") || string.contains(".config.");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Set zzh(PackageInfo object) {
        Object object2 = ((PackageInfo)object).applicationInfo.metaData;
        HashSet hashSet = new HashSet();
        if (object2 != null) {
            if ((object2 = object2.getString("com.android.dynamic.apk.fused.modules")) == null || ((String)object2).isEmpty()) {
                zzb.zza("App has no fused modules.", new Object[0]);
            } else {
                Collections.addAll(hashSet, ((String)object2).split(",", -1));
                hashSet.remove("");
                hashSet.remove("base");
            }
        }
        if (Build.VERSION.SDK_INT < 21) {
            return hashSet;
        }
        object = ((PackageInfo)object).splitNames;
        if (object != null) {
            object2 = new Object[]{Arrays.toString((Object[])object)};
            zzb.zza("Adding splits from package manager: %s", (Object[])object2);
            Collections.addAll(hashSet, object);
        } else {
            object = new Object[]{};
            zzb.zza("No splits are found or app cannot be found in package manager.", (Object[])object);
        }
        if ((object = zzr.zza()) != null) {
            hashSet.addAll(object.zza());
        }
        return hashSet;
    }

    public static final Set zzf(PackageInfo object) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : zzs.zzh((PackageInfo)object)) {
            if (zzs.zze(string)) continue;
            hashSet.add(string);
        }
        return hashSet;
    }
}

