/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-06-10 at 01:25:22 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.storage.model;

/**
 * An access-control list.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Cloud Storage JSON API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BucketAccessControls extends com.google.api.client.json.GenericJson {

  /**
   * The list of items.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<BucketAccessControl> items;

  static {
    // hack to force ProGuard to consider BucketAccessControl used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(BucketAccessControl.class);
  }

  /**
   * The kind of item this is. For lists of bucket access control entries, this is always
   * storage#bucketAccessControls.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The list of items.
   * @return value or {@code null} for none
   */
  public java.util.List<BucketAccessControl> getItems() {
    return items;
  }

  /**
   * The list of items.
   * @param items items or {@code null} for none
   */
  public BucketAccessControls setItems(java.util.List<BucketAccessControl> items) {
    this.items = items;
    return this;
  }

  /**
   * The kind of item this is. For lists of bucket access control entries, this is always
   * storage#bucketAccessControls.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The kind of item this is. For lists of bucket access control entries, this is always
   * storage#bucketAccessControls.
   * @param kind kind or {@code null} for none
   */
  public BucketAccessControls setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  @Override
  public BucketAccessControls set(String fieldName, Object value) {
    return (BucketAccessControls) super.set(fieldName, value);
  }

  @Override
  public BucketAccessControls clone() {
    return (BucketAccessControls) super.clone();
  }

}
