/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.vision.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.vision.v1.VisionRequest;
import com.google.api.services.vision.v1.VisionRequestInitializer;
import com.google.api.services.vision.v1.model.AddProductToProductSetRequest;
import com.google.api.services.vision.v1.model.AsyncBatchAnnotateFilesRequest;
import com.google.api.services.vision.v1.model.AsyncBatchAnnotateImagesRequest;
import com.google.api.services.vision.v1.model.BatchAnnotateFilesRequest;
import com.google.api.services.vision.v1.model.BatchAnnotateFilesResponse;
import com.google.api.services.vision.v1.model.BatchAnnotateImagesRequest;
import com.google.api.services.vision.v1.model.BatchAnnotateImagesResponse;
import com.google.api.services.vision.v1.model.CancelOperationRequest;
import com.google.api.services.vision.v1.model.Empty;
import com.google.api.services.vision.v1.model.ImportProductSetsRequest;
import com.google.api.services.vision.v1.model.ListOperationsResponse;
import com.google.api.services.vision.v1.model.ListProductSetsResponse;
import com.google.api.services.vision.v1.model.ListProductsInProductSetResponse;
import com.google.api.services.vision.v1.model.ListProductsResponse;
import com.google.api.services.vision.v1.model.ListReferenceImagesResponse;
import com.google.api.services.vision.v1.model.Operation;
import com.google.api.services.vision.v1.model.Product;
import com.google.api.services.vision.v1.model.ProductSet;
import com.google.api.services.vision.v1.model.PurgeProductsRequest;
import com.google.api.services.vision.v1.model.ReferenceImage;
import com.google.api.services.vision.v1.model.RemoveProductFromProductSetRequest;
import java.io.IOException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vision
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://vision.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://vision.googleapis.com/";

    public Vision(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Vision(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Files files() {
        return new Files();
    }

    public Images images() {
        return new Images();
    }

    public Locations locations() {
        return new Locations();
    }

    public Operations operations() {
        return new Operations();
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.25.0 of the Cloud Vision API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://vision.googleapis.com/", Vision.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Vision.DEFAULT_BATCH_PATH);
        }

        public Vision build() {
            return new Vision(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setVisionRequestInitializer(VisionRequestInitializer visionRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)visionRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public Files files() {
            return new Files();
        }

        public Images images() {
            return new Images();
        }

        public Locations locations() {
            return new Locations();
        }

        public Operations operations() {
            return new Operations();
        }

        public class Operations {
            public Get get(String string) throws IOException {
                Get get = new Get(string);
                Vision.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends VisionRequest<Operation> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String string) {
                    super(Vision.this, "GET", REST_PATH, null, Operation.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/operations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Vision.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/operations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String string) {
                    if (!Vision.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/operations/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }
        }

        public class Locations {
            public Files files() {
                return new Files();
            }

            public Images images() {
                return new Images();
            }

            public Operations operations() {
                return new Operations();
            }

            public ProductSets productSets() {
                return new ProductSets();
            }

            public Products products() {
                return new Products();
            }

            public class Products {
                public Create create(String string, Product product) throws IOException {
                    Create create = new Create(string, product);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)create);
                    return create;
                }

                public Delete delete(String string) throws IOException {
                    Delete delete = new Delete(string);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)delete);
                    return delete;
                }

                public Get get(String string) throws IOException {
                    Get get = new Get(string);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public List list(String string) throws IOException {
                    List list = new List(string);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                public Patch patch(String string, Product product) throws IOException {
                    Patch patch = new Patch(string, product);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)patch);
                    return patch;
                }

                public Purge purge(String string, PurgeProductsRequest purgeProductsRequest) throws IOException {
                    Purge purge = new Purge(string, purgeProductsRequest);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)purge);
                    return purge;
                }

                public ReferenceImages referenceImages() {
                    return new ReferenceImages();
                }

                public class ReferenceImages {
                    public Create create(String string, ReferenceImage referenceImage) throws IOException {
                        Create create = new Create(string, referenceImage);
                        Vision.this.initialize((AbstractGoogleClientRequest<?>)create);
                        return create;
                    }

                    public Delete delete(String string) throws IOException {
                        Delete delete = new Delete(string);
                        Vision.this.initialize((AbstractGoogleClientRequest<?>)delete);
                        return delete;
                    }

                    public Get get(String string) throws IOException {
                        Get get = new Get(string);
                        Vision.this.initialize((AbstractGoogleClientRequest<?>)get);
                        return get;
                    }

                    public List list(String string) throws IOException {
                        List list = new List(string);
                        Vision.this.initialize((AbstractGoogleClientRequest<?>)list);
                        return list;
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class List
                    extends VisionRequest<ListReferenceImagesResponse> {
                        private static final String REST_PATH = "v1/{+parent}/referenceImages";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String pageToken;
                        @Key
                        private Integer pageSize;

                        protected List(String string) {
                            super(Vision.this, "GET", REST_PATH, null, ListReferenceImagesResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/products/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                            if (!Vision.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/products/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String string) {
                            return (List)super.set$Xgafv(string);
                        }

                        public List setAccessToken(String string) {
                            return (List)super.setAccessToken(string);
                        }

                        public List setAlt(String string) {
                            return (List)super.setAlt(string);
                        }

                        public List setCallback(String string) {
                            return (List)super.setCallback(string);
                        }

                        public List setFields(String string) {
                            return (List)super.setFields(string);
                        }

                        public List setKey(String string) {
                            return (List)super.setKey(string);
                        }

                        public List setOauthToken(String string) {
                            return (List)super.setOauthToken(string);
                        }

                        public List setPrettyPrint(Boolean bl) {
                            return (List)super.setPrettyPrint(bl);
                        }

                        public List setQuotaUser(String string) {
                            return (List)super.setQuotaUser(string);
                        }

                        public List setUploadType(String string) {
                            return (List)super.setUploadType(string);
                        }

                        public List setUploadProtocol(String string) {
                            return (List)super.setUploadProtocol(string);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String string) {
                            if (!Vision.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/products/[^/]+$");
                            }
                            this.parent = string;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String string) {
                            this.pageToken = string;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer n) {
                            this.pageSize = n;
                            return this;
                        }

                        @Override
                        public List set(String string, Object object) {
                            return (List)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Get
                    extends VisionRequest<ReferenceImage> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Get(String string) {
                            super(Vision.this, "GET", REST_PATH, null, ReferenceImage.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/products/[^/]+/referenceImages/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                            if (!Vision.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/products/[^/]+/referenceImages/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String string) {
                            return (Get)super.set$Xgafv(string);
                        }

                        public Get setAccessToken(String string) {
                            return (Get)super.setAccessToken(string);
                        }

                        public Get setAlt(String string) {
                            return (Get)super.setAlt(string);
                        }

                        public Get setCallback(String string) {
                            return (Get)super.setCallback(string);
                        }

                        public Get setFields(String string) {
                            return (Get)super.setFields(string);
                        }

                        public Get setKey(String string) {
                            return (Get)super.setKey(string);
                        }

                        public Get setOauthToken(String string) {
                            return (Get)super.setOauthToken(string);
                        }

                        public Get setPrettyPrint(Boolean bl) {
                            return (Get)super.setPrettyPrint(bl);
                        }

                        public Get setQuotaUser(String string) {
                            return (Get)super.setQuotaUser(string);
                        }

                        public Get setUploadType(String string) {
                            return (Get)super.setUploadType(string);
                        }

                        public Get setUploadProtocol(String string) {
                            return (Get)super.setUploadProtocol(string);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String string) {
                            if (!Vision.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/products/[^/]+/referenceImages/[^/]+$");
                            }
                            this.name = string;
                            return this;
                        }

                        @Override
                        public Get set(String string, Object object) {
                            return (Get)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Delete
                    extends VisionRequest<Empty> {
                        private static final String REST_PATH = "v1/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Delete(String string) {
                            super(Vision.this, "DELETE", REST_PATH, null, Empty.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/products/[^/]+/referenceImages/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                            if (!Vision.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/products/[^/]+/referenceImages/[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String string) {
                            return (Delete)super.set$Xgafv(string);
                        }

                        public Delete setAccessToken(String string) {
                            return (Delete)super.setAccessToken(string);
                        }

                        public Delete setAlt(String string) {
                            return (Delete)super.setAlt(string);
                        }

                        public Delete setCallback(String string) {
                            return (Delete)super.setCallback(string);
                        }

                        public Delete setFields(String string) {
                            return (Delete)super.setFields(string);
                        }

                        public Delete setKey(String string) {
                            return (Delete)super.setKey(string);
                        }

                        public Delete setOauthToken(String string) {
                            return (Delete)super.setOauthToken(string);
                        }

                        public Delete setPrettyPrint(Boolean bl) {
                            return (Delete)super.setPrettyPrint(bl);
                        }

                        public Delete setQuotaUser(String string) {
                            return (Delete)super.setQuotaUser(string);
                        }

                        public Delete setUploadType(String string) {
                            return (Delete)super.setUploadType(string);
                        }

                        public Delete setUploadProtocol(String string) {
                            return (Delete)super.setUploadProtocol(string);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Delete setName(String string) {
                            if (!Vision.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/products/[^/]+/referenceImages/[^/]+$");
                            }
                            this.name = string;
                            return this;
                        }

                        @Override
                        public Delete set(String string, Object object) {
                            return (Delete)super.set(string, object);
                        }
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class Create
                    extends VisionRequest<ReferenceImage> {
                        private static final String REST_PATH = "v1/{+parent}/referenceImages";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String referenceImageId;

                        protected Create(String string, ReferenceImage referenceImage) {
                            super(Vision.this, "POST", REST_PATH, (Object)referenceImage, ReferenceImage.class);
                            this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/products/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                            if (!Vision.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/products/[^/]+$");
                            }
                        }

                        public Create set$Xgafv(String string) {
                            return (Create)super.set$Xgafv(string);
                        }

                        public Create setAccessToken(String string) {
                            return (Create)super.setAccessToken(string);
                        }

                        public Create setAlt(String string) {
                            return (Create)super.setAlt(string);
                        }

                        public Create setCallback(String string) {
                            return (Create)super.setCallback(string);
                        }

                        public Create setFields(String string) {
                            return (Create)super.setFields(string);
                        }

                        public Create setKey(String string) {
                            return (Create)super.setKey(string);
                        }

                        public Create setOauthToken(String string) {
                            return (Create)super.setOauthToken(string);
                        }

                        public Create setPrettyPrint(Boolean bl) {
                            return (Create)super.setPrettyPrint(bl);
                        }

                        public Create setQuotaUser(String string) {
                            return (Create)super.setQuotaUser(string);
                        }

                        public Create setUploadType(String string) {
                            return (Create)super.setUploadType(string);
                        }

                        public Create setUploadProtocol(String string) {
                            return (Create)super.setUploadProtocol(string);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Create setParent(String string) {
                            if (!Vision.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+/products/[^/]+$");
                            }
                            this.parent = string;
                            return this;
                        }

                        public String getReferenceImageId() {
                            return this.referenceImageId;
                        }

                        public Create setReferenceImageId(String string) {
                            this.referenceImageId = string;
                            return this;
                        }

                        @Override
                        public Create set(String string, Object object) {
                            return (Create)super.set(string, object);
                        }
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Purge
                extends VisionRequest<Operation> {
                    private static final String REST_PATH = "v1/{+parent}/products:purge";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected Purge(String string, PurgeProductsRequest purgeProductsRequest) {
                        super(Vision.this, "POST", REST_PATH, (Object)purgeProductsRequest, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Purge set$Xgafv(String string) {
                        return (Purge)super.set$Xgafv(string);
                    }

                    public Purge setAccessToken(String string) {
                        return (Purge)super.setAccessToken(string);
                    }

                    public Purge setAlt(String string) {
                        return (Purge)super.setAlt(string);
                    }

                    public Purge setCallback(String string) {
                        return (Purge)super.setCallback(string);
                    }

                    public Purge setFields(String string) {
                        return (Purge)super.setFields(string);
                    }

                    public Purge setKey(String string) {
                        return (Purge)super.setKey(string);
                    }

                    public Purge setOauthToken(String string) {
                        return (Purge)super.setOauthToken(string);
                    }

                    public Purge setPrettyPrint(Boolean bl) {
                        return (Purge)super.setPrettyPrint(bl);
                    }

                    public Purge setQuotaUser(String string) {
                        return (Purge)super.setQuotaUser(string);
                    }

                    public Purge setUploadType(String string) {
                        return (Purge)super.setUploadType(string);
                    }

                    public Purge setUploadProtocol(String string) {
                        return (Purge)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Purge setParent(String string) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = string;
                        return this;
                    }

                    @Override
                    public Purge set(String string, Object object) {
                        return (Purge)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Patch
                extends VisionRequest<Product> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String updateMask;

                    protected Patch(String string, Product product) {
                        super(Vision.this, "PATCH", REST_PATH, (Object)product, Product.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/products/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/products/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String string) {
                        return (Patch)super.set$Xgafv(string);
                    }

                    public Patch setAccessToken(String string) {
                        return (Patch)super.setAccessToken(string);
                    }

                    public Patch setAlt(String string) {
                        return (Patch)super.setAlt(string);
                    }

                    public Patch setCallback(String string) {
                        return (Patch)super.setCallback(string);
                    }

                    public Patch setFields(String string) {
                        return (Patch)super.setFields(string);
                    }

                    public Patch setKey(String string) {
                        return (Patch)super.setKey(string);
                    }

                    public Patch setOauthToken(String string) {
                        return (Patch)super.setOauthToken(string);
                    }

                    public Patch setPrettyPrint(Boolean bl) {
                        return (Patch)super.setPrettyPrint(bl);
                    }

                    public Patch setQuotaUser(String string) {
                        return (Patch)super.setQuotaUser(string);
                    }

                    public Patch setUploadType(String string) {
                        return (Patch)super.setUploadType(string);
                    }

                    public Patch setUploadProtocol(String string) {
                        return (Patch)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String string) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/products/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String string) {
                        this.updateMask = string;
                        return this;
                    }

                    @Override
                    public Patch set(String string, Object object) {
                        return (Patch)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends VisionRequest<ListProductsResponse> {
                    private static final String REST_PATH = "v1/{+parent}/products";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String pageToken;
                    @Key
                    private Integer pageSize;

                    protected List(String string) {
                        super(Vision.this, "GET", REST_PATH, null, ListProductsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String string) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = string;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String string) {
                        this.pageToken = string;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer n) {
                        this.pageSize = n;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends VisionRequest<Product> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String string) {
                        super(Vision.this, "GET", REST_PATH, null, Product.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/products/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/products/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String string) {
                        return (Get)super.set$Xgafv(string);
                    }

                    public Get setAccessToken(String string) {
                        return (Get)super.setAccessToken(string);
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setCallback(String string) {
                        return (Get)super.setCallback(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUploadType(String string) {
                        return (Get)super.setUploadType(string);
                    }

                    public Get setUploadProtocol(String string) {
                        return (Get)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String string) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/products/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Delete
                extends VisionRequest<Empty> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String string) {
                        super(Vision.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/products/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/products/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String string) {
                        return (Delete)super.set$Xgafv(string);
                    }

                    public Delete setAccessToken(String string) {
                        return (Delete)super.setAccessToken(string);
                    }

                    public Delete setAlt(String string) {
                        return (Delete)super.setAlt(string);
                    }

                    public Delete setCallback(String string) {
                        return (Delete)super.setCallback(string);
                    }

                    public Delete setFields(String string) {
                        return (Delete)super.setFields(string);
                    }

                    public Delete setKey(String string) {
                        return (Delete)super.setKey(string);
                    }

                    public Delete setOauthToken(String string) {
                        return (Delete)super.setOauthToken(string);
                    }

                    public Delete setPrettyPrint(Boolean bl) {
                        return (Delete)super.setPrettyPrint(bl);
                    }

                    public Delete setQuotaUser(String string) {
                        return (Delete)super.setQuotaUser(string);
                    }

                    public Delete setUploadType(String string) {
                        return (Delete)super.setUploadType(string);
                    }

                    public Delete setUploadProtocol(String string) {
                        return (Delete)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String string) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/products/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Delete set(String string, Object object) {
                        return (Delete)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Create
                extends VisionRequest<Product> {
                    private static final String REST_PATH = "v1/{+parent}/products";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String productId;

                    protected Create(String string, Product product) {
                        super(Vision.this, "POST", REST_PATH, (Object)product, Product.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String string) {
                        return (Create)super.set$Xgafv(string);
                    }

                    public Create setAccessToken(String string) {
                        return (Create)super.setAccessToken(string);
                    }

                    public Create setAlt(String string) {
                        return (Create)super.setAlt(string);
                    }

                    public Create setCallback(String string) {
                        return (Create)super.setCallback(string);
                    }

                    public Create setFields(String string) {
                        return (Create)super.setFields(string);
                    }

                    public Create setKey(String string) {
                        return (Create)super.setKey(string);
                    }

                    public Create setOauthToken(String string) {
                        return (Create)super.setOauthToken(string);
                    }

                    public Create setPrettyPrint(Boolean bl) {
                        return (Create)super.setPrettyPrint(bl);
                    }

                    public Create setQuotaUser(String string) {
                        return (Create)super.setQuotaUser(string);
                    }

                    public Create setUploadType(String string) {
                        return (Create)super.setUploadType(string);
                    }

                    public Create setUploadProtocol(String string) {
                        return (Create)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String string) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = string;
                        return this;
                    }

                    public String getProductId() {
                        return this.productId;
                    }

                    public Create setProductId(String string) {
                        this.productId = string;
                        return this;
                    }

                    @Override
                    public Create set(String string, Object object) {
                        return (Create)super.set(string, object);
                    }
                }
            }

            public class ProductSets {
                public AddProduct addProduct(String string, AddProductToProductSetRequest addProductToProductSetRequest) throws IOException {
                    AddProduct addProduct = new AddProduct(string, addProductToProductSetRequest);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)addProduct);
                    return addProduct;
                }

                public Create create(String string, ProductSet productSet) throws IOException {
                    Create create = new Create(string, productSet);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)create);
                    return create;
                }

                public Delete delete(String string) throws IOException {
                    Delete delete = new Delete(string);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)delete);
                    return delete;
                }

                public Get get(String string) throws IOException {
                    Get get = new Get(string);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public VisionImport visionImport(String string, ImportProductSetsRequest importProductSetsRequest) throws IOException {
                    VisionImport visionImport = new VisionImport(string, importProductSetsRequest);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)visionImport);
                    return visionImport;
                }

                public List list(String string) throws IOException {
                    List list = new List(string);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                public Patch patch(String string, ProductSet productSet) throws IOException {
                    Patch patch = new Patch(string, productSet);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)patch);
                    return patch;
                }

                public RemoveProduct removeProduct(String string, RemoveProductFromProductSetRequest removeProductFromProductSetRequest) throws IOException {
                    RemoveProduct removeProduct = new RemoveProduct(string, removeProductFromProductSetRequest);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)removeProduct);
                    return removeProduct;
                }

                public Products products() {
                    return new Products();
                }

                public class Products {
                    public List list(String string) throws IOException {
                        List list = new List(string);
                        Vision.this.initialize((AbstractGoogleClientRequest<?>)list);
                        return list;
                    }

                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    public class List
                    extends VisionRequest<ListProductsInProductSetResponse> {
                        private static final String REST_PATH = "v1/{+name}/products";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private String pageToken;
                        @Key
                        private Integer pageSize;

                        protected List(String string) {
                            super(Vision.this, "GET", REST_PATH, null, ListProductsInProductSetResponse.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                            if (!Vision.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String string) {
                            return (List)super.set$Xgafv(string);
                        }

                        public List setAccessToken(String string) {
                            return (List)super.setAccessToken(string);
                        }

                        public List setAlt(String string) {
                            return (List)super.setAlt(string);
                        }

                        public List setCallback(String string) {
                            return (List)super.setCallback(string);
                        }

                        public List setFields(String string) {
                            return (List)super.setFields(string);
                        }

                        public List setKey(String string) {
                            return (List)super.setKey(string);
                        }

                        public List setOauthToken(String string) {
                            return (List)super.setOauthToken(string);
                        }

                        public List setPrettyPrint(Boolean bl) {
                            return (List)super.setPrettyPrint(bl);
                        }

                        public List setQuotaUser(String string) {
                            return (List)super.setQuotaUser(string);
                        }

                        public List setUploadType(String string) {
                            return (List)super.setUploadType(string);
                        }

                        public List setUploadProtocol(String string) {
                            return (List)super.setUploadProtocol(string);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public List setName(String string) {
                            if (!Vision.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                            }
                            this.name = string;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String string) {
                            this.pageToken = string;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer n) {
                            this.pageSize = n;
                            return this;
                        }

                        @Override
                        public List set(String string, Object object) {
                            return (List)super.set(string, object);
                        }
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class RemoveProduct
                extends VisionRequest<Empty> {
                    private static final String REST_PATH = "v1/{+name}:removeProduct";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected RemoveProduct(String string, RemoveProductFromProductSetRequest removeProductFromProductSetRequest) {
                        super(Vision.this, "POST", REST_PATH, (Object)removeProductFromProductSetRequest, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                        }
                    }

                    public RemoveProduct set$Xgafv(String string) {
                        return (RemoveProduct)super.set$Xgafv(string);
                    }

                    public RemoveProduct setAccessToken(String string) {
                        return (RemoveProduct)super.setAccessToken(string);
                    }

                    public RemoveProduct setAlt(String string) {
                        return (RemoveProduct)super.setAlt(string);
                    }

                    public RemoveProduct setCallback(String string) {
                        return (RemoveProduct)super.setCallback(string);
                    }

                    public RemoveProduct setFields(String string) {
                        return (RemoveProduct)super.setFields(string);
                    }

                    public RemoveProduct setKey(String string) {
                        return (RemoveProduct)super.setKey(string);
                    }

                    public RemoveProduct setOauthToken(String string) {
                        return (RemoveProduct)super.setOauthToken(string);
                    }

                    public RemoveProduct setPrettyPrint(Boolean bl) {
                        return (RemoveProduct)super.setPrettyPrint(bl);
                    }

                    public RemoveProduct setQuotaUser(String string) {
                        return (RemoveProduct)super.setQuotaUser(string);
                    }

                    public RemoveProduct setUploadType(String string) {
                        return (RemoveProduct)super.setUploadType(string);
                    }

                    public RemoveProduct setUploadProtocol(String string) {
                        return (RemoveProduct)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public RemoveProduct setName(String string) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public RemoveProduct set(String string, Object object) {
                        return (RemoveProduct)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Patch
                extends VisionRequest<ProductSet> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String updateMask;

                    protected Patch(String string, ProductSet productSet) {
                        super(Vision.this, "PATCH", REST_PATH, (Object)productSet, ProductSet.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String string) {
                        return (Patch)super.set$Xgafv(string);
                    }

                    public Patch setAccessToken(String string) {
                        return (Patch)super.setAccessToken(string);
                    }

                    public Patch setAlt(String string) {
                        return (Patch)super.setAlt(string);
                    }

                    public Patch setCallback(String string) {
                        return (Patch)super.setCallback(string);
                    }

                    public Patch setFields(String string) {
                        return (Patch)super.setFields(string);
                    }

                    public Patch setKey(String string) {
                        return (Patch)super.setKey(string);
                    }

                    public Patch setOauthToken(String string) {
                        return (Patch)super.setOauthToken(string);
                    }

                    public Patch setPrettyPrint(Boolean bl) {
                        return (Patch)super.setPrettyPrint(bl);
                    }

                    public Patch setQuotaUser(String string) {
                        return (Patch)super.setQuotaUser(string);
                    }

                    public Patch setUploadType(String string) {
                        return (Patch)super.setUploadType(string);
                    }

                    public Patch setUploadProtocol(String string) {
                        return (Patch)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String string) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String string) {
                        this.updateMask = string;
                        return this;
                    }

                    @Override
                    public Patch set(String string, Object object) {
                        return (Patch)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends VisionRequest<ListProductSetsResponse> {
                    private static final String REST_PATH = "v1/{+parent}/productSets";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String pageToken;
                    @Key
                    private Integer pageSize;

                    protected List(String string) {
                        super(Vision.this, "GET", REST_PATH, null, ListProductSetsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String string) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = string;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String string) {
                        this.pageToken = string;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer n) {
                        this.pageSize = n;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class VisionImport
                extends VisionRequest<Operation> {
                    private static final String REST_PATH = "v1/{+parent}/productSets:import";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected VisionImport(String string, ImportProductSetsRequest importProductSetsRequest) {
                        super(Vision.this, "POST", REST_PATH, (Object)importProductSetsRequest, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public VisionImport set$Xgafv(String string) {
                        return (VisionImport)super.set$Xgafv(string);
                    }

                    public VisionImport setAccessToken(String string) {
                        return (VisionImport)super.setAccessToken(string);
                    }

                    public VisionImport setAlt(String string) {
                        return (VisionImport)super.setAlt(string);
                    }

                    public VisionImport setCallback(String string) {
                        return (VisionImport)super.setCallback(string);
                    }

                    public VisionImport setFields(String string) {
                        return (VisionImport)super.setFields(string);
                    }

                    public VisionImport setKey(String string) {
                        return (VisionImport)super.setKey(string);
                    }

                    public VisionImport setOauthToken(String string) {
                        return (VisionImport)super.setOauthToken(string);
                    }

                    public VisionImport setPrettyPrint(Boolean bl) {
                        return (VisionImport)super.setPrettyPrint(bl);
                    }

                    public VisionImport setQuotaUser(String string) {
                        return (VisionImport)super.setQuotaUser(string);
                    }

                    public VisionImport setUploadType(String string) {
                        return (VisionImport)super.setUploadType(string);
                    }

                    public VisionImport setUploadProtocol(String string) {
                        return (VisionImport)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public VisionImport setParent(String string) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = string;
                        return this;
                    }

                    @Override
                    public VisionImport set(String string, Object object) {
                        return (VisionImport)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends VisionRequest<ProductSet> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String string) {
                        super(Vision.this, "GET", REST_PATH, null, ProductSet.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String string) {
                        return (Get)super.set$Xgafv(string);
                    }

                    public Get setAccessToken(String string) {
                        return (Get)super.setAccessToken(string);
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setCallback(String string) {
                        return (Get)super.setCallback(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUploadType(String string) {
                        return (Get)super.setUploadType(string);
                    }

                    public Get setUploadProtocol(String string) {
                        return (Get)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String string) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Delete
                extends VisionRequest<Empty> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String string) {
                        super(Vision.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String string) {
                        return (Delete)super.set$Xgafv(string);
                    }

                    public Delete setAccessToken(String string) {
                        return (Delete)super.setAccessToken(string);
                    }

                    public Delete setAlt(String string) {
                        return (Delete)super.setAlt(string);
                    }

                    public Delete setCallback(String string) {
                        return (Delete)super.setCallback(string);
                    }

                    public Delete setFields(String string) {
                        return (Delete)super.setFields(string);
                    }

                    public Delete setKey(String string) {
                        return (Delete)super.setKey(string);
                    }

                    public Delete setOauthToken(String string) {
                        return (Delete)super.setOauthToken(string);
                    }

                    public Delete setPrettyPrint(Boolean bl) {
                        return (Delete)super.setPrettyPrint(bl);
                    }

                    public Delete setQuotaUser(String string) {
                        return (Delete)super.setQuotaUser(string);
                    }

                    public Delete setUploadType(String string) {
                        return (Delete)super.setUploadType(string);
                    }

                    public Delete setUploadProtocol(String string) {
                        return (Delete)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String string) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Delete set(String string, Object object) {
                        return (Delete)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Create
                extends VisionRequest<ProductSet> {
                    private static final String REST_PATH = "v1/{+parent}/productSets";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String productSetId;

                    protected Create(String string, ProductSet productSet) {
                        super(Vision.this, "POST", REST_PATH, (Object)productSet, ProductSet.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String string) {
                        return (Create)super.set$Xgafv(string);
                    }

                    public Create setAccessToken(String string) {
                        return (Create)super.setAccessToken(string);
                    }

                    public Create setAlt(String string) {
                        return (Create)super.setAlt(string);
                    }

                    public Create setCallback(String string) {
                        return (Create)super.setCallback(string);
                    }

                    public Create setFields(String string) {
                        return (Create)super.setFields(string);
                    }

                    public Create setKey(String string) {
                        return (Create)super.setKey(string);
                    }

                    public Create setOauthToken(String string) {
                        return (Create)super.setOauthToken(string);
                    }

                    public Create setPrettyPrint(Boolean bl) {
                        return (Create)super.setPrettyPrint(bl);
                    }

                    public Create setQuotaUser(String string) {
                        return (Create)super.setQuotaUser(string);
                    }

                    public Create setUploadType(String string) {
                        return (Create)super.setUploadType(string);
                    }

                    public Create setUploadProtocol(String string) {
                        return (Create)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String string) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = string;
                        return this;
                    }

                    public String getProductSetId() {
                        return this.productSetId;
                    }

                    public Create setProductSetId(String string) {
                        this.productSetId = string;
                        return this;
                    }

                    @Override
                    public Create set(String string, Object object) {
                        return (Create)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class AddProduct
                extends VisionRequest<Empty> {
                    private static final String REST_PATH = "v1/{+name}:addProduct";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected AddProduct(String string, AddProductToProductSetRequest addProductToProductSetRequest) {
                        super(Vision.this, "POST", REST_PATH, (Object)addProductToProductSetRequest, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                        }
                    }

                    public AddProduct set$Xgafv(String string) {
                        return (AddProduct)super.set$Xgafv(string);
                    }

                    public AddProduct setAccessToken(String string) {
                        return (AddProduct)super.setAccessToken(string);
                    }

                    public AddProduct setAlt(String string) {
                        return (AddProduct)super.setAlt(string);
                    }

                    public AddProduct setCallback(String string) {
                        return (AddProduct)super.setCallback(string);
                    }

                    public AddProduct setFields(String string) {
                        return (AddProduct)super.setFields(string);
                    }

                    public AddProduct setKey(String string) {
                        return (AddProduct)super.setKey(string);
                    }

                    public AddProduct setOauthToken(String string) {
                        return (AddProduct)super.setOauthToken(string);
                    }

                    public AddProduct setPrettyPrint(Boolean bl) {
                        return (AddProduct)super.setPrettyPrint(bl);
                    }

                    public AddProduct setQuotaUser(String string) {
                        return (AddProduct)super.setQuotaUser(string);
                    }

                    public AddProduct setUploadType(String string) {
                        return (AddProduct)super.setUploadType(string);
                    }

                    public AddProduct setUploadProtocol(String string) {
                        return (AddProduct)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public AddProduct setName(String string) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/productSets/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public AddProduct set(String string, Object object) {
                        return (AddProduct)super.set(string, object);
                    }
                }
            }

            public class Operations {
                public Get get(String string) throws IOException {
                    Get get = new Get(string);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends VisionRequest<Operation> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String string) {
                        super(Vision.this, "GET", REST_PATH, null, Operation.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String string) {
                        return (Get)super.set$Xgafv(string);
                    }

                    public Get setAccessToken(String string) {
                        return (Get)super.setAccessToken(string);
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setCallback(String string) {
                        return (Get)super.setCallback(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUploadType(String string) {
                        return (Get)super.setUploadType(string);
                    }

                    public Get setUploadProtocol(String string) {
                        return (Get)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String string) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/locations/[^/]+/operations/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }
            }

            public class Images {
                public Annotate annotate(String string, BatchAnnotateImagesRequest batchAnnotateImagesRequest) throws IOException {
                    Annotate annotate = new Annotate(string, batchAnnotateImagesRequest);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)annotate);
                    return annotate;
                }

                public AsyncBatchAnnotate asyncBatchAnnotate(String string, AsyncBatchAnnotateImagesRequest asyncBatchAnnotateImagesRequest) throws IOException {
                    AsyncBatchAnnotate asyncBatchAnnotate = new AsyncBatchAnnotate(string, asyncBatchAnnotateImagesRequest);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)asyncBatchAnnotate);
                    return asyncBatchAnnotate;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class AsyncBatchAnnotate
                extends VisionRequest<Operation> {
                    private static final String REST_PATH = "v1/{+parent}/images:asyncBatchAnnotate";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected AsyncBatchAnnotate(String string, AsyncBatchAnnotateImagesRequest asyncBatchAnnotateImagesRequest) {
                        super(Vision.this, "POST", REST_PATH, (Object)asyncBatchAnnotateImagesRequest, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public AsyncBatchAnnotate set$Xgafv(String string) {
                        return (AsyncBatchAnnotate)super.set$Xgafv(string);
                    }

                    public AsyncBatchAnnotate setAccessToken(String string) {
                        return (AsyncBatchAnnotate)super.setAccessToken(string);
                    }

                    public AsyncBatchAnnotate setAlt(String string) {
                        return (AsyncBatchAnnotate)super.setAlt(string);
                    }

                    public AsyncBatchAnnotate setCallback(String string) {
                        return (AsyncBatchAnnotate)super.setCallback(string);
                    }

                    public AsyncBatchAnnotate setFields(String string) {
                        return (AsyncBatchAnnotate)super.setFields(string);
                    }

                    public AsyncBatchAnnotate setKey(String string) {
                        return (AsyncBatchAnnotate)super.setKey(string);
                    }

                    public AsyncBatchAnnotate setOauthToken(String string) {
                        return (AsyncBatchAnnotate)super.setOauthToken(string);
                    }

                    public AsyncBatchAnnotate setPrettyPrint(Boolean bl) {
                        return (AsyncBatchAnnotate)super.setPrettyPrint(bl);
                    }

                    public AsyncBatchAnnotate setQuotaUser(String string) {
                        return (AsyncBatchAnnotate)super.setQuotaUser(string);
                    }

                    public AsyncBatchAnnotate setUploadType(String string) {
                        return (AsyncBatchAnnotate)super.setUploadType(string);
                    }

                    public AsyncBatchAnnotate setUploadProtocol(String string) {
                        return (AsyncBatchAnnotate)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public AsyncBatchAnnotate setParent(String string) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = string;
                        return this;
                    }

                    @Override
                    public AsyncBatchAnnotate set(String string, Object object) {
                        return (AsyncBatchAnnotate)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Annotate
                extends VisionRequest<BatchAnnotateImagesResponse> {
                    private static final String REST_PATH = "v1/{+parent}/images:annotate";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected Annotate(String string, BatchAnnotateImagesRequest batchAnnotateImagesRequest) {
                        super(Vision.this, "POST", REST_PATH, (Object)batchAnnotateImagesRequest, BatchAnnotateImagesResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Annotate set$Xgafv(String string) {
                        return (Annotate)super.set$Xgafv(string);
                    }

                    public Annotate setAccessToken(String string) {
                        return (Annotate)super.setAccessToken(string);
                    }

                    public Annotate setAlt(String string) {
                        return (Annotate)super.setAlt(string);
                    }

                    public Annotate setCallback(String string) {
                        return (Annotate)super.setCallback(string);
                    }

                    public Annotate setFields(String string) {
                        return (Annotate)super.setFields(string);
                    }

                    public Annotate setKey(String string) {
                        return (Annotate)super.setKey(string);
                    }

                    public Annotate setOauthToken(String string) {
                        return (Annotate)super.setOauthToken(string);
                    }

                    public Annotate setPrettyPrint(Boolean bl) {
                        return (Annotate)super.setPrettyPrint(bl);
                    }

                    public Annotate setQuotaUser(String string) {
                        return (Annotate)super.setQuotaUser(string);
                    }

                    public Annotate setUploadType(String string) {
                        return (Annotate)super.setUploadType(string);
                    }

                    public Annotate setUploadProtocol(String string) {
                        return (Annotate)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Annotate setParent(String string) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = string;
                        return this;
                    }

                    @Override
                    public Annotate set(String string, Object object) {
                        return (Annotate)super.set(string, object);
                    }
                }
            }

            public class Files {
                public Annotate annotate(String string, BatchAnnotateFilesRequest batchAnnotateFilesRequest) throws IOException {
                    Annotate annotate = new Annotate(string, batchAnnotateFilesRequest);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)annotate);
                    return annotate;
                }

                public AsyncBatchAnnotate asyncBatchAnnotate(String string, AsyncBatchAnnotateFilesRequest asyncBatchAnnotateFilesRequest) throws IOException {
                    AsyncBatchAnnotate asyncBatchAnnotate = new AsyncBatchAnnotate(string, asyncBatchAnnotateFilesRequest);
                    Vision.this.initialize((AbstractGoogleClientRequest<?>)asyncBatchAnnotate);
                    return asyncBatchAnnotate;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class AsyncBatchAnnotate
                extends VisionRequest<Operation> {
                    private static final String REST_PATH = "v1/{+parent}/files:asyncBatchAnnotate";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected AsyncBatchAnnotate(String string, AsyncBatchAnnotateFilesRequest asyncBatchAnnotateFilesRequest) {
                        super(Vision.this, "POST", REST_PATH, (Object)asyncBatchAnnotateFilesRequest, Operation.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public AsyncBatchAnnotate set$Xgafv(String string) {
                        return (AsyncBatchAnnotate)super.set$Xgafv(string);
                    }

                    public AsyncBatchAnnotate setAccessToken(String string) {
                        return (AsyncBatchAnnotate)super.setAccessToken(string);
                    }

                    public AsyncBatchAnnotate setAlt(String string) {
                        return (AsyncBatchAnnotate)super.setAlt(string);
                    }

                    public AsyncBatchAnnotate setCallback(String string) {
                        return (AsyncBatchAnnotate)super.setCallback(string);
                    }

                    public AsyncBatchAnnotate setFields(String string) {
                        return (AsyncBatchAnnotate)super.setFields(string);
                    }

                    public AsyncBatchAnnotate setKey(String string) {
                        return (AsyncBatchAnnotate)super.setKey(string);
                    }

                    public AsyncBatchAnnotate setOauthToken(String string) {
                        return (AsyncBatchAnnotate)super.setOauthToken(string);
                    }

                    public AsyncBatchAnnotate setPrettyPrint(Boolean bl) {
                        return (AsyncBatchAnnotate)super.setPrettyPrint(bl);
                    }

                    public AsyncBatchAnnotate setQuotaUser(String string) {
                        return (AsyncBatchAnnotate)super.setQuotaUser(string);
                    }

                    public AsyncBatchAnnotate setUploadType(String string) {
                        return (AsyncBatchAnnotate)super.setUploadType(string);
                    }

                    public AsyncBatchAnnotate setUploadProtocol(String string) {
                        return (AsyncBatchAnnotate)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public AsyncBatchAnnotate setParent(String string) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = string;
                        return this;
                    }

                    @Override
                    public AsyncBatchAnnotate set(String string, Object object) {
                        return (AsyncBatchAnnotate)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Annotate
                extends VisionRequest<BatchAnnotateFilesResponse> {
                    private static final String REST_PATH = "v1/{+parent}/files:annotate";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected Annotate(String string, BatchAnnotateFilesRequest batchAnnotateFilesRequest) {
                        super(Vision.this, "POST", REST_PATH, (Object)batchAnnotateFilesRequest, BatchAnnotateFilesResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Annotate set$Xgafv(String string) {
                        return (Annotate)super.set$Xgafv(string);
                    }

                    public Annotate setAccessToken(String string) {
                        return (Annotate)super.setAccessToken(string);
                    }

                    public Annotate setAlt(String string) {
                        return (Annotate)super.setAlt(string);
                    }

                    public Annotate setCallback(String string) {
                        return (Annotate)super.setCallback(string);
                    }

                    public Annotate setFields(String string) {
                        return (Annotate)super.setFields(string);
                    }

                    public Annotate setKey(String string) {
                        return (Annotate)super.setKey(string);
                    }

                    public Annotate setOauthToken(String string) {
                        return (Annotate)super.setOauthToken(string);
                    }

                    public Annotate setPrettyPrint(Boolean bl) {
                        return (Annotate)super.setPrettyPrint(bl);
                    }

                    public Annotate setQuotaUser(String string) {
                        return (Annotate)super.setQuotaUser(string);
                    }

                    public Annotate setUploadType(String string) {
                        return (Annotate)super.setUploadType(string);
                    }

                    public Annotate setUploadProtocol(String string) {
                        return (Annotate)super.setUploadProtocol(string);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Annotate setParent(String string) {
                        if (!Vision.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+/locations/[^/]+$");
                        }
                        this.parent = string;
                        return this;
                    }

                    @Override
                    public Annotate set(String string, Object object) {
                        return (Annotate)super.set(string, object);
                    }
                }
            }
        }

        public class Images {
            public Annotate annotate(String string, BatchAnnotateImagesRequest batchAnnotateImagesRequest) throws IOException {
                Annotate annotate = new Annotate(string, batchAnnotateImagesRequest);
                Vision.this.initialize((AbstractGoogleClientRequest<?>)annotate);
                return annotate;
            }

            public AsyncBatchAnnotate asyncBatchAnnotate(String string, AsyncBatchAnnotateImagesRequest asyncBatchAnnotateImagesRequest) throws IOException {
                AsyncBatchAnnotate asyncBatchAnnotate = new AsyncBatchAnnotate(string, asyncBatchAnnotateImagesRequest);
                Vision.this.initialize((AbstractGoogleClientRequest<?>)asyncBatchAnnotate);
                return asyncBatchAnnotate;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class AsyncBatchAnnotate
            extends VisionRequest<Operation> {
                private static final String REST_PATH = "v1/{+parent}/images:asyncBatchAnnotate";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected AsyncBatchAnnotate(String string, AsyncBatchAnnotateImagesRequest asyncBatchAnnotateImagesRequest) {
                    super(Vision.this, "POST", REST_PATH, (Object)asyncBatchAnnotateImagesRequest, Operation.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Vision.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public AsyncBatchAnnotate set$Xgafv(String string) {
                    return (AsyncBatchAnnotate)super.set$Xgafv(string);
                }

                public AsyncBatchAnnotate setAccessToken(String string) {
                    return (AsyncBatchAnnotate)super.setAccessToken(string);
                }

                public AsyncBatchAnnotate setAlt(String string) {
                    return (AsyncBatchAnnotate)super.setAlt(string);
                }

                public AsyncBatchAnnotate setCallback(String string) {
                    return (AsyncBatchAnnotate)super.setCallback(string);
                }

                public AsyncBatchAnnotate setFields(String string) {
                    return (AsyncBatchAnnotate)super.setFields(string);
                }

                public AsyncBatchAnnotate setKey(String string) {
                    return (AsyncBatchAnnotate)super.setKey(string);
                }

                public AsyncBatchAnnotate setOauthToken(String string) {
                    return (AsyncBatchAnnotate)super.setOauthToken(string);
                }

                public AsyncBatchAnnotate setPrettyPrint(Boolean bl) {
                    return (AsyncBatchAnnotate)super.setPrettyPrint(bl);
                }

                public AsyncBatchAnnotate setQuotaUser(String string) {
                    return (AsyncBatchAnnotate)super.setQuotaUser(string);
                }

                public AsyncBatchAnnotate setUploadType(String string) {
                    return (AsyncBatchAnnotate)super.setUploadType(string);
                }

                public AsyncBatchAnnotate setUploadProtocol(String string) {
                    return (AsyncBatchAnnotate)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public AsyncBatchAnnotate setParent(String string) {
                    if (!Vision.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                @Override
                public AsyncBatchAnnotate set(String string, Object object) {
                    return (AsyncBatchAnnotate)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Annotate
            extends VisionRequest<BatchAnnotateImagesResponse> {
                private static final String REST_PATH = "v1/{+parent}/images:annotate";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Annotate(String string, BatchAnnotateImagesRequest batchAnnotateImagesRequest) {
                    super(Vision.this, "POST", REST_PATH, (Object)batchAnnotateImagesRequest, BatchAnnotateImagesResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Vision.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Annotate set$Xgafv(String string) {
                    return (Annotate)super.set$Xgafv(string);
                }

                public Annotate setAccessToken(String string) {
                    return (Annotate)super.setAccessToken(string);
                }

                public Annotate setAlt(String string) {
                    return (Annotate)super.setAlt(string);
                }

                public Annotate setCallback(String string) {
                    return (Annotate)super.setCallback(string);
                }

                public Annotate setFields(String string) {
                    return (Annotate)super.setFields(string);
                }

                public Annotate setKey(String string) {
                    return (Annotate)super.setKey(string);
                }

                public Annotate setOauthToken(String string) {
                    return (Annotate)super.setOauthToken(string);
                }

                public Annotate setPrettyPrint(Boolean bl) {
                    return (Annotate)super.setPrettyPrint(bl);
                }

                public Annotate setQuotaUser(String string) {
                    return (Annotate)super.setQuotaUser(string);
                }

                public Annotate setUploadType(String string) {
                    return (Annotate)super.setUploadType(string);
                }

                public Annotate setUploadProtocol(String string) {
                    return (Annotate)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public Annotate setParent(String string) {
                    if (!Vision.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                @Override
                public Annotate set(String string, Object object) {
                    return (Annotate)super.set(string, object);
                }
            }
        }

        public class Files {
            public Annotate annotate(String string, BatchAnnotateFilesRequest batchAnnotateFilesRequest) throws IOException {
                Annotate annotate = new Annotate(string, batchAnnotateFilesRequest);
                Vision.this.initialize((AbstractGoogleClientRequest<?>)annotate);
                return annotate;
            }

            public AsyncBatchAnnotate asyncBatchAnnotate(String string, AsyncBatchAnnotateFilesRequest asyncBatchAnnotateFilesRequest) throws IOException {
                AsyncBatchAnnotate asyncBatchAnnotate = new AsyncBatchAnnotate(string, asyncBatchAnnotateFilesRequest);
                Vision.this.initialize((AbstractGoogleClientRequest<?>)asyncBatchAnnotate);
                return asyncBatchAnnotate;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class AsyncBatchAnnotate
            extends VisionRequest<Operation> {
                private static final String REST_PATH = "v1/{+parent}/files:asyncBatchAnnotate";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected AsyncBatchAnnotate(String string, AsyncBatchAnnotateFilesRequest asyncBatchAnnotateFilesRequest) {
                    super(Vision.this, "POST", REST_PATH, (Object)asyncBatchAnnotateFilesRequest, Operation.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Vision.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public AsyncBatchAnnotate set$Xgafv(String string) {
                    return (AsyncBatchAnnotate)super.set$Xgafv(string);
                }

                public AsyncBatchAnnotate setAccessToken(String string) {
                    return (AsyncBatchAnnotate)super.setAccessToken(string);
                }

                public AsyncBatchAnnotate setAlt(String string) {
                    return (AsyncBatchAnnotate)super.setAlt(string);
                }

                public AsyncBatchAnnotate setCallback(String string) {
                    return (AsyncBatchAnnotate)super.setCallback(string);
                }

                public AsyncBatchAnnotate setFields(String string) {
                    return (AsyncBatchAnnotate)super.setFields(string);
                }

                public AsyncBatchAnnotate setKey(String string) {
                    return (AsyncBatchAnnotate)super.setKey(string);
                }

                public AsyncBatchAnnotate setOauthToken(String string) {
                    return (AsyncBatchAnnotate)super.setOauthToken(string);
                }

                public AsyncBatchAnnotate setPrettyPrint(Boolean bl) {
                    return (AsyncBatchAnnotate)super.setPrettyPrint(bl);
                }

                public AsyncBatchAnnotate setQuotaUser(String string) {
                    return (AsyncBatchAnnotate)super.setQuotaUser(string);
                }

                public AsyncBatchAnnotate setUploadType(String string) {
                    return (AsyncBatchAnnotate)super.setUploadType(string);
                }

                public AsyncBatchAnnotate setUploadProtocol(String string) {
                    return (AsyncBatchAnnotate)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public AsyncBatchAnnotate setParent(String string) {
                    if (!Vision.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                @Override
                public AsyncBatchAnnotate set(String string, Object object) {
                    return (AsyncBatchAnnotate)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Annotate
            extends VisionRequest<BatchAnnotateFilesResponse> {
                private static final String REST_PATH = "v1/{+parent}/files:annotate";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Annotate(String string, BatchAnnotateFilesRequest batchAnnotateFilesRequest) {
                    super(Vision.this, "POST", REST_PATH, (Object)batchAnnotateFilesRequest, BatchAnnotateFilesResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Vision.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Annotate set$Xgafv(String string) {
                    return (Annotate)super.set$Xgafv(string);
                }

                public Annotate setAccessToken(String string) {
                    return (Annotate)super.setAccessToken(string);
                }

                public Annotate setAlt(String string) {
                    return (Annotate)super.setAlt(string);
                }

                public Annotate setCallback(String string) {
                    return (Annotate)super.setCallback(string);
                }

                public Annotate setFields(String string) {
                    return (Annotate)super.setFields(string);
                }

                public Annotate setKey(String string) {
                    return (Annotate)super.setKey(string);
                }

                public Annotate setOauthToken(String string) {
                    return (Annotate)super.setOauthToken(string);
                }

                public Annotate setPrettyPrint(Boolean bl) {
                    return (Annotate)super.setPrettyPrint(bl);
                }

                public Annotate setQuotaUser(String string) {
                    return (Annotate)super.setQuotaUser(string);
                }

                public Annotate setUploadType(String string) {
                    return (Annotate)super.setUploadType(string);
                }

                public Annotate setUploadProtocol(String string) {
                    return (Annotate)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public Annotate setParent(String string) {
                    if (!Vision.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                @Override
                public Annotate set(String string, Object object) {
                    return (Annotate)super.set(string, object);
                }
            }
        }
    }

    public class Operations {
        public Cancel cancel(String string, CancelOperationRequest cancelOperationRequest) throws IOException {
            Cancel cancel = new Cancel(string, cancelOperationRequest);
            Vision.this.initialize((AbstractGoogleClientRequest<?>)cancel);
            return cancel;
        }

        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            Vision.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Vision.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Vision.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends VisionRequest<ListOperationsResponse> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private Integer pageSize;

            protected List(String string) {
                super(Vision.this, "GET", REST_PATH, null, ListOperationsResponse.class);
                this.NAME_PATTERN = Pattern.compile("^operations$");
                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                if (!Vision.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^operations$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String string) {
                return (List)super.set$Xgafv(string);
            }

            public List setAccessToken(String string) {
                return (List)super.setAccessToken(string);
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setCallback(String string) {
                return (List)super.setCallback(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUploadType(String string) {
                return (List)super.setUploadType(string);
            }

            public List setUploadProtocol(String string) {
                return (List)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public List setName(String string) {
                if (!Vision.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^operations$");
                }
                this.name = string;
                return this;
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String string) {
                this.filter = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer n) {
                this.pageSize = n;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends VisionRequest<Operation> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String string) {
                super(Vision.this, "GET", REST_PATH, null, Operation.class);
                this.NAME_PATTERN = Pattern.compile("^operations/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                if (!Vision.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^operations/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String string) {
                return (Get)super.set$Xgafv(string);
            }

            public Get setAccessToken(String string) {
                return (Get)super.setAccessToken(string);
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setCallback(String string) {
                return (Get)super.setCallback(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUploadType(String string) {
                return (Get)super.setUploadType(string);
            }

            public Get setUploadProtocol(String string) {
                return (Get)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String string) {
                if (!Vision.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^operations/[^/]+$");
                }
                this.name = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends VisionRequest<Empty> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Delete(String string) {
                super(Vision.this, "DELETE", REST_PATH, null, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^operations/.*$");
                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                if (!Vision.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
            }

            public Delete set$Xgafv(String string) {
                return (Delete)super.set$Xgafv(string);
            }

            public Delete setAccessToken(String string) {
                return (Delete)super.setAccessToken(string);
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setCallback(String string) {
                return (Delete)super.setCallback(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUploadType(String string) {
                return (Delete)super.setUploadType(string);
            }

            public Delete setUploadProtocol(String string) {
                return (Delete)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public Delete setName(String string) {
                if (!Vision.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
                this.name = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Cancel
        extends VisionRequest<Empty> {
            private static final String REST_PATH = "v1/{+name}:cancel";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Cancel(String string, CancelOperationRequest cancelOperationRequest) {
                super(Vision.this, "POST", REST_PATH, (Object)cancelOperationRequest, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^operations/.*$");
                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                if (!Vision.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
            }

            public Cancel set$Xgafv(String string) {
                return (Cancel)super.set$Xgafv(string);
            }

            public Cancel setAccessToken(String string) {
                return (Cancel)super.setAccessToken(string);
            }

            public Cancel setAlt(String string) {
                return (Cancel)super.setAlt(string);
            }

            public Cancel setCallback(String string) {
                return (Cancel)super.setCallback(string);
            }

            public Cancel setFields(String string) {
                return (Cancel)super.setFields(string);
            }

            public Cancel setKey(String string) {
                return (Cancel)super.setKey(string);
            }

            public Cancel setOauthToken(String string) {
                return (Cancel)super.setOauthToken(string);
            }

            public Cancel setPrettyPrint(Boolean bl) {
                return (Cancel)super.setPrettyPrint(bl);
            }

            public Cancel setQuotaUser(String string) {
                return (Cancel)super.setQuotaUser(string);
            }

            public Cancel setUploadType(String string) {
                return (Cancel)super.setUploadType(string);
            }

            public Cancel setUploadProtocol(String string) {
                return (Cancel)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public Cancel setName(String string) {
                if (!Vision.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^operations/.*$");
                }
                this.name = string;
                return this;
            }

            @Override
            public Cancel set(String string, Object object) {
                return (Cancel)super.set(string, object);
            }
        }
    }

    public class Locations {
        public Operations operations() {
            return new Operations();
        }

        public class Operations {
            public Get get(String string) throws IOException {
                Get get = new Get(string);
                Vision.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends VisionRequest<Operation> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String string) {
                    super(Vision.this, "GET", REST_PATH, null, Operation.class);
                    this.NAME_PATTERN = Pattern.compile("^locations/[^/]+/operations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Vision.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^locations/[^/]+/operations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String string) {
                    if (!Vision.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^locations/[^/]+/operations/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }
        }
    }

    public class Images {
        public Annotate annotate(BatchAnnotateImagesRequest batchAnnotateImagesRequest) throws IOException {
            Annotate annotate = new Annotate(batchAnnotateImagesRequest);
            Vision.this.initialize((AbstractGoogleClientRequest<?>)annotate);
            return annotate;
        }

        public AsyncBatchAnnotate asyncBatchAnnotate(AsyncBatchAnnotateImagesRequest asyncBatchAnnotateImagesRequest) throws IOException {
            AsyncBatchAnnotate asyncBatchAnnotate = new AsyncBatchAnnotate(asyncBatchAnnotateImagesRequest);
            Vision.this.initialize((AbstractGoogleClientRequest<?>)asyncBatchAnnotate);
            return asyncBatchAnnotate;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AsyncBatchAnnotate
        extends VisionRequest<Operation> {
            private static final String REST_PATH = "v1/images:asyncBatchAnnotate";

            protected AsyncBatchAnnotate(AsyncBatchAnnotateImagesRequest asyncBatchAnnotateImagesRequest) {
                super(Vision.this, "POST", REST_PATH, (Object)asyncBatchAnnotateImagesRequest, Operation.class);
            }

            public AsyncBatchAnnotate set$Xgafv(String string) {
                return (AsyncBatchAnnotate)super.set$Xgafv(string);
            }

            public AsyncBatchAnnotate setAccessToken(String string) {
                return (AsyncBatchAnnotate)super.setAccessToken(string);
            }

            public AsyncBatchAnnotate setAlt(String string) {
                return (AsyncBatchAnnotate)super.setAlt(string);
            }

            public AsyncBatchAnnotate setCallback(String string) {
                return (AsyncBatchAnnotate)super.setCallback(string);
            }

            public AsyncBatchAnnotate setFields(String string) {
                return (AsyncBatchAnnotate)super.setFields(string);
            }

            public AsyncBatchAnnotate setKey(String string) {
                return (AsyncBatchAnnotate)super.setKey(string);
            }

            public AsyncBatchAnnotate setOauthToken(String string) {
                return (AsyncBatchAnnotate)super.setOauthToken(string);
            }

            public AsyncBatchAnnotate setPrettyPrint(Boolean bl) {
                return (AsyncBatchAnnotate)super.setPrettyPrint(bl);
            }

            public AsyncBatchAnnotate setQuotaUser(String string) {
                return (AsyncBatchAnnotate)super.setQuotaUser(string);
            }

            public AsyncBatchAnnotate setUploadType(String string) {
                return (AsyncBatchAnnotate)super.setUploadType(string);
            }

            public AsyncBatchAnnotate setUploadProtocol(String string) {
                return (AsyncBatchAnnotate)super.setUploadProtocol(string);
            }

            @Override
            public AsyncBatchAnnotate set(String string, Object object) {
                return (AsyncBatchAnnotate)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Annotate
        extends VisionRequest<BatchAnnotateImagesResponse> {
            private static final String REST_PATH = "v1/images:annotate";

            protected Annotate(BatchAnnotateImagesRequest batchAnnotateImagesRequest) {
                super(Vision.this, "POST", REST_PATH, (Object)batchAnnotateImagesRequest, BatchAnnotateImagesResponse.class);
            }

            public Annotate set$Xgafv(String string) {
                return (Annotate)super.set$Xgafv(string);
            }

            public Annotate setAccessToken(String string) {
                return (Annotate)super.setAccessToken(string);
            }

            public Annotate setAlt(String string) {
                return (Annotate)super.setAlt(string);
            }

            public Annotate setCallback(String string) {
                return (Annotate)super.setCallback(string);
            }

            public Annotate setFields(String string) {
                return (Annotate)super.setFields(string);
            }

            public Annotate setKey(String string) {
                return (Annotate)super.setKey(string);
            }

            public Annotate setOauthToken(String string) {
                return (Annotate)super.setOauthToken(string);
            }

            public Annotate setPrettyPrint(Boolean bl) {
                return (Annotate)super.setPrettyPrint(bl);
            }

            public Annotate setQuotaUser(String string) {
                return (Annotate)super.setQuotaUser(string);
            }

            public Annotate setUploadType(String string) {
                return (Annotate)super.setUploadType(string);
            }

            public Annotate setUploadProtocol(String string) {
                return (Annotate)super.setUploadProtocol(string);
            }

            @Override
            public Annotate set(String string, Object object) {
                return (Annotate)super.set(string, object);
            }
        }
    }

    public class Files {
        public Annotate annotate(BatchAnnotateFilesRequest batchAnnotateFilesRequest) throws IOException {
            Annotate annotate = new Annotate(batchAnnotateFilesRequest);
            Vision.this.initialize((AbstractGoogleClientRequest<?>)annotate);
            return annotate;
        }

        public AsyncBatchAnnotate asyncBatchAnnotate(AsyncBatchAnnotateFilesRequest asyncBatchAnnotateFilesRequest) throws IOException {
            AsyncBatchAnnotate asyncBatchAnnotate = new AsyncBatchAnnotate(asyncBatchAnnotateFilesRequest);
            Vision.this.initialize((AbstractGoogleClientRequest<?>)asyncBatchAnnotate);
            return asyncBatchAnnotate;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class AsyncBatchAnnotate
        extends VisionRequest<Operation> {
            private static final String REST_PATH = "v1/files:asyncBatchAnnotate";

            protected AsyncBatchAnnotate(AsyncBatchAnnotateFilesRequest asyncBatchAnnotateFilesRequest) {
                super(Vision.this, "POST", REST_PATH, (Object)asyncBatchAnnotateFilesRequest, Operation.class);
            }

            public AsyncBatchAnnotate set$Xgafv(String string) {
                return (AsyncBatchAnnotate)super.set$Xgafv(string);
            }

            public AsyncBatchAnnotate setAccessToken(String string) {
                return (AsyncBatchAnnotate)super.setAccessToken(string);
            }

            public AsyncBatchAnnotate setAlt(String string) {
                return (AsyncBatchAnnotate)super.setAlt(string);
            }

            public AsyncBatchAnnotate setCallback(String string) {
                return (AsyncBatchAnnotate)super.setCallback(string);
            }

            public AsyncBatchAnnotate setFields(String string) {
                return (AsyncBatchAnnotate)super.setFields(string);
            }

            public AsyncBatchAnnotate setKey(String string) {
                return (AsyncBatchAnnotate)super.setKey(string);
            }

            public AsyncBatchAnnotate setOauthToken(String string) {
                return (AsyncBatchAnnotate)super.setOauthToken(string);
            }

            public AsyncBatchAnnotate setPrettyPrint(Boolean bl) {
                return (AsyncBatchAnnotate)super.setPrettyPrint(bl);
            }

            public AsyncBatchAnnotate setQuotaUser(String string) {
                return (AsyncBatchAnnotate)super.setQuotaUser(string);
            }

            public AsyncBatchAnnotate setUploadType(String string) {
                return (AsyncBatchAnnotate)super.setUploadType(string);
            }

            public AsyncBatchAnnotate setUploadProtocol(String string) {
                return (AsyncBatchAnnotate)super.setUploadProtocol(string);
            }

            @Override
            public AsyncBatchAnnotate set(String string, Object object) {
                return (AsyncBatchAnnotate)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Annotate
        extends VisionRequest<BatchAnnotateFilesResponse> {
            private static final String REST_PATH = "v1/files:annotate";

            protected Annotate(BatchAnnotateFilesRequest batchAnnotateFilesRequest) {
                super(Vision.this, "POST", REST_PATH, (Object)batchAnnotateFilesRequest, BatchAnnotateFilesResponse.class);
            }

            public Annotate set$Xgafv(String string) {
                return (Annotate)super.set$Xgafv(string);
            }

            public Annotate setAccessToken(String string) {
                return (Annotate)super.setAccessToken(string);
            }

            public Annotate setAlt(String string) {
                return (Annotate)super.setAlt(string);
            }

            public Annotate setCallback(String string) {
                return (Annotate)super.setCallback(string);
            }

            public Annotate setFields(String string) {
                return (Annotate)super.setFields(string);
            }

            public Annotate setKey(String string) {
                return (Annotate)super.setKey(string);
            }

            public Annotate setOauthToken(String string) {
                return (Annotate)super.setOauthToken(string);
            }

            public Annotate setPrettyPrint(Boolean bl) {
                return (Annotate)super.setPrettyPrint(bl);
            }

            public Annotate setQuotaUser(String string) {
                return (Annotate)super.setQuotaUser(string);
            }

            public Annotate setUploadType(String string) {
                return (Annotate)super.setUploadType(string);
            }

            public Annotate setUploadProtocol(String string) {
                return (Annotate)super.setUploadProtocol(string);
            }

            @Override
            public Annotate set(String string, Object object) {
                return (Annotate)super.set(string, object);
            }
        }
    }
}

