/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.field;

import com.google.appengine.repackaged.org.joda.time.DateTimeField;
import com.google.appengine.repackaged.org.joda.time.DateTimeFieldType;
import com.google.appengine.repackaged.org.joda.time.DurationField;
import com.google.appengine.repackaged.org.joda.time.field.DecoratedDateTimeField;
import com.google.appengine.repackaged.org.joda.time.field.FieldUtils;
import com.google.appengine.repackaged.org.joda.time.field.RemainderDateTimeField;
import com.google.appengine.repackaged.org.joda.time.field.ScaledDurationField;

public class DividedDateTimeField
extends DecoratedDateTimeField {
    private static final long serialVersionUID = 8318475124230605365L;
    final int iDivisor;
    final DurationField iDurationField;
    private final int iMin;
    private final int iMax;

    public DividedDateTimeField(DateTimeField field, DateTimeFieldType type, int divisor) {
        super(field, type);
        if (divisor < 2) {
            throw new IllegalArgumentException("The divisor must be at least 2");
        }
        DurationField unitField = field.getDurationField();
        this.iDurationField = unitField == null ? null : new ScaledDurationField(unitField, type.getDurationType(), divisor);
        this.iDivisor = divisor;
        int i = field.getMinimumValue();
        int min = i >= 0 ? i / divisor : (i + 1) / divisor - 1;
        int j = field.getMaximumValue();
        int max = j >= 0 ? j / divisor : (j + 1) / divisor - 1;
        this.iMin = min;
        this.iMax = max;
    }

    public DividedDateTimeField(RemainderDateTimeField remainderField, DateTimeFieldType type) {
        super(remainderField.getWrappedField(), type);
        int divisor = this.iDivisor = remainderField.iDivisor;
        this.iDurationField = remainderField.iRangeField;
        DateTimeField field = this.getWrappedField();
        int i = field.getMinimumValue();
        int min = i >= 0 ? i / divisor : (i + 1) / divisor - 1;
        int j = field.getMaximumValue();
        int max = j >= 0 ? j / divisor : (j + 1) / divisor - 1;
        this.iMin = min;
        this.iMax = max;
    }

    @Override
    public int get(long instant) {
        int value = this.getWrappedField().get(instant);
        if (value >= 0) {
            return value / this.iDivisor;
        }
        return (value + 1) / this.iDivisor - 1;
    }

    @Override
    public long add(long instant, int amount) {
        return this.getWrappedField().add(instant, amount * this.iDivisor);
    }

    @Override
    public long add(long instant, long amount) {
        return this.getWrappedField().add(instant, amount * (long)this.iDivisor);
    }

    @Override
    public long addWrapField(long instant, int amount) {
        return this.set(instant, FieldUtils.getWrappedValue(this.get(instant), amount, this.iMin, this.iMax));
    }

    @Override
    public int getDifference(long minuendInstant, long subtrahendInstant) {
        return this.getWrappedField().getDifference(minuendInstant, subtrahendInstant) / this.iDivisor;
    }

    @Override
    public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
        return this.getWrappedField().getDifferenceAsLong(minuendInstant, subtrahendInstant) / (long)this.iDivisor;
    }

    @Override
    public long set(long instant, int value) {
        FieldUtils.verifyValueBounds(this, value, this.iMin, this.iMax);
        int remainder = this.getRemainder(this.getWrappedField().get(instant));
        return this.getWrappedField().set(instant, value * this.iDivisor + remainder);
    }

    @Override
    public DurationField getDurationField() {
        return this.iDurationField;
    }

    @Override
    public int getMinimumValue() {
        return this.iMin;
    }

    @Override
    public int getMaximumValue() {
        return this.iMax;
    }

    @Override
    public long roundFloor(long instant) {
        DateTimeField field = this.getWrappedField();
        return field.roundFloor(field.set(instant, this.get(instant) * this.iDivisor));
    }

    @Override
    public long remainder(long instant) {
        return this.set(instant, this.get(this.getWrappedField().remainder(instant)));
    }

    public int getDivisor() {
        return this.iDivisor;
    }

    private int getRemainder(int value) {
        if (value >= 0) {
            return value % this.iDivisor;
        }
        return this.iDivisor - 1 + (value + 1) % this.iDivisor;
    }
}

