/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import com.google.ar.core.Pose;
import com.google.ar.core.Session;
import com.google.ar.core.TrackableBase;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class AugmentedFace
extends TrackableBase {
    private static final String TAG = "ARCore-AugmentedFace";
    private FloatBuffer verticesBuffer;
    private FloatBuffer normalsBuffer;
    private FloatBuffer textureCoordinatesBuffer;
    private ShortBuffer triangleIndicesBuffer;

    /*
     * WARNING - void declaration
     */
    AugmentedFace(long nativeHandle, Session session) {
        super((long)var1_1, (Session)var3_2);
        void var3_2;
        void var1_1;
        this.populateMeshData();
    }

    protected AugmentedFace() {
        super(0L, null);
    }

    void populateMeshData() {
        AugmentedFace augmentedFace = this;
        augmentedFace.verticesBuffer = Session.directByteBufferOrDefault(augmentedFace.nativeGetMeshVerticesByteBuffer(augmentedFace.session.nativeWrapperHandle, this.nativeHandle)).asFloatBuffer();
        AugmentedFace augmentedFace2 = this;
        augmentedFace2.normalsBuffer = Session.directByteBufferOrDefault(augmentedFace2.nativeGetMeshNormalsByteBuffer(augmentedFace2.session.nativeWrapperHandle, this.nativeHandle)).asFloatBuffer();
        AugmentedFace augmentedFace3 = this;
        augmentedFace3.textureCoordinatesBuffer = Session.directByteBufferOrDefault(augmentedFace3.nativeGetMeshTextureCoordinatesByteBuffer(augmentedFace3.session.nativeWrapperHandle, this.nativeHandle)).asFloatBuffer();
        AugmentedFace augmentedFace4 = this;
        augmentedFace4.triangleIndicesBuffer = Session.directByteBufferOrDefault(augmentedFace4.nativeGetMeshTriangleIndicesByteBuffer(augmentedFace4.session.nativeWrapperHandle, this.nativeHandle)).asShortBuffer();
    }

    public FloatBuffer getMeshVertices() {
        return this.verticesBuffer;
    }

    public FloatBuffer getMeshNormals() {
        return this.normalsBuffer;
    }

    public FloatBuffer getMeshTextureCoordinates() {
        return this.textureCoordinatesBuffer;
    }

    public ShortBuffer getMeshTriangleIndices() {
        return this.triangleIndicesBuffer;
    }

    /*
     * WARNING - void declaration
     */
    public Pose getRegionPose(RegionType regionType) {
        void var1_1;
        AugmentedFace augmentedFace = this;
        return augmentedFace.nativeGetRegionPose(augmentedFace.session.nativeWrapperHandle, this.nativeHandle, var1_1.nativeCode);
    }

    public Pose getCenterPose() {
        AugmentedFace augmentedFace = this;
        return augmentedFace.nativeGetCenterPose(augmentedFace.session.nativeWrapperHandle, this.nativeHandle);
    }

    private native ByteBuffer nativeGetMeshVerticesByteBuffer(long var1, long var3);

    private native ByteBuffer nativeGetMeshNormalsByteBuffer(long var1, long var3);

    private native ByteBuffer nativeGetMeshTextureCoordinatesByteBuffer(long var1, long var3);

    private native ByteBuffer nativeGetMeshTriangleIndicesByteBuffer(long var1, long var3);

    private native Pose nativeGetRegionPose(long var1, long var3, int var5);

    private native Pose nativeGetCenterPose(long var1, long var3);

    public static enum RegionType {
        NOSE_TIP(0),
        FOREHEAD_LEFT(1),
        FOREHEAD_RIGHT(2);

        final int nativeCode;

        /*
         * WARNING - void declaration
         */
        private RegionType(int nativeCode) {
            void var3_3;
            this.nativeCode = var3_3;
        }
    }
}

