/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import android.util.Range;
import android.util.Size;
import androidx.annotation.NonNull;
import com.google.ar.core.Session;
import com.google.ar.core.exceptions.FatalException;
import com.google.ar.core.p;
import java.util.EnumSet;

public class CameraConfig {
    private final Session session;
    private final long nativeSymbolTableHandle;
    long nativeHandle;

    /*
     * WARNING - void declaration
     */
    CameraConfig(Session session, long cameraConfigHandle) {
        void var2_2;
        void var1_1;
        this.session = var1_1;
        this.nativeHandle = var2_2;
        this.nativeSymbolTableHandle = var1_1.nativeSymbolTableHandle;
    }

    protected CameraConfig() {
        this.session = null;
        this.nativeHandle = 0L;
        this.nativeSymbolTableHandle = 0L;
    }

    protected void finalize() throws Throwable {
        long l2 = this.nativeHandle;
        if (l2 != 0L) {
            CameraConfig.nativeDestroyCameraConfig(this.nativeSymbolTableHandle, l2);
            this.nativeHandle = 0L;
        }
        super.finalize();
    }

    @NonNull
    public Size getImageSize() {
        CameraConfig cameraConfig = this;
        int[] nArray = new int[2];
        cameraConfig.nativeGetImageDimensions(cameraConfig.session.nativeWrapperHandle, this.nativeHandle, nArray);
        return new Size(nArray[0], nArray[1]);
    }

    @NonNull
    public Size getTextureSize() {
        CameraConfig cameraConfig = this;
        int[] nArray = new int[2];
        cameraConfig.nativeGetTextureDimensions(cameraConfig.session.nativeWrapperHandle, this.nativeHandle, nArray);
        return new Size(nArray[0], nArray[1]);
    }

    @NonNull
    public Range<Integer> getFpsRange() {
        CameraConfig cameraConfig = this;
        int[] nArray = new int[2];
        cameraConfig.nativeGetFpsRange(cameraConfig.session.nativeWrapperHandle, this.nativeHandle, nArray);
        return new Range((Comparable)Integer.valueOf(nArray[0]), (Comparable)Integer.valueOf(nArray[1]));
    }

    @NonNull
    public DepthSensorUsage getDepthSensorUsage() {
        CameraConfig cameraConfig = this;
        return DepthSensorUsage.forNumber(cameraConfig.nativeGetDepthSensorUsage(cameraConfig.session.nativeWrapperHandle, this.nativeHandle));
    }

    public String getCameraId() {
        CameraConfig cameraConfig = this;
        return cameraConfig.nativeGetCameraId(cameraConfig.session.nativeWrapperHandle, this.nativeHandle);
    }

    @NonNull
    public FacingDirection getFacingDirection() {
        CameraConfig cameraConfig = this;
        return FacingDirection.forNumber(cameraConfig.nativeGetFacingDirection(cameraConfig.session.nativeWrapperHandle, this.nativeHandle));
    }

    @NonNull
    public StereoCameraUsage getStereoCameraUsage() {
        CameraConfig cameraConfig = this;
        return StereoCameraUsage.forNumber(cameraConfig.nativeGetStereoCameraUsage(cameraConfig.session.nativeWrapperHandle, this.nativeHandle));
    }

    private static native void nativeDestroyCameraConfig(long var0, long var2);

    private native void nativeGetImageDimensions(long var1, long var3, int[] var5);

    private native void nativeGetTextureDimensions(long var1, long var3, int[] var5);

    private native void nativeGetFpsRange(long var1, long var3, int[] var5);

    private native int nativeGetDepthSensorUsage(long var1, long var3);

    private native String nativeGetCameraId(long var1, long var3);

    private native int nativeGetFacingDirection(long var1, long var3);

    private native int nativeGetStereoCameraUsage(long var1, long var3);

    public static enum DepthSensorUsage {
        REQUIRE_AND_USE(1),
        DO_NOT_USE(2);

        final int nativeCode;

        /*
         * WARNING - void declaration
         */
        private DepthSensorUsage(int nativeCode) {
            void var3_3;
            this.nativeCode = var3_3;
        }

        @NonNull
        static DepthSensorUsage forNumber(int nativeCode) {
            DepthSensorUsage[] depthSensorUsageArray = DepthSensorUsage.values();
            int n2 = depthSensorUsageArray.length;
            int n3 = 0;
            while (true) {
                int n4;
                if (n3 < n2) {
                    DepthSensorUsage depthSensorUsage = depthSensorUsageArray[n3];
                    if (depthSensorUsage.nativeCode == n4) {
                        return depthSensorUsage;
                    }
                } else {
                    String string2 = "Unexpected value for native DepthSensorUsage, value=";
                    throw new FatalException(p.b((byte)52, n4, string2));
                }
                ++n3;
            }
        }

        @NonNull
        static EnumSet<DepthSensorUsage> forBitFlags(int nativeFlags) {
            EnumSet<DepthSensorUsage> enumSet = EnumSet.noneOf(DepthSensorUsage.class);
            for (DepthSensorUsage depthSensorUsage : DepthSensorUsage.values()) {
                int n2;
                if ((depthSensorUsage.nativeCode & n2) == 0) continue;
                enumSet.add(depthSensorUsage);
            }
            return enumSet;
        }
    }

    public static enum FacingDirection {
        BACK(0),
        FRONT(1);

        final int nativeCode;

        /*
         * WARNING - void declaration
         */
        private FacingDirection(int nativeCode) {
            void var3_3;
            this.nativeCode = var3_3;
        }

        @NonNull
        static FacingDirection forNumber(int nativeCode) {
            FacingDirection[] facingDirectionArray = FacingDirection.values();
            int n2 = facingDirectionArray.length;
            int n3 = 0;
            while (true) {
                int n4;
                if (n3 < n2) {
                    FacingDirection facingDirection = facingDirectionArray[n3];
                    if (facingDirection.nativeCode == n4) {
                        return facingDirection;
                    }
                } else {
                    String string2 = "Unexpected value for native FacingDirection, value=";
                    throw new FatalException(p.b((byte)51, n4, string2));
                }
                ++n3;
            }
        }
    }

    public static enum StereoCameraUsage {
        REQUIRE_AND_USE(1),
        DO_NOT_USE(2);

        final int nativeCode;

        /*
         * WARNING - void declaration
         */
        private StereoCameraUsage(int nativeCode) {
            void var3_3;
            this.nativeCode = var3_3;
        }

        @NonNull
        static StereoCameraUsage forNumber(int nativeCode) {
            StereoCameraUsage[] stereoCameraUsageArray = StereoCameraUsage.values();
            int n2 = stereoCameraUsageArray.length;
            int n3 = 0;
            while (true) {
                int n4;
                if (n3 < n2) {
                    StereoCameraUsage stereoCameraUsage = stereoCameraUsageArray[n3];
                    if (stereoCameraUsage.nativeCode == n4) {
                        return stereoCameraUsage;
                    }
                } else {
                    String string2 = "Unexpected value for native StereoCameraUsage, value=";
                    throw new FatalException(p.b((byte)53, n4, string2));
                }
                ++n3;
            }
        }

        @NonNull
        static EnumSet<StereoCameraUsage> forBitFlags(int nativeFlags) {
            EnumSet<StereoCameraUsage> enumSet = EnumSet.noneOf(StereoCameraUsage.class);
            for (StereoCameraUsage stereoCameraUsage : StereoCameraUsage.values()) {
                int n2;
                if ((stereoCameraUsage.nativeCode & n2) == 0) continue;
                enumSet.add(stereoCameraUsage);
            }
            return enumSet;
        }
    }

    public static enum TargetFps {
        TARGET_FPS_30(1),
        TARGET_FPS_60(2);

        final int nativeCode;

        /*
         * WARNING - void declaration
         */
        private TargetFps(int nativeCode) {
            void var3_3;
            this.nativeCode = var3_3;
        }

        static EnumSet<TargetFps> forBitFlags(int nativeFlags) {
            EnumSet<TargetFps> enumSet = EnumSet.noneOf(TargetFps.class);
            for (TargetFps targetFps : TargetFps.values()) {
                int n2;
                if ((targetFps.nativeCode & n2) == 0) continue;
                enumSet.add(targetFps);
            }
            return enumSet;
        }
    }
}

