/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import androidx.annotation.NonNull;
import com.google.ar.core.CameraConfig;
import com.google.ar.core.Session;
import java.util.EnumSet;
import java.util.Iterator;

public class CameraConfigFilter {
    private static final String TAG = CameraConfigFilter.class.getSimpleName();
    private final Session session;
    private final long nativeSymbolTableHandle;
    long nativeHandle;

    /*
     * WARNING - void declaration
     */
    public CameraConfigFilter(Session session) {
        void var1_1;
        this.session = var1_1;
        this.nativeHandle = CameraConfigFilter.nativeCreateCameraConfigFilter(var1_1.nativeWrapperHandle);
        this.nativeSymbolTableHandle = var1_1.nativeSymbolTableHandle;
    }

    protected CameraConfigFilter() {
        this.session = null;
        this.nativeHandle = 0L;
        this.nativeSymbolTableHandle = 0L;
    }

    protected void finalize() throws Throwable {
        long l2 = this.nativeHandle;
        if (l2 != 0L) {
            CameraConfigFilter.nativeDestroyCameraConfigFilter(this.nativeSymbolTableHandle, l2);
            this.nativeHandle = 0L;
        }
        super.finalize();
    }

    @NonNull
    public CameraConfigFilter setTargetFps(EnumSet<CameraConfig.TargetFps> frameRates) {
        Iterator iterator = frameRates.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            n2 |= ((CameraConfig.TargetFps)((Object)iterator.next())).nativeCode;
        }
        CameraConfigFilter cameraConfigFilter = this;
        cameraConfigFilter.nativeSetTargetFps(cameraConfigFilter.session.nativeWrapperHandle, this.nativeHandle, n2);
        return this;
    }

    @NonNull
    public EnumSet<CameraConfig.TargetFps> getTargetFps() {
        CameraConfigFilter cameraConfigFilter = this;
        return CameraConfig.TargetFps.forBitFlags(cameraConfigFilter.nativeGetTargetFps(cameraConfigFilter.session.nativeWrapperHandle, this.nativeHandle));
    }

    @NonNull
    public CameraConfigFilter setDepthSensorUsage(EnumSet<CameraConfig.DepthSensorUsage> depthSensorUsageFilters) {
        Iterator iterator = depthSensorUsageFilters.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            n2 |= ((CameraConfig.DepthSensorUsage)((Object)iterator.next())).nativeCode;
        }
        CameraConfigFilter cameraConfigFilter = this;
        cameraConfigFilter.nativeSetDepthSensorUsage(cameraConfigFilter.session.nativeWrapperHandle, this.nativeHandle, n2);
        return this;
    }

    @NonNull
    public EnumSet<CameraConfig.DepthSensorUsage> getDepthSensorUsage() {
        CameraConfigFilter cameraConfigFilter = this;
        return CameraConfig.DepthSensorUsage.forBitFlags(cameraConfigFilter.nativeGetDepthSensorUsage(cameraConfigFilter.session.nativeWrapperHandle, this.nativeHandle));
    }

    @NonNull
    public CameraConfigFilter setStereoCameraUsage(EnumSet<CameraConfig.StereoCameraUsage> stereoCameraUsageFilters) {
        Iterator iterator = stereoCameraUsageFilters.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            n2 |= ((CameraConfig.StereoCameraUsage)((Object)iterator.next())).nativeCode;
        }
        CameraConfigFilter cameraConfigFilter = this;
        cameraConfigFilter.nativeSetStereoCameraUsage(cameraConfigFilter.session.nativeWrapperHandle, this.nativeHandle, n2);
        return this;
    }

    @NonNull
    public EnumSet<CameraConfig.StereoCameraUsage> getStereoCameraUsage() {
        CameraConfigFilter cameraConfigFilter = this;
        return CameraConfig.StereoCameraUsage.forBitFlags(cameraConfigFilter.nativeGetStereoCameraUsage(cameraConfigFilter.session.nativeWrapperHandle, this.nativeHandle));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public CameraConfigFilter setFacingDirection(CameraConfig.FacingDirection facingDirections) {
        void var1_1;
        CameraConfigFilter cameraConfigFilter = this;
        cameraConfigFilter.nativeSetFacingDirection(cameraConfigFilter.session.nativeWrapperHandle, this.nativeHandle, var1_1.nativeCode);
        return this;
    }

    @NonNull
    public CameraConfig.FacingDirection getFacingDirection() {
        CameraConfigFilter cameraConfigFilter = this;
        return CameraConfig.FacingDirection.forNumber(cameraConfigFilter.nativeGetFacingDirection(cameraConfigFilter.session.nativeWrapperHandle, this.nativeHandle));
    }

    private static native long nativeCreateCameraConfigFilter(long var0);

    private static native void nativeDestroyCameraConfigFilter(long var0, long var2);

    private native void nativeSetTargetFps(long var1, long var3, int var5);

    private native int nativeGetTargetFps(long var1, long var3);

    private native void nativeSetDepthSensorUsage(long var1, long var3, int var5);

    private native int nativeGetDepthSensorUsage(long var1, long var3);

    private native void nativeSetStereoCameraUsage(long var1, long var3, int var5);

    private native int nativeGetStereoCameraUsage(long var1, long var3);

    private native void nativeSetFacingDirection(long var1, long var3, int var5);

    private native int nativeGetFacingDirection(long var1, long var3);
}

