/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import android.hardware.HardwareBuffer;
import android.media.Image;
import android.os.Build;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.google.ar.core.Anchor;
import com.google.ar.core.ArImage;
import com.google.ar.core.Camera;
import com.google.ar.core.Coordinates2d;
import com.google.ar.core.Coordinates3d;
import com.google.ar.core.HitResult;
import com.google.ar.core.ImageMetadata;
import com.google.ar.core.LightEstimate;
import com.google.ar.core.Plane;
import com.google.ar.core.PointCloud;
import com.google.ar.core.Pose;
import com.google.ar.core.SemanticLabel;
import com.google.ar.core.Session;
import com.google.ar.core.TrackData;
import com.google.ar.core.Trackable;
import com.google.ar.core.ai;
import com.google.ar.core.exceptions.NotYetAvailableException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class Frame {
    private static final String TAG = "ARCore-Frame";
    static final ArrayList<Anchor> ANCHORS_EMPTY_LIST = new ArrayList();
    static final ArrayList<Plane> PLANES_EMPTY_LIST = new ArrayList();
    final Session session;
    final long nativeSymbolTableHandle;
    long nativeHandle;
    private LightEstimate lightEstimate;

    /*
     * WARNING - void declaration
     */
    Frame(Session session) {
        void var1_1;
        void v0 = var1_1;
        this((Session)v0, Frame.nativeCreateFrame(v0.nativeWrapperHandle));
    }

    /*
     * WARNING - void declaration
     */
    Frame(Session session, long frameNativeHandle) {
        void var2_2;
        void var1_1;
        this.session = var1_1;
        this.nativeHandle = var2_2;
        this.nativeSymbolTableHandle = var1_1.nativeSymbolTableHandle;
    }

    protected Frame() {
        this.nativeHandle = 0L;
        this.session = null;
        this.nativeSymbolTableHandle = 0L;
    }

    protected void finalize() throws Throwable {
        long l2 = this.nativeHandle;
        if (l2 != 0L) {
            Frame.nativeDestroyFrame(this.nativeSymbolTableHandle, l2);
            this.nativeHandle = 0L;
        }
        super.finalize();
    }

    @NonNull
    public Camera getCamera() {
        return new Camera(this.session, this);
    }

    public boolean hasDisplayGeometryChanged() {
        Frame frame = this;
        return frame.nativeHasDisplayGeometryChanged(frame.session.nativeWrapperHandle, this.nativeHandle);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void transformDisplayUvCoords(FloatBuffer uvCoords, FloatBuffer outUvCoords) {
        void var1_1;
        void var2_2;
        if (!uvCoords.isDirect() || !var2_2.isDirect()) {
            throw new IllegalArgumentException("transformDisplayUvCoords currently requires direct buffers.");
        }
        Frame frame = this;
        frame.nativeTransformDisplayUvCoords(frame.session.nativeWrapperHandle, this.nativeHandle, (FloatBuffer)var1_1, (FloatBuffer)var2_2);
    }

    public long getTimestamp() {
        Frame frame = this;
        return frame.nativeGetTimestamp(frame.session.nativeWrapperHandle, this.nativeHandle);
    }

    public long getAndroidCameraTimestamp() {
        Frame frame = this;
        return frame.nativeGetAndroidCameraTimestamp(frame.session.nativeWrapperHandle, this.nativeHandle);
    }

    public Pose getAndroidSensorPose() {
        Frame frame = this;
        return frame.nativeGetAndroidSensorPose(frame.session.nativeWrapperHandle, this.nativeHandle);
    }

    @NonNull
    public LightEstimate getLightEstimate() {
        if (this.lightEstimate == null) {
            Session session = this.session;
            this.lightEstimate = new LightEstimate(session);
        }
        Frame frame = this;
        frame.nativeGetLightEstimate(frame.session.nativeWrapperHandle, this.nativeHandle, this.lightEstimate.nativeHandle);
        return this.lightEstimate;
    }

    @NonNull
    public ImageMetadata getImageMetadata() throws NotYetAvailableException {
        Frame frame = this_;
        long l2 = frame.nativeAcquireImageMetadata(frame.session.nativeWrapperHandle, ((Frame)((Object)this_)).nativeHandle);
        Session this_ = ((Frame)((Object)this_)).session;
        return new ImageMetadata(l2, this_);
    }

    @NonNull
    public PointCloud acquirePointCloud() {
        Frame frame = this;
        long l2 = frame.nativeAcquirePointCloud(frame.session.nativeWrapperHandle, this.nativeHandle);
        return new PointCloud(this.session, l2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public List<HitResult> hitTest(float xPx, float yPx) {
        void var2_2;
        void var1_1;
        Frame frame = this;
        return frame.convertNativeHitResultsToList(frame.nativeHitTest(frame.session.nativeWrapperHandle, this.nativeHandle, (float)var1_1, (float)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public List<HitResult> hitTest(MotionEvent motionEvent) {
        void var1_1;
        return this.hitTest(var1_1.getX(), var1_1.getY());
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public List<HitResult> hitTest(float[] origin3, int originOffset, float[] direction3, int directionOffset) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Frame frame = this;
        return frame.convertNativeHitResultsToList(frame.nativeHitTestRay(frame.session.nativeWrapperHandle, this.nativeHandle, (float[])var1_1, (int)var2_2, (float[])var3_3, (int)var4_4));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public List<HitResult> hitTestInstantPlacement(float xPx, float yPx, float approximateDistanceMeters) {
        void var3_3;
        void var2_2;
        void var1_1;
        Frame frame = this;
        return frame.convertNativeHitResultsToList(frame.nativeHitTestInstantPlacement(frame.session.nativeWrapperHandle, this.nativeHandle, (float)var1_1, (float)var2_2, (float)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private List<HitResult> convertNativeHitResultsToList(long[] hitResultHandles) {
        void var1_1;
        int n2 = ((void)var1_1).length;
        ArrayList<HitResult> arrayList = new ArrayList<HitResult>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            void var5_5 = var1_1[i2];
            Session session = this.session;
            HitResult hitResult = new HitResult((long)var5_5, session);
            if (hitResult.getTrackable() == null) continue;
            arrayList.add(hitResult);
        }
        return Collections.unmodifiableList(arrayList);
    }

    @NonNull
    public Collection<Anchor> getUpdatedAnchors() {
        Frame frame = this;
        long[] lArray = frame.nativeAcquireUpdatedAnchors(frame.session.nativeWrapperHandle, this.nativeHandle);
        return this.session.convertNativeAnchorsToCollection(lArray);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public <T extends Trackable> Collection<T> getUpdatedTrackables(Class<T> filterType) {
        void var1_1;
        Object object = ai.a(filterType);
        if (object == ai.b) {
            return Collections.emptyList();
        }
        Frame frame = this;
        object = frame.nativeAcquireUpdatedTrackables(frame.session.nativeWrapperHandle, this.nativeHandle, object.k);
        return this.session.convertNativeTrackablesToCollection(var1_1, (long[])object);
    }

    /*
     * WARNING - void declaration
     */
    public void recordTrackData(UUID trackId, ByteBuffer sample) {
        void var2_2;
        byte[] byArray;
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[16]);
        byteBuffer.putLong(byArray.getMostSignificantBits());
        byteBuffer.putLong(byArray.getLeastSignificantBits());
        if (var2_2.hasArray() && var2_2.arrayOffset() == 0) {
            Frame frame = this;
            frame.nativeRecordTrackData(frame.session.nativeWrapperHandle, this.nativeHandle, byteBuffer.array(), var2_2.array());
            return;
        }
        byArray = new byte[var2_2.remaining()];
        var2_2.get(byArray);
        Frame frame = this;
        frame.nativeRecordTrackData(frame.session.nativeWrapperHandle, this.nativeHandle, byteBuffer.array(), byArray);
    }

    @NonNull
    public Collection<TrackData> getUpdatedTrackData(UUID trackUuid) {
        long[] lArray;
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[16]);
        byteBuffer.putLong(lArray.getMostSignificantBits());
        byteBuffer.putLong(lArray.getLeastSignificantBits());
        Frame frame = this;
        lArray = frame.nativeAcquireTrackData(frame.session.nativeWrapperHandle, this.nativeHandle, byteBuffer.array());
        return this.session.convertNativeTrackDataToCollection(lArray);
    }

    @NonNull
    public Image acquireCameraImage() throws NotYetAvailableException {
        Frame frame = this;
        long l2 = frame.nativeAcquireCameraImage(frame.session.nativeWrapperHandle, this.nativeHandle);
        return new ArImage(this.session, l2);
    }

    @Deprecated(forRemoval=true)
    @NonNull
    public Image acquireDepthImage() throws NotYetAvailableException {
        Frame frame = this;
        long l2 = frame.nativeAcquireDepthImage(frame.session.nativeWrapperHandle, this.nativeHandle);
        return new ArImage(this.session, l2);
    }

    @NonNull
    public Image acquireDepthImage16Bits() throws NotYetAvailableException {
        Frame frame = this;
        long l2 = frame.nativeAcquireDepthImage16Bits(frame.session.nativeWrapperHandle, this.nativeHandle);
        return new ArImage(this.session, l2);
    }

    @Deprecated(forRemoval=true)
    @NonNull
    public Image acquireRawDepthImage() throws NotYetAvailableException {
        Frame frame = this;
        long l2 = frame.nativeAcquireRawDepthImage(frame.session.nativeWrapperHandle, this.nativeHandle);
        return new ArImage(this.session, l2);
    }

    @NonNull
    public Image acquireRawDepthImage16Bits() throws NotYetAvailableException {
        Frame frame = this;
        long l2 = frame.nativeAcquireRawDepthImage16Bits(frame.session.nativeWrapperHandle, this.nativeHandle);
        return new ArImage(this.session, l2);
    }

    @NonNull
    public Image acquireRawDepthConfidenceImage() throws NotYetAvailableException {
        Frame frame = this;
        long l2 = frame.nativeAcquireRawDepthConfidenceImage(frame.session.nativeWrapperHandle, this.nativeHandle);
        return new ArImage(this.session, l2);
    }

    @NonNull
    public Image acquireSemanticImage() throws NotYetAvailableException {
        Frame frame = this;
        long l2 = frame.nativeAcquireSemanticImage(frame.session.nativeWrapperHandle, this.nativeHandle);
        return new ArImage(this.session, l2);
    }

    @NonNull
    public Image acquireSemanticConfidenceImage() throws NotYetAvailableException {
        Frame frame = this;
        long l2 = frame.nativeAcquireSemanticConfidenceImage(frame.session.nativeWrapperHandle, this.nativeHandle);
        return new ArImage(this.session, l2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public float getSemanticLabelFraction(SemanticLabel queryLabel) throws NotYetAvailableException {
        void var1_1;
        Frame frame = this;
        return frame.nativeGetSemanticLabelFraction(frame.session.nativeWrapperHandle, this.nativeHandle, var1_1.nativeCode);
    }

    /*
     * WARNING - void declaration
     */
    public void transformCoordinates2d(Coordinates2d inputCoordinates, FloatBuffer inputVertices2d, Coordinates2d outputCoordinates, FloatBuffer outputVertices2d) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Frame frame = this;
        frame.nativeTransformCoordinates2dFloatArrayOrBuffer(frame.session.nativeWrapperHandle, this.nativeHandle, var1_1.nativeCode, var2_2, var3_3.nativeCode, var4_4);
    }

    /*
     * WARNING - void declaration
     */
    public void transformCoordinates2d(Coordinates2d inputCoordinates, float[] inputVertices2d, Coordinates2d outputCoordinates, float[] outputVertices2d) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Frame frame = this;
        frame.nativeTransformCoordinates2dFloatArrayOrBuffer(frame.session.nativeWrapperHandle, this.nativeHandle, var1_1.nativeCode, var2_2, var3_3.nativeCode, var4_4);
    }

    /*
     * WARNING - void declaration
     */
    public void transformCoordinates3d(Coordinates2d inputCoordinates, FloatBuffer inputVertices2d, Coordinates3d outputCoordinates, FloatBuffer outputVertices3d) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Frame frame = this;
        frame.nativeTransformCoordinates3dFloatArrayOrBuffer(frame.session.nativeWrapperHandle, this.nativeHandle, var1_1.nativeCode, var2_2, var3_3.nativeCode, var4_4);
    }

    /*
     * WARNING - void declaration
     */
    public void transformCoordinates3d(Coordinates2d inputCoordinates, float[] inputVertices2d, Coordinates3d outputCoordinates, float[] outputVertices3d) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Frame frame = this;
        frame.nativeTransformCoordinates3dFloatArrayOrBuffer(frame.session.nativeWrapperHandle, this.nativeHandle, var1_1.nativeCode, var2_2, var3_3.nativeCode, var4_4);
    }

    public int getCameraTextureName() {
        Frame frame = this;
        return frame.nativeGetCameraTextureName(frame.session.nativeWrapperHandle, this.nativeHandle);
    }

    private static native long nativeCreateFrame(long var0);

    private static native void nativeDestroyFrame(long var0, long var2);

    private native boolean nativeHasDisplayGeometryChanged(long var1, long var3);

    private native void nativeTransformDisplayUvCoords(long var1, long var3, FloatBuffer var5, FloatBuffer var6);

    @RequiresApi(value=27)
    public HardwareBuffer getHardwareBuffer() throws NotYetAvailableException, IllegalStateException {
        if (Build.VERSION.SDK_INT < 27) {
            throw new IllegalStateException("Hardware Buffer isn't supported is current Android version");
        }
        Frame frame = this;
        return frame.nativeGetHardwareBuffer(frame.session.nativeWrapperHandle, this.nativeHandle);
    }

    private native long nativeGetTimestamp(long var1, long var3);

    private native long nativeGetAndroidCameraTimestamp(long var1, long var3);

    private native Pose nativeGetAndroidSensorPose(long var1, long var3);

    native long[] nativeHitTest(long var1, long var3, float var5, float var6);

    native long[] nativeHitTestRay(long var1, long var3, float[] var5, int var6, float[] var7, int var8);

    native long[] nativeHitTestInstantPlacement(long var1, long var3, float var5, float var6, float var7);

    private native void nativeGetLightEstimate(long var1, long var3, long var5);

    private native long nativeAcquireImageMetadata(long var1, long var3);

    native long nativeAcquirePointCloud(long var1, long var3);

    private native long[] nativeAcquireUpdatedAnchors(long var1, long var3);

    native long[] nativeAcquireUpdatedTrackables(long var1, long var3, int var5);

    private native void nativeRecordTrackData(long var1, long var3, byte[] var5, byte[] var6);

    private native long[] nativeAcquireTrackData(long var1, long var3, byte[] var5);

    private native long nativeAcquireCameraImage(long var1, long var3);

    private native long nativeAcquireDepthImage(long var1, long var3);

    private native long nativeAcquireDepthImage16Bits(long var1, long var3);

    private native long nativeAcquireSemanticImage(long var1, long var3);

    private native long nativeAcquireSemanticConfidenceImage(long var1, long var3);

    private native float nativeGetSemanticLabelFraction(long var1, long var3, int var5);

    private native long nativeAcquireRawDepthImage(long var1, long var3);

    private native long nativeAcquireRawDepthImage16Bits(long var1, long var3);

    private native long nativeAcquireRawDepthConfidenceImage(long var1, long var3);

    private native void nativeTransformCoordinates2dFloatArrayOrBuffer(long var1, long var3, int var5, Object var6, int var7, Object var8);

    private native void nativeTransformCoordinates3dFloatArrayOrBuffer(long var1, long var3, int var5, Object var6, int var7, Object var8);

    private native int nativeGetCameraTextureName(long var1, long var3);

    private native HardwareBuffer nativeGetHardwareBuffer(long var1, long var3);
}

