/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import androidx.annotation.NonNull;
import com.google.ar.core.Session;
import com.google.ar.core.annotations.UsedByNative;

@UsedByNative(value="session_jni_wrapper.cc")
public class GeospatialPose {
    private final Session session;
    final long nativeSymbolTableHandle;
    long nativeHandle;

    /*
     * WARNING - void declaration
     */
    GeospatialPose(long nativeHandle, Session session) {
        void var1_1;
        void var3_2;
        this.session = var3_2;
        this.nativeHandle = var1_1;
        this.nativeSymbolTableHandle = var3_2.nativeSymbolTableHandle;
    }

    protected void finalize() throws Throwable {
        long l2 = this.nativeHandle;
        if (l2 != 0L) {
            GeospatialPose.nativeDestroy(this.nativeSymbolTableHandle, l2);
        }
        super.finalize();
    }

    public double getLatitude() {
        GeospatialPose geospatialPose = this;
        return geospatialPose.nativeGetLatitude(geospatialPose.session.nativeWrapperHandle, this.nativeHandle);
    }

    public double getLongitude() {
        GeospatialPose geospatialPose = this;
        return geospatialPose.nativeGetLongitude(geospatialPose.session.nativeWrapperHandle, this.nativeHandle);
    }

    public double getAltitude() {
        GeospatialPose geospatialPose = this;
        return geospatialPose.nativeGetAltitude(geospatialPose.session.nativeWrapperHandle, this.nativeHandle);
    }

    @Deprecated
    public double getHeading() {
        GeospatialPose geospatialPose = this;
        return geospatialPose.nativeGetHeading(geospatialPose.session.nativeWrapperHandle, this.nativeHandle);
    }

    @Deprecated
    public double getHeadingAccuracy() {
        GeospatialPose geospatialPose = this;
        return geospatialPose.nativeGetHeadingAccuracy(geospatialPose.session.nativeWrapperHandle, this.nativeHandle);
    }

    public double getOrientationYawAccuracy() {
        GeospatialPose geospatialPose = this;
        return geospatialPose.nativeGetOrientationYawAccuracy(geospatialPose.session.nativeWrapperHandle, this.nativeHandle);
    }

    public double getHorizontalAccuracy() {
        GeospatialPose geospatialPose = this;
        return geospatialPose.nativeGetHorizontalAccuracy(geospatialPose.session.nativeWrapperHandle, this.nativeHandle);
    }

    public double getVerticalAccuracy() {
        GeospatialPose geospatialPose = this;
        return geospatialPose.nativeGetVerticalAccuracy(geospatialPose.session.nativeWrapperHandle, this.nativeHandle);
    }

    @NonNull
    public float[] getEastUpSouthQuaternion() {
        GeospatialPose geospatialPose = this;
        return geospatialPose.nativeEastUpSouthQuaternion(geospatialPose.session.nativeWrapperHandle, this.nativeHandle);
    }

    private static native void nativeDestroy(long var0, long var2);

    private native double nativeGetLatitude(long var1, long var3);

    private native double nativeGetLongitude(long var1, long var3);

    private native double nativeGetAltitude(long var1, long var3);

    private native double nativeGetHeading(long var1, long var3);

    private native double nativeGetHeadingAccuracy(long var1, long var3);

    private native double nativeGetHorizontalAccuracy(long var1, long var3);

    private native double nativeGetVerticalAccuracy(long var1, long var3);

    private native float[] nativeEastUpSouthQuaternion(long var1, long var3);

    private native double nativeGetOrientationYawAccuracy(long var1, long var3);
}

