/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import android.util.Rational;
import com.google.ar.core.Session;
import com.google.ar.core.exceptions.FatalException;
import com.google.ar.core.exceptions.MetadataNotFoundException;
import com.google.ar.core.q;

public class ImageMetadata {
    private static final int SECTION_COLOR_CORRECTION = 0;
    private static final int SECTION_CONTROL = 1;
    private static final int SECTION_EDGE = 3;
    private static final int SECTION_FLASH = 4;
    private static final int SECTION_FLASH_INFO = 5;
    private static final int SECTION_HOT_PIXEL = 6;
    private static final int SECTION_JPEG = 7;
    private static final int SECTION_LENS = 8;
    private static final int SECTION_LENS_INFO = 9;
    private static final int SECTION_NOISE_REDUCTION = 10;
    private static final int SECTION_REQUEST = 12;
    private static final int SECTION_SCALER = 13;
    private static final int SECTION_SENSOR = 14;
    private static final int SECTION_SENSOR_INFO = 15;
    private static final int SECTION_SHADING = 16;
    private static final int SECTION_STATISTICS = 17;
    private static final int SECTION_STATISTICS_INFO = 18;
    private static final int SECTION_TONEMAP = 19;
    private static final int SECTION_INFO = 21;
    private static final int SECTION_BLACK_LEVEL = 22;
    private static final int SECTION_SYNC = 23;
    private static final int SECTION_DEPTH = 25;
    private static final int COLOR_CORRECTION_START = 0;
    private static final int CONTROL_START = 65536;
    private static final int EDGE_START = 196608;
    private static final int FLASH_START = 262144;
    private static final int FLASH_INFO_START = 327680;
    private static final int HOT_PIXEL_START = 393216;
    private static final int JPEG_START = 458752;
    private static final int LENS_START = 524288;
    private static final int LENS_INFO_START = 589824;
    private static final int NOISE_REDUCTION_START = 655360;
    private static final int REQUEST_START = 786432;
    private static final int SCALER_START = 851968;
    private static final int SENSOR_START = 917504;
    private static final int SENSOR_INFO_START = 983040;
    private static final int SHADING_START = 0x100000;
    private static final int STATISTICS_START = 0x110000;
    private static final int STATISTICS_INFO_START = 0x120000;
    private static final int TONEMAP_START = 0x130000;
    private static final int INFO_START = 0x150000;
    private static final int BLACK_LEVEL_START = 0x160000;
    private static final int SYNC_START = 0x170000;
    private static final int DEPTH_START = 0x190000;
    public static final int COLOR_CORRECTION_MODE = 0;
    public static final int COLOR_CORRECTION_TRANSFORM = 1;
    public static final int COLOR_CORRECTION_GAINS = 2;
    public static final int COLOR_CORRECTION_ABERRATION_MODE = 3;
    public static final int CONTROL_AE_ANTIBANDING_MODE = 65536;
    public static final int CONTROL_AE_EXPOSURE_COMPENSATION = 65537;
    public static final int CONTROL_AE_LOCK = 65538;
    public static final int CONTROL_AE_MODE = 65539;
    public static final int CONTROL_AE_REGIONS = 65540;
    public static final int CONTROL_AE_TARGET_FPS_RANGE = 65541;
    public static final int CONTROL_AE_PRECAPTURE_TRIGGER = 65542;
    public static final int CONTROL_AF_MODE = 65543;
    public static final int CONTROL_AF_REGIONS = 65544;
    public static final int CONTROL_AF_TRIGGER = 65545;
    public static final int CONTROL_AWB_LOCK = 65546;
    public static final int CONTROL_AWB_MODE = 65547;
    public static final int CONTROL_AWB_REGIONS = 65548;
    public static final int CONTROL_CAPTURE_INTENT = 65549;
    public static final int CONTROL_EFFECT_MODE = 65550;
    public static final int CONTROL_MODE = 65551;
    public static final int CONTROL_SCENE_MODE = 65552;
    public static final int CONTROL_VIDEO_STABILIZATION_MODE = 65553;
    public static final int CONTROL_AE_STATE = 65567;
    public static final int CONTROL_AF_STATE = 65568;
    public static final int CONTROL_AWB_STATE = 65570;
    public static final int CONTROL_POST_RAW_SENSITIVITY_BOOST = 65576;
    public static final int EDGE_MODE = 196608;
    public static final int FLASH_MODE = 262146;
    public static final int FLASH_STATE = 262149;
    public static final int HOT_PIXEL_MODE = 393216;
    public static final int JPEG_GPS_COORDINATES = 458752;
    public static final int JPEG_GPS_PROCESSING_METHOD = 458753;
    public static final int JPEG_GPS_TIMESTAMP = 458754;
    public static final int JPEG_ORIENTATION = 458755;
    public static final int JPEG_QUALITY = 458756;
    public static final int JPEG_THUMBNAIL_QUALITY = 458757;
    public static final int JPEG_THUMBNAIL_SIZE = 458758;
    public static final int LENS_APERTURE = 524288;
    public static final int LENS_FILTER_DENSITY = 524289;
    public static final int LENS_FOCAL_LENGTH = 524290;
    public static final int LENS_FOCUS_DISTANCE = 524291;
    public static final int LENS_OPTICAL_STABILIZATION_MODE = 524292;
    public static final int LENS_POSE_ROTATION = 524294;
    public static final int LENS_POSE_TRANSLATION = 524295;
    public static final int LENS_FOCUS_RANGE = 524296;
    public static final int LENS_STATE = 524297;
    public static final int LENS_INTRINSIC_CALIBRATION = 524298;
    public static final int LENS_RADIAL_DISTORTION = 524299;
    public static final int NOISE_REDUCTION_MODE = 655360;
    public static final int REQUEST_PIPELINE_DEPTH = 786441;
    public static final int SCALER_CROP_REGION = 851968;
    public static final int SENSOR_EXPOSURE_TIME = 917504;
    public static final int SENSOR_FRAME_DURATION = 917505;
    public static final int SENSOR_SENSITIVITY = 917506;
    public static final int SENSOR_TIMESTAMP = 917520;
    public static final int SENSOR_NEUTRAL_COLOR_POINT = 917522;
    public static final int SENSOR_NOISE_PROFILE = 917523;
    public static final int SENSOR_GREEN_SPLIT = 917526;
    public static final int SENSOR_TEST_PATTERN_DATA = 917527;
    public static final int SENSOR_TEST_PATTERN_MODE = 917528;
    public static final int SENSOR_ROLLING_SHUTTER_SKEW = 917530;
    public static final int SENSOR_DYNAMIC_BLACK_LEVEL = 917532;
    public static final int SENSOR_DYNAMIC_WHITE_LEVEL = 917533;
    public static final int SHADING_MODE = 0x100000;
    public static final int STATISTICS_FACE_DETECT_MODE = 0x110000;
    public static final int STATISTICS_HOT_PIXEL_MAP_MODE = 0x110003;
    public static final int STATISTICS_FACE_IDS = 0x110004;
    public static final int STATISTICS_FACE_LANDMARKS = 0x110005;
    public static final int STATISTICS_FACE_RECTANGLES = 0x110006;
    public static final int STATISTICS_FACE_SCORES = 0x110007;
    public static final int STATISTICS_LENS_SHADING_MAP = 0x11000B;
    public static final int STATISTICS_SCENE_FLICKER = 0x11000E;
    public static final int STATISTICS_HOT_PIXEL_MAP = 0x11000F;
    public static final int STATISTICS_LENS_SHADING_MAP_MODE = 0x110010;
    public static final int TONEMAP_CURVE_BLUE = 0x130000;
    public static final int TONEMAP_CURVE_GREEN = 0x130001;
    public static final int TONEMAP_CURVE_RED = 1245186;
    public static final int TONEMAP_MODE = 0x130003;
    public static final int TONEMAP_GAMMA = 1245190;
    public static final int TONEMAP_PRESET_CURVE = 1245191;
    public static final int BLACK_LEVEL_LOCK = 0x160000;
    public static final int SYNC_FRAME_NUMBER = 0x170000;
    private static final String TAG = "ARCore-ImageMetadata";
    private static final int TYPE_BYTE = 0;
    private static final int TYPE_INT = 1;
    private static final int TYPE_FLOAT = 2;
    private static final int TYPE_LONG = 3;
    private static final int TYPE_DOUBLE = 4;
    private static final int TYPE_RATIONAL = 5;
    private final Session session;
    private final long nativeSymbolTableHandle;
    private final long nativeHandle;
    private final q sketchEntry;

    /*
     * WARNING - void declaration
     */
    ImageMetadata(long nativeHandle, Session session) {
        void var1_1;
        void var3_2;
        this.session = var3_2;
        this.nativeHandle = var1_1;
        this.nativeSymbolTableHandle = var3_2.nativeSymbolTableHandle;
        this.sketchEntry = new q();
    }

    protected ImageMetadata() {
        this.session = null;
        this.nativeHandle = 0L;
        this.nativeSymbolTableHandle = 0L;
        this.sketchEntry = null;
    }

    protected void finalize() throws Throwable {
        long l2 = this.nativeHandle;
        if (l2 != 0L) {
            ImageMetadata.nativeReleaseImageMetadata(this.nativeSymbolTableHandle, l2);
        }
        super.finalize();
    }

    public long[] getKeys() {
        ImageMetadata imageMetadata = this_;
        Object this_ = imageMetadata.nativeGetAllKeys(imageMetadata.session.nativeWrapperHandle, ((ImageMetadata)this_).nativeHandle);
        if (this_ == null) {
            throw new FatalException("Unknown error in ImageMetadata.getKeys().");
        }
        return this_;
    }

    /*
     * WARNING - void declaration
     */
    public byte getByte(int key) throws MetadataNotFoundException {
        Object object;
        object.getMetdataEntry(key, object.sketchEntry);
        q q2 = object.sketchEntry;
        if (q2.b != 0 || q2.c != 1) {
            void var1_1;
            object = new Object[]{(int)var1_1};
            throw new IllegalArgumentException(String.format("Wrong return type for ImageMetadata key: %1$d.", object));
        }
        byte by = super.nativeGetByteFromMetadataEntry(object.session.nativeWrapperHandle, q2.a);
        object = object.sketchEntry;
        super.nativeDestroyMetadataEntry(object.session.nativeWrapperHandle, object.a);
        return by;
    }

    /*
     * WARNING - void declaration
     */
    public int getInt(int key) throws MetadataNotFoundException {
        Object object;
        object.getMetdataEntry(key, object.sketchEntry);
        q q2 = object.sketchEntry;
        if (q2.b != 1 || q2.c != 1) {
            void var1_1;
            object = new Object[]{(int)var1_1};
            throw new IllegalArgumentException(String.format("Wrong return type for ImageMetadata key: %1$d.", object));
        }
        int n2 = super.nativeGetIntFromMetadataEntry(object.session.nativeWrapperHandle, q2.a);
        object = object.sketchEntry;
        super.nativeDestroyMetadataEntry(object.session.nativeWrapperHandle, object.a);
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    public float getFloat(int key) throws MetadataNotFoundException {
        Object object;
        object.getMetdataEntry(key, object.sketchEntry);
        q q2 = object.sketchEntry;
        if (q2.b != 2 || q2.c != 1) {
            void var1_1;
            object = new Object[]{(int)var1_1};
            throw new IllegalArgumentException(String.format("Wrong return type for ImageMetadata key: %1$d.", object));
        }
        float f2 = super.nativeGetFloatFromMetadataEntry(object.session.nativeWrapperHandle, q2.a);
        object = object.sketchEntry;
        super.nativeDestroyMetadataEntry(object.session.nativeWrapperHandle, object.a);
        return f2;
    }

    /*
     * WARNING - void declaration
     */
    public long getLong(int key) throws MetadataNotFoundException {
        ImageMetadata imageMetadata = q2;
        imageMetadata.getMetdataEntry(key, imageMetadata.sketchEntry);
        Object[] objectArray = ((ImageMetadata)((Object)q2)).sketchEntry;
        if (objectArray.b != 3 || objectArray.c != 1) {
            void var1_1;
            objectArray = new Object[]{(int)var1_1, ((ImageMetadata)((Object)q2)).sketchEntry.b, ((ImageMetadata)((Object)q2)).sketchEntry.c};
            throw new IllegalArgumentException(String.format("Wrong return type for ImageMetadata key: %1$d, type: %2$d, count: %3$d.", objectArray));
        }
        ImageMetadata imageMetadata2 = q2;
        long l2 = imageMetadata2.nativeGetLongFromMetadataEntry(imageMetadata2.session.nativeWrapperHandle, objectArray.a);
        ImageMetadata imageMetadata3 = q2;
        q q2 = imageMetadata3.sketchEntry;
        imageMetadata3.nativeDestroyMetadataEntry(((ImageMetadata)((Object)q2)).session.nativeWrapperHandle, q2.a);
        return l2;
    }

    /*
     * WARNING - void declaration
     */
    public double getDouble(int key) throws MetadataNotFoundException {
        Object object;
        object.getMetdataEntry(key, object.sketchEntry);
        q q2 = object.sketchEntry;
        if (q2.b != 4 || q2.c != 1) {
            void var1_1;
            object = new Object[]{(int)var1_1};
            throw new IllegalArgumentException(String.format("Wrong return type for ImageMetadata key: %1$d.", object));
        }
        double d2 = super.nativeGetDoubleFromMetadataEntry(object.session.nativeWrapperHandle, q2.a);
        object = object.sketchEntry;
        super.nativeDestroyMetadataEntry(object.session.nativeWrapperHandle, object.a);
        return d2;
    }

    /*
     * WARNING - void declaration
     */
    public Rational getRational(int key) throws MetadataNotFoundException {
        Object object;
        object.getMetdataEntry(key, object.sketchEntry);
        q q2 = object.sketchEntry;
        if (q2.b != 5 || q2.c != 1) {
            void var1_1;
            object = new Object[]{(int)var1_1};
            throw new IllegalArgumentException(String.format("Wrong return type for ImageMetadata key: %1$d.", object));
        }
        Rational rational = super.nativeGetRationalFromMetadataEntry(object.session.nativeWrapperHandle, q2.a);
        object = object.sketchEntry;
        super.nativeDestroyMetadataEntry(object.session.nativeWrapperHandle, object.a);
        return rational;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getByteArray(int key) throws MetadataNotFoundException {
        Object object;
        object.getMetdataEntry(key, object.sketchEntry);
        q q2 = object.sketchEntry;
        if (q2.b != 0) {
            void var1_1;
            object = new Object[]{(int)var1_1};
            throw new IllegalArgumentException(String.format("Wrong return type for ImageMetadata key: %1$d.", object));
        }
        byte[] byArray = super.nativeGetByteArrayFromMetadataEntry(object.session.nativeWrapperHandle, q2.a);
        object = object.sketchEntry;
        super.nativeDestroyMetadataEntry(object.session.nativeWrapperHandle, object.a);
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    public int[] getIntArray(int key) throws MetadataNotFoundException {
        Object object;
        object.getMetdataEntry(key, object.sketchEntry);
        q q2 = object.sketchEntry;
        if (q2.b != 1) {
            void var1_1;
            object = new Object[]{(int)var1_1};
            throw new IllegalArgumentException(String.format("Wrong return type for ImageMetadata key: %1$d.", object));
        }
        int[] nArray = super.nativeGetIntArrayFromMetadataEntry(object.session.nativeWrapperHandle, q2.a);
        object = object.sketchEntry;
        super.nativeDestroyMetadataEntry(object.session.nativeWrapperHandle, object.a);
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    public float[] getFloatArray(int key) throws MetadataNotFoundException {
        Object object;
        object.getMetdataEntry(key, object.sketchEntry);
        q q2 = object.sketchEntry;
        if (q2.b != 2) {
            void var1_1;
            object = new Object[]{(int)var1_1};
            throw new IllegalArgumentException(String.format("Wrong return type for ImageMetadata key: %1$d.", object));
        }
        float[] fArray = super.nativeGetFloatArrayFromMetadataEntry(object.session.nativeWrapperHandle, q2.a);
        object = object.sketchEntry;
        super.nativeDestroyMetadataEntry(object.session.nativeWrapperHandle, object.a);
        return fArray;
    }

    /*
     * WARNING - void declaration
     */
    public long[] getLongArray(int key) throws MetadataNotFoundException {
        Object object;
        object.getMetdataEntry(key, object.sketchEntry);
        q q2 = object.sketchEntry;
        if (q2.b != 3) {
            void var1_1;
            object = new Object[]{(int)var1_1};
            throw new IllegalArgumentException(String.format("Wrong return type for ImageMetadata key: %1$d.", object));
        }
        long[] lArray = super.nativeGetLongArrayFromMetadataEntry(object.session.nativeWrapperHandle, q2.a);
        object = object.sketchEntry;
        super.nativeDestroyMetadataEntry(object.session.nativeWrapperHandle, object.a);
        return lArray;
    }

    /*
     * WARNING - void declaration
     */
    public double[] getDoubleArray(int key) throws MetadataNotFoundException {
        Object object;
        object.getMetdataEntry(key, object.sketchEntry);
        q q2 = object.sketchEntry;
        if (q2.b != 4) {
            void var1_1;
            object = new Object[]{(int)var1_1};
            throw new IllegalArgumentException(String.format("Wrong return type for ImageMetadata key: %1$d.", object));
        }
        double[] dArray = super.nativeGetDoubleArrayFromMetadataEntry(object.session.nativeWrapperHandle, q2.a);
        object = object.sketchEntry;
        super.nativeDestroyMetadataEntry(object.session.nativeWrapperHandle, object.a);
        return dArray;
    }

    /*
     * WARNING - void declaration
     */
    public Rational[] getRationalArray(int key) throws MetadataNotFoundException {
        Object object;
        object.getMetdataEntry(key, object.sketchEntry);
        q q2 = object.sketchEntry;
        if (q2.b != 5) {
            void var1_1;
            object = new Object[]{(int)var1_1};
            throw new IllegalArgumentException(String.format("Wrong return type for ImageMetadata key: %1$d.", object));
        }
        Rational[] rationalArray = super.nativeGetRationalArrayFromMetadataEntry(object.session.nativeWrapperHandle, q2.a);
        object = object.sketchEntry;
        super.nativeDestroyMetadataEntry(object.session.nativeWrapperHandle, object.a);
        return rationalArray;
    }

    static native void nativeLoadSymbols();

    private native long[] nativeGetAllKeys(long var1, long var3);

    private native long nativeGetMetadataEntry(long var1, long var3, int var5);

    private static native void nativeReleaseImageMetadata(long var0, long var2);

    private native void nativeDestroyMetadataEntry(long var1, long var3);

    private native int nativeGetMetadataEntryValueType(long var1, long var3);

    private native int nativeGetMetadataEntryValueCount(long var1, long var3);

    private native byte nativeGetByteFromMetadataEntry(long var1, long var3);

    private native int nativeGetIntFromMetadataEntry(long var1, long var3);

    private native float nativeGetFloatFromMetadataEntry(long var1, long var3);

    private native long nativeGetLongFromMetadataEntry(long var1, long var3);

    private native double nativeGetDoubleFromMetadataEntry(long var1, long var3);

    private native Rational nativeGetRationalFromMetadataEntry(long var1, long var3);

    private native byte[] nativeGetByteArrayFromMetadataEntry(long var1, long var3);

    private native int[] nativeGetIntArrayFromMetadataEntry(long var1, long var3);

    private native float[] nativeGetFloatArrayFromMetadataEntry(long var1, long var3);

    private native long[] nativeGetLongArrayFromMetadataEntry(long var1, long var3);

    private native double[] nativeGetDoubleArrayFromMetadataEntry(long var1, long var3);

    private native Rational[] nativeGetRationalArrayFromMetadataEntry(long var1, long var3);

    /*
     * WARNING - void declaration
     */
    private void getMetdataEntry(int key, q entry) {
        void var2_2;
        void var1_1;
        long l2;
        var2_2.a = l2 = this_.nativeGetMetadataEntry(this_.session.nativeWrapperHandle, this_.nativeHandle, (int)var1_1);
        if (l2 == 0L) {
            Object[] this_ = new Object[]{(int)var1_1};
            throw new IllegalArgumentException(String.format("Invalid ImageMetadata key: %1$d", this_));
        }
        var2_2.b = super.nativeGetMetadataEntryValueType(this_.session.nativeWrapperHandle, l2);
        var2_2.c = super.nativeGetMetadataEntryValueCount(this_.session.nativeWrapperHandle, var2_2.a);
    }
}

