/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import androidx.annotation.NonNull;
import com.google.ar.core.Quaternion;
import com.google.ar.core.annotations.UsedByNative;
import java.util.Locale;

@UsedByNative(value="session_jni_wrapper.cc")
public class Pose {
    public static final Pose IDENTITY = new Pose(new float[]{0.0f, 0.0f, 0.0f}, Quaternion.a);
    @UsedByNative(value="session_jni_wrapper.cc")
    private final Quaternion quaternion;
    @UsedByNative(value="session_jni_wrapper.cc")
    private final float[] translation;

    /*
     * WARNING - void declaration
     */
    private Pose(float x2, float y2, float z2, float qx, float qy, float qz, float qw) {
        void var3_3;
        void var2_2;
        void var1_1;
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        this.quaternion = new Quaternion((float)var4_4, (float)var5_5, (float)var6_6, (float)var7_7);
        this.translation = new float[]{var1_1, var2_2, var3_3};
    }

    /*
     * WARNING - void declaration
     */
    public Pose(float[] translation, float[] rotation) {
        this((float)var1_1[0], (float)var1_1[1], (float)var1_1[2], (float)var2_2[0], (float)var2_2[1], (float)var2_2[2], (float)var2_2[3]);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @UsedByNative(value="session_jni_wrapper.cc")
    private Pose(float[] translation, Quaternion quaternion) {
        void var2_2;
        void var1_1;
        this.translation = var1_1;
        this.quaternion = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static Pose makeTranslation(float tx, float ty, float tz) {
        void var2_2;
        void var1_1;
        float f2;
        return new Pose(new float[]{f2, var1_1, var2_2}, Pose.IDENTITY.quaternion);
    }

    @NonNull
    public static Pose makeTranslation(float[] translation) {
        float[] fArray;
        return Pose.makeTranslation(translation[0], fArray[1], fArray[2]);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static Pose makeRotation(float x2, float y2, float z2, float w2) {
        void var3_3;
        void var2_2;
        void var1_1;
        float f2;
        return new Pose(Pose.IDENTITY.translation, new Quaternion(f2, (float)var1_1, (float)var2_2, (float)var3_3));
    }

    @NonNull
    public static Pose makeRotation(float[] quaternion) {
        float[] fArray;
        return Pose.makeRotation(quaternion[0], fArray[1], fArray[2], fArray[3]);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Pose compose(Pose rhs) {
        void var1_1;
        float[] fArray = new float[3];
        Quaternion.j(this.quaternion, var1_1.translation, 0, fArray, 0);
        float[] fArray2 = this.translation;
        fArray[0] = fArray[0] + fArray2[0];
        fArray[1] = fArray[1] + fArray2[1];
        fArray[2] = fArray[2] + fArray2[2];
        return new Pose(fArray, this.quaternion.h(var1_1.quaternion));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static Pose makeInterpolated(Pose a2, Pose b2, float t2) {
        void var1_1;
        void var2_2;
        Quaternion quaternion;
        if (t2 == 0.0f) {
            return quaternion;
        }
        if (var2_2 == 1.0f) {
            return var1_1;
        }
        float[] fArray = new float[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            int n2 = i2;
            fArray[n2] = ((Pose)((Object)quaternion)).translation[i2] * (1.0f - var2_2) + var1_1.translation[n2] * var2_2;
        }
        quaternion = Quaternion.i(((Pose)((Object)quaternion)).quaternion, var1_1.quaternion, (float)var2_2);
        return new Pose(fArray, quaternion);
    }

    @NonNull
    public Pose inverse() {
        float[] fArray = new float[3];
        Quaternion quaternion = this.quaternion.g();
        Quaternion.j(quaternion, this.translation, 0, fArray, 0);
        fArray[0] = -fArray[0];
        fArray[1] = -fArray[1];
        fArray[2] = -fArray[2];
        return new Pose(fArray, quaternion);
    }

    @NonNull
    public Pose extractRotation() {
        return new Pose(Pose.IDENTITY.translation, this.quaternion);
    }

    public Pose extractTranslation() {
        Quaternion quaternion = Pose.IDENTITY.quaternion;
        return new Pose(this.translation, quaternion);
    }

    /*
     * WARNING - void declaration
     */
    public void toMatrix(float[] dest, int offset) {
        void var2_2;
        void var1_1;
        ((Pose)this_).quaternion.k((float[])var1_1, (int)var2_2);
        Object this_ = ((Pose)this_).translation;
        var1_1[var2_2 + 12] = this_[0];
        var1_1[var2_2 + 13] = this_[1];
        var1_1[var2_2 + 14] = this_[2];
        var1_1[var2_2 + 3] = 0.0f;
        var1_1[var2_2 + 7] = 0.0f;
        var1_1[var2_2 + 11] = 0.0f;
        var1_1[var2_2 + 15] = 1.0f;
    }

    public float tx() {
        return this.translation[0];
    }

    public float ty() {
        return this.translation[1];
    }

    public float tz() {
        return this.translation[2];
    }

    public float qx() {
        return this.quaternion.b();
    }

    public float qy() {
        return this.quaternion.c();
    }

    public float qz() {
        return this.quaternion.d();
    }

    public float qw() {
        return this.quaternion.e();
    }

    /*
     * WARNING - void declaration
     */
    public void getTranslation(float[] dest, int offset) {
        void var2_2;
        void var1_1;
        System.arraycopy(this.translation, 0, var1_1, (int)var2_2, 3);
    }

    public float[] getTranslation() {
        float[] fArray = new float[3];
        this.getTranslation(fArray, 0);
        return fArray;
    }

    /*
     * WARNING - void declaration
     */
    public void getRotationQuaternion(float[] dest, int offset) {
        void var2_2;
        void var1_1;
        this.quaternion.f((float[])var1_1, (int)var2_2);
    }

    public float[] getRotationQuaternion() {
        float[] fArray = new float[4];
        this.getRotationQuaternion(fArray, 0);
        return fArray;
    }

    /*
     * WARNING - void declaration
     */
    public void rotateVector(float[] vectorIn, int inOffset, float[] vectorOut, int outOffset) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Quaternion.j(this.quaternion, (float[])var1_1, (int)var2_2, (float[])var3_3, (int)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    public float[] rotateVector(float[] vectorIn) {
        void var1_1;
        float[] fArray = new float[3];
        this.rotateVector((float[])var1_1, 0, fArray, 0);
        return fArray;
    }

    /*
     * WARNING - void declaration
     */
    public void transformPoint(float[] pointIn, int inOffset, float[] pointOut, int outOffset) {
        void var4_5;
        void var3_4;
        void var2_3;
        void var1_1;
        this.rotateVector((float[])var1_1, (int)var2_3, (float[])var3_4, (int)var4_5);
        for (int i2 = 0; i2 < 3; ++i2) {
            void v0 = var3_4;
            int n2 = i2 + var4_5;
            v0[n2] = v0[n2] + this.translation[i2];
        }
    }

    /*
     * WARNING - void declaration
     */
    public float[] transformPoint(float[] x2) {
        void var1_1;
        float[] fArray = new float[3];
        this.transformPoint((float[])var1_1, 0, fArray, 0);
        return fArray;
    }

    /*
     * WARNING - void declaration
     */
    public void getTransformedAxis(int axis, float scale, float[] dest, int offset) {
        void var4_4;
        void var3_3;
        void var2_2;
        float[] fArray = new float[]{0.0f, 0.0f, 0.0f};
        fArray[var1_1] = var2_2;
        Quaternion.j(this.quaternion, fArray, 0, (float[])var3_3, (int)var4_4);
    }

    /*
     * WARNING - void declaration
     */
    public float[] getTransformedAxis(int axis, float scale) {
        void var2_2;
        void var1_1;
        float[] fArray = new float[3];
        this.getTransformedAxis((int)var1_1, (float)var2_2, fArray, 0);
        return fArray;
    }

    public float[] getXAxis() {
        return this.getTransformedAxis(0, 1.0f);
    }

    public float[] getYAxis() {
        return this.getTransformedAxis(1, 1.0f);
    }

    public float[] getZAxis() {
        return this.getTransformedAxis(2, 1.0f);
    }

    public String toString() {
        float[] fArray = this.translation;
        Object[] objectArray = new Object[]{Float.valueOf(fArray[0]), Float.valueOf(this.translation[1]), Float.valueOf(this.translation[2]), Float.valueOf(this.quaternion.b()), Float.valueOf(this.quaternion.c()), Float.valueOf(this.quaternion.d()), Float.valueOf(this.quaternion.e())};
        return String.format(Locale.ENGLISH, "t:[x:%.3f, y:%.3f, z:%.3f], q:[x:%.2f, y:%.2f, z:%.2f, w:%.2f]", objectArray);
    }

    Quaternion getQuaternion() {
        return this.quaternion;
    }
}

