/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.ar.core.Anchor;
import com.google.ar.core.ArImage;
import com.google.ar.core.AugmentedImage;
import com.google.ar.core.CameraConfig;
import com.google.ar.core.CameraConfigFilter;
import com.google.ar.core.Config;
import com.google.ar.core.DepthPoint;
import com.google.ar.core.Earth;
import com.google.ar.core.Frame;
import com.google.ar.core.HostCloudAnchorFuture;
import com.google.ar.core.ImageMetadata;
import com.google.ar.core.InstantPlacementPoint;
import com.google.ar.core.Plane;
import com.google.ar.core.PlaybackStatus;
import com.google.ar.core.Point;
import com.google.ar.core.Pose;
import com.google.ar.core.RecordingConfig;
import com.google.ar.core.RecordingStatus;
import com.google.ar.core.ResolveCloudAnchorFuture;
import com.google.ar.core.SharedCamera;
import com.google.ar.core.StreetscapeGeometry;
import com.google.ar.core.TrackData;
import com.google.ar.core.Trackable;
import com.google.ar.core.TrackableBase;
import com.google.ar.core.VpsAvailability;
import com.google.ar.core.VpsAvailabilityFuture;
import com.google.ar.core.ah;
import com.google.ar.core.ai;
import com.google.ar.core.annotations.UsedByNative;
import com.google.ar.core.exceptions.CameraNotAvailableException;
import com.google.ar.core.exceptions.FatalException;
import com.google.ar.core.exceptions.PlaybackFailedException;
import com.google.ar.core.exceptions.RecordingFailedException;
import com.google.ar.core.exceptions.UnavailableApkTooOldException;
import com.google.ar.core.exceptions.UnavailableArcoreNotInstalledException;
import com.google.ar.core.exceptions.UnavailableDeviceNotCompatibleException;
import com.google.ar.core.exceptions.UnavailableSdkTooOldException;
import com.google.ar.core.p;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class Session {
    private static final String TAG = "ARCore-Session";
    long nativeWrapperHandle;
    final long nativeSymbolTableHandle;
    private SharedCamera sharedCamera = null;
    final p faceCache = new p();

    /*
     * WARNING - void declaration
     */
    public Session(Context context) throws UnavailableArcoreNotInstalledException, UnavailableApkTooOldException, UnavailableSdkTooOldException, UnavailableDeviceNotCompatibleException {
        this((Context)var1_1, EnumSet.noneOf(Feature.class));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Session(Context context, Set<Feature> features) throws UnavailableArcoreNotInstalledException, UnavailableApkTooOldException, UnavailableSdkTooOldException, UnavailableDeviceNotCompatibleException, IllegalArgumentException {
        void var1_1;
        void var2_2;
        System.loadLibrary("arcore_sdk_jni");
        int[] nArray = new int[var2_2.size() + 1];
        Iterator iterator = var2_2.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            nArray[n2] = ((Feature)((Object)iterator.next())).nativeCode;
            ++n2;
        }
        nArray[n2] = 0;
        this.nativeWrapperHandle = Session.nativeCreateSessionAndWrapperWithFeatures((Context)var1_1, nArray);
        this.nativeSymbolTableHandle = this.nativeGetSymbolTable(this.nativeWrapperHandle);
        if (var2_2.contains((Object)Feature.SHARED_CAMERA)) {
            this.sharedCamera = new SharedCamera(this);
        }
        Session.loadDynamicSymbolsAfterSessionCreate();
    }

    /*
     * WARNING - void declaration
     */
    Session(long nativeWrapperHandle) {
        void var1_1;
        this.nativeWrapperHandle = var1_1;
        this.nativeSymbolTableHandle = this.nativeGetSymbolTable((long)var1_1);
    }

    protected Session() {
        this.nativeWrapperHandle = 0L;
        this.nativeSymbolTableHandle = 0L;
    }

    @Deprecated
    @NonNull
    public static Session createForSharedCamera(Context context) throws UnavailableArcoreNotInstalledException, UnavailableApkTooOldException, UnavailableSdkTooOldException, UnavailableDeviceNotCompatibleException {
        Context context2;
        return new Session(context2, EnumSet.of(Feature.SHARED_CAMERA));
    }

    @NonNull
    public SharedCamera getSharedCamera() {
        SharedCamera this_ = ((Session)((Object)this_)).sharedCamera;
        if (this_ == null) {
            throw new IllegalStateException("Shared camera is not in use, please create session using new Session(context, EnumSet.of(Session.Feature.SHARED_CAMERA)).");
        }
        return this_;
    }

    protected void finalize() throws Throwable {
        long l2 = this.nativeWrapperHandle;
        if (l2 != 0L) {
            this.nativeDestroySessionWrapper(l2);
            this.nativeWrapperHandle = 0L;
        }
        super.finalize();
    }

    public void close() {
        Session session = this;
        session.nativeCloseSession(session.nativeWrapperHandle);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    Trackable createTrackable(long trackableHandle) {
        Enum enum_;
        void var1_1;
        block13: {
            int n2 = TrackableBase.internalGetType(this.nativeWrapperHandle, (long)var1_1);
            for (ai ai2 : ai.values()) {
                if (ai2.k != n2) continue;
                enum_ = ai2;
                break block13;
            }
            enum_ = null;
        }
        if (enum_ == null) {
            TrackableBase.internalReleaseNativeHandle(this.nativeSymbolTableHandle, (long)var1_1);
            return null;
        }
        switch (enum_.ordinal()) {
            default: {
                throw null;
            }
            case 0: 
            case 1: {
                return null;
            }
            case 9: {
                return new InstantPlacementPoint((long)var1_1, this);
            }
            case 8: {
                return new DepthPoint((long)var1_1, this);
            }
            case 7: {
                return this.getEarth();
            }
            case 6: {
                return new StreetscapeGeometry((long)var1_1, this);
            }
            case 5: {
                return this.faceCache.a((long)var1_1, this);
            }
            case 4: {
                return new AugmentedImage((long)var1_1, this);
            }
            case 3: {
                return new Point((long)var1_1, this);
            }
            case 2: 
        }
        return new Plane((long)var1_1, this);
    }

    /*
     * WARNING - void declaration
     */
    public void configure(Config config) {
        void var1_1;
        Session session = this;
        session.nativeConfigure(session.nativeWrapperHandle, var1_1.nativeHandle);
    }

    @NonNull
    public Config getConfig() {
        Session session = this;
        Config config = new Config(session);
        session.getConfig(config);
        return config;
    }

    /*
     * WARNING - void declaration
     */
    public void getConfig(Config configToFill) {
        void var1_1;
        Session session = this;
        session.nativeGetConfig(session.nativeWrapperHandle, var1_1.nativeHandle);
    }

    public void resume() throws CameraNotAvailableException {
        Session session = this;
        session.nativeResume(session.nativeWrapperHandle);
    }

    boolean isSharedCameraUsed() {
        return this.sharedCamera != null;
    }

    @NonNull
    public Frame update() throws CameraNotAvailableException {
        Frame frame = new Frame(this);
        Session session = this;
        session.nativeUpdate(session.nativeWrapperHandle, frame.nativeHandle);
        return frame;
    }

    public void pause() {
        this.pauseSharedCameraIfInUse();
        Session session = this;
        session.nativePause(session.nativeWrapperHandle);
    }

    private void pauseSharedCameraIfInUse() {
        SharedCamera this_ = ((Session)((Object)this_)).sharedCamera;
        if (this_ != null) {
            this_.pause();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setCameraTextureNames(int[] textureIds) {
        void var1_1;
        if (textureIds == null || ((void)var1_1).length == 0) {
            throw new IllegalArgumentException("textureIds must be an array with at least 1 entry.");
        }
        Session session = this;
        session.nativeSetCameraTextureNames(session.nativeWrapperHandle, (int[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setCameraTextureName(int textureId) {
        void var1_1;
        Session session = this;
        session.nativeSetCameraTextureName(session.nativeWrapperHandle, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setDisplayGeometry(int displayRotation, int widthPx, int heightPx) {
        void var3_3;
        void var2_2;
        void var1_1;
        Session session = this;
        session.nativeSetDisplayGeometry(session.nativeWrapperHandle, (int)var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public boolean isSupported(Config config) {
        void var1_1;
        Session session = this;
        return session.nativeIsSupported(session.nativeWrapperHandle, var1_1.nativeHandle);
    }

    @NonNull
    public Collection<Anchor> getAllAnchors() {
        Session session = this;
        return session.convertNativeAnchorsToCollection(session.nativeAcquireAllAnchors(session.nativeWrapperHandle));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public <T extends Trackable> Collection<T> getAllTrackables(Class<T> filterType) {
        void var1_1;
        ai ai2 = ai.a(filterType);
        if (ai2 == ai.b) {
            return Collections.emptyList();
        }
        Session session = this;
        return session.convertNativeTrackablesToCollection((Class<T>)var1_1, session.nativeAcquireAllTrackables(session.nativeWrapperHandle, ai2.k));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Anchor createAnchor(Pose pose) {
        void var1_1;
        Session session = this;
        long l2 = session.nativeCreateAnchor(session.nativeWrapperHandle, (Pose)var1_1);
        return new Anchor(l2, this);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public FeatureMapQuality estimateFeatureMapQualityForHosting(Pose pose) {
        void var1_1;
        Session session = this;
        return FeatureMapQuality.forNumber(session.nativeEstimateFeatureMapQualityForHosting(session.nativeWrapperHandle, (Pose)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public Anchor hostCloudAnchor(Anchor anchor) {
        void var1_1;
        Session session = this;
        long l2 = session.nativeHostCloudAnchor(session.nativeWrapperHandle, var1_1.nativeHandle);
        return new Anchor(l2, this);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public Anchor hostCloudAnchorWithTtl(Anchor anchor, int ttlDays) {
        void var2_2;
        void var1_1;
        Session session = this;
        long l2 = session.nativeHostCloudAnchorWithTtl(session.nativeWrapperHandle, var1_1.nativeHandle, (int)var2_2);
        return new Anchor(l2, this);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NonNull
    public HostCloudAnchorFuture hostCloudAnchorAsync(Anchor anchor, int ttlDays, @Nullable BiConsumer<String, Anchor.CloudAnchorState> callback) {
        void var2_2;
        long[] lArray;
        HostCloudAnchorFuture.CallbackWrapper callbackWrapper;
        callbackWrapper = callback != null ? new HostCloudAnchorFuture.CallbackWrapper((BiConsumer)((Object)callbackWrapper)) : null;
        Session session = this;
        lArray = session.nativeHostCloudAnchorAsync(session.nativeWrapperHandle, lArray.nativeHandle, (int)var2_2, callbackWrapper);
        return new HostCloudAnchorFuture(this, lArray[0], lArray[1]);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public Anchor resolveCloudAnchor(String cloudAnchorId) {
        void var1_1;
        Session session = this;
        long l2 = session.nativeResolveCloudAnchor(session.nativeWrapperHandle, (String)var1_1);
        return new Anchor(l2, this);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNull
    public ResolveCloudAnchorFuture resolveCloudAnchorAsync(String cloudAnchorId, @Nullable BiConsumer<Anchor, Anchor.CloudAnchorState> callback) {
        long[] lArray;
        ResolveCloudAnchorFuture.CallbackWrapper callbackWrapper;
        callbackWrapper = callback != null ? new ResolveCloudAnchorFuture.CallbackWrapper(this, (BiConsumer)((Object)callbackWrapper)) : null;
        Session session = this;
        lArray = session.nativeResolveCloudAnchorAsync(session.nativeWrapperHandle, (String)lArray, callbackWrapper);
        return new ResolveCloudAnchorFuture(this, lArray[0], lArray[1]);
    }

    /*
     * WARNING - void declaration
     */
    Collection<TrackData> convertNativeTrackDataToCollection(long[] trackDataHandles) {
        void var1_1;
        int n2 = ((void)var1_1).length;
        ArrayList<TrackData> arrayList = new ArrayList<TrackData>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            void var5_5 = var1_1[i2];
            arrayList.add(new TrackData((long)var5_5, this));
        }
        return Collections.unmodifiableList(arrayList);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    Collection<Anchor> convertNativeAnchorsToCollection(long[] anchorHandles) {
        void var1_1;
        int n2 = ((void)var1_1).length;
        ArrayList<Anchor> arrayList = new ArrayList<Anchor>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            void var5_5 = var1_1[i2];
            arrayList.add(new Anchor((long)var5_5, this));
        }
        return Collections.unmodifiableList(arrayList);
    }

    /*
     * WARNING - void declaration
     */
    <T extends Trackable> Collection<T> convertNativeTrackablesToCollection(Class<T> filterType, long[] trackableHandles) {
        void var2_2;
        int n2 = ((void)var2_2).length;
        ArrayList<Trackable> arrayList = new ArrayList<Trackable>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            void var1_1;
            Trackable trackable = this.createTrackable((long)var2_2[i2]);
            if (trackable == null) continue;
            arrayList.add((Trackable)var1_1.cast(trackable));
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Deprecated
    @NonNull
    public List<CameraConfig> getSupportedCameraConfigs() {
        Session session = this;
        return session.convertNativeCameraConfigsToCollection(session.nativeGetSupportedCameraConfigs(session.nativeWrapperHandle));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public List<CameraConfig> getSupportedCameraConfigs(CameraConfigFilter cameraConfigFilter) {
        void var1_1;
        if (cameraConfigFilter == null) {
            throw new IllegalArgumentException();
        }
        Session session = this;
        long[] lArray = session.nativeGetSupportedCameraConfigsWithFilter(session.nativeWrapperHandle, var1_1.nativeHandle);
        int n2 = lArray.length;
        ArrayList<CameraConfig> arrayList = new ArrayList<CameraConfig>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = lArray[i2];
            arrayList.add(new CameraConfig(this, l2));
        }
        return Collections.unmodifiableList(arrayList);
    }

    /*
     * WARNING - void declaration
     */
    public void setCameraConfig(CameraConfig cameraConfig) {
        void var1_1;
        Session session = this;
        session.nativeSetCameraConfig(session.nativeWrapperHandle, var1_1.nativeHandle);
    }

    @NonNull
    public CameraConfig getCameraConfig() {
        Session session = this;
        long l2 = session.nativeGetCameraConfig(session.nativeWrapperHandle);
        return new CameraConfig(this, l2);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    List<CameraConfig> convertNativeCameraConfigsToCollection(long[] cameraConfigHandles) {
        void var1_1;
        int n2 = ((void)var1_1).length;
        ArrayList<CameraConfig> arrayList = new ArrayList<CameraConfig>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            void var5_5 = var1_1[i2];
            arrayList.add(new CameraConfig(this, (long)var5_5));
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Nullable
    public Earth getEarth() {
        Session session = this;
        long l2 = session.nativeAcquireEarth(session.nativeWrapperHandle);
        if (l2 != 0L) {
            return new Earth(l2, this);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isDepthModeSupported(Config.DepthMode mode) {
        void var1_1;
        Session session = this;
        return session.nativeIsDepthModeSupported(session.nativeWrapperHandle, var1_1.nativeCode);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isSemanticModeSupported(Config.SemanticMode mode) {
        void var1_1;
        Session session = this;
        return session.nativeIsSemanticModeSupported(session.nativeWrapperHandle, var1_1.nativeCode);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isImageStabilizationModeSupported(Config.ImageStabilizationMode imageStabilizationMode) {
        void var1_1;
        Session session = this;
        return session.nativeIsImageStabilizationModeSupported(session.nativeWrapperHandle, var1_1.nativeCode);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isGeospatialModeSupported(Config.GeospatialMode geospatialMode) {
        void var1_1;
        Session session = this;
        return session.nativeIsGeospatialModeSupported(session.nativeWrapperHandle, var1_1.nativeCode);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NonNull
    public VpsAvailabilityFuture checkVpsAvailabilityAsync(double latitude, double longitude, @Nullable Consumer<VpsAvailability> callback) {
        void var3_2;
        void var1_1;
        Object object;
        object = callback != null ? new VpsAvailabilityFuture.CallbackWrapper((Consumer)object) : null;
        Session session = this;
        object = session.nativeCheckVpsAvailabilityAsync(session.nativeWrapperHandle, (double)var1_1, (double)var3_2, (VpsAvailabilityFuture.CallbackWrapper)object);
        return new VpsAvailabilityFuture(this, (long)object[0], (long)object[1]);
    }

    static void throwExceptionFromArStatus(int arStatus) throws Exception {
        int n2;
        Session.throwExceptionFromArStatus(null, n2, null, null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @UsedByNative(value="session_jni.cc")
    static void throwExceptionFromArStatus(String possibleErrorTrace, int arStatus, String[] filenames, int[] lineNumbers) throws Exception {
        ah[] ahArray = ah.values();
        int n2 = ahArray.length;
        int n3 = 0;
        while (true) {
            block13: {
                void var0_3;
                void var0_1;
                String string2;
                String string3;
                void var3_11;
                void var2_9;
                Serializable serializable;
                ah ah2;
                int n4;
                block15: {
                    block14: {
                        if (n3 >= n2) {
                            int n5 = String.valueOf(n4).length();
                            StringBuilder stringBuilder = new StringBuilder(n5 + 23);
                            stringBuilder.append("Unexpected error code: ");
                            stringBuilder.append(n4);
                            throw new FatalException(stringBuilder.toString());
                        }
                        ah2 = ahArray[n3];
                        if (ah2.G != n4) break block13;
                        serializable = ah2.H;
                        if (serializable == null) {
                            return;
                        }
                        if (var2_9 == null) break block14;
                        if (var3_11 != null) {
                            n4 = ((void)var2_9).length;
                            if (n4 != ((void)var3_11).length) {
                                n4 = 0;
                            }
                            break block15;
                        } else {
                            n4 = 0;
                        }
                        break block15;
                    }
                    n4 = 0;
                }
                if ((string3 = ah2.I) == null && string2 == null) {
                    throw (Exception)((Class)serializable).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                if (string3 != null) {
                    if (string2 == null) {
                        String string4 = string3;
                    } else {
                        String.valueOf(string3);
                        String.valueOf(string2);
                        String string5 = String.valueOf(string3).concat(String.valueOf(string2));
                    }
                }
                serializable = (Exception)ah2.H.getConstructor(String.class).newInstance(var0_1);
                StackTraceElement[] stackTraceElementArray = ((Throwable)serializable).getStackTrace();
                StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[n4 + stackTraceElementArray.length];
                boolean bl = false;
                while (var0_3 < n4) {
                    ah2 = var2_9[var0_3];
                    void v1 = var0_3++;
                    void var8_20 = var3_11[v1];
                    stackTraceElementArray2[v1] = new StackTraceElement("ARCore", "native", (String)((Object)ah2), (int)var8_20);
                }
                int n6 = stackTraceElementArray.length;
                n4 = 0;
                while (true) {
                    void var0_4;
                    if (n4 >= n6) {
                        ((Throwable)serializable).setStackTrace(stackTraceElementArray2);
                        throw serializable;
                    }
                    stackTraceElementArray2[var0_4] = stackTraceElementArray[n4];
                    ++var0_4;
                    ++n4;
                }
            }
            ++n3;
        }
    }

    static void loadDynamicSymbolsAfterSessionCreate() {
        if (Build.VERSION.SDK_INT >= 24) {
            ArImage.nativeLoadSymbols();
            ImageMetadata.nativeLoadSymbols();
            return;
        }
    }

    static ByteBuffer directByteBufferOrDefault(ByteBuffer nullableDirectByteBuffer) {
        ByteBuffer byteBuffer;
        if (nullableDirectByteBuffer == null) {
            return ByteBuffer.allocateDirect(0).order(ByteOrder.nativeOrder());
        }
        return byteBuffer.order(ByteOrder.nativeOrder());
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setPlaybackDataset(String mp4DatasetFilePath) throws PlaybackFailedException {
        void var1_1;
        Session session = this;
        session.nativeSetPlaybackDataset(session.nativeWrapperHandle, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setPlaybackDatasetUri(Uri mp4DatasetUri) throws PlaybackFailedException {
        void var1_1;
        Session session = this;
        session.nativeSetPlaybackDatasetUri(session.nativeWrapperHandle, var1_1.toString());
    }

    @NonNull
    public PlaybackStatus getPlaybackStatus() {
        Session session = this;
        return PlaybackStatus.forNumber(session.nativeGetPlaybackStatus(session.nativeWrapperHandle));
    }

    /*
     * WARNING - void declaration
     */
    public void startRecording(RecordingConfig recordingConfig) throws RecordingFailedException {
        void var1_1;
        if (recordingConfig == null) {
            throw new IllegalArgumentException();
        }
        Session session = this;
        session.nativeStartRecording(session.nativeWrapperHandle, var1_1.nativeHandle);
    }

    public void stopRecording() throws RecordingFailedException {
        Session session = this;
        session.nativeStopRecording(session.nativeWrapperHandle);
    }

    @NonNull
    public RecordingStatus getRecordingStatus() {
        Session session = this;
        return RecordingStatus.forNumber(session.nativeGetRecordingStatus(session.nativeWrapperHandle));
    }

    private static native long nativeCreateSessionAndWrapperWithFeatures(Context var0, int[] var1) throws UnavailableArcoreNotInstalledException, UnavailableApkTooOldException, UnavailableSdkTooOldException, UnavailableDeviceNotCompatibleException;

    native void nativeDestroySessionWrapper(long var1);

    private native void nativeCloseSession(long var1);

    private native long nativeGetSymbolTable(long var1);

    private native int nativeCheckModuleAvailability(long var1, int var3);

    private native void nativeRequestModuleInstallImmediate(long var1, int[] var3);

    private native void nativeRequestModuleInstallDeferred(long var1, int[] var3);

    private native boolean nativeIsSupported(long var1, long var3);

    private native void nativeConfigure(long var1, long var3);

    private native void nativeGetConfig(long var1, long var3);

    private native void nativeGetRandomAccessStats(long var1, long var3);

    private native void nativeResume(long var1);

    private native void nativePause(long var1);

    private native void nativeSetCameraTextureNames(long var1, int[] var3);

    private native void nativeSetCameraTextureName(long var1, int var3);

    private native void nativeSetDisplayGeometry(long var1, int var3, int var4, int var5);

    private native void nativeUpdate(long var1, long var3);

    private native long nativeCreateAnchor(long var1, Pose var3);

    private native long[] nativeAcquireAllAnchors(long var1);

    native long[] nativeAcquireAllTrackables(long var1, int var3);

    private native int nativeEstimateFeatureMapQualityForHosting(long var1, Pose var3);

    private native long nativeHostCloudAnchor(long var1, long var3);

    private native long nativeHostCloudAnchorWithTtl(long var1, long var3, int var5);

    private native long[] nativeHostCloudAnchorAsync(long var1, long var3, int var5, HostCloudAnchorFuture.CallbackWrapper var6);

    private native long nativeResolveCloudAnchor(long var1, String var3);

    private native long[] nativeResolveCloudAnchorAsync(long var1, String var3, ResolveCloudAnchorFuture.CallbackWrapper var4);

    private native long[] nativeGetSupportedCameraConfigsWithFilter(long var1, long var3);

    private native long[] nativeGetSupportedCameraConfigs(long var1);

    private native int nativeSetCameraConfig(long var1, long var3);

    private native long nativeGetCameraConfig(long var1);

    private native long nativeAcquireEarth(long var1);

    private native void nativeSetPlaybackDataset(long var1, String var3);

    private native void nativeSetPlaybackDatasetUri(long var1, String var3);

    private native void nativeStartRecording(long var1, long var3);

    private native void nativeStopRecording(long var1);

    private native int nativeGetRecordingStatus(long var1);

    private native int nativeGetPlaybackStatus(long var1);

    static native long nativeCreateSessionWrapperFromHandle(long var0, long var2);

    native long nativeReleaseSessionOwnership(long var1);

    native long nativeGetSessionNativeHandle(long var1);

    native boolean nativeIsDepthModeSupported(long var1, int var3);

    native boolean nativeIsSemanticModeSupported(long var1, int var3);

    native boolean nativeIsImageStabilizationModeSupported(long var1, int var3);

    native boolean nativeIsGeospatialModeSupported(long var1, int var3);

    native long[] nativeCheckVpsAvailabilityAsync(long var1, double var3, double var5, VpsAvailabilityFuture.CallbackWrapper var7);

    public static enum Feature {
        FRONT_CAMERA(1),
        SHARED_CAMERA(1000);

        final int nativeCode;

        /*
         * WARNING - void declaration
         */
        private Feature(int nativeCode) {
            void var3_3;
            this.nativeCode = var3_3;
        }
    }

    public static enum FeatureMapQuality {
        INSUFFICIENT(0),
        SUFFICIENT(1),
        GOOD(2);

        final int nativeCode;

        /*
         * WARNING - void declaration
         */
        private FeatureMapQuality(int nativeCode) {
            void var3_3;
            this.nativeCode = var3_3;
        }

        @NonNull
        static FeatureMapQuality forNumber(int nativeCode) {
            FeatureMapQuality[] featureMapQualityArray = FeatureMapQuality.values();
            int n2 = featureMapQualityArray.length;
            int n3 = 0;
            while (true) {
                int n4;
                if (n3 < n2) {
                    FeatureMapQuality featureMapQuality = featureMapQualityArray[n3];
                    if (featureMapQuality.nativeCode == n4) {
                        return featureMapQuality;
                    }
                } else {
                    String string2 = "Unexpected value for native FeatureMapQuality, value=";
                    throw new FatalException(p.b((byte)53, n4, string2));
                }
                ++n3;
            }
        }
    }
}

