/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import androidx.annotation.NonNull;
import com.google.ar.core.Session;
import java.nio.ByteBuffer;
import java.util.UUID;

public class Track {
    private final Session session;
    private final long nativeSymbolTableHandle;
    long nativeHandle;

    /*
     * WARNING - void declaration
     */
    public Track(Session session) {
        void var1_1;
        this.session = var1_1;
        this.nativeHandle = Track.nativeCreateTrack(var1_1.nativeWrapperHandle);
        this.nativeSymbolTableHandle = var1_1.nativeSymbolTableHandle;
    }

    protected Track() {
        this.session = null;
        this.nativeHandle = 0L;
        this.nativeSymbolTableHandle = 0L;
    }

    protected void finalize() throws Throwable {
        long l2 = this.nativeHandle;
        if (l2 != 0L) {
            Track.nativeDestroyTrack(this.nativeSymbolTableHandle, l2);
            this.nativeHandle = 0L;
        }
        super.finalize();
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Track setId(UUID trackUuid) {
        void var1_1;
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[16]);
        byteBuffer.putLong(var1_1.getMostSignificantBits());
        byteBuffer.putLong(var1_1.getLeastSignificantBits());
        Track track = this;
        track.nativeSetId(track.session.nativeWrapperHandle, this.nativeHandle, byteBuffer.array());
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Track setMetadata(ByteBuffer metadata) {
        void var1_1;
        metadata.position(0);
        byte[] byArray = new byte[var1_1.remaining()];
        var1_1.get(byArray);
        Track track = this;
        track.nativeSetMetadata(track.session.nativeWrapperHandle, this.nativeHandle, byArray);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public Track setMimeType(String mimeType) {
        void var1_1;
        Track track = this;
        track.nativeSetMimeType(track.session.nativeWrapperHandle, this.nativeHandle, (String)var1_1);
        return this;
    }

    private static native long nativeCreateTrack(long var0);

    private static native void nativeDestroyTrack(long var0, long var2);

    private native void nativeSetId(long var1, long var3, byte[] var5);

    private native void nativeSetMetadata(long var1, long var3, byte[] var5);

    private native void nativeSetMimeType(long var1, long var3, String var5);
}

