// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: proto/tink.proto

package com.google.crypto.tink.proto;

/**
 * <pre>
 * Tink produces and accepts ciphertexts or signatures that consist
 * of a prefix and a payload. The payload and its format is determined
 * entirely by the primitive, but the prefix has to be one of the following
 * 4 types:
 *   - Legacy: prefix is 5 bytes, starts with &#92;x00 and followed by a 4-byte
 *             key id that is computed from the key material.
 *   - Crunchy: prefix is 5 bytes, starts with &#92;x00 and followed by a 4-byte
 *             key id that is generated randomly.
 *   - Tink  : prefix is 5 bytes, starts with &#92;x01 and followed by 4-byte
 *             key id that is generated randomly.
 *   - Raw   : prefix is 0 byte, i.e., empty.
 * </pre>
 *
 * Protobuf enum {@code google.crypto.tink.OutputPrefixType}
 */
public enum OutputPrefixType
    implements com.google.protobuf.Internal.EnumLite {
  /**
   * <code>UNKNOWN_PREFIX = 0;</code>
   */
  UNKNOWN_PREFIX(0),
  /**
   * <code>TINK = 1;</code>
   */
  TINK(1),
  /**
   * <code>LEGACY = 2;</code>
   */
  LEGACY(2),
  /**
   * <code>RAW = 3;</code>
   */
  RAW(3),
  /**
   * <pre>
   * CRUNCHY is like LEGACY, but with two differences:
   *   - Its key id is generated randomly (like TINK)
   *   - Its signature schemes don't append zero to sign messages
   * </pre>
   *
   * <code>CRUNCHY = 4;</code>
   */
  CRUNCHY(4),
  UNRECOGNIZED(-1),
  ;

  /**
   * <code>UNKNOWN_PREFIX = 0;</code>
   */
  public static final int UNKNOWN_PREFIX_VALUE = 0;
  /**
   * <code>TINK = 1;</code>
   */
  public static final int TINK_VALUE = 1;
  /**
   * <code>LEGACY = 2;</code>
   */
  public static final int LEGACY_VALUE = 2;
  /**
   * <code>RAW = 3;</code>
   */
  public static final int RAW_VALUE = 3;
  /**
   * <pre>
   * CRUNCHY is like LEGACY, but with two differences:
   *   - Its key id is generated randomly (like TINK)
   *   - Its signature schemes don't append zero to sign messages
   * </pre>
   *
   * <code>CRUNCHY = 4;</code>
   */
  public static final int CRUNCHY_VALUE = 4;


  public final int getNumber() {
    return value;
  }

  /**
   * @deprecated Use {@link #forNumber(int)} instead.
   */
  @java.lang.Deprecated
  public static OutputPrefixType valueOf(int value) {
    return forNumber(value);
  }

  public static OutputPrefixType forNumber(int value) {
    switch (value) {
      case 0: return UNKNOWN_PREFIX;
      case 1: return TINK;
      case 2: return LEGACY;
      case 3: return RAW;
      case 4: return CRUNCHY;
      default: return null;
    }
  }

  public static com.google.protobuf.Internal.EnumLiteMap<OutputPrefixType>
      internalGetValueMap() {
    return internalValueMap;
  }
  private static final com.google.protobuf.Internal.EnumLiteMap<
      OutputPrefixType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<OutputPrefixType>() {
          public OutputPrefixType findValueByNumber(int number) {
            return OutputPrefixType.forNumber(number);
          }
        };

  private final int value;

  private OutputPrefixType(int value) {
    this.value = value;
  }

  // @@protoc_insertion_point(enum_scope:google.crypto.tink.OutputPrefixType)
}

