/*
 * Decompiled with CFR 0.152.
 */
package dagger.android;

import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.util.Log;
import dagger.android.DispatchingAndroidInjector;
import dagger.android.HasDispatchingActivityInjector;
import dagger.android.HasDispatchingBroadcastReceiverInjector;
import dagger.android.HasDispatchingFragmentInjector;
import dagger.android.HasDispatchingServiceInjector;
import dagger.internal.Preconditions;

public final class AndroidInjection {
    private static final String TAG = "dagger.android";

    public static void inject(Activity activity) {
        Preconditions.checkNotNull((Object)activity, (String)"activity");
        Application application = activity.getApplication();
        if (!(application instanceof HasDispatchingActivityInjector)) {
            throw new RuntimeException(String.format("%s does not implement %s", application.getClass().getCanonicalName(), HasDispatchingActivityInjector.class.getCanonicalName()));
        }
        DispatchingAndroidInjector<Activity> activityInjector = ((HasDispatchingActivityInjector)application).activityInjector();
        Preconditions.checkNotNull(activityInjector, (String)"%s.activityInjector() returned null", (Object)application.getClass().getCanonicalName());
        activityInjector.inject(activity);
    }

    public static void inject(Fragment fragment) {
        Preconditions.checkNotNull((Object)fragment, (String)"fragment");
        HasDispatchingFragmentInjector hasDispatchingFragmentInjector = AndroidInjection.findHasFragmentInjector(fragment);
        Log.d((String)TAG, (String)String.format("An injector for %s was found in %s", fragment.getClass().getCanonicalName(), hasDispatchingFragmentInjector.getClass().getCanonicalName()));
        DispatchingAndroidInjector<Fragment> fragmentInjector = hasDispatchingFragmentInjector.fragmentInjector();
        Preconditions.checkNotNull(fragmentInjector, (String)"%s.fragmentInjector() returned null", (Object)hasDispatchingFragmentInjector.getClass().getCanonicalName());
        fragmentInjector.inject(fragment);
    }

    private static HasDispatchingFragmentInjector findHasFragmentInjector(Fragment fragment) {
        Fragment parentFragment = fragment;
        while ((parentFragment = parentFragment.getParentFragment()) != null) {
            if (!(parentFragment instanceof HasDispatchingFragmentInjector)) continue;
            return (HasDispatchingFragmentInjector)parentFragment;
        }
        Activity activity = fragment.getActivity();
        if (activity instanceof HasDispatchingFragmentInjector) {
            return (HasDispatchingFragmentInjector)activity;
        }
        if (activity.getApplication() instanceof HasDispatchingFragmentInjector) {
            return (HasDispatchingFragmentInjector)activity.getApplication();
        }
        throw new IllegalArgumentException(String.format("No injector was found for %s", fragment.getClass().getCanonicalName()));
    }

    public static void inject(Service service) {
        Preconditions.checkNotNull((Object)service, (String)"service");
        Application application = service.getApplication();
        if (!(application instanceof HasDispatchingServiceInjector)) {
            throw new RuntimeException(String.format("%s does not implement %s", application.getClass().getCanonicalName(), HasDispatchingServiceInjector.class.getCanonicalName()));
        }
        DispatchingAndroidInjector<Service> serviceInjector = ((HasDispatchingServiceInjector)application).serviceInjector();
        Preconditions.checkNotNull(serviceInjector, (String)"%s.serviceInjector() returned null", (Object)application.getClass().getCanonicalName());
        serviceInjector.inject(service);
    }

    public static void inject(BroadcastReceiver broadcastReceiver, Context context) {
        Preconditions.checkNotNull((Object)broadcastReceiver, (String)"broadcastReceiver");
        Preconditions.checkNotNull((Object)context, (String)"context");
        Application application = (Application)context.getApplicationContext();
        if (!(application instanceof HasDispatchingBroadcastReceiverInjector)) {
            throw new RuntimeException(String.format("%s does not implement %s", application.getClass().getCanonicalName(), HasDispatchingBroadcastReceiverInjector.class.getCanonicalName()));
        }
        DispatchingAndroidInjector<BroadcastReceiver> broadcastReceiverInjector = ((HasDispatchingBroadcastReceiverInjector)application).broadcastReceiverInjector();
        Preconditions.checkNotNull(broadcastReceiverInjector, (String)"%s.broadcastReceiverInjector() returned null", (Object)application.getClass().getCanonicalName());
        broadcastReceiverInjector.inject(broadcastReceiver);
    }

    private AndroidInjection() {
    }
}

