/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingGraphValidator;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentGenerator;
import dagger.internal.codegen.SourceFileGenerationException;
import dagger.internal.codegen.ValidationReport;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;

abstract class AbstractComponentProcessingStep
implements BasicAnnotationProcessor.ProcessingStep {
    private final Messager messager;
    private final BindingGraphValidator bindingGraphValidator;
    private final BindingGraph.Factory bindingGraphFactory;
    private final ComponentGenerator componentGenerator;

    AbstractComponentProcessingStep(Messager messager, BindingGraphValidator bindingGraphValidator, BindingGraph.Factory bindingGraphFactory, ComponentGenerator componentGenerator) {
        this.messager = messager;
        this.bindingGraphValidator = bindingGraphValidator;
        this.bindingGraphFactory = bindingGraphFactory;
        this.componentGenerator = componentGenerator;
    }

    public final ImmutableSet<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        ImmutableSet.Builder rejectedElements = ImmutableSet.builder();
        for (ComponentDescriptor componentDescriptor : this.componentDescriptors(elementsByAnnotation)) {
            try {
                BindingGraph bindingGraph = this.bindingGraphFactory.create(componentDescriptor);
                ValidationReport<BindingGraph> graphReport = this.bindingGraphValidator.validate(bindingGraph);
                graphReport.printMessagesTo(this.messager);
                if (!graphReport.isClean()) continue;
                try {
                    this.componentGenerator.generate(bindingGraph);
                }
                catch (SourceFileGenerationException e) {
                    e.printMessageTo(this.messager);
                }
            }
            catch (TypeNotPresentException e) {
                rejectedElements.add((Object)componentDescriptor.componentDefinitionType());
            }
        }
        return rejectedElements.build();
    }

    protected abstract Set<ComponentDescriptor> componentDescriptors(SetMultimap<Class<? extends Annotation>, Element> var1);
}

