/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import dagger.Component;
import dagger.internal.codegen.AutoValue_BindingGraph;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.InjectBindingRegistry;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.ModuleDescriptor;
import dagger.internal.codegen.ProductionBinding;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.ResolvedBindings;
import dagger.producers.ProductionComponent;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;

abstract class BindingGraph {
    BindingGraph() {
    }

    abstract ComponentDescriptor componentDescriptor();

    abstract ImmutableMap<BindingKey, ResolvedBindings> resolvedBindings();

    abstract ImmutableMap<ExecutableElement, BindingGraph> subgraphs();

    ImmutableSet<TypeElement> componentRequirements() {
        return FluentIterable.from(this.componentDescriptor().transitiveModules()).transform((Function)new Function<ModuleDescriptor, TypeElement>(){

            public TypeElement apply(ModuleDescriptor input) {
                return input.moduleElement();
            }
        }).append(this.componentDescriptor().dependencies()).append((Iterable)this.componentDescriptor().executorDependency().asSet()).toSet();
    }

    static final class Factory {
        private final Elements elements;
        private final InjectBindingRegistry injectBindingRegistry;
        private final Key.Factory keyFactory;
        private final DependencyRequest.Factory dependencyRequestFactory;
        private final ProvisionBinding.Factory provisionBindingFactory;
        private final ProductionBinding.Factory productionBindingFactory;

        Factory(Elements elements, InjectBindingRegistry injectBindingRegistry, Key.Factory keyFactory, DependencyRequest.Factory dependencyRequestFactory, ProvisionBinding.Factory provisionBindingFactory, ProductionBinding.Factory productionBindingFactory) {
            this.elements = elements;
            this.injectBindingRegistry = injectBindingRegistry;
            this.keyFactory = keyFactory;
            this.dependencyRequestFactory = dependencyRequestFactory;
            this.provisionBindingFactory = provisionBindingFactory;
            this.productionBindingFactory = productionBindingFactory;
        }

        BindingGraph create(ComponentDescriptor componentDescriptor) {
            return this.create((Optional<RequestResolver>)Optional.absent(), componentDescriptor);
        }

        private BindingGraph create(Optional<RequestResolver> parentResolver, ComponentDescriptor componentDescriptor) {
            ImmutableSet.Builder explicitProvisionBindingsBuilder = ImmutableSet.builder();
            ImmutableSet.Builder explicitProductionBindingsBuilder = ImmutableSet.builder();
            TypeElement componentDefinitionType = componentDescriptor.componentDefinitionType();
            ProvisionBinding componentBinding = this.provisionBindingFactory.forComponent(componentDefinitionType);
            explicitProvisionBindingsBuilder.add((Object)componentBinding);
            Optional componentMirror = MoreElements.getAnnotationMirror(componentDefinitionType, Component.class).or(MoreElements.getAnnotationMirror(componentDefinitionType, ProductionComponent.class));
            ImmutableSet<TypeElement> componentDependencyTypes = componentMirror.isPresent() ? MoreTypes.asTypeElements(ConfigurationAnnotations.getComponentDependencies((AnnotationMirror)componentMirror.get())) : ImmutableSet.of();
            for (TypeElement componentDependency : componentDependencyTypes) {
                explicitProvisionBindingsBuilder.add((Object)this.provisionBindingFactory.forComponent(componentDependency));
                List<ExecutableElement> dependencyMethods = ElementFilter.methodsIn(this.elements.getAllMembers(componentDependency));
                for (ExecutableElement method : dependencyMethods) {
                    if (!ComponentDescriptor.isComponentContributionMethod(this.elements, method)) continue;
                    if (componentDescriptor.kind().equals((Object)ComponentDescriptor.Kind.PRODUCTION_COMPONENT) && ComponentDescriptor.isComponentProductionMethod(this.elements, method)) {
                        explicitProductionBindingsBuilder.add((Object)this.productionBindingFactory.forComponentMethod(method));
                        continue;
                    }
                    explicitProvisionBindingsBuilder.add((Object)this.provisionBindingFactory.forComponentMethod(method));
                }
            }
            for (ModuleDescriptor moduleDescriptor : componentDescriptor.transitiveModules()) {
                for (ContributionBinding binding : moduleDescriptor.bindings()) {
                    if (binding instanceof ProvisionBinding) {
                        explicitProvisionBindingsBuilder.add((Object)((ProvisionBinding)binding));
                    }
                    if (!(binding instanceof ProductionBinding)) continue;
                    explicitProductionBindingsBuilder.add((Object)((ProductionBinding)binding));
                }
            }
            RequestResolver requestResolver = new RequestResolver(parentResolver, componentDescriptor.wrappedScope(), this.explicitBindingsByKey((Iterable)explicitProvisionBindingsBuilder.build()), this.explicitBindingsByKey((Iterable)explicitProductionBindingsBuilder.build()));
            for (ComponentDescriptor.ComponentMethodDescriptor componentMethod : componentDescriptor.componentMethods()) {
                Optional<DependencyRequest> componentMethodRequest = componentMethod.dependencyRequest();
                if (!componentMethodRequest.isPresent()) continue;
                requestResolver.resolve((DependencyRequest)componentMethodRequest.get());
            }
            ImmutableMap.Builder subgraphsBuilder = ImmutableMap.builder();
            for (Map.Entry subcomponentEntry : componentDescriptor.subcomponents().entrySet()) {
                subgraphsBuilder.put(subcomponentEntry.getKey(), (Object)this.create((Optional<RequestResolver>)Optional.of((Object)requestResolver), (ComponentDescriptor)subcomponentEntry.getValue()));
            }
            return new AutoValue_BindingGraph(componentDescriptor, requestResolver.getResolvedBindings(), (ImmutableMap<ExecutableElement, BindingGraph>)subgraphsBuilder.build());
        }

        private <B extends ContributionBinding> ImmutableSetMultimap<Key, B> explicitBindingsByKey(Iterable<? extends B> bindings) {
            ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
            for (ContributionBinding binding : bindings) {
                builder.put((Object)binding.key(), (Object)binding);
            }
            return builder.build();
        }

        private final class RequestResolver {
            final Optional<RequestResolver> parentResolver;
            final Optional<Equivalence.Wrapper<AnnotationMirror>> targetScope;
            final ImmutableSetMultimap<Key, ProvisionBinding> explicitProvisionBindings;
            final ImmutableSetMultimap<Key, ProductionBinding> explicitProductionBindings;
            final Map<BindingKey, ResolvedBindings> resolvedBindings;
            final Deque<BindingKey> cycleStack = new ArrayDeque<BindingKey>();

            RequestResolver(Optional<RequestResolver> parentResolver, Optional<Equivalence.Wrapper<AnnotationMirror>> targetScope, ImmutableSetMultimap<Key, ProvisionBinding> explicitProvisionBindings, ImmutableSetMultimap<Key, ProductionBinding> explicitProductionBindings) {
                assert (parentResolver != null);
                this.parentResolver = parentResolver;
                assert (targetScope != null);
                this.targetScope = targetScope;
                assert (explicitProvisionBindings != null);
                this.explicitProvisionBindings = explicitProvisionBindings;
                assert (explicitProductionBindings != null);
                this.explicitProductionBindings = explicitProductionBindings;
                this.resolvedBindings = Maps.newLinkedHashMap();
            }

            ResolvedBindings lookUpBindings(DependencyRequest request) {
                BindingKey bindingKey = request.bindingKey();
                switch (bindingKey.kind()) {
                    case CONTRIBUTION: {
                        Optional<RequestResolver> owningResolver;
                        ImmutableSet<ProvisionBinding> explicitProvisionBindingsForKey = this.getExplicitProvisionBindings(bindingKey.key());
                        ImmutableSet<ProductionBinding> explicitProductionBindingsForKey = this.getExplicitProductionBindings(bindingKey.key());
                        Optional<Key> mapProviderKey = Factory.this.keyFactory.implicitMapProviderKeyFrom(bindingKey.key());
                        ImmutableSet<ProvisionBinding> explicitMapProvisionBindings = ImmutableSet.of();
                        if (mapProviderKey.isPresent()) {
                            explicitMapProvisionBindings = this.getExplicitProvisionBindings((Key)mapProviderKey.get());
                        }
                        Optional<Key> mapProducerKey = Factory.this.keyFactory.implicitMapProducerKeyFrom(bindingKey.key());
                        ImmutableSet<ProductionBinding> explicitMapProductionBindings = ImmutableSet.of();
                        if (mapProducerKey.isPresent()) {
                            explicitMapProductionBindings = this.getExplicitProductionBindings((Key)mapProducerKey.get());
                        }
                        if (!explicitProvisionBindingsForKey.isEmpty() || !explicitProductionBindingsForKey.isEmpty()) {
                            ImmutableSet.Builder ownedBindings = ImmutableSet.builder();
                            ImmutableSet.Builder inheritedBindings = ImmutableSet.builder();
                            for (ProvisionBinding provisionBinding : Sets.union(explicitProvisionBindingsForKey, explicitMapProvisionBindings)) {
                                Optional<RequestResolver> owningResolver2 = this.getOwningResolver(provisionBinding);
                                if (owningResolver2.isPresent() && !((RequestResolver)owningResolver2.get()).equals(this)) {
                                    ((RequestResolver)owningResolver2.get()).resolve(request);
                                    inheritedBindings.add((Object)provisionBinding);
                                    continue;
                                }
                                ownedBindings.add((Object)provisionBinding);
                            }
                            return ResolvedBindings.create(bindingKey, (Set<? extends Binding>)ownedBindings.addAll(explicitProductionBindingsForKey).addAll(explicitMapProductionBindings).build(), (Set<? extends Binding>)inheritedBindings.build());
                        }
                        if (!explicitMapProductionBindings.isEmpty()) {
                            DependencyRequest implicitRequest = Factory.this.dependencyRequestFactory.forImplicitMapBinding(request, (Key)mapProducerKey.get());
                            return ResolvedBindings.create(bindingKey, Factory.this.productionBindingFactory.forImplicitMapBinding(request, implicitRequest));
                        }
                        if (!explicitMapProvisionBindings.isEmpty()) {
                            DependencyRequest implicitRequest = Factory.this.dependencyRequestFactory.forImplicitMapBinding(request, (Key)mapProviderKey.get());
                            return ResolvedBindings.create(bindingKey, Factory.this.provisionBindingFactory.forImplicitMapBinding(request, implicitRequest));
                        }
                        Optional<ProvisionBinding> provisionBinding = Factory.this.injectBindingRegistry.getOrFindProvisionBinding(bindingKey.key());
                        if (provisionBinding.isPresent() && (owningResolver = this.getOwningResolver((ProvisionBinding)provisionBinding.get())).isPresent() && !((RequestResolver)owningResolver.get()).equals(this)) {
                            ((RequestResolver)owningResolver.get()).resolve(request);
                            return ResolvedBindings.create(bindingKey, (Set<? extends Binding>)ImmutableSet.of(), provisionBinding.asSet());
                        }
                        return ResolvedBindings.create(bindingKey, provisionBinding.asSet(), (Set<? extends Binding>)ImmutableSet.of());
                    }
                    case MEMBERS_INJECTION: {
                        return ResolvedBindings.create(bindingKey, this.rollUpMembersInjectionBindings(bindingKey.key()));
                    }
                }
                throw new AssertionError();
            }

            private MembersInjectionBinding rollUpMembersInjectionBindings(Key key) {
                MembersInjectionBinding parentBinding;
                MembersInjectionBinding membersInjectionBinding = Factory.this.injectBindingRegistry.getOrFindMembersInjectionBinding(key);
                if (membersInjectionBinding.injectionStrategy().equals((Object)MembersInjectionBinding.Strategy.DELEGATE) && (parentBinding = this.rollUpMembersInjectionBindings(((DependencyRequest)membersInjectionBinding.parentInjectorRequest().get()).key())).injectionStrategy().equals((Object)MembersInjectionBinding.Strategy.NO_OP)) {
                    return membersInjectionBinding.withoutParentInjectorRequest();
                }
                return membersInjectionBinding;
            }

            private Optional<RequestResolver> getOwningResolver(ProvisionBinding provisionBinding) {
                Optional<Equivalence.Wrapper<AnnotationMirror>> bindingScope = provisionBinding.wrappedScope();
                for (RequestResolver requestResolver : this.getResolverLineage().reverse()) {
                    if (!requestResolver.explicitProvisionBindings.containsValue((Object)provisionBinding)) continue;
                    return Optional.of((Object)requestResolver);
                }
                for (RequestResolver requestResolver : this.getResolverLineage().reverse()) {
                    if (!bindingScope.isPresent() || !bindingScope.equals(requestResolver.targetScope)) continue;
                    return Optional.of((Object)requestResolver);
                }
                return Optional.absent();
            }

            private ImmutableList<RequestResolver> getResolverLineage() {
                ArrayList resolverList = Lists.newArrayList();
                Optional<RequestResolver> currentResolver = Optional.of((Object)this);
                while (currentResolver.isPresent()) {
                    resolverList.add(currentResolver.get());
                    currentResolver = ((RequestResolver)currentResolver.get()).parentResolver;
                }
                return ImmutableList.copyOf((Collection)Lists.reverse((List)resolverList));
            }

            private ImmutableSet<ProvisionBinding> getExplicitProvisionBindings(Key requestKey) {
                ImmutableSet.Builder explicitBindingsForKey = ImmutableSet.builder();
                for (RequestResolver resolver : this.getResolverLineage()) {
                    explicitBindingsForKey.addAll((Iterable)resolver.explicitProvisionBindings.get((Object)requestKey));
                }
                return explicitBindingsForKey.build();
            }

            private ImmutableSet<ProductionBinding> getExplicitProductionBindings(Key requestKey) {
                ImmutableSet.Builder explicitBindingsForKey = ImmutableSet.builder();
                for (RequestResolver resolver : this.getResolverLineage()) {
                    explicitBindingsForKey.addAll((Iterable)resolver.explicitProductionBindings.get((Object)requestKey));
                }
                return explicitBindingsForKey.build();
            }

            private Optional<ResolvedBindings> getPreviouslyResolvedBindings(BindingKey bindingKey) {
                Optional result = Optional.fromNullable((Object)this.resolvedBindings.get(bindingKey));
                if (result.isPresent()) {
                    return result;
                }
                if (this.parentResolver.isPresent()) {
                    return ((RequestResolver)this.parentResolver.get()).getPreviouslyResolvedBindings(bindingKey);
                }
                return Optional.absent();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void resolve(DependencyRequest request) {
                BindingKey bindingKey = request.bindingKey();
                Optional<ResolvedBindings> previouslyResolvedBinding = this.getPreviouslyResolvedBindings(bindingKey);
                if (previouslyResolvedBinding.isPresent() && (!bindingKey.kind().equals((Object)BindingKey.Kind.CONTRIBUTION) || ((ResolvedBindings)previouslyResolvedBinding.get()).contributionBindings().isEmpty() || !ContributionBinding.bindingTypeFor(((ResolvedBindings)previouslyResolvedBinding.get()).contributionBindings()).isMultibinding())) {
                    return;
                }
                if (this.cycleStack.contains(bindingKey)) {
                    return;
                }
                this.cycleStack.push(bindingKey);
                try {
                    ResolvedBindings bindings = this.lookUpBindings(request);
                    for (Binding binding : bindings.ownedBindings()) {
                        for (DependencyRequest dependency : binding.implicitDependencies()) {
                            this.resolve(dependency);
                        }
                    }
                    this.resolvedBindings.put(bindingKey, bindings);
                }
                finally {
                    this.cycleStack.pop();
                }
            }

            ImmutableMap<BindingKey, ResolvedBindings> getResolvedBindings() {
                ImmutableMap.Builder resolvedBindingsBuilder = ImmutableMap.builder();
                resolvedBindingsBuilder.putAll(this.resolvedBindings);
                if (this.parentResolver.isPresent()) {
                    for (ResolvedBindings resolvedInParent : ((RequestResolver)this.parentResolver.get()).getResolvedBindings().values()) {
                        BindingKey bindingKey = resolvedInParent.bindingKey();
                        if (this.resolvedBindings.containsKey(bindingKey)) continue;
                        if (resolvedInParent.ownedBindings().isEmpty()) {
                            resolvedBindingsBuilder.put((Object)bindingKey, (Object)resolvedInParent);
                            continue;
                        }
                        resolvedBindingsBuilder.put((Object)bindingKey, (Object)ResolvedBindings.create(bindingKey, (Set<? extends Binding>)ImmutableSet.of(), resolvedInParent.bindings()));
                    }
                }
                return resolvedBindingsBuilder.build();
            }
        }
    }
}

