/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import dagger.Component;
import dagger.internal.codegen.AutoValue_BindingGraphValidator_ResolvedRequest;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.DependencyRequestFormatter;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.InjectBindingRegistry;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.KeyFormatter;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.MethodSignatureFormatter;
import dagger.internal.codegen.MissingBindingSuggestions;
import dagger.internal.codegen.ProductionBinding;
import dagger.internal.codegen.ProductionBindingFormatter;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.ProvisionBindingFormatter;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.Util;
import dagger.internal.codegen.ValidationReport;
import dagger.internal.codegen.ValidationType;
import dagger.internal.codegen.Validator;
import dagger.internal.codegen.writer.TypeNames;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Formatter;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

public class BindingGraphValidator
implements Validator<BindingGraph> {
    private final Types types;
    private final InjectBindingRegistry injectBindingRegistry;
    private final ValidationType scopeCycleValidationType;
    private final Diagnostic.Kind nullableValidationType;
    private final ProvisionBindingFormatter provisionBindingFormatter;
    private final ProductionBindingFormatter productionBindingFormatter;
    private final MethodSignatureFormatter methodSignatureFormatter;
    private final DependencyRequestFormatter dependencyRequestFormatter;
    private final KeyFormatter keyFormatter;
    private static final Function<ResolvedRequest, DependencyRequest> REQUEST_FROM_RESOLVED_REQUEST = new Function<ResolvedRequest, DependencyRequest>(){

        public DependencyRequest apply(ResolvedRequest resolvedRequest) {
            return resolvedRequest.request();
        }
    };

    BindingGraphValidator(Types types, InjectBindingRegistry injectBindingRegistry, ValidationType scopeCycleValidationType, Diagnostic.Kind nullableValidationType, ProvisionBindingFormatter provisionBindingFormatter, ProductionBindingFormatter productionBindingFormatter, MethodSignatureFormatter methodSignatureFormatter, DependencyRequestFormatter dependencyRequestFormatter, KeyFormatter keyFormatter) {
        this.types = types;
        this.injectBindingRegistry = injectBindingRegistry;
        this.scopeCycleValidationType = scopeCycleValidationType;
        this.nullableValidationType = nullableValidationType;
        this.provisionBindingFormatter = provisionBindingFormatter;
        this.productionBindingFormatter = productionBindingFormatter;
        this.methodSignatureFormatter = methodSignatureFormatter;
        this.dependencyRequestFormatter = dependencyRequestFormatter;
        this.keyFormatter = keyFormatter;
    }

    @Override
    public ValidationReport<BindingGraph> validate(BindingGraph subject) {
        Validation validation = new Validation(subject);
        validation.validateSubgraph(subject);
        return validation.buildReport();
    }

    private void appendIndentedComponentsList(StringBuilder message, Iterable<TypeElement> types) {
        for (TypeElement scopedComponent : types) {
            message.append("    ");
            Optional<AnnotationMirror> scope = InjectionAnnotations.getScopeAnnotation(scopedComponent);
            if (scope.isPresent()) {
                message.append(ErrorMessages.format((AnnotationMirror)scope.get())).append(' ');
            }
            message.append(ErrorMessages.stripCommonTypePrefixes(scopedComponent.getQualifiedName().toString())).append('\n');
        }
    }

    private ImmutableSet<TypeElement> scopedTypesIn(Set<TypeElement> types) {
        return FluentIterable.from(types).filter((Predicate)new Predicate<TypeElement>(){

            public boolean apply(TypeElement input) {
                return InjectionAnnotations.getScopeAnnotation(input).isPresent();
            }
        }).toSet();
    }

    private boolean doesPathRequireProvisionOnly(Deque<ResolvedRequest> path) {
        if (path.size() == 1) {
            switch (path.peek().request().kind()) {
                case INSTANCE: 
                case PROVIDER: 
                case LAZY: 
                case MEMBERS_INJECTOR: {
                    return true;
                }
                case PRODUCER: 
                case PRODUCED: 
                case FUTURE: {
                    return false;
                }
            }
            throw new AssertionError();
        }
        ImmutableSet<ProvisionBinding> dependentProvisions = this.provisionsDependingOnLatestRequest(path);
        return !dependentProvisions.isEmpty();
    }

    private ImmutableSet<ProvisionBinding> provisionsDependingOnLatestRequest(Deque<ResolvedRequest> path) {
        Iterator<ResolvedRequest> iterator = path.iterator();
        final DependencyRequest request = iterator.next().request();
        ResolvedRequest previousResolvedRequest = iterator.next();
        ImmutableSet bindings = FluentIterable.from(previousResolvedRequest.binding().bindings()).filter((Predicate)new Predicate<Binding>(){

            public boolean apply(Binding binding) {
                return binding instanceof ProvisionBinding && binding.implicitDependencies().contains(request);
            }
        }).toSet();
        return bindings;
    }

    private String formatBindingType(ContributionBinding.BindingType type) {
        switch (type) {
            case MAP: {
                return "Map";
            }
            case SET: {
                return "Set";
            }
            case UNIQUE: {
                return "Unique";
            }
        }
        throw new IllegalStateException("Unknown binding type: " + (Object)((Object)type));
    }

    static abstract class Traverser {
        Traverser() {
        }

        abstract boolean visitResolvedRequest(Deque<ResolvedRequest> var1);
    }

    static abstract class ResolvedRequest {
        ResolvedRequest() {
        }

        abstract DependencyRequest request();

        abstract ResolvedBindings binding();

        static ResolvedRequest create(DependencyRequest request, BindingGraph graph) {
            BindingKey bindingKey = request.bindingKey();
            ResolvedBindings resolvedBindings = (ResolvedBindings)graph.resolvedBindings().get((Object)bindingKey);
            return new AutoValue_BindingGraphValidator_ResolvedRequest(request, resolvedBindings == null ? ResolvedBindings.create(bindingKey, (Set<? extends Binding>)ImmutableSet.of(), (Set<? extends Binding>)ImmutableSet.of()) : resolvedBindings);
        }
    }

    private class Validation {
        final BindingGraph topLevelGraph;
        final ValidationReport.Builder<BindingGraph> reportBuilder;
        private static final int DUPLICATE_SIZE_LIMIT = 10;

        Validation(BindingGraph topLevelGraph) {
            this.topLevelGraph = topLevelGraph;
            this.reportBuilder = ValidationReport.Builder.about(topLevelGraph);
        }

        ValidationReport<BindingGraph> buildReport() {
            return this.reportBuilder.build();
        }

        void validateSubgraph(BindingGraph subject) {
            this.validateComponentScope(subject);
            this.validateDependencyScopes(subject);
            this.validateBuilders(subject);
            for (ComponentDescriptor.ComponentMethodDescriptor componentMethod : subject.componentDescriptor().componentMethods()) {
                Optional<DependencyRequest> entryPoint = componentMethod.dependencyRequest();
                if (!entryPoint.isPresent()) continue;
                this.traverseRequest((DependencyRequest)entryPoint.get(), new ArrayDeque<ResolvedRequest>(), Sets.newHashSet(), subject, Sets.newHashSet());
            }
            for (BindingGraph subgraph : subject.subgraphs().values()) {
                this.validateSubgraph(subgraph);
            }
        }

        private void traverseRequest(DependencyRequest request, Deque<ResolvedRequest> bindingPath, Set<BindingKey> keysInPath, BindingGraph graph, Set<DependencyRequest> resolvedRequests) {
            Verify.verify((bindingPath.size() == keysInPath.size() ? 1 : 0) != 0, (String)"mismatched path vs keys -- (%s vs %s)", (Object[])new Object[]{bindingPath, keysInPath});
            BindingKey requestKey = request.bindingKey();
            if (keysInPath.contains(requestKey)) {
                this.reportCycle(request, bindingPath);
                return;
            }
            if (resolvedRequests.add(request)) {
                ResolvedRequest resolvedRequest = ResolvedRequest.create(request, graph);
                bindingPath.push(resolvedRequest);
                keysInPath.add(requestKey);
                this.validateResolvedBinding(bindingPath, resolvedRequest.binding());
                for (Binding binding : resolvedRequest.binding().bindings()) {
                    for (DependencyRequest nextRequest : binding.implicitDependencies()) {
                        this.traverseRequest(nextRequest, bindingPath, keysInPath, graph, resolvedRequests);
                    }
                }
                bindingPath.poll();
                keysInPath.remove(requestKey);
            }
        }

        private boolean validateResolvedBinding(Deque<ResolvedRequest> path, ResolvedBindings resolvedBinding) {
            if (resolvedBinding.bindings().isEmpty()) {
                this.reportMissingBinding(path);
                return false;
            }
            ImmutableSet.Builder provisionBindingsBuilder = ImmutableSet.builder();
            ImmutableSet.Builder productionBindingsBuilder = ImmutableSet.builder();
            ImmutableSet.Builder membersInjectionBindingsBuilder = ImmutableSet.builder();
            for (Binding binding : resolvedBinding.bindings()) {
                if (binding instanceof ProvisionBinding) {
                    provisionBindingsBuilder.add((Object)((ProvisionBinding)binding));
                }
                if (binding instanceof ProductionBinding) {
                    productionBindingsBuilder.add((Object)((ProductionBinding)binding));
                }
                if (!(binding instanceof MembersInjectionBinding)) continue;
                membersInjectionBindingsBuilder.add((Object)((MembersInjectionBinding)binding));
            }
            ImmutableSet provisionBindings = provisionBindingsBuilder.build();
            ImmutableSet productionBindings = productionBindingsBuilder.build();
            ImmutableSet membersInjectionBindings = membersInjectionBindingsBuilder.build();
            switch (resolvedBinding.bindingKey().kind()) {
                case CONTRIBUTION: {
                    if (!membersInjectionBindings.isEmpty()) {
                        throw new IllegalArgumentException("contribution binding keys should never have members injection bindings");
                    }
                    Sets.SetView combined = Sets.union((Set)provisionBindings, (Set)productionBindings);
                    if (!this.validateNullability(path.peek().request(), (Set<ContributionBinding>)combined)) {
                        return false;
                    }
                    if (!productionBindings.isEmpty() && BindingGraphValidator.this.doesPathRequireProvisionOnly(path)) {
                        this.reportProviderMayNotDependOnProducer(path);
                        return false;
                    }
                    if (provisionBindings.size() + productionBindings.size() <= 1) {
                        return true;
                    }
                    ImmutableListMultimap bindingsByType = ContributionBinding.bindingTypesFor(Iterables.concat((Iterable)provisionBindings, (Iterable)productionBindings));
                    if (bindingsByType.keySet().size() > 1) {
                        this.reportMultipleBindingTypes(path);
                        return false;
                    }
                    if (!((ContributionBinding.BindingType)((Object)Iterables.getOnlyElement((Iterable)bindingsByType.keySet()))).equals((Object)ContributionBinding.BindingType.UNIQUE)) break;
                    this.reportDuplicateBindings(path);
                    return false;
                }
                case MEMBERS_INJECTION: {
                    MembersInjectionBinding binding;
                    if (!provisionBindings.isEmpty() || !productionBindings.isEmpty()) {
                        throw new IllegalArgumentException("members injection binding keys should never have contribution bindings");
                    }
                    if (membersInjectionBindings.size() > 1) {
                        this.reportDuplicateBindings(path);
                        return false;
                    }
                    if (membersInjectionBindings.size() != 1 || this.validateMembersInjectionBinding(binding = (MembersInjectionBinding)Iterables.getOnlyElement((Iterable)membersInjectionBindings), path)) break;
                    return false;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return true;
        }

        private boolean validateNullability(DependencyRequest request, Set<ContributionBinding> bindings) {
            boolean valid = true;
            if (!request.isNullable()) {
                String typeName = null;
                for (ContributionBinding binding : bindings) {
                    String methodSignature;
                    if (!binding.nullableType().isPresent()) continue;
                    if (binding instanceof ProvisionBinding) {
                        ProvisionBinding provisionBinding = (ProvisionBinding)binding;
                        methodSignature = BindingGraphValidator.this.provisionBindingFormatter.format(provisionBinding);
                    } else {
                        ProductionBinding productionBinding = (ProductionBinding)binding;
                        methodSignature = BindingGraphValidator.this.productionBindingFormatter.format(productionBinding);
                    }
                    if (typeName == null) {
                        typeName = TypeNames.forTypeMirror(request.key().type()).toString();
                    }
                    this.reportBuilder.addItem(String.format("%s is not nullable, but is being provided by %s", typeName, methodSignature) + "\n at: " + BindingGraphValidator.this.dependencyRequestFormatter.format(request), BindingGraphValidator.this.nullableValidationType, request.requestElement());
                    valid = false;
                }
            }
            return valid;
        }

        private boolean validateMembersInjectionBinding(MembersInjectionBinding binding, final Deque<ResolvedRequest> path) {
            return binding.key().type().accept(new SimpleTypeVisitor6<Boolean, Void>(){

                @Override
                protected Boolean defaultAction(TypeMirror e, Void p) {
                    Validation.this.reportBuilder.addItem("Invalid members injection request.", ((ResolvedRequest)path.peek()).request().requestElement());
                    return false;
                }

                @Override
                public Boolean visitDeclared(DeclaredType type, Void ignored) {
                    for (TypeMirror typeMirror : type.getTypeArguments()) {
                        boolean declared;
                        switch (typeMirror.getKind()) {
                            case ARRAY: {
                                declared = MoreTypes.asArray(typeMirror).getComponentType().accept(new SimpleTypeVisitor6<Boolean, Void>(){

                                    @Override
                                    protected Boolean defaultAction(TypeMirror e, Void p) {
                                        return false;
                                    }

                                    @Override
                                    public Boolean visitDeclared(DeclaredType t, Void p) {
                                        for (TypeMirror typeMirror : t.getTypeArguments()) {
                                            if (typeMirror.accept(this, null).booleanValue()) continue;
                                            return false;
                                        }
                                        return true;
                                    }

                                    @Override
                                    public Boolean visitArray(ArrayType t, Void p) {
                                        return t.getComponentType().accept(this, null);
                                    }

                                    @Override
                                    public Boolean visitPrimitive(PrimitiveType t, Void p) {
                                        return true;
                                    }
                                }, null);
                                break;
                            }
                            case DECLARED: {
                                declared = true;
                                break;
                            }
                            default: {
                                declared = false;
                            }
                        }
                        if (declared) continue;
                        ImmutableList printableDependencyPath = FluentIterable.from((Iterable)path).transform(REQUEST_FROM_RESOLVED_REQUEST).transform((Function)BindingGraphValidator.this.dependencyRequestFormatter).filter(Predicates.not((Predicate)Predicates.equalTo((Object)""))).toList().reverse();
                        Validation.this.reportBuilder.addItem(String.format("Type parameters must be bounded for members injection. %s required by %s, via:\n%s", typeMirror.toString(), type.toString(), Joiner.on((char)'\n').join((Iterable)printableDependencyPath)), ((ResolvedRequest)path.peek()).request().requestElement());
                        return false;
                    }
                    TypeElement element = MoreElements.asType(type.asElement());
                    if (!MoreTypes.asDeclared(element.asType()).getTypeArguments().isEmpty() && BindingGraphValidator.this.types.isSameType(BindingGraphValidator.this.types.erasure(element.asType()), type)) {
                        ImmutableList immutableList = FluentIterable.from((Iterable)path).transform(REQUEST_FROM_RESOLVED_REQUEST).transform((Function)BindingGraphValidator.this.dependencyRequestFormatter).filter(Predicates.not((Predicate)Predicates.equalTo((Object)""))).toList().reverse();
                        Validation.this.reportBuilder.addItem(String.format("%s has type parameters, cannot members inject the raw type. via:\n%s", type.toString(), Joiner.on((char)'\n').join((Iterable)immutableList)), ((ResolvedRequest)path.peek()).request().requestElement());
                        return false;
                    }
                    return true;
                }
            }, null);
        }

        private void validateDependencyScopes(BindingGraph subject) {
            ComponentDescriptor descriptor = subject.componentDescriptor();
            Optional<AnnotationMirror> scope = descriptor.scope();
            ImmutableSet scopedDependencies = BindingGraphValidator.this.scopedTypesIn(descriptor.dependencies());
            if (scope.isPresent()) {
                if (BindingGraphValidator.this.scopeCycleValidationType.diagnosticKind().isPresent() && MoreTypes.isTypeOf(Singleton.class, ((AnnotationMirror)scope.get()).getAnnotationType())) {
                    if (!scopedDependencies.isEmpty()) {
                        StringBuilder message = new StringBuilder("This @Singleton component cannot depend on scoped components:\n");
                        BindingGraphValidator.this.appendIndentedComponentsList(message, (Iterable)scopedDependencies);
                        this.reportBuilder.addItem(message.toString(), (Diagnostic.Kind)((Object)BindingGraphValidator.this.scopeCycleValidationType.diagnosticKind().get()), (Element)descriptor.componentDefinitionType(), descriptor.componentAnnotation());
                    }
                } else if (scopedDependencies.size() > 1) {
                    StringBuilder message = new StringBuilder(ErrorMessages.format((AnnotationMirror)scope.get())).append(' ').append(descriptor.componentDefinitionType().getQualifiedName()).append(" depends on more than one scoped component:\n");
                    BindingGraphValidator.this.appendIndentedComponentsList(message, (Iterable)scopedDependencies);
                    this.reportBuilder.addItem(message.toString(), descriptor.componentDefinitionType(), descriptor.componentAnnotation());
                } else if (!BindingGraphValidator.this.scopeCycleValidationType.equals((Object)ValidationType.NONE)) {
                    this.validateScopeHierarchy(descriptor.componentDefinitionType(), descriptor.componentDefinitionType(), new ArrayDeque<Equivalence.Wrapper<AnnotationMirror>>(), new ArrayDeque<TypeElement>());
                }
            } else if (!scopedDependencies.isEmpty()) {
                StringBuilder message = new StringBuilder(descriptor.componentDefinitionType().getQualifiedName()).append(" (unscoped) cannot depend on scoped components:\n");
                BindingGraphValidator.this.appendIndentedComponentsList(message, (Iterable)scopedDependencies);
                this.reportBuilder.addItem(message.toString(), descriptor.componentDefinitionType(), descriptor.componentAnnotation());
            }
        }

        private void validateBuilders(BindingGraph subject) {
            Sets.SetView missingSetters;
            ComponentDescriptor componentDesc = subject.componentDescriptor();
            if (!componentDesc.builderSpec().isPresent()) {
                return;
            }
            ImmutableSet<TypeElement> allDependents = subject.componentRequirements();
            Set requiredDependents = Sets.filter(allDependents, (Predicate)new Predicate<TypeElement>(){

                public boolean apply(TypeElement input) {
                    return !Util.componentCanMakeNewInstances(input);
                }
            });
            final ComponentDescriptor.BuilderSpec spec = (ComponentDescriptor.BuilderSpec)componentDesc.builderSpec().get();
            Map<TypeElement, ExecutableElement> allSetters = spec.methodMap();
            ErrorMessages.ComponentBuilderMessages msgs = ErrorMessages.builderMsgsFor(subject.componentDescriptor().kind());
            Sets.SetView extraSetters = Sets.difference(allSetters.keySet(), allDependents);
            if (!extraSetters.isEmpty()) {
                Collection excessMethods = Maps.filterKeys(allSetters, (Predicate)Predicates.in((Collection)extraSetters)).values();
                FluentIterable formatted = FluentIterable.from(excessMethods).transform((Function)new Function<ExecutableElement, String>(){

                    public String apply(ExecutableElement input) {
                        return BindingGraphValidator.this.methodSignatureFormatter.format(input, (Optional<DeclaredType>)Optional.of((Object)MoreTypes.asDeclared(spec.builderDefinitionType().asType())));
                    }
                });
                this.reportBuilder.addItem(String.format(msgs.extraSetters(), formatted), spec.builderDefinitionType());
            }
            if (!(missingSetters = Sets.difference((Set)requiredDependents, allSetters.keySet())).isEmpty()) {
                this.reportBuilder.addItem(String.format(msgs.missingSetters(), missingSetters), spec.builderDefinitionType());
            }
        }

        private void validateScopeHierarchy(TypeElement rootComponent, TypeElement componentType, Deque<Equivalence.Wrapper<AnnotationMirror>> scopeStack, Deque<TypeElement> scopedDependencyStack) {
            Optional<AnnotationMirror> scope = InjectionAnnotations.getScopeAnnotation(componentType);
            if (scope.isPresent()) {
                Equivalence.Wrapper wrappedScope = AnnotationMirrors.equivalence().wrap(scope.get());
                if (scopeStack.contains(wrappedScope)) {
                    scopedDependencyStack.push(componentType);
                    StringBuilder message = new StringBuilder();
                    message.append(rootComponent.getQualifiedName());
                    message.append(" depends on scoped components in a non-hierarchical scope ordering:\n");
                    BindingGraphValidator.this.appendIndentedComponentsList(message, scopedDependencyStack);
                    if (BindingGraphValidator.this.scopeCycleValidationType.diagnosticKind().isPresent()) {
                        this.reportBuilder.addItem(message.toString(), (Diagnostic.Kind)((Object)BindingGraphValidator.this.scopeCycleValidationType.diagnosticKind().get()), (Element)rootComponent, (AnnotationMirror)MoreElements.getAnnotationMirror(rootComponent, Component.class).get());
                    }
                    scopedDependencyStack.pop();
                } else {
                    ImmutableSet scopedDependencies;
                    Optional<AnnotationMirror> componentAnnotation = MoreElements.getAnnotationMirror(componentType, Component.class);
                    if (componentAnnotation.isPresent() && (scopedDependencies = BindingGraphValidator.this.scopedTypesIn(MoreTypes.asTypeElements(ConfigurationAnnotations.getComponentDependencies((AnnotationMirror)componentAnnotation.get())))).size() == 1) {
                        scopeStack.push((Equivalence.Wrapper<AnnotationMirror>)wrappedScope);
                        scopedDependencyStack.push(componentType);
                        this.validateScopeHierarchy(rootComponent, (TypeElement)Iterables.getOnlyElement((Iterable)scopedDependencies), scopeStack, scopedDependencyStack);
                        scopedDependencyStack.pop();
                        scopeStack.pop();
                    }
                }
            }
        }

        void validateComponentScope(BindingGraph subject) {
            ImmutableMap<BindingKey, ResolvedBindings> resolvedBindings = subject.resolvedBindings();
            Optional<Equivalence.Wrapper<AnnotationMirror>> componentScope = subject.componentDescriptor().wrappedScope();
            ImmutableSet.Builder incompatiblyScopedMethodsBuilder = ImmutableSet.builder();
            for (ResolvedBindings bindings : resolvedBindings.values()) {
                if (!bindings.bindingKey().kind().equals((Object)BindingKey.Kind.CONTRIBUTION)) continue;
                block5: for (ContributionBinding contributionBinding : bindings.ownedContributionBindings()) {
                    ProvisionBinding provisionBinding;
                    if (!(contributionBinding instanceof ProvisionBinding) || !(provisionBinding = (ProvisionBinding)contributionBinding).scope().isPresent() || componentScope.equals(provisionBinding.wrappedScope())) continue;
                    switch (provisionBinding.bindingKind()) {
                        case PROVISION: {
                            ExecutableElement provisionMethod = MoreElements.asExecutable(provisionBinding.bindingElement());
                            incompatiblyScopedMethodsBuilder.add((Object)BindingGraphValidator.this.methodSignatureFormatter.format(provisionMethod));
                            continue block5;
                        }
                        case INJECTION: {
                            incompatiblyScopedMethodsBuilder.add((Object)(ErrorMessages.stripCommonTypePrefixes(((AnnotationMirror)provisionBinding.scope().get()).toString()) + " class " + provisionBinding.bindingTypeElement().getQualifiedName()));
                            continue block5;
                        }
                    }
                    throw new IllegalStateException();
                }
            }
            ImmutableSet incompatiblyScopedMethods = incompatiblyScopedMethodsBuilder.build();
            if (!incompatiblyScopedMethods.isEmpty()) {
                TypeElement componentType = subject.componentDescriptor().componentDefinitionType();
                StringBuilder message = new StringBuilder(componentType.getQualifiedName());
                if (componentScope.isPresent()) {
                    message.append(" scoped with ");
                    message.append(ErrorMessages.stripCommonTypePrefixes(ErrorMessages.format((AnnotationMirror)((Equivalence.Wrapper)componentScope.get()).get())));
                    message.append(" may not reference bindings with different scopes:\n");
                } else {
                    message.append(" (unscoped) may not reference scoped bindings:\n");
                }
                for (String method : incompatiblyScopedMethods) {
                    message.append("    ").append(method).append("\n");
                }
                this.reportBuilder.addItem(message.toString(), componentType, subject.componentDescriptor().componentAnnotation());
            }
        }

        private void reportProviderMayNotDependOnProducer(Deque<ResolvedRequest> path) {
            StringBuilder errorMessage = new StringBuilder();
            if (path.size() == 1) {
                new Formatter(errorMessage).format("%s is a provision entry-point, which cannot depend on a production.", BindingGraphValidator.this.keyFormatter.format(path.peek().request().key()));
            } else {
                ImmutableSet dependentProvisions = BindingGraphValidator.this.provisionsDependingOnLatestRequest(path);
                new Formatter(errorMessage).format("%s is a provision, which cannot depend on a production.", BindingGraphValidator.this.keyFormatter.format(((ProvisionBinding)dependentProvisions.iterator().next()).key()));
            }
            this.reportBuilder.addItem(errorMessage.toString(), path.getLast().request().requestElement());
        }

        private void reportMissingBinding(Deque<ResolvedRequest> path) {
            Key key = path.peek().request().key();
            BindingKey bindingKey = path.peek().request().bindingKey();
            TypeMirror type = key.type();
            String typeName = TypeNames.forTypeMirror(type).toString();
            boolean requiresContributionMethod = !key.isValidImplicitProvisionKey(BindingGraphValidator.this.types);
            boolean requiresProvision = BindingGraphValidator.this.doesPathRequireProvisionOnly(path);
            StringBuilder errorMessage = new StringBuilder();
            String requiresErrorMessageFormat = requiresContributionMethod ? (requiresProvision ? "%s cannot be provided without an @Provides-annotated method." : "%s cannot be provided without an @Provides- or @Produces-annotated method.") : (requiresProvision ? "%s cannot be provided without an @Inject constructor or from an @Provides-annotated method." : "%s cannot be provided without an @Inject constructor or from an @Provides- or @Produces-annotated method.");
            errorMessage.append(String.format(requiresErrorMessageFormat, typeName));
            if (key.isValidMembersInjectionKey() && !BindingGraphValidator.this.injectBindingRegistry.getOrFindMembersInjectionBinding(key).injectionSites().isEmpty()) {
                errorMessage.append(" ").append("This type supports members injection but cannot be implicitly provided.");
            }
            ImmutableList printableDependencyPath = FluentIterable.from(path).transform(REQUEST_FROM_RESOLVED_REQUEST).transform((Function)BindingGraphValidator.this.dependencyRequestFormatter).filter(Predicates.not((Predicate)Predicates.equalTo((Object)""))).toList().reverse();
            for (String dependency : printableDependencyPath.subList(1, printableDependencyPath.size())) {
                errorMessage.append('\n').append(dependency);
            }
            for (String suggestion : MissingBindingSuggestions.forKey(this.topLevelGraph, bindingKey)) {
                errorMessage.append('\n').append(suggestion);
            }
            this.reportBuilder.addItem(errorMessage.toString(), path.getLast().request().requestElement());
        }

        private void reportDuplicateBindings(Deque<ResolvedRequest> path) {
            ResolvedBindings resolvedBinding = path.peek().binding();
            StringBuilder builder = new StringBuilder();
            new Formatter(builder).format("%s is bound multiple times:", BindingGraphValidator.this.keyFormatter.format(path.peek().request().key()));
            for (Binding binding : Iterables.limit(resolvedBinding.bindings(), (int)10)) {
                builder.append('\n').append("    ");
                if (binding instanceof ProvisionBinding) {
                    builder.append(BindingGraphValidator.this.provisionBindingFormatter.format((ProvisionBinding)binding));
                    continue;
                }
                if (!(binding instanceof ProductionBinding)) continue;
                builder.append(BindingGraphValidator.this.productionBindingFormatter.format((ProductionBinding)binding));
            }
            int numberOfOtherBindings = resolvedBinding.bindings().size() - 10;
            if (numberOfOtherBindings > 0) {
                builder.append('\n').append("    ").append("and ").append(numberOfOtherBindings).append(" other");
            }
            if (numberOfOtherBindings > 1) {
                builder.append('s');
            }
            this.reportBuilder.addItem(builder.toString(), path.getLast().request().requestElement());
        }

        private void reportMultipleBindingTypes(Deque<ResolvedRequest> path) {
            ResolvedBindings resolvedBinding = path.peek().binding();
            StringBuilder builder = new StringBuilder();
            new Formatter(builder).format("%s has incompatible bindings:\n", BindingGraphValidator.this.keyFormatter.format(path.peek().request().key()));
            ImmutableListMultimap<ContributionBinding.BindingType, ? extends ContributionBinding> bindingsByType = ContributionBinding.bindingTypesFor(resolvedBinding.contributionBindings());
            for (ContributionBinding.BindingType type : Ordering.natural().immutableSortedCopy((Iterable)bindingsByType.keySet())) {
                builder.append("    ");
                builder.append(BindingGraphValidator.this.formatBindingType(type));
                builder.append(" bindings:\n");
                for (ContributionBinding binding : bindingsByType.get((Object)type)) {
                    builder.append("    ").append("    ");
                    if (binding instanceof ProvisionBinding) {
                        builder.append(BindingGraphValidator.this.provisionBindingFormatter.format((ProvisionBinding)binding));
                    } else if (binding instanceof ProductionBinding) {
                        builder.append(BindingGraphValidator.this.productionBindingFormatter.format((ProductionBinding)binding));
                    }
                    builder.append('\n');
                }
            }
            this.reportBuilder.addItem(builder.toString(), path.getLast().request().requestElement());
        }

        private void reportCycle(DependencyRequest request, Deque<ResolvedRequest> path) {
            ImmutableList pathElements = ImmutableList.builder().add((Object)request).addAll(Iterables.transform(path, (Function)REQUEST_FROM_RESOLVED_REQUEST)).build();
            ImmutableList printableDependencyPath = FluentIterable.from((Iterable)pathElements).transform((Function)BindingGraphValidator.this.dependencyRequestFormatter).filter(Predicates.not((Predicate)Predicates.equalTo((Object)""))).toList().reverse();
            DependencyRequest rootRequest = path.getLast().request();
            TypeElement componentType = MoreElements.asType(rootRequest.requestElement().getEnclosingElement());
            this.reportBuilder.addItem(String.format("%s.%s() contains a dependency cycle:\n%s", componentType.getQualifiedName(), rootRequest.requestElement().getSimpleName(), Joiner.on((String)"\n").join((Iterable)printableDependencyPath.subList(1, printableDependencyPath.size()))), rootRequest.requestElement());
        }
    }
}

