/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.Util;
import dagger.internal.codegen.ValidationReport;
import dagger.internal.codegen.Validator;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

class BuilderValidator
implements Validator<TypeElement> {
    private final Elements elements;
    private final Types types;
    private final ComponentDescriptor.Kind componentType;

    BuilderValidator(Elements elements, Types types, ComponentDescriptor.Kind componentType) {
        this.elements = elements;
        this.types = types;
        this.componentType = componentType;
    }

    @Override
    public ValidationReport<TypeElement> validate(TypeElement subject) {
        Set<Modifier> modifiers;
        ValidationReport.Builder<TypeElement> builder = ValidationReport.Builder.about(subject);
        Element componentElement = subject.getEnclosingElement();
        ErrorMessages.ComponentBuilderMessages msgs = ErrorMessages.builderMsgsFor(this.componentType);
        Class<? extends Annotation> componentAnnotation = this.componentType.annotationType();
        Class<? extends Annotation> builderAnnotation = this.componentType.builderAnnotationType();
        Preconditions.checkArgument((subject.getAnnotation(builderAnnotation) != null ? 1 : 0) != 0);
        if (!MoreElements.isAnnotationPresent(componentElement, componentAnnotation)) {
            builder.addItem(msgs.mustBeInComponent(), subject);
        }
        switch (subject.getKind()) {
            case CLASS: {
                List<? extends Element> allElements = subject.getEnclosedElements();
                List<ExecutableElement> cxtors = ElementFilter.constructorsIn(allElements);
                if (cxtors.size() == 1 && ((ExecutableElement)Iterables.getOnlyElement(cxtors)).getParameters().size() == 0) break;
                builder.addItem(msgs.cxtorOnlyOneAndNoArgs(), subject);
                break;
            }
            case INTERFACE: {
                break;
            }
            default: {
                builder.addItem(msgs.mustBeClassOrInterface(), subject);
                return builder.build();
            }
        }
        if (!subject.getTypeParameters().isEmpty()) {
            builder.addItem(msgs.generics(), subject);
        }
        if ((modifiers = subject.getModifiers()).contains((Object)Modifier.PRIVATE)) {
            builder.addItem(msgs.isPrivate(), subject);
        }
        if (!modifiers.contains((Object)Modifier.STATIC)) {
            builder.addItem(msgs.mustBeStatic(), subject);
        }
        if (!modifiers.contains((Object)Modifier.ABSTRACT)) {
            builder.addItem(msgs.mustBeAbstract(), subject);
        }
        ExecutableElement buildMethod = null;
        LinkedHashMultimap methodsPerParam = LinkedHashMultimap.create();
        for (ExecutableElement method : Util.getUnimplementedMethods(this.elements, subject)) {
            ExecutableType resolvedMethodType = MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(subject.asType()), method));
            TypeMirror returnType = resolvedMethodType.getReturnType();
            if (method.getParameters().size() == 0) {
                if (this.types.isSameType(returnType, componentElement.asType())) {
                    if (buildMethod != null) {
                        this.error(builder, method, msgs.twoBuildMethods(), msgs.inheritedTwoBuildMethods(), buildMethod);
                    }
                } else {
                    this.error(builder, method, msgs.buildMustReturnComponentType(), msgs.inheritedBuildMustReturnComponentType(), new Object[0]);
                }
                buildMethod = method;
            } else if (method.getParameters().size() > 1) {
                this.error(builder, method, msgs.methodsMustTakeOneArg(), msgs.inheritedMethodsMustTakeOneArg(), new Object[0]);
            } else if (returnType.getKind() != TypeKind.VOID && !this.types.isSubtype(subject.asType(), returnType)) {
                this.error(builder, method, msgs.methodsMustReturnVoidOrBuilder(), msgs.inheritedMethodsMustReturnVoidOrBuilder(), new Object[0]);
            } else {
                methodsPerParam.put((Object)MoreTypes.equivalence().wrap(Iterables.getOnlyElement(resolvedMethodType.getParameterTypes())), (Object)method);
            }
            if (method.getTypeParameters().isEmpty()) continue;
            this.error(builder, method, msgs.methodsMayNotHaveTypeParameters(), msgs.inheritedMethodsMayNotHaveTypeParameters(), new Object[0]);
        }
        if (buildMethod == null) {
            builder.addItem(msgs.missingBuildMethod(), subject);
        }
        for (Map.Entry entry : methodsPerParam.asMap().entrySet()) {
            if (((Collection)entry.getValue()).size() <= 1) continue;
            TypeMirror type = (TypeMirror)((Equivalence.Wrapper)entry.getKey()).get();
            builder.addItem(String.format(msgs.manyMethodsForType(), type, entry.getValue()), subject);
        }
        return builder.build();
    }

    private void error(ValidationReport.Builder<TypeElement> builder, ExecutableElement method, String enclosedError, String inheritedError, Object ... extraArgs) {
        if (method.getEnclosingElement().equals(builder.getSubject())) {
            builder.addItem(String.format(enclosedError, extraArgs), method);
        } else {
            Object[] newArgs = new Object[extraArgs.length + 1];
            newArgs[0] = method;
            System.arraycopy(extraArgs, 0, newArgs, 1, extraArgs.length);
            builder.addItem(String.format(inheritedError, newArgs), builder.getSubject());
        }
    }
}

