/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Equivalence;
import com.google.common.base.Optional;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.Component;
import dagger.Lazy;
import dagger.MembersInjector;
import dagger.Subcomponent;
import dagger.internal.codegen.AutoValue_ComponentDescriptor;
import dagger.internal.codegen.AutoValue_ComponentDescriptor_BuilderSpec;
import dagger.internal.codegen.AutoValue_ComponentDescriptor_ComponentMethodDescriptor;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.ModuleDescriptor;
import dagger.internal.codegen.Util;
import dagger.producers.ProductionComponent;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.inject.Provider;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

abstract class ComponentDescriptor {
    ComponentDescriptor() {
    }

    abstract Kind kind();

    abstract AnnotationMirror componentAnnotation();

    abstract TypeElement componentDefinitionType();

    abstract ImmutableSet<TypeElement> dependencies();

    abstract ImmutableSet<ModuleDescriptor> modules();

    ImmutableSet<ModuleDescriptor> transitiveModules() {
        LinkedHashSet<ModuleDescriptor> transitiveModules = new LinkedHashSet<ModuleDescriptor>();
        for (ModuleDescriptor module : this.modules()) {
            ComponentDescriptor.addTransitiveModules(transitiveModules, module);
        }
        return ImmutableSet.copyOf(transitiveModules);
    }

    private static Set<ModuleDescriptor> addTransitiveModules(Set<ModuleDescriptor> transitiveModules, ModuleDescriptor module) {
        if (transitiveModules.add(module)) {
            for (ModuleDescriptor includedModule : module.includedModules()) {
                ComponentDescriptor.addTransitiveModules(transitiveModules, includedModule);
            }
        }
        return transitiveModules;
    }

    abstract ImmutableMap<ExecutableElement, TypeElement> dependencyMethodIndex();

    abstract Optional<TypeElement> executorDependency();

    Optional<AnnotationMirror> scope() {
        return Util.unwrapOptionalEquivalence(this.wrappedScope());
    }

    abstract Optional<Equivalence.Wrapper<AnnotationMirror>> wrappedScope();

    abstract ImmutableMap<ExecutableElement, ComponentDescriptor> subcomponents();

    abstract ImmutableSet<ComponentMethodDescriptor> componentMethods();

    abstract Optional<BuilderSpec> builderSpec();

    static boolean isComponentContributionMethod(Elements elements, ExecutableElement method) {
        return method.getParameters().isEmpty() && !method.getReturnType().getKind().equals((Object)TypeKind.VOID) && !elements.getTypeElement(Object.class.getCanonicalName()).equals(method.getEnclosingElement());
    }

    static boolean isComponentProductionMethod(Elements elements, ExecutableElement method) {
        return ComponentDescriptor.isComponentContributionMethod(elements, method) && MoreTypes.isTypeOf(ListenableFuture.class, method.getReturnType());
    }

    static final class Factory {
        private final Elements elements;
        private final Types types;
        private final DependencyRequest.Factory dependencyRequestFactory;
        private final ModuleDescriptor.Factory moduleDescriptorFactory;

        Factory(Elements elements, Types types, DependencyRequest.Factory dependencyRequestFactory, ModuleDescriptor.Factory moduleDescriptorFactory) {
            this.elements = elements;
            this.types = types;
            this.dependencyRequestFactory = dependencyRequestFactory;
            this.moduleDescriptorFactory = moduleDescriptorFactory;
        }

        ComponentDescriptor forComponent(TypeElement componentDefinitionType) {
            return this.create(componentDefinitionType, Kind.COMPONENT);
        }

        ComponentDescriptor forProductionComponent(TypeElement componentDefinitionType) {
            return this.create(componentDefinitionType, Kind.PRODUCTION_COMPONENT);
        }

        private ComponentDescriptor create(TypeElement componentDefinitionType, Kind kind) {
            DeclaredType declaredComponentType = MoreTypes.asDeclared(componentDefinitionType.asType());
            AnnotationMirror componentMirror = (AnnotationMirror)MoreElements.getAnnotationMirror(componentDefinitionType, kind.annotationType()).or(MoreElements.getAnnotationMirror(componentDefinitionType, Subcomponent.class)).get();
            ImmutableSet<TypeElement> componentDependencyTypes = ConfigurationAnnotations.isComponent(componentDefinitionType) ? MoreTypes.asTypeElements(ConfigurationAnnotations.getComponentDependencies(componentMirror)) : ImmutableSet.of();
            ImmutableMap.Builder dependencyMethodIndex = ImmutableMap.builder();
            for (TypeElement componentDependency : componentDependencyTypes) {
                List<ExecutableElement> dependencyMethods = ElementFilter.methodsIn(this.elements.getAllMembers(componentDependency));
                for (ExecutableElement dependencyMethod : dependencyMethods) {
                    if (!ComponentDescriptor.isComponentContributionMethod(this.elements, dependencyMethod)) continue;
                    dependencyMethodIndex.put((Object)dependencyMethod, (Object)componentDependency);
                }
            }
            Optional executorDependency = kind.equals((Object)Kind.PRODUCTION_COMPONENT) ? Optional.of((Object)this.elements.getTypeElement(Executor.class.getCanonicalName())) : Optional.absent();
            ImmutableSet.Builder modules = ImmutableSet.builder();
            for (TypeMirror moduleIncludesType : ConfigurationAnnotations.getComponentModules(componentMirror)) {
                modules.add((Object)this.moduleDescriptorFactory.create(MoreTypes.asTypeElement(moduleIncludesType)));
            }
            ImmutableSet<ExecutableElement> unimplementedMethods = Util.getUnimplementedMethods(this.elements, componentDefinitionType);
            ImmutableSet.Builder componentMethodsBuilder = ImmutableSet.builder();
            ImmutableMap.Builder subcomponentDescriptors = ImmutableMap.builder();
            for (ExecutableElement componentMethod : unimplementedMethods) {
                ExecutableType resolvedMethod = MoreTypes.asExecutable(this.types.asMemberOf(declaredComponentType, componentMethod));
                ComponentMethodDescriptor componentMethodDescriptor = this.getDescriptorForComponentMethod(componentDefinitionType, kind, componentMethod);
                componentMethodsBuilder.add((Object)componentMethodDescriptor);
                switch (componentMethodDescriptor.kind()) {
                    case SUBCOMPONENT: {
                        subcomponentDescriptors.put((Object)componentMethod, (Object)this.create(MoreElements.asType(MoreTypes.asElement(resolvedMethod.getReturnType())), Kind.SUBCOMPONENT));
                        break;
                    }
                    case SUBCOMPONENT_BUILDER: {
                        subcomponentDescriptors.put((Object)componentMethod, (Object)this.create(MoreElements.asType(MoreTypes.asElement(resolvedMethod.getReturnType()).getEnclosingElement()), Kind.SUBCOMPONENT));
                        break;
                    }
                }
            }
            ImmutableList<DeclaredType> enclosedBuilders = kind.builderAnnotationType() == null ? ImmutableList.of() : ConfigurationAnnotations.enclosedBuilders(componentDefinitionType, kind.builderAnnotationType());
            Optional builderType = Optional.fromNullable((Object)Iterables.getOnlyElement(enclosedBuilders, null));
            Optional<AnnotationMirror> scope = InjectionAnnotations.getScopeAnnotation(componentDefinitionType);
            return new AutoValue_ComponentDescriptor(kind, componentMirror, componentDefinitionType, componentDependencyTypes, (ImmutableSet<ModuleDescriptor>)modules.build(), (ImmutableMap<ExecutableElement, TypeElement>)dependencyMethodIndex.build(), (Optional<TypeElement>)executorDependency, Util.wrapOptionalInEquivalence(AnnotationMirrors.equivalence(), scope), (ImmutableMap<ExecutableElement, ComponentDescriptor>)subcomponentDescriptors.build(), (ImmutableSet<ComponentMethodDescriptor>)componentMethodsBuilder.build(), this.createBuilderSpec((Optional<DeclaredType>)builderType));
        }

        private ComponentMethodDescriptor getDescriptorForComponentMethod(TypeElement componentElement, Kind componentKind, ExecutableElement componentMethod) {
            ExecutableType resolvedComponentMethod = MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(componentElement.asType()), componentMethod));
            TypeMirror returnType = resolvedComponentMethod.getReturnType();
            if (returnType.getKind().equals((Object)TypeKind.DECLARED)) {
                if (MoreTypes.isTypeOf(Provider.class, returnType) || MoreTypes.isTypeOf(Lazy.class, returnType)) {
                    return new AutoValue_ComponentDescriptor_ComponentMethodDescriptor(ComponentMethodKind.PROVISON, (Optional<DependencyRequest>)Optional.of((Object)this.dependencyRequestFactory.forComponentProvisionMethod(componentMethod, resolvedComponentMethod)), componentMethod);
                }
                if (MoreTypes.isTypeOf(MembersInjector.class, returnType)) {
                    return new AutoValue_ComponentDescriptor_ComponentMethodDescriptor(ComponentMethodKind.MEMBERS_INJECTION, (Optional<DependencyRequest>)Optional.of((Object)this.dependencyRequestFactory.forComponentMembersInjectionMethod(componentMethod, resolvedComponentMethod)), componentMethod);
                }
                if (MoreElements.isAnnotationPresent(MoreTypes.asElement(returnType), Subcomponent.class)) {
                    return new AutoValue_ComponentDescriptor_ComponentMethodDescriptor(ComponentMethodKind.SUBCOMPONENT, (Optional<DependencyRequest>)Optional.absent(), componentMethod);
                }
            }
            if (componentMethod.getParameters().isEmpty() && !componentMethod.getReturnType().getKind().equals((Object)TypeKind.VOID)) {
                switch (componentKind) {
                    case COMPONENT: 
                    case SUBCOMPONENT: {
                        return new AutoValue_ComponentDescriptor_ComponentMethodDescriptor(ComponentMethodKind.PROVISON, (Optional<DependencyRequest>)Optional.of((Object)this.dependencyRequestFactory.forComponentProvisionMethod(componentMethod, resolvedComponentMethod)), componentMethod);
                    }
                    case PRODUCTION_COMPONENT: {
                        return new AutoValue_ComponentDescriptor_ComponentMethodDescriptor(ComponentMethodKind.PRODUCTION, (Optional<DependencyRequest>)Optional.of((Object)this.dependencyRequestFactory.forComponentProductionMethod(componentMethod, resolvedComponentMethod)), componentMethod);
                    }
                }
                throw new AssertionError();
            }
            List<? extends TypeMirror> parameterTypes = resolvedComponentMethod.getParameterTypes();
            if (parameterTypes.size() == 1 && (returnType.getKind().equals((Object)TypeKind.VOID) || MoreTypes.equivalence().equivalent((Object)returnType, (Object)parameterTypes.get(0)))) {
                return new AutoValue_ComponentDescriptor_ComponentMethodDescriptor(ComponentMethodKind.MEMBERS_INJECTION, (Optional<DependencyRequest>)Optional.of((Object)this.dependencyRequestFactory.forComponentMembersInjectionMethod(componentMethod, resolvedComponentMethod)), componentMethod);
            }
            throw new IllegalArgumentException("not a valid component method: " + componentMethod);
        }

        private Optional<BuilderSpec> createBuilderSpec(Optional<DeclaredType> builderType) {
            if (!builderType.isPresent()) {
                return Optional.absent();
            }
            TypeElement element = MoreTypes.asTypeElement((TypeMirror)builderType.get());
            ImmutableSet<ExecutableElement> methods = Util.getUnimplementedMethods(this.elements, element);
            ImmutableMap.Builder map = ImmutableMap.builder();
            ExecutableElement buildMethod = null;
            for (ExecutableElement method : methods) {
                if (method.getParameters().isEmpty()) {
                    buildMethod = method;
                    continue;
                }
                ExecutableType resolved = MoreTypes.asExecutable(this.types.asMemberOf((DeclaredType)builderType.get(), method));
                map.put((Object)MoreTypes.asTypeElement((TypeMirror)Iterables.getOnlyElement(resolved.getParameterTypes())), (Object)method);
            }
            Verify.verify((buildMethod != null ? 1 : 0) != 0);
            return Optional.of((Object)new AutoValue_ComponentDescriptor_BuilderSpec(element, (Map<TypeElement, ExecutableElement>)map.build(), buildMethod, element.getEnclosingElement().asType()));
        }
    }

    static abstract class BuilderSpec {
        BuilderSpec() {
        }

        abstract TypeElement builderDefinitionType();

        abstract Map<TypeElement, ExecutableElement> methodMap();

        abstract ExecutableElement buildMethod();

        abstract TypeMirror componentType();
    }

    static enum ComponentMethodKind {
        PROVISON,
        PRODUCTION,
        MEMBERS_INJECTION,
        SUBCOMPONENT,
        SUBCOMPONENT_BUILDER;

    }

    static abstract class ComponentMethodDescriptor {
        ComponentMethodDescriptor() {
        }

        abstract ComponentMethodKind kind();

        abstract Optional<DependencyRequest> dependencyRequest();

        abstract ExecutableElement methodElement();
    }

    static enum Kind {
        COMPONENT(Component.class, null),
        SUBCOMPONENT(Subcomponent.class, null),
        PRODUCTION_COMPONENT(ProductionComponent.class, null);

        private final Class<? extends Annotation> annotationType;
        private final Class<? extends Annotation> builderType;

        private Kind(Class<? extends Annotation> annotationType, Class<? extends Annotation> builderType) {
            this.annotationType = annotationType;
            this.builderType = builderType;
        }

        Class<? extends Annotation> annotationType() {
            return this.annotationType;
        }

        Class<? extends Annotation> builderAnnotationType() {
            return this.builderType;
        }
    }
}

