/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.MembersInjector;
import dagger.internal.Factory;
import dagger.internal.InstanceFactory;
import dagger.internal.MapFactory;
import dagger.internal.MapProviderFactory;
import dagger.internal.MembersInjectors;
import dagger.internal.ScopedProvider;
import dagger.internal.SetFactory;
import dagger.internal.codegen.AutoValue_ComponentGenerator_MemberSelect;
import dagger.internal.codegen.AutoValue_ComponentGenerator_ProxyClassAndField;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentProcessor;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.DependencyRequestMapper;
import dagger.internal.codegen.FrameworkField;
import dagger.internal.codegen.KeyVariableNamer;
import dagger.internal.codegen.MapKeys;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.MethodSignature;
import dagger.internal.codegen.ModuleDescriptor;
import dagger.internal.codegen.ProductionBinding;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.SourceFileGenerator;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.Util;
import dagger.internal.codegen.writer.ClassName;
import dagger.internal.codegen.writer.ClassWriter;
import dagger.internal.codegen.writer.ConstructorWriter;
import dagger.internal.codegen.writer.FieldWriter;
import dagger.internal.codegen.writer.JavaWriter;
import dagger.internal.codegen.writer.MethodWriter;
import dagger.internal.codegen.writer.ParameterizedTypeName;
import dagger.internal.codegen.writer.Snippet;
import dagger.internal.codegen.writer.StringLiteral;
import dagger.internal.codegen.writer.TypeName;
import dagger.internal.codegen.writer.TypeNames;
import dagger.internal.codegen.writer.VoidName;
import dagger.producers.Producer;
import dagger.producers.internal.Producers;
import dagger.producers.internal.SetProducer;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.processing.Filer;
import javax.inject.Provider;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementKindVisitor6;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

final class ComponentGenerator
extends SourceFileGenerator<BindingGraph> {
    private final Types types;
    private final Diagnostic.Kind nullableValidationType;

    ComponentGenerator(Filer filer, Types types, Diagnostic.Kind nullableValidationType) {
        super(filer);
        this.types = types;
        this.nullableValidationType = nullableValidationType;
    }

    @Override
    ClassName nameGeneratedType(BindingGraph input) {
        ClassName componentDefinitionClassName = ClassName.fromTypeElement(input.componentDescriptor().componentDefinitionType());
        String componentName = "Dagger" + componentDefinitionClassName.classFileName().replace('$', '_');
        return componentDefinitionClassName.topLevelClassName().peerNamed(componentName);
    }

    @Override
    Iterable<? extends Element> getOriginatingElements(BindingGraph input) {
        return ImmutableSet.of((Object)input.componentDescriptor().componentDefinitionType());
    }

    @Override
    Optional<? extends Element> getElementForErrorReporting(BindingGraph input) {
        return Optional.of((Object)input.componentDescriptor().componentDefinitionType());
    }

    @Override
    ImmutableSet<JavaWriter> write(ClassName componentName, BindingGraph input) {
        TypeElement componentDefinitionType = input.componentDescriptor().componentDefinitionType();
        ClassName componentDefinitionTypeName = ClassName.fromTypeElement(componentDefinitionType);
        JavaWriter writer = JavaWriter.inPackage(componentName.packageName());
        ClassWriter componentWriter = writer.addClass(componentName.simpleName());
        componentWriter.annotate(Generated.class).setValue(ComponentProcessor.class.getCanonicalName());
        componentWriter.addModifiers(Modifier.PUBLIC, Modifier.FINAL);
        Preconditions.checkState((boolean)componentDefinitionType.getModifiers().contains((Object)Modifier.ABSTRACT));
        componentWriter.setSupertype(componentDefinitionType);
        HashSet javaWriters = Sets.newHashSet();
        javaWriters.add(writer);
        this.writeComponent(input, componentDefinitionTypeName, componentWriter, javaWriters);
        return ImmutableSet.copyOf((Collection)javaWriters);
    }

    private ClassWriter writeBuilder(BindingGraph input, ClassName componentApiName, ClassName componentImplName, ClassWriter componentWriter, Map<TypeElement, MemberSelect> componentContributionFields) {
        MethodWriter buildMethod;
        ClassWriter builderWriter;
        Optional<ComponentDescriptor.BuilderSpec> builderSpec = input.componentDescriptor().builderSpec();
        switch (input.componentDescriptor().kind()) {
            case COMPONENT: 
            case PRODUCTION_COMPONENT: {
                builderWriter = componentWriter.addNestedClass("Builder");
                builderWriter.addModifiers(Modifier.STATIC, new Modifier[0]);
                MethodWriter builderFactoryMethod = builderSpec.isPresent() ? componentWriter.addMethod(((ComponentDescriptor.BuilderSpec)builderSpec.get()).builderDefinitionType().asType(), "builder") : componentWriter.addMethod(builderWriter, "builder");
                builderFactoryMethod.addModifiers(Modifier.PUBLIC, Modifier.STATIC);
                builderFactoryMethod.body().addSnippet("return new %s();", builderWriter.name());
                break;
            }
            case SUBCOMPONENT: {
                Verify.verify((boolean)builderSpec.isPresent());
                builderWriter = componentWriter.addNestedClass(componentApiName.simpleName() + "Builder");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        builderWriter.addModifiers(Modifier.FINAL, new Modifier[0]);
        builderWriter.addConstructor().addModifiers(Modifier.PRIVATE, new Modifier[0]);
        if (builderSpec.isPresent()) {
            builderWriter.addModifiers(Modifier.PRIVATE, new Modifier[0]);
            builderWriter.setSupertype(((ComponentDescriptor.BuilderSpec)builderSpec.get()).builderDefinitionType());
        } else {
            builderWriter.addModifiers(Modifier.PUBLIC, new Modifier[0]);
        }
        ImmutableMap componentContributionNames = ImmutableMap.copyOf((Map)Maps.asMap(input.componentRequirements(), (Function)Functions.compose((Function)CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_CAMEL), (Function)new Function<TypeElement, String>(){

            public String apply(TypeElement input) {
                return input.getSimpleName().toString();
            }
        })));
        if (builderSpec.isPresent()) {
            ExecutableElement specBuildMethod = ((ComponentDescriptor.BuilderSpec)builderSpec.get()).buildMethod();
            buildMethod = builderWriter.addMethod(componentApiName, specBuildMethod.getSimpleName().toString());
            buildMethod.annotate(Override.class);
        } else {
            buildMethod = builderWriter.addMethod(componentApiName, "build");
        }
        buildMethod.addModifiers(Modifier.PUBLIC, new Modifier[0]);
        for (Map.Entry entry : componentContributionNames.entrySet()) {
            MethodWriter builderMethod;
            TypeElement contributionElement = (TypeElement)entry.getKey();
            String contributionName = (String)entry.getValue();
            FieldWriter builderField = builderWriter.addField(contributionElement, contributionName);
            builderField.addModifiers(Modifier.PRIVATE, new Modifier[0]);
            componentContributionFields.put(contributionElement, MemberSelect.instanceSelect(componentImplName, Snippet.format("builder.%s", builderField.name())));
            if (Util.componentCanMakeNewInstances(contributionElement)) {
                buildMethod.body().addSnippet("if (%s == null) {", builderField.name()).addSnippet("  this.%s = new %s();", builderField.name(), ClassName.fromTypeElement(contributionElement)).addSnippet("}", new Object[0]);
            } else {
                buildMethod.body().addSnippet("if (%s == null) {", builderField.name()).addSnippet("  throw new IllegalStateException(\"%s must be set\");", builderField.name()).addSnippet("}", new Object[0]);
            }
            boolean returnsVoid = false;
            if (builderSpec.isPresent()) {
                ExecutableElement method = ((ComponentDescriptor.BuilderSpec)builderSpec.get()).methodMap().get(contributionElement);
                if (method == null) continue;
                if (method.getReturnType().getKind().equals((Object)TypeKind.VOID)) {
                    returnsVoid = true;
                    builderMethod = builderWriter.addMethod(method.getReturnType(), method.getSimpleName().toString());
                } else {
                    builderMethod = builderWriter.addMethod(builderWriter, method.getSimpleName().toString());
                }
                builderMethod.annotate(Override.class);
            } else {
                builderMethod = builderWriter.addMethod(builderWriter, contributionName);
            }
            builderMethod.addModifiers(Modifier.PUBLIC, new Modifier[0]);
            builderMethod.addParameter(contributionElement, contributionName);
            builderMethod.body().addSnippet("if (%s == null) {", contributionName).addSnippet("  throw new NullPointerException(%s);", StringLiteral.forValue(contributionName)).addSnippet("}", new Object[0]).addSnippet("this.%s = %s;", builderField.name(), contributionName);
            if (returnsVoid) continue;
            builderMethod.body().addSnippet("return this;", new Object[0]);
        }
        buildMethod.body().addSnippet("return new %s(this);", componentImplName);
        return builderWriter;
    }

    private boolean requiresUserSuppliedDependents(BindingGraph input) {
        Set userRequiredDependents = Sets.filter(input.componentRequirements(), (Predicate)new Predicate<TypeElement>(){

            public boolean apply(TypeElement input) {
                return !Util.componentCanMakeNewInstances(input);
            }
        });
        return !userRequiredDependents.isEmpty();
    }

    private ImmutableMap<BindingKey, MemberSelect> writeComponent(BindingGraph input, ClassName componentDefinitionTypeName, ClassWriter componentWriter, Set<JavaWriter> proxyWriters) {
        HashMap componentContributionFields = Maps.newHashMap();
        ClassWriter builderWriter = this.writeBuilder(input, componentDefinitionTypeName, componentWriter.name(), componentWriter, componentContributionFields);
        if (!this.requiresUserSuppliedDependents(input)) {
            MethodWriter factoryMethod = componentWriter.addMethod(componentDefinitionTypeName, "create");
            factoryMethod.addModifiers(Modifier.PUBLIC, Modifier.STATIC);
            factoryMethod.body().addSnippet("return builder().%s();", input.componentDescriptor().builderSpec().isPresent() ? ((ComponentDescriptor.BuilderSpec)input.componentDescriptor().builderSpec().get()).buildMethod().getSimpleName() : "build");
        }
        HashMap memberSelectSnippetsBuilder = Maps.newHashMap();
        HashMap multibindingContributionSnippetsBuilder = Maps.newHashMap();
        ImmutableSet.Builder enumBindingKeysBuilder = ImmutableSet.builder();
        HashMap packageProxies = Maps.newHashMap();
        this.writeFields(input, componentWriter, proxyWriters, memberSelectSnippetsBuilder, multibindingContributionSnippetsBuilder, (ImmutableSet.Builder<BindingKey>)enumBindingKeysBuilder, packageProxies);
        ImmutableMap memberSelectSnippets = ImmutableMap.copyOf((Map)memberSelectSnippetsBuilder);
        ImmutableMap multibindingContributionSnippets = ImmutableMap.copyOf((Map)multibindingContributionSnippetsBuilder);
        ImmutableSet enumBindingKeys = enumBindingKeysBuilder.build();
        ConstructorWriter constructorWriter = componentWriter.addConstructor();
        constructorWriter.addModifiers(Modifier.PRIVATE, new Modifier[0]);
        constructorWriter.addParameter(builderWriter, "builder");
        constructorWriter.body().addSnippet("assert builder != null;", new Object[0]);
        this.initializeFrameworkTypes(input, componentWriter, constructorWriter, (Optional<ClassName>)Optional.of((Object)builderWriter.name()), componentContributionFields, (ImmutableMap<BindingKey, MemberSelect>)memberSelectSnippets, (ImmutableMap<ContributionBinding, Snippet>)ImmutableMap.of(), (ImmutableMap<ContributionBinding, Snippet>)multibindingContributionSnippets);
        this.writeInterfaceMethods(input, componentWriter, (ImmutableMap<BindingKey, MemberSelect>)memberSelectSnippets, (ImmutableSet<BindingKey>)enumBindingKeys);
        for (Map.Entry subgraphEntry : input.subgraphs().entrySet()) {
            this.writeSubcomponent(componentWriter, MoreTypes.asDeclared(input.componentDescriptor().componentDefinitionType().asType()), proxyWriters, (ImmutableMap<BindingKey, MemberSelect>)memberSelectSnippets, (ImmutableMap<ContributionBinding, Snippet>)multibindingContributionSnippets, (ExecutableElement)subgraphEntry.getKey(), (BindingGraph)subgraphEntry.getValue());
        }
        return memberSelectSnippets;
    }

    private void writeSubcomponent(ClassWriter componentWriter, DeclaredType containingComponent, Set<JavaWriter> proxyWriters, ImmutableMap<BindingKey, MemberSelect> parentMemberSelectSnippets, ImmutableMap<ContributionBinding, Snippet> parentMultibindingContributionSnippets, ExecutableElement subcomponentFactoryMethod, BindingGraph subgraph) {
        Optional builderName;
        MethodWriter componentMethod;
        TypeMirror subcomponentType;
        ClassName subcomponentApiName = ClassName.fromTypeElement(subgraph.componentDescriptor().componentDefinitionType());
        ClassWriter subcomponentWriter = componentWriter.addNestedClass(subcomponentApiName.simpleName() + "Impl");
        subcomponentWriter.addModifiers(Modifier.PRIVATE, Modifier.FINAL);
        ConstructorWriter constructorWriter = subcomponentWriter.addConstructor();
        constructorWriter.addModifiers(Modifier.PRIVATE, new Modifier[0]);
        constructorWriter.body();
        HashMap componentContributionFields = Maps.newHashMap();
        ImmutableList.Builder subcomponentConstructorParameters = ImmutableList.builder();
        if (subgraph.componentDescriptor().builderSpec().isPresent()) {
            ComponentDescriptor.BuilderSpec spec = (ComponentDescriptor.BuilderSpec)subgraph.componentDescriptor().builderSpec().get();
            subcomponentType = spec.componentType();
            componentMethod = componentWriter.addMethod(ClassName.fromTypeElement(spec.builderDefinitionType()), subcomponentFactoryMethod.getSimpleName().toString());
            ClassWriter builderWriter = this.writeBuilder(subgraph, subcomponentApiName, subcomponentWriter.name(), componentWriter, componentContributionFields);
            builderName = Optional.of((Object)builderWriter.name());
            constructorWriter.addParameter(builderWriter, "builder");
            constructorWriter.body().addSnippet("assert builder != null;", new Object[0]);
            componentMethod.body().addSnippet("return new %s();", builderWriter.name());
        } else {
            builderName = Optional.absent();
            ExecutableType resolvedMethod = MoreTypes.asExecutable(this.types.asMemberOf(containingComponent, subcomponentFactoryMethod));
            subcomponentType = resolvedMethod.getReturnType();
            componentMethod = componentWriter.addMethod(subcomponentType, subcomponentFactoryMethod.getSimpleName().toString());
            this.writeSubcomponentWithoutBuilder(subcomponentFactoryMethod, subgraph, subcomponentWriter, constructorWriter, componentContributionFields, (ImmutableList.Builder<Snippet>)subcomponentConstructorParameters, componentMethod, resolvedMethod);
        }
        componentMethod.addModifiers(Modifier.PUBLIC, new Modifier[0]);
        componentMethod.annotate(Override.class);
        TypeElement subcomponentElement = MoreTypes.asTypeElement(subcomponentType);
        Preconditions.checkState((boolean)subcomponentElement.getModifiers().contains((Object)Modifier.ABSTRACT));
        subcomponentWriter.setSupertype(subcomponentElement);
        HashMap memberSelectSnippetsBuilder = Maps.newHashMap();
        HashMap multibindingContributionSnippetsBuilder = Maps.newHashMap();
        ImmutableSet.Builder enumBindingKeysBuilder = ImmutableSet.builder();
        HashMap packageProxies = Maps.newHashMap();
        this.writeFields(subgraph, subcomponentWriter, proxyWriters, memberSelectSnippetsBuilder, multibindingContributionSnippetsBuilder, (ImmutableSet.Builder<BindingKey>)enumBindingKeysBuilder, packageProxies);
        for (Map.Entry parentBindingEntry : parentMemberSelectSnippets.entrySet()) {
            if (memberSelectSnippetsBuilder.containsKey(parentBindingEntry.getKey())) continue;
            memberSelectSnippetsBuilder.put(parentBindingEntry.getKey(), parentBindingEntry.getValue());
        }
        ImmutableMap memberSelectSnippets = ImmutableMap.copyOf((Map)memberSelectSnippetsBuilder);
        ImmutableMap multibindingContributionSnippets = ImmutableMap.copyOf((Map)multibindingContributionSnippetsBuilder);
        ImmutableSet enumBindingKeys = enumBindingKeysBuilder.build();
        this.initializeFrameworkTypes(subgraph, subcomponentWriter, constructorWriter, (Optional<ClassName>)builderName, componentContributionFields, (ImmutableMap<BindingKey, MemberSelect>)memberSelectSnippets, parentMultibindingContributionSnippets, (ImmutableMap<ContributionBinding, Snippet>)multibindingContributionSnippets);
        this.writeInterfaceMethods(subgraph, subcomponentWriter, (ImmutableMap<BindingKey, MemberSelect>)memberSelectSnippets, (ImmutableSet<BindingKey>)enumBindingKeys);
        for (Map.Entry subgraphEntry : subgraph.subgraphs().entrySet()) {
            this.writeSubcomponent(subcomponentWriter, MoreTypes.asDeclared(subgraph.componentDescriptor().componentDefinitionType().asType()), proxyWriters, (ImmutableMap<BindingKey, MemberSelect>)memberSelectSnippets, (ImmutableMap<ContributionBinding, Snippet>)new ImmutableMap.Builder().putAll(parentMultibindingContributionSnippets).putAll((Map)multibindingContributionSnippets).build(), (ExecutableElement)subgraphEntry.getKey(), (BindingGraph)subgraphEntry.getValue());
        }
    }

    private void writeSubcomponentWithoutBuilder(ExecutableElement subcomponentFactoryMethod, BindingGraph subgraph, ClassWriter subcomponentWriter, ConstructorWriter constructorWriter, Map<TypeElement, MemberSelect> componentContributionFields, ImmutableList.Builder<Snippet> subcomponentConstructorParameters, MethodWriter componentMethod, ExecutableType resolvedMethod) {
        List<? extends VariableElement> params = subcomponentFactoryMethod.getParameters();
        List<? extends TypeMirror> paramTypes = resolvedMethod.getParameterTypes();
        for (int i = 0; i < params.size(); ++i) {
            VariableElement moduleVariable = params.get(i);
            TypeElement moduleTypeElement = MoreTypes.asTypeElement(paramTypes.get(i));
            TypeName moduleType = TypeNames.forTypeMirror(paramTypes.get(i));
            componentMethod.addParameter(moduleType, moduleVariable.getSimpleName().toString());
            if (componentContributionFields.containsKey(moduleTypeElement)) continue;
            String preferredModuleName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, moduleTypeElement.getSimpleName().toString());
            FieldWriter contributionField = subcomponentWriter.addField(moduleTypeElement, preferredModuleName);
            contributionField.addModifiers(Modifier.PRIVATE, Modifier.FINAL);
            String actualModuleName = contributionField.name();
            constructorWriter.addParameter(moduleType, actualModuleName);
            constructorWriter.body().addSnippet(Snippet.format(Joiner.on((char)'\n').join((Object)"if (%s == null) {", (Object)"  throw new NullPointerException();", new Object[]{"}"}), actualModuleName));
            constructorWriter.body().addSnippet(Snippet.format("this.%1$s = %1$s;", actualModuleName));
            MemberSelect moduleSelect = MemberSelect.instanceSelect(subcomponentWriter.name(), Snippet.format(actualModuleName, new Object[0]));
            componentContributionFields.put(moduleTypeElement, moduleSelect);
            subcomponentConstructorParameters.add((Object)Snippet.format("%s", moduleVariable.getSimpleName()));
        }
        ImmutableSet uninitializedModules = FluentIterable.from(subgraph.componentDescriptor().transitiveModules()).transform(ModuleDescriptor.getModuleElement()).filter(Predicates.not((Predicate)Predicates.in(componentContributionFields.keySet()))).toSet();
        for (TypeElement moduleType : uninitializedModules) {
            String preferredModuleName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, moduleType.getSimpleName().toString());
            FieldWriter contributionField = subcomponentWriter.addField(moduleType, preferredModuleName);
            contributionField.addModifiers(Modifier.PRIVATE, Modifier.FINAL);
            String actualModuleName = contributionField.name();
            constructorWriter.body().addSnippet(Snippet.format("this.%s = new %s();", actualModuleName, ClassName.fromTypeElement(moduleType)));
            MemberSelect moduleSelect = MemberSelect.instanceSelect(subcomponentWriter.name(), Snippet.format(actualModuleName, new Object[0]));
            componentContributionFields.put(moduleType, moduleSelect);
        }
        componentMethod.body().addSnippet("return new %s(%s);", subcomponentWriter.name(), Snippet.makeParametersSnippet((Iterable<Snippet>)subcomponentConstructorParameters.build()));
    }

    private void writeFields(BindingGraph input, ClassWriter componentWriter, Set<JavaWriter> proxyWriters, Map<BindingKey, MemberSelect> memberSelectSnippetsBuilder, Map<ContributionBinding, Snippet> multibindingContributionSnippetsBuilder, ImmutableSet.Builder<BindingKey> enumBindingKeysBuilder, Map<String, ProxyClassAndField> packageProxies) {
        for (ResolvedBindings resolvedBindings : input.resolvedBindings().values()) {
            this.writeField(componentWriter, proxyWriters, memberSelectSnippetsBuilder, multibindingContributionSnippetsBuilder, enumBindingKeysBuilder, packageProxies, resolvedBindings);
        }
    }

    private void writeField(ClassWriter componentWriter, Set<JavaWriter> proxyWriters, Map<BindingKey, MemberSelect> memberSelectSnippetsBuilder, Map<ContributionBinding, Snippet> multibindingContributionSnippetsBuilder, ImmutableSet.Builder<BindingKey> enumBindingKeysBuilder, Map<String, ProxyClassAndField> packageProxies, ResolvedBindings resolvedBindings) {
        ImmutableSet<? extends ContributionBinding> contributionBindings;
        EnumSet<Modifier> fieldModifiers;
        ClassWriter classWithFields;
        Optional proxySelector;
        String bindingPackage;
        BindingKey bindingKey = resolvedBindings.bindingKey();
        if (bindingKey.kind().equals((Object)BindingKey.Kind.CONTRIBUTION) && resolvedBindings.ownedContributionBindings().isEmpty() && !ContributionBinding.bindingTypeFor(resolvedBindings.contributionBindings()).isMultibinding()) {
            return;
        }
        if (resolvedBindings.bindings().size() == 1) {
            MembersInjectionBinding membersInjectionBinding;
            if (bindingKey.kind().equals((Object)BindingKey.Kind.CONTRIBUTION)) {
                ProvisionBinding provisionBinding;
                ContributionBinding contributionBinding = (ContributionBinding)Iterables.getOnlyElement(resolvedBindings.contributionBindings());
                if (!contributionBinding.bindingType().isMultibinding() && contributionBinding instanceof ProvisionBinding && (provisionBinding = (ProvisionBinding)contributionBinding).factoryCreationStrategy().equals((Object)ProvisionBinding.FactoryCreationStrategy.ENUM_INSTANCE) && !provisionBinding.scope().isPresent()) {
                    enumBindingKeysBuilder.add((Object)bindingKey);
                    memberSelectSnippetsBuilder.put(bindingKey, MemberSelect.staticSelect(SourceFiles.factoryNameForProvisionBinding(provisionBinding), Snippet.format("create()", new Object[0])));
                    return;
                }
            } else if (bindingKey.kind().equals((Object)BindingKey.Kind.MEMBERS_INJECTION) && (membersInjectionBinding = (MembersInjectionBinding)Iterables.getOnlyElement(resolvedBindings.membersInjectionBindings())).injectionStrategy().equals((Object)MembersInjectionBinding.Strategy.NO_OP)) {
                enumBindingKeysBuilder.add((Object)bindingKey);
                memberSelectSnippetsBuilder.put(bindingKey, MemberSelect.staticMethodInvocationWithCast(ClassName.fromClass(MembersInjectors.class), Snippet.format("noOp()", new Object[0]), ClassName.fromClass(MembersInjector.class)));
                return;
            }
        }
        if ((bindingPackage = (String)Binding.bindingPackageFor(resolvedBindings.bindings()).or((Object)componentWriter.name().packageName())).equals(componentWriter.name().packageName())) {
            proxySelector = Optional.absent();
            classWithFields = componentWriter;
            fieldModifiers = EnumSet.of(Modifier.PRIVATE);
        } else {
            ProxyClassAndField proxyClassAndField = packageProxies.get(bindingPackage);
            if (proxyClassAndField == null) {
                JavaWriter proxyJavaWriter = JavaWriter.inPackage(bindingPackage);
                proxyWriters.add(proxyJavaWriter);
                ClassWriter proxyWriter = proxyJavaWriter.addClass(componentWriter.name().simpleName() + "_PackageProxy");
                proxyWriter.annotate(Generated.class).setValue(ComponentProcessor.class.getCanonicalName());
                proxyWriter.addModifiers(Modifier.PUBLIC, Modifier.FINAL);
                FieldWriter proxyFieldWriter = componentWriter.addField(proxyWriter.name(), bindingPackage.replace('.', '_') + "_Proxy");
                proxyFieldWriter.addModifiers(Modifier.PRIVATE, Modifier.FINAL);
                proxyFieldWriter.setInitializer("new %s()", proxyWriter.name());
                proxyClassAndField = ProxyClassAndField.create(proxyWriter, proxyFieldWriter);
                packageProxies.put(bindingPackage, proxyClassAndField);
            }
            proxySelector = Optional.of((Object)proxyClassAndField.proxyFieldWriter().name());
            classWithFields = proxyClassAndField.proxyWriter();
            fieldModifiers = EnumSet.of(Modifier.PUBLIC);
        }
        if (bindingKey.kind().equals((Object)BindingKey.Kind.CONTRIBUTION) && ContributionBinding.bindingTypeFor(contributionBindings = resolvedBindings.contributionBindings()).isMultibinding()) {
            int contributionNumber = 0;
            for (ContributionBinding contributionBinding : contributionBindings) {
                if (contributionBinding.isSyntheticBinding()) continue;
                ++contributionNumber;
                if (!resolvedBindings.ownedBindings().contains((Object)contributionBinding)) continue;
                FrameworkField contributionBindingField = ComponentGenerator.frameworkFieldForSyntheticContributionBinding(bindingKey, contributionNumber, contributionBinding);
                FieldWriter contributionField = classWithFields.addField(contributionBindingField.frameworkType(), contributionBindingField.name());
                contributionField.addModifiers(fieldModifiers);
                ImmutableList contributionSelectTokens = new ImmutableList.Builder().addAll((Iterable)proxySelector.asSet()).add((Object)contributionField.name()).build();
                multibindingContributionSnippetsBuilder.put(contributionBinding, Snippet.memberSelectSnippet((Iterable<? extends Object>)contributionSelectTokens));
            }
        }
        FrameworkField bindingField = this.frameworkFieldForResolvedBindings(resolvedBindings);
        FieldWriter frameworkField = classWithFields.addField(bindingField.frameworkType(), bindingField.name());
        frameworkField.addModifiers(fieldModifiers);
        ImmutableList memberSelectTokens = new ImmutableList.Builder().addAll((Iterable)proxySelector.asSet()).add((Object)frameworkField.name()).build();
        memberSelectSnippetsBuilder.put(bindingKey, MemberSelect.instanceSelect(componentWriter.name(), Snippet.memberSelectSnippet((Iterable<? extends Object>)memberSelectTokens)));
    }

    private void writeInterfaceMethods(BindingGraph input, ClassWriter componentWriter, ImmutableMap<BindingKey, MemberSelect> memberSelectSnippets, ImmutableSet<BindingKey> enumBindingKeys) throws AssertionError {
        HashSet interfaceMethods = Sets.newHashSet();
        block5: for (ComponentDescriptor.ComponentMethodDescriptor componentMethod : input.componentDescriptor().componentMethods()) {
            if (!componentMethod.dependencyRequest().isPresent()) continue;
            DependencyRequest interfaceRequest = (DependencyRequest)componentMethod.dependencyRequest().get();
            ExecutableElement requestElement = MoreElements.asExecutable(interfaceRequest.requestElement());
            ExecutableType requestType = MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(input.componentDescriptor().componentDefinitionType().asType()), requestElement));
            MethodSignature signature = MethodSignature.fromExecutableType(requestElement.getSimpleName().toString(), requestType);
            if (interfaceMethods.contains(signature)) continue;
            interfaceMethods.add(signature);
            MethodWriter interfaceMethod = requestType.getReturnType().getKind().equals((Object)TypeKind.VOID) ? componentWriter.addMethod(VoidName.VOID, requestElement.getSimpleName().toString()) : componentWriter.addMethod(requestType.getReturnType(), requestElement.getSimpleName().toString());
            interfaceMethod.annotate(Override.class);
            interfaceMethod.addModifiers(Modifier.PUBLIC, new Modifier[0]);
            BindingKey bindingKey = interfaceRequest.bindingKey();
            switch (interfaceRequest.kind()) {
                case MEMBERS_INJECTOR: {
                    MemberSelect membersInjectorSelect = (MemberSelect)memberSelectSnippets.get((Object)bindingKey);
                    List<? extends VariableElement> parameters = requestElement.getParameters();
                    if (parameters.isEmpty()) {
                        interfaceMethod.body().addSnippet("return %s;", membersInjectorSelect.getSnippetFor(componentWriter.name()));
                        break;
                    }
                    VariableElement parameter = (VariableElement)Iterables.getOnlyElement(parameters);
                    Name parameterName = parameter.getSimpleName();
                    interfaceMethod.addParameter(TypeNames.forTypeMirror((TypeMirror)Iterables.getOnlyElement(requestType.getParameterTypes())), parameterName.toString());
                    interfaceMethod.body().addSnippet("%s.injectMembers(%s);", membersInjectorSelect.getSnippetFor(componentWriter.name()), parameterName);
                    if (requestType.getReturnType().getKind().equals((Object)TypeKind.VOID)) continue block5;
                    interfaceMethod.body().addSnippet("return %s;", parameterName);
                    break;
                }
                case INSTANCE: {
                    if (enumBindingKeys.contains((Object)bindingKey) && bindingKey.key().type().getKind().equals((Object)TypeKind.DECLARED) && !((DeclaredType)bindingKey.key().type()).getTypeArguments().isEmpty()) {
                        ParameterizedTypeName factoryType = ParameterizedTypeName.create(Provider.class, TypeNames.forTypeMirror(requestType.getReturnType()));
                        interfaceMethod.body().addSnippet("%s factory = %s;", factoryType, ((MemberSelect)memberSelectSnippets.get((Object)bindingKey)).getSnippetFor(componentWriter.name()));
                        interfaceMethod.body().addSnippet("return factory.get();", new Object[0]);
                        break;
                    }
                }
                case LAZY: 
                case PRODUCED: 
                case PRODUCER: 
                case PROVIDER: 
                case FUTURE: {
                    interfaceMethod.body().addSnippet("return %s;", SourceFiles.frameworkTypeUsageStatement(((MemberSelect)memberSelectSnippets.get((Object)bindingKey)).getSnippetFor(componentWriter.name()), interfaceRequest.kind()));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }

    private void initializeFrameworkTypes(BindingGraph input, ClassWriter componentWriter, ConstructorWriter constructorWriter, Optional<ClassName> builderName, Map<TypeElement, MemberSelect> componentContributionFields, ImmutableMap<BindingKey, MemberSelect> memberSelectSnippets, ImmutableMap<ContributionBinding, Snippet> parentMultibindingContributionSnippets, ImmutableMap<ContributionBinding, Snippet> multibindingContributionSnippets) throws AssertionError {
        List partitions = Lists.partition((List)input.resolvedBindings().keySet().asList(), (int)100);
        for (int i = 0; i < partitions.size(); ++i) {
            MethodWriter initializeMethod = componentWriter.addMethod(VoidName.VOID, "initialize" + (i == 0 ? "" : Integer.valueOf(i)));
            initializeMethod.body();
            initializeMethod.addModifiers(Modifier.PRIVATE, new Modifier[0]);
            if (builderName.isPresent()) {
                initializeMethod.addParameter((TypeName)builderName.get(), "builder").addModifiers(Modifier.FINAL, new Modifier[0]);
                constructorWriter.body().addSnippet("%s(builder);", initializeMethod.name());
            } else {
                constructorWriter.body().addSnippet("%s();", initializeMethod.name());
            }
            block10: for (BindingKey bindingKey : (List)partitions.get(i)) {
                Snippet memberSelectSnippet = ((MemberSelect)memberSelectSnippets.get((Object)bindingKey)).getSnippetFor(componentWriter.name());
                ResolvedBindings resolvedBindings = (ResolvedBindings)input.resolvedBindings().get((Object)bindingKey);
                block0 : switch (bindingKey.kind()) {
                    case CONTRIBUTION: {
                        ImmutableSet<? extends ContributionBinding> bindings = resolvedBindings.contributionBindings();
                        switch (ContributionBinding.bindingTypeFor(bindings)) {
                            case SET: {
                                boolean hasOnlyProvisions = Iterables.all(bindings, (Predicate)Predicates.instanceOf(ProvisionBinding.class));
                                ImmutableList.Builder parameterSnippets = ImmutableList.builder();
                                for (ContributionBinding binding : bindings) {
                                    if (multibindingContributionSnippets.containsKey((Object)binding)) {
                                        Snippet initializeSnippet = this.initializeFactoryForContributionBinding(binding, input, componentWriter.name(), componentContributionFields, memberSelectSnippets);
                                        Snippet snippet = (Snippet)multibindingContributionSnippets.get((Object)binding);
                                        initializeMethod.body().addSnippet("this.%s = %s;", snippet, initializeSnippet);
                                        parameterSnippets.add((Object)snippet);
                                        continue;
                                    }
                                    if (parentMultibindingContributionSnippets.containsKey((Object)binding)) {
                                        parameterSnippets.add(parentMultibindingContributionSnippets.get((Object)binding));
                                        continue;
                                    }
                                    throw new IllegalStateException(binding + " was not found in");
                                }
                                Snippet initializeSetSnippet = Snippet.format("%s.create(%s)", hasOnlyProvisions ? ClassName.fromClass(SetFactory.class) : ClassName.fromClass(SetProducer.class), Snippet.makeParametersSnippet((Iterable<Snippet>)parameterSnippets.build()));
                                initializeMethod.body().addSnippet("this.%s = %s;", memberSelectSnippet, initializeSetSnippet);
                                break block0;
                            }
                            case MAP: {
                                if (Sets.filter(bindings, (Predicate)Predicates.instanceOf(ProductionBinding.class)).isEmpty()) {
                                    ImmutableSet<? extends ContributionBinding> provisionBindings = bindings;
                                    for (ProvisionBinding provisionBinding : provisionBindings) {
                                        if (this.isNonProviderMap(provisionBinding.key().type()) || !multibindingContributionSnippets.containsKey((Object)provisionBinding)) continue;
                                        Snippet snippet = (Snippet)multibindingContributionSnippets.get((Object)provisionBinding);
                                        initializeMethod.body().addSnippet("this.%s = %s;", snippet, this.initializeFactoryForProvisionBinding(provisionBinding, componentWriter.name(), input.componentDescriptor().dependencyMethodIndex(), componentContributionFields, memberSelectSnippets));
                                    }
                                    if (provisionBindings.isEmpty()) continue block10;
                                    Snippet initializeMapSnippet = this.initializeMapBinding(componentWriter.name(), memberSelectSnippets, (ImmutableMap<ContributionBinding, Snippet>)new ImmutableMap.Builder().putAll(parentMultibindingContributionSnippets).putAll(multibindingContributionSnippets).build(), (Set<ProvisionBinding>)provisionBindings);
                                    initializeMethod.body().addSnippet("this.%s = %s;", memberSelectSnippet, initializeMapSnippet);
                                    break block0;
                                }
                                throw new IllegalStateException("producer map bindings not implemented yet");
                            }
                            case UNIQUE: {
                                ContributionBinding binding;
                                if (resolvedBindings.ownedContributionBindings().isEmpty()) continue block10;
                                binding = (ContributionBinding)Iterables.getOnlyElement(bindings);
                                if (binding instanceof ProvisionBinding) {
                                    ProvisionBinding provisionBinding = (ProvisionBinding)binding;
                                    if (provisionBinding.factoryCreationStrategy().equals((Object)ProvisionBinding.FactoryCreationStrategy.ENUM_INSTANCE) && !provisionBinding.scope().isPresent()) continue block10;
                                    initializeMethod.body().addSnippet("this.%s = %s;", memberSelectSnippet, this.initializeFactoryForProvisionBinding(provisionBinding, componentWriter.name(), input.componentDescriptor().dependencyMethodIndex(), componentContributionFields, memberSelectSnippets));
                                    break block0;
                                }
                                if (binding instanceof ProductionBinding) {
                                    ProductionBinding productionBinding = (ProductionBinding)binding;
                                    initializeMethod.body().addSnippet("this.%s = %s;", memberSelectSnippet, this.initializeFactoryForProductionBinding(productionBinding, input, componentWriter.name(), input.componentDescriptor().dependencyMethodIndex(), componentContributionFields, memberSelectSnippets));
                                    break block0;
                                }
                                throw new AssertionError();
                            }
                            default: {
                                throw new IllegalStateException();
                            }
                        }
                    }
                    case MEMBERS_INJECTION: {
                        MembersInjectionBinding binding = (MembersInjectionBinding)Iterables.getOnlyElement(resolvedBindings.membersInjectionBindings());
                        if (binding.injectionStrategy().equals((Object)MembersInjectionBinding.Strategy.NO_OP)) continue block10;
                        initializeMethod.body().addSnippet("this.%s = %s;", memberSelectSnippet, this.initializeMembersInjectorForBinding(componentWriter.name(), binding, memberSelectSnippets));
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }
    }

    private static FrameworkField frameworkFieldForSyntheticContributionBinding(BindingKey bindingKey, int contributionNumber, ContributionBinding contributionBinding) throws AssertionError {
        switch (contributionBinding.bindingType()) {
            case MAP: {
                return FrameworkField.createForMapBindingContribution(contributionBinding.frameworkClass(), BindingKey.create(bindingKey.kind(), contributionBinding.key()), KeyVariableNamer.INSTANCE.apply(bindingKey.key()) + "Contribution" + contributionNumber);
            }
            case SET: {
                return FrameworkField.createWithTypeFromKey(contributionBinding.frameworkClass(), bindingKey, KeyVariableNamer.INSTANCE.apply(bindingKey.key()) + "Contribution" + contributionNumber);
            }
            case UNIQUE: {
                return FrameworkField.createWithTypeFromKey(contributionBinding.frameworkClass(), bindingKey, KeyVariableNamer.INSTANCE.apply(bindingKey.key()) + "Contribution" + contributionNumber);
            }
        }
        throw new AssertionError();
    }

    private static Class<?> frameworkClassForResolvedBindings(ResolvedBindings resolvedBindings) {
        switch (resolvedBindings.bindingKey().kind()) {
            case CONTRIBUTION: {
                for (ContributionBinding binding : resolvedBindings.contributionBindings()) {
                    if (!(binding instanceof ProductionBinding)) continue;
                    return Producer.class;
                }
                return Provider.class;
            }
            case MEMBERS_INJECTION: {
                return MembersInjector.class;
            }
        }
        throw new AssertionError();
    }

    private FrameworkField frameworkFieldForResolvedBindings(ResolvedBindings resolvedBindings) {
        BindingKey bindingKey = resolvedBindings.bindingKey();
        switch (bindingKey.kind()) {
            case CONTRIBUTION: {
                ImmutableSet<? extends ContributionBinding> contributionBindings = resolvedBindings.contributionBindings();
                ContributionBinding.BindingType bindingsType = ProvisionBinding.bindingTypeFor(contributionBindings);
                switch (bindingsType) {
                    case SET: 
                    case MAP: {
                        return FrameworkField.createWithTypeFromKey(ComponentGenerator.frameworkClassForResolvedBindings(resolvedBindings), bindingKey, KeyVariableNamer.INSTANCE.apply(bindingKey.key()));
                    }
                    case UNIQUE: {
                        ContributionBinding binding = (ContributionBinding)Iterables.getOnlyElement(contributionBindings);
                        return FrameworkField.createWithTypeFromKey(ComponentGenerator.frameworkClassForResolvedBindings(resolvedBindings), bindingKey, binding.bindingElement().accept(new ElementKindVisitor6<String, Void>(){

                            @Override
                            public String visitExecutableAsConstructor(ExecutableElement e, Void p) {
                                return e.getEnclosingElement().accept(this, null);
                            }

                            @Override
                            public String visitExecutableAsMethod(ExecutableElement e, Void p) {
                                return e.getSimpleName().toString();
                            }

                            @Override
                            public String visitType(TypeElement e, Void p) {
                                return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, e.getSimpleName().toString());
                            }
                        }, null));
                    }
                }
                throw new AssertionError();
            }
            case MEMBERS_INJECTION: {
                return FrameworkField.createWithTypeFromKey(MembersInjector.class, bindingKey, CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, ((Binding)Iterables.getOnlyElement(resolvedBindings.bindings())).bindingElement().getSimpleName().toString()));
            }
        }
        throw new AssertionError();
    }

    private Snippet initializeFactoryForContributionBinding(ContributionBinding binding, BindingGraph input, ClassName componentName, Map<TypeElement, MemberSelect> componentContributionFields, ImmutableMap<BindingKey, MemberSelect> memberSelectSnippets) {
        if (binding instanceof ProvisionBinding) {
            return this.initializeFactoryForProvisionBinding((ProvisionBinding)binding, componentName, input.componentDescriptor().dependencyMethodIndex(), componentContributionFields, memberSelectSnippets);
        }
        if (binding instanceof ProductionBinding) {
            return this.initializeFactoryForProductionBinding((ProductionBinding)binding, input, componentName, input.componentDescriptor().dependencyMethodIndex(), componentContributionFields, memberSelectSnippets);
        }
        throw new AssertionError();
    }

    private Snippet initializeFactoryForProvisionBinding(ProvisionBinding binding, ClassName componentName, ImmutableMap<ExecutableElement, TypeElement> dependencyMethodIndex, Map<TypeElement, MemberSelect> contributionFields, ImmutableMap<BindingKey, MemberSelect> memberSelectSnippets) {
        switch (binding.bindingKind()) {
            case COMPONENT: {
                MemberSelect componentContributionSelect = contributionFields.get(MoreTypes.asTypeElement(binding.key().type()));
                return Snippet.format("%s.<%s>create(%s)", ClassName.fromClass(InstanceFactory.class), TypeNames.forTypeMirror(binding.key().type()), componentContributionSelect != null ? componentContributionSelect.getSnippetFor(componentName) : "this");
            }
            case COMPONENT_PROVISION: {
                TypeElement bindingTypeElement = (TypeElement)dependencyMethodIndex.get((Object)binding.bindingElement());
                String sourceFieldName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, bindingTypeElement.getSimpleName().toString());
                if (binding.nullableType().isPresent() || this.nullableValidationType.equals((Object)Diagnostic.Kind.WARNING)) {
                    Snippet nullableSnippet = binding.nullableType().isPresent() ? Snippet.format("@%s ", TypeNames.forTypeMirror((TypeMirror)binding.nullableType().get())) : Snippet.format("", new Object[0]);
                    return Snippet.format(Joiner.on((char)'\n').join((Object)"new %s<%2$s>() {", (Object)"  private final %6$s %7$s = %3$s;", new Object[]{"  %5$s@Override public %2$s get() {", "    return %7$s.%4$s();", "  }", "}"}), ClassName.fromClass(Factory.class), TypeNames.forTypeMirror(binding.key().type()), contributionFields.get(bindingTypeElement).getSnippetFor(componentName), binding.bindingElement().getSimpleName().toString(), nullableSnippet, TypeNames.forTypeMirror(bindingTypeElement.asType()), sourceFieldName);
                }
                StringLiteral failMsg = StringLiteral.forValue("Cannot return null from a non-@Nullable component method");
                return Snippet.format(Joiner.on((char)'\n').join((Object)"new %s<%2$s>() {", (Object)"  private final %6$s %7$s = %3$s;", new Object[]{"  @Override public %2$s get() {", "    %2$s provided = %7$s.%4$s();", "    if (provided == null) {", "      throw new NullPointerException(%5$s);", "    }", "    return provided;", "  }", "}"}), ClassName.fromClass(Factory.class), TypeNames.forTypeMirror(binding.key().type()), contributionFields.get(bindingTypeElement).getSnippetFor(componentName), binding.bindingElement().getSimpleName().toString(), failMsg, TypeNames.forTypeMirror(bindingTypeElement.asType()), sourceFieldName);
            }
            case INJECTION: 
            case PROVISION: {
                ArrayList parameters = Lists.newArrayListWithCapacity((int)(binding.dependencies().size() + 1));
                if (binding.bindingKind().equals((Object)ProvisionBinding.Kind.PROVISION) && !binding.bindingElement().getModifiers().contains((Object)Modifier.STATIC)) {
                    parameters.add(contributionFields.get(binding.contributedBy().get()).getSnippetFor(componentName));
                }
                parameters.addAll(this.getDependencyParameters(componentName, binding.implicitDependencies(), memberSelectSnippets));
                Snippet factorySnippet = Snippet.format("%s.create(%s)", SourceFiles.factoryNameForProvisionBinding(binding), Snippet.makeParametersSnippet(parameters));
                return binding.scope().isPresent() ? Snippet.format("%s.create(%s)", ClassName.fromClass(ScopedProvider.class), factorySnippet) : factorySnippet;
            }
        }
        throw new AssertionError();
    }

    private Snippet initializeFactoryForProductionBinding(ProductionBinding binding, BindingGraph bindingGraph, ClassName componentName, ImmutableMap<ExecutableElement, TypeElement> dependencyMethodIndex, Map<TypeElement, MemberSelect> contributionFields, ImmutableMap<BindingKey, MemberSelect> memberSelectSnippets) {
        switch (binding.bindingKind()) {
            case COMPONENT_PRODUCTION: {
                TypeElement bindingTypeElement = (TypeElement)dependencyMethodIndex.get((Object)binding.bindingElement());
                String sourceFieldName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, bindingTypeElement.getSimpleName().toString());
                return Snippet.format(Joiner.on((char)'\n').join((Object)"new %s<%2$s>() {", (Object)"  private final %6$s %7$s = %4$s;", new Object[]{"  @Override public %3$s<%2$s> get() {", "    return %7$s.%5$s();", "  }", "}"}), ClassName.fromClass(Producer.class), TypeNames.forTypeMirror(binding.key().type()), ClassName.fromClass(ListenableFuture.class), contributionFields.get(bindingTypeElement).getSnippetFor(componentName), binding.bindingElement().getSimpleName().toString(), TypeNames.forTypeMirror(bindingTypeElement.asType()), sourceFieldName);
            }
            case IMMEDIATE: 
            case FUTURE_PRODUCTION: {
                ArrayList parameters = Lists.newArrayListWithCapacity((int)(binding.dependencies().size() + 2));
                parameters.add(contributionFields.get(binding.bindingTypeElement()).getSnippetFor(componentName));
                parameters.add(contributionFields.get(bindingGraph.componentDescriptor().executorDependency().get()).getSnippetFor(componentName));
                parameters.addAll(this.getProducerDependencyParameters(bindingGraph, componentName, (Iterable<DependencyRequest>)binding.dependencies(), memberSelectSnippets));
                return Snippet.format("new %s(%s)", SourceFiles.factoryNameForProductionBinding(binding), Snippet.makeParametersSnippet(parameters));
            }
        }
        throw new AssertionError();
    }

    private Snippet initializeMembersInjectorForBinding(ClassName componentName, MembersInjectionBinding binding, ImmutableMap<BindingKey, MemberSelect> memberSelectSnippets) {
        switch (binding.injectionStrategy()) {
            case NO_OP: {
                return Snippet.format("%s.noOp()", ClassName.fromClass(MembersInjectors.class));
            }
            case DELEGATE: {
                DependencyRequest parentInjectorRequest = (DependencyRequest)binding.parentInjectorRequest().get();
                return Snippet.format("%s.delegatingTo(%s)", ClassName.fromClass(MembersInjectors.class), ((MemberSelect)memberSelectSnippets.get((Object)parentInjectorRequest.bindingKey())).getSnippetFor(componentName));
            }
            case INJECT_MEMBERS: {
                List<Snippet> parameters = this.getDependencyParameters(componentName, binding.implicitDependencies(), memberSelectSnippets);
                return Snippet.format("%s.create(%s)", SourceFiles.membersInjectorNameForMembersInjectionBinding(binding), Snippet.makeParametersSnippet(parameters));
            }
        }
        throw new AssertionError();
    }

    private List<Snippet> getDependencyParameters(ClassName componentName, Iterable<DependencyRequest> dependencies, ImmutableMap<BindingKey, MemberSelect> memberSelectSnippets) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (Collection requestsForKey : SourceFiles.indexDependenciesByUnresolvedKey(this.types, dependencies).asMap().values()) {
            BindingKey key = (BindingKey)Iterables.getOnlyElement((Iterable)FluentIterable.from((Iterable)requestsForKey).transform((Function)new Function<DependencyRequest, BindingKey>(){

                public BindingKey apply(DependencyRequest request) {
                    return request.bindingKey();
                }
            }).toSet());
            parameters.add((Object)((MemberSelect)memberSelectSnippets.get((Object)key)).getSnippetWithRawTypeCastFor(componentName));
        }
        return parameters.build();
    }

    private List<Snippet> getProducerDependencyParameters(BindingGraph bindingGraph, ClassName componentName, Iterable<DependencyRequest> dependencies, ImmutableMap<BindingKey, MemberSelect> memberSelectSnippets) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (Collection requestsForKey : SourceFiles.indexDependenciesByUnresolvedKey(this.types, dependencies).asMap().values()) {
            BindingKey key = (BindingKey)Iterables.getOnlyElement((Iterable)FluentIterable.from((Iterable)requestsForKey).transform((Function)new Function<DependencyRequest, BindingKey>(){

                public BindingKey apply(DependencyRequest request) {
                    return request.bindingKey();
                }
            }));
            ResolvedBindings resolvedBindings = (ResolvedBindings)bindingGraph.resolvedBindings().get((Object)key);
            Class<?> frameworkClass = DependencyRequestMapper.FOR_PRODUCER.getFrameworkClass(requestsForKey);
            if (ComponentGenerator.frameworkClassForResolvedBindings(resolvedBindings).equals(Provider.class) && frameworkClass.equals(Producer.class)) {
                parameters.add((Object)Snippet.format("%s.producerFromProvider(%s)", ClassName.fromClass(Producers.class), ((MemberSelect)memberSelectSnippets.get((Object)key)).getSnippetFor(componentName)));
                continue;
            }
            parameters.add((Object)((MemberSelect)memberSelectSnippets.get((Object)key)).getSnippetFor(componentName));
        }
        return parameters.build();
    }

    private Snippet initializeMapBinding(ClassName componentName, ImmutableMap<BindingKey, MemberSelect> memberSelectSnippets, ImmutableMap<ContributionBinding, Snippet> multibindingContributionSnippets, Set<ProvisionBinding> bindings) {
        ProvisionBinding firstBinding = bindings.iterator().next();
        DeclaredType mapType = MoreTypes.asDeclared(firstBinding.key().type());
        if (this.isNonProviderMap(mapType)) {
            return Snippet.format("%s.create(%s)", ClassName.fromClass(MapFactory.class), ((MemberSelect)memberSelectSnippets.get((Object)((DependencyRequest)Iterables.getOnlyElement(firstBinding.dependencies())).bindingKey())).getSnippetFor(componentName));
        }
        ImmutableList.Builder snippets = ImmutableList.builder();
        snippets.add((Object)Snippet.format("%s.<%s, %s>builder(%d)", ClassName.fromClass(MapProviderFactory.class), TypeNames.forTypeMirror(Util.getKeyTypeOfMap(mapType)), TypeNames.forTypeMirror(Util.getProvidedValueTypeOfMap(mapType)), bindings.size()));
        for (ProvisionBinding binding : bindings) {
            snippets.add((Object)Snippet.format("    .put(%s, %s)", MapKeys.getMapKeySnippet(binding.bindingElement()), multibindingContributionSnippets.get((Object)binding)));
        }
        snippets.add((Object)Snippet.format("    .build()", new Object[0]));
        return Snippet.join(Joiner.on((char)'\n'), (Iterable<Snippet>)snippets.build());
    }

    private boolean isNonProviderMap(TypeMirror type) {
        return MoreTypes.isTypeOf(Map.class, type) && !MoreTypes.isTypeOf(Provider.class, MoreTypes.asDeclared(type).getTypeArguments().get(1));
    }

    static abstract class MemberSelect {
        MemberSelect() {
        }

        static MemberSelect instanceSelect(ClassName owningClass, Snippet snippet) {
            return new AutoValue_ComponentGenerator_MemberSelect((Optional<TypeName>)Optional.absent(), owningClass, false, snippet);
        }

        static MemberSelect staticSelect(ClassName owningClass, Snippet snippet) {
            return new AutoValue_ComponentGenerator_MemberSelect((Optional<TypeName>)Optional.absent(), owningClass, true, snippet);
        }

        static MemberSelect staticMethodInvocationWithCast(ClassName owningClass, Snippet snippet, TypeName castType) {
            return new AutoValue_ComponentGenerator_MemberSelect((Optional<TypeName>)Optional.of((Object)castType), owningClass, true, snippet);
        }

        abstract Optional<TypeName> selectedCast();

        abstract ClassName owningClass();

        abstract boolean staticMember();

        abstract Snippet snippet();

        private Snippet qualifiedSelectSnippet() {
            return Snippet.format("%s" + (this.staticMember() ? "" : ".this") + ".%s", this.owningClass(), this.snippet());
        }

        Snippet getSnippetWithRawTypeCastFor(ClassName usingClass) {
            Snippet snippet = this.getSnippetFor(usingClass);
            return this.selectedCast().isPresent() ? Snippet.format("(%s) %s", this.selectedCast().get(), snippet) : snippet;
        }

        Snippet getSnippetFor(ClassName usingClass) {
            return this.owningClass().equals(usingClass) ? this.snippet() : this.qualifiedSelectSnippet();
        }
    }

    static abstract class ProxyClassAndField {
        ProxyClassAndField() {
        }

        abstract ClassWriter proxyWriter();

        abstract FieldWriter proxyFieldWriter();

        static ProxyClassAndField create(ClassWriter proxyWriter, FieldWriter proxyFieldWriter) {
            return new AutoValue_ComponentGenerator_ProxyClassAndField(proxyWriter, proxyFieldWriter);
        }
    }
}

